/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardAction;
import org.eclipse.swt.graphics.Color;

public class HyperlinkFigure
extends Label {
    private DashboardAction action;

    public HyperlinkFigure(DashboardAction action) {
        this.action = action;
        this.hookMouse();
    }

    protected void paintFigure(Graphics graphics) {
        Color color = graphics.getForegroundColor();
        if (this.action.isEnabled()) {
            graphics.setForegroundColor(ColorConstants.blue);
        } else {
            graphics.setForegroundColor(ColorConstants.gray);
        }
        super.paintFigure(graphics);
        Rectangle bounds = this.getBounds();
        int y = bounds.y + bounds.height - 1;
        graphics.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        graphics.setForegroundColor(color);
    }

    protected void hookMouse() {
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                if (HyperlinkFigure.this.action.isEnabled()) {
                    HyperlinkFigure.this.action.run();
                }
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                HyperlinkFigure.this.setCursor(Cursors.HAND);
            }

            public void mouseExited(MouseEvent me) {
                HyperlinkFigure.this.setCursor(null);
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
    }
}

