/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.XtendMigrationFacade;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MigrateXtendResource
implements IObjectActionDelegate {
    static final String QVTO_EXTENSION = "qvto";
    private Shell shell;
    private IFile selectedFile;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        IFile qvtoFile = this.getQvtoFile();
        if (qvtoFile.exists() && !MessageDialog.openConfirm((Shell)this.shell, (String)"Name conflict", (String)("The file " + qvtoFile.getName() + " already present in this folder. Do you want to owerwrite it?"))) {
            return;
        }
        try {
            InputStream inputStream = this.getQvtoResourceContent(qvtoFile.getCharset());
            if (inputStream == null) {
                return;
            }
            if (!qvtoFile.exists()) {
                qvtoFile.create(inputStream, true, null);
            } else {
                qvtoFile.setContents(inputStream, true, true, null);
            }
        }
        catch (CoreException e) {
            this.showError("Migration problems", "Following exception appears:\n\n" + e.getMessage());
        }
    }

    private InputStream getQvtoResourceContent(String charset) {
        RootManager rootManager = new RootManager(this.selectedFile.getProject());
        String templateFullName = rootManager.getTemplateFullName(this.selectedFile);
        if (templateFullName == null) {
            this.showError("Incorrect xtend resource", "Unable to locate proper xpand root for this xtend resource");
            return null;
        }
        WorkspaceResourceManager resourceManager = rootManager.getResourceManager(this.selectedFile);
        XtendMigrationFacade migrationFacade = new XtendMigrationFacade(resourceManager, templateFullName);
        try {
            StringBuilder qvtoResourceContent = migrationFacade.migrateXtendResource();
            return new ByteArrayInputStream(qvtoResourceContent.toString().getBytes(charset));
        }
        catch (MigrationException e) {
            this.reportMigrationException(e);
        }
        catch (UnsupportedEncodingException e) {
            this.showError("Unsupported encoding", "Specified encoding \"" + charset + "\" is not supported by the platform: " + e.getMessage());
        }
        return null;
    }

    private void reportMigrationException(MigrationException e) {
        switch (e.getType()) {
            case ANALYZATION_PROBLEMS: {
                StringBuilder sb = new StringBuilder("Following analyzation problems present:\n\n");
                for (AnalysationIssue issue : e.getIssues()) {
                    sb.append(issue.toString());
                    sb.append("\n");
                }
                this.showError("Unable to load xtend resource", sb.toString());
                return;
            }
        }
        this.showError("Migration exception", "Migration exception appears:\n" + e.getMessage());
    }

    private IFile getQvtoFile() {
        IPath qvtoFilePath = this.selectedFile.getFullPath().removeFileExtension().addFileExtension(QVTO_EXTENSION);
        IFile qvtoFile = ResourcesPlugin.getWorkspace().getRoot().getFile(qvtoFilePath);
        return qvtoFile;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)structuredSelection.getFirstElement();
            action.setEnabled(true);
            return;
        }
        this.selectedFile = null;
        action.setEnabled(false);
    }

    private void showError(String title, String contents) {
        MessageDialog.openError((Shell)this.shell, (String)title, (String)contents);
    }
}

