/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.internal.xpand.migration.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyTemplateRootRegistry
implements IRegistryEventListener {
    private static final String MIGRATED_LOCATION_ATTR = "migratedLocation";
    private static final String CURRENT_LOCATION_ATTR = "currentLocation";
    private static final String ORIGINAL_LOCATION_ATTR = "originalLocation";
    private static final String EXTENSION_POINT_ID = "org.eclipse.gmf.xpand.migration.templates";
    private Map<IPath, IPath> original2CurrentRootMap;
    private Map<IPath, IPath> original2MigratedMap;

    public IPath getActualRoot(IPath originalRoot) {
        Map<IPath, IPath> map = this.getOriginal2CurrentRootMap();
        if (map.containsKey(originalRoot)) {
            return map.get(originalRoot);
        }
        return originalRoot;
    }

    public IPath getMigratedRoot(IPath originalRoot) {
        if (this.getOriginal2MigratedMap().containsKey(originalRoot)) {
            return this.getOriginal2MigratedMap().get(originalRoot);
        }
        if (this.getOriginal2CurrentRootMap().containsKey(originalRoot)) {
            return originalRoot;
        }
        IPath newPath = originalRoot.removeTrailingSeparator();
        newPath = newPath.addFileExtension("migrated");
        if (originalRoot.hasTrailingSeparator()) {
            newPath = newPath.addTrailingSeparator();
        }
        return newPath;
    }

    private synchronized Map<IPath, IPath> getOriginal2CurrentRootMap() {
        if (this.original2CurrentRootMap == null) {
            this.loadExtensions();
        }
        return this.original2CurrentRootMap;
    }

    private synchronized Map<IPath, IPath> getOriginal2MigratedMap() {
        if (this.original2MigratedMap == null) {
            this.loadExtensions();
        }
        return this.original2MigratedMap;
    }

    private void loadExtensions() {
        this.original2CurrentRootMap = new HashMap<IPath, IPath>();
        this.original2MigratedMap = new HashMap<IPath, IPath>();
        IExtensionPoint templatesExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = templatesExtensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String originalLocation = configElement.getAttribute(ORIGINAL_LOCATION_ATTR).trim();
            Path originalPath = new Path(originalLocation);
            if (!originalPath.isAbsolute()) {
                Activator.logWarn("Only absolute original paths supported: \"" + originalLocation + "\"");
            } else {
                String currentLocation = configElement.getAttribute(CURRENT_LOCATION_ATTR).trim();
                Path currentPath = new Path(currentLocation);
                if (!currentPath.isAbsolute()) {
                    Activator.logWarn("Only absolute current paths supported: \"" + currentLocation + "\"");
                } else if (this.original2CurrentRootMap.containsKey(originalPath)) {
                    IPath existingCurrentPath = this.original2CurrentRootMap.get(originalPath);
                    Activator.logWarn("Duplicating template root mapping specified: \"" + originalPath.toString() + "\" -> \"" + existingCurrentPath.toString() + "\" and \"" + originalPath.toString() + "\" -> \"" + currentPath.toString() + "\". Last entry will be skipped.");
                } else {
                    this.original2CurrentRootMap.put((IPath)originalPath, (IPath)currentPath);
                    String migratedLocation = configElement.getAttribute(MIGRATED_LOCATION_ATTR);
                    if (migratedLocation != null) {
                        Path migratedPath = new Path(migratedLocation);
                        if (!migratedPath.isAbsolute()) {
                            Activator.logWarn("Only absolute migrated paths supported: \"" + migratedLocation + "\"");
                        } else {
                            this.original2MigratedMap.put((IPath)originalPath, (IPath)migratedPath);
                        }
                    }
                }
            }
            ++n2;
        }
        Platform.getExtensionRegistry().addListener((IRegistryEventListener)this, EXTENSION_POINT_ID);
    }

    public synchronized void added(IExtension[] extensions) {
        this.original2CurrentRootMap = null;
        this.original2MigratedMap = null;
    }

    public synchronized void added(IExtensionPoint[] extensionPoints) {
        this.original2CurrentRootMap = null;
        this.original2MigratedMap = null;
    }

    public synchronized void removed(IExtension[] extensions) {
        this.original2CurrentRootMap = null;
        this.original2MigratedMap = null;
    }

    public synchronized void removed(IExtensionPoint[] extensionPoints) {
        this.original2CurrentRootMap = null;
        this.original2MigratedMap = null;
    }
}

