/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.internal.routers;

import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;

public class RectilinearRouterTest
extends TestCase {
    private RectilinearRouter rectilinearRouter;

    public RectilinearRouterTest(String name) {
        super(name);
    }

    protected RectilinearRouter getRectilinearRouter() {
        if (this.rectilinearRouter == null) {
            this.rectilinearRouter = new RectilinearRouter();
        }
        return this.rectilinearRouter;
    }

    protected void setUp() {
        try {
            super.setUp();
        }
        catch (Exception e) {
            RectilinearRouterTest.fail((String)("The RectilinearRouterTest.setUp method caught an exception - " + e));
        }
    }

    public void verifyConnection(Connection conn) {
        List lineSegs = PointListUtilities.getLineSegments((PointList)conn.getPoints());
        ListIterator li = lineSegs.listIterator();
        while (li.hasNext()) {
            LineSeg line = (LineSeg)li.next();
            RectilinearRouterTest.assertTrue((line.isHorizontal() || line.isVertical() ? 1 : 0) != 0);
        }
        RectilinearRouterTest.assertTrue((conn.getPoints().size() >= 2 ? 1 : 0) != 0);
        RectilinearRouterTest.assertTrue((boolean)conn.getPoints().getFirstPoint().equals((Object)conn.getSourceAnchor().getLocation(conn.getPoints().getFirstPoint())));
        RectilinearRouterTest.assertTrue((boolean)conn.getPoints().getLastPoint().equals((Object)conn.getTargetAnchor().getLocation(conn.getPoints().getLastPoint())));
    }

    public void testRouteConnectionAttachedToConnection() {
        RectangleFigure node1 = new RectangleFigure();
        RectangleFigure node2 = new RectangleFigure();
        RectangleFigure node3 = new RectangleFigure();
        node1.setSize(40, 40);
        node1.setLocation(new Point(100, 100));
        node2.setSize(40, 40);
        node2.setLocation(new Point(400, 100));
        node3.setSize(40, 40);
        node3.setLocation(new Point(250, 300));
        PolylineConnectionEx conn1 = new PolylineConnectionEx();
        conn1.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node1));
        conn1.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node2));
        conn1.setConnectionRouter((ConnectionRouter)new ObliqueRouter());
        PointList points = new PointList();
        points.addPoint(new Point(node1.getBounds().getCenter()));
        points.addPoint(new Point(200, node1.getBounds().getCenter().y));
        points.addPoint(new Point(300, 200));
        points.addPoint(new Point(node2.getBounds().getCenter()));
        conn1.setPoints(points);
        BaseSlidableAnchor anchor = new BaseSlidableAnchor((IFigure)conn1);
        PolylineConnectionEx conn2 = new PolylineConnectionEx();
        conn2.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node3));
        conn2.setTargetAnchor((ConnectionAnchor)anchor);
        this.getRectilinearRouter().route((Connection)conn2);
        this.verifyConnection((Connection)conn2);
    }

    public void testRouteConnections() {
        RectangleFigure node1 = new RectangleFigure();
        RectangleFigure node2 = new RectangleFigure();
        RectangleFigure node3 = new RectangleFigure();
        node1.setSize(40, 40);
        node1.setLocation(new Point(100, 200));
        node2.setSize(40, 40);
        node2.setLocation(new Point(200, 200));
        node3.setSize(40, 40);
        node3.setLocation(new Point(150, 50));
        FixedPointConnectionAnchor anchor = new FixedPointConnectionAnchor(node3);
        PolylineConnection conn1 = new PolylineConnection();
        conn1.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node1));
        conn1.setTargetAnchor((ConnectionAnchor)anchor);
        conn1.setConnectionRouter((ConnectionRouter)this.getRectilinearRouter());
        PointList points = new PointList();
        points.addPoint(new Point(node1.getBounds().getCenter()));
        points.addPoint(new Point(node1.getBounds().getCenter().x, 150));
        points.addPoint(new Point(node3.getBounds().getCenter()));
        conn1.setPoints(points);
        PolylineConnection conn2 = new PolylineConnection();
        conn2.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node2));
        conn2.setTargetAnchor((ConnectionAnchor)anchor);
        conn2.setConnectionRouter((ConnectionRouter)this.getRectilinearRouter());
        points = new PointList();
        points.addPoint(new Point(node1.getBounds().getCenter()));
        points.addPoint(new Point(node3.getBounds().getCenter()));
        conn2.setPoints(points);
        RectangleFigure node4 = new RectangleFigure();
        RectangleFigure node5 = new RectangleFigure();
        node4.setSize(40, 40);
        node4.setLocation(new Point(100, 300));
        node5.setSize(40, 40);
        node5.setLocation(new Point(200, 300));
        PolylineConnection conn3 = new PolylineConnection();
        conn3.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node4));
        conn3.setTargetAnchor((ConnectionAnchor)anchor);
        conn3.setConnectionRouter((ConnectionRouter)this.getRectilinearRouter());
        points = new PointList();
        points.addPoint(new Point(node4.getBounds().getCenter()));
        points.addPoint(new Point(200, 250));
        points.addPoint(new Point(50, 150));
        points.addPoint(new Point(node3.getBounds().getCenter()));
        conn3.setPoints(points);
        PolylineConnection conn4 = new PolylineConnection();
        conn4.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node5));
        conn4.setTargetAnchor((ConnectionAnchor)anchor);
        conn4.setConnectionRouter((ConnectionRouter)this.getRectilinearRouter());
        points = new PointList();
        points.addPoint(new Point(node4.getBounds().getCenter()));
        points.addPoint(new Point(node4.getBounds().getCenter().x, node3.getBounds().getCenter().y));
        points.addPoint(new Point(node3.getBounds().getCenter()));
        conn4.setPoints(points);
        this.getRectilinearRouter().route((Connection)conn1);
        this.getRectilinearRouter().route((Connection)conn2);
        this.getRectilinearRouter().route((Connection)conn3);
        this.getRectilinearRouter().route((Connection)conn4);
        this.verifyConnection((Connection)conn1);
        this.verifyConnection((Connection)conn2);
        this.verifyConnection((Connection)conn3);
        this.verifyConnection((Connection)conn4);
    }

    private static class FixedPointConnectionAnchor
    extends AbstractConnectionAnchor {
        RectangleFigure rf;

        public FixedPointConnectionAnchor(RectangleFigure rf) {
            super((IFigure)rf);
            this.rf = rf;
        }

        public Point getLocation(Point reference) {
            return this.rf.getBounds().getBottomRight();
        }
    }
}

