/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.draw2d.ui.internal.routers;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.tests.runtime.draw2d.ui.internal.routers.AbstractForestRouterTest;

public class LeftRightForestRouterTest
extends AbstractForestRouterTest {
    public LeftRightForestRouterTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.getConnection1().getSourceAnchor().getOwner().setLocation(new Point(200, 100));
            this.getConnection2().getSourceAnchor().getOwner().setLocation(new Point(200, 200));
            this.getConnection1().getTargetAnchor().getOwner().setLocation(new Point(50, 150));
            this.getConnection3().getSourceAnchor().getOwner().setLocation(new Point(300, 100));
            this.getConnection4().getSourceAnchor().getOwner().setLocation(new Point(300, 200));
            this.getConnection1().setOrientation(ITreeConnection.Orientation.HORIZONTAL);
            this.getConnection2().setOrientation(ITreeConnection.Orientation.HORIZONTAL);
            this.getConnection3().setOrientation(ITreeConnection.Orientation.HORIZONTAL);
            this.getConnection4().setOrientation(ITreeConnection.Orientation.HORIZONTAL);
        }
        catch (Exception e) {
            LeftRightForestRouterTest.fail((String)("The ForestRouterTest.setUp method caught an exception - " + e));
        }
    }

    public void testRouteLeftRight() {
        AbsoluteBendpoint abp;
        this.routeConnections("LeftRight:no constraint");
        ArrayList<AbsoluteBendpoint> newConstraint = new ArrayList<AbsoluteBendpoint>(this.getConnection1().getPoints().size());
        PointList pts = PointListUtilities.copyPoints((PointList)this.getConnection1().getPoints());
        OrthogonalRouterUtilities.resetEndPointsToCenter((Connection)this.getConnection1(), (PointList)pts);
        pts.setPoint(pts.getPoint(2).getTranslated(0, 10), 2);
        pts.setPoint(pts.getPoint(3).getTranslated(0, 10), 3);
        int i = 0;
        while (i < pts.size()) {
            abp = new AbsoluteBendpoint(pts.getPoint(i));
            newConstraint.add(abp);
            ++i;
        }
        this.getForestRouter().setConstraint((Connection)this.getConnection1(), newConstraint);
        this.routeConnections("LeftRight:change trunk end");
        pts.setPoint(pts.getPoint(1).getTranslated(10, 0), 1);
        pts.setPoint(pts.getPoint(2).getTranslated(10, 0), 2);
        newConstraint = new ArrayList(this.getConnection1().getPoints().size());
        i = 0;
        while (i < pts.size()) {
            abp = new AbsoluteBendpoint(pts.getPoint(i));
            newConstraint.add(abp);
            ++i;
        }
        this.getForestRouter().setConstraint((Connection)this.getConnection1(), newConstraint);
        this.routeConnections("LeftRight:change trunk shoulder");
        pts.setPoint(pts.getPoint(0).getTranslated(0, 10), 0);
        pts.setPoint(pts.getPoint(1).getTranslated(0, 10), 1);
        newConstraint = new ArrayList(this.getConnection1().getPoints().size());
        i = 0;
        while (i < pts.size()) {
            abp = new AbsoluteBendpoint(pts.getPoint(i));
            newConstraint.add(abp);
            ++i;
        }
        this.getForestRouter().setConstraint((Connection)this.getConnection1(), newConstraint);
        this.routeConnections("LeftRight:change branch");
    }

    public void testMultiTrees() {
        this.routeMultiTreeConnections("LeftRight:no constraint");
    }
}

