/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core.internal;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.BasePasteOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.ObjectInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteTarget;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ListIndexComparator;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.LoadingEMFResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.MergedEObjectInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.PasteOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SerializationEMFResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.l10n.EMFClipboardCoreMessages;

public class PasteIntoParentOperation
extends BasePasteOperation {
    private PasteTarget element;
    private LoadingEMFResource eLoadedResource;
    private Map childPasteProcessMap;
    private List originalChildObjectInfo;
    private XMLResource parentResource;
    private List containmentAnnotationReferences;
    private EAnnotation serializationAnnotation;
    private Map contentObject2ProxyMap;
    private Map hintsMap = Collections.EMPTY_MAP;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.clipboard.core.internal.PasteIntoParentOperation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public final XMLResource getParentResource() {
        if (this.parentResource == null) {
            this.parentResource = this.element.isResource() ? (XMLResource)this.element.getObject() : this.getClipboardOperationHelper().getResource(this.getEObject());
        }
        return this.parentResource;
    }

    final LoadingEMFResource getLoadedResource() {
        return this.eLoadedResource;
    }

    public EObject getLoadedEObject(String objId) {
        return (EObject)this.getLoadedResource().getIDToEObjectMapCopy().get(objId);
    }

    public String getLoadedEObjectID(EObject eObject) {
        return (String)this.getLoadedResource().getEObjectToIDMapCopy().get(eObject);
    }

    public Map getHintsMap() {
        return this.hintsMap;
    }

    public PasteIntoParentOperation(PasteOperation pasteProcess, PasteTarget element, Map hintsMap) throws Exception {
        super(pasteProcess);
        this.element = element;
        this.hintsMap = hintsMap;
        this.childPasteProcessMap = new HashMap();
        this.eLoadedResource = this.loadEObjects();
        if (!this.getHintsMap().containsKey("*ignore_recycle=id")) {
            Iterator childEObjectInfoIt = this.getOriginalChildObjectInfo().iterator();
            while (childEObjectInfoIt.hasNext()) {
                ObjectInfo objectInfo = (ObjectInfo)childEObjectInfoIt.next();
                if (!objectInfo.hasHint("*recycle=id") || !this.findDuplicateGUID(this.getLoadedEObject(objectInfo.objId))) continue;
                this.throwException("PasteIntoParentOperation", new IllegalArgumentException(EMFClipboardCoreMessages.copypaste_duplicateId));
            }
        }
        this.getContentObject2ProxyMap();
    }

    private PasteIntoParentOperation(PasteIntoParentOperation pasteIntoParentOperation, PasteTarget element) {
        super(pasteIntoParentOperation);
        this.element = element;
        this.hintsMap = pasteIntoParentOperation.getHintsMap();
        this.childPasteProcessMap = pasteIntoParentOperation.childPasteProcessMap;
        this.eLoadedResource = pasteIntoParentOperation.getLoadedResource();
        this.originalChildObjectInfo = pasteIntoParentOperation.getOriginalChildObjectInfo();
        this.parentResource = pasteIntoParentOperation.getParentResource();
        this.containmentAnnotationReferences = pasteIntoParentOperation.getContainmentAnnotationReferences();
        this.serializationAnnotation = pasteIntoParentOperation.getSerializationAnnotation();
        this.contentObject2ProxyMap = pasteIntoParentOperation.getContentObject2ProxyMap();
    }

    private boolean findDuplicateGUID(EObject toPaste) {
        XMLResource parentRes = this.getParentResource();
        EObject original = (EObject)this.getContentObject2ProxyMap().get(toPaste);
        URI sourceUri = original == null ? null : EcoreUtil.getURI((EObject)original).trimFragment();
        boolean result = false;
        if (!parentRes.getURI().equals((Object)sourceUri)) {
            TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(toPaste));
            while (!result && iter.hasNext()) {
                boolean bl = result = parentRes.getEObject(this.getLoadedEObjectID((EObject)iter.next())) != null;
            }
        }
        return result;
    }

    public PasteIntoParentOperation clone(EObject newElement) {
        return new PasteIntoParentOperation(this, new PasteTarget(newElement));
    }

    private void performPostPasteOperations(List operations) throws Exception {
        if (!operations.isEmpty()) {
            ArrayList<PasteChildOperation> postPasteOperations = new ArrayList<PasteChildOperation>();
            Iterator it = operations.iterator();
            while (it.hasNext()) {
                this.getProgressMonitor().worked(1);
                if (this.isCancelled()) {
                    this.throwCancelException();
                }
                PasteChildOperation pasteOperation = (PasteChildOperation)it.next();
                pasteOperation.paste();
                PasteChildOperation postPasteOperation = pasteOperation.getPostPasteOperation();
                if (postPasteOperation == null) continue;
                postPasteOperations.add(postPasteOperation);
            }
            this.performPostPasteOperations(postPasteOperations);
        }
    }

    private void resolveLocalProxies() {
        Iterator it = this.getLoadedResource().getContents().iterator();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            if (eObj instanceof EAnnotation) continue;
            this.resolveLocalProxies(eObj);
            TreeIterator contentIt = eObj.eAllContents();
            while (contentIt.hasNext()) {
                this.resolveLocalProxies((EObject)contentIt.next());
            }
        }
    }

    private void resolveLocalProxies(EObject eObject) {
        Iterator it = eObject.eClass().getEAllReferences().iterator();
        EReference ref = null;
        while (it.hasNext()) {
            EObject resolved;
            EObject eObj;
            ref = (EReference)it.next();
            if (ref.isContainment() || !ref.isChangeable()) continue;
            Object value = eObject.eGet((EStructuralFeature)ref, true);
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)ref)) {
                Collection collection = (Collection)value;
                boolean withInverseElist = collection instanceof EObjectWithInverseEList;
                Iterator valIt = new ArrayList(collection).iterator();
                while (valIt.hasNext()) {
                    EObject eObj2 = (EObject)valIt.next();
                    if (!eObj2.eIsProxy()) continue;
                    EObject resolved2 = ClipboardSupportUtil.resolve(eObj2, this.getLoadedResource().getIDToEObjectMapCopy());
                    if (!resolved2.eIsProxy()) {
                        if (collection.contains(resolved2)) {
                            collection.remove(eObj2);
                            continue;
                        }
                        EcoreUtil.replace((EObject)eObject, (EStructuralFeature)ref, (Object)eObj2, (Object)resolved2);
                        continue;
                    }
                    if (!withInverseElist) continue;
                    collection.remove(eObj2);
                }
                continue;
            }
            if (value == null || !(eObj = (EObject)value).eIsProxy() || (resolved = ClipboardSupportUtil.resolve(eObj, this.getLoadedResource().getIDToEObjectMapCopy())).eIsProxy()) continue;
            EcoreUtil.replace((EObject)eObject, (EStructuralFeature)ref, (Object)eObj, (Object)resolved);
        }
    }

    /*
     * Exception decompiling
     */
    public void paste() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 189->193)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fireCreateEvents() {
        ArrayList elements = new ArrayList();
        Object it = EcoreUtil.getAllContents((Collection)this.getPastedElementSet());
        while (it.hasNext()) {
            elements.add(it.next());
        }
        elements.removeAll(this.getPastedElementSet());
        it = elements.iterator();
        while (it.hasNext()) {
            ClipboardSupportUtil.sendCreateEvent((EObject)it.next());
        }
    }

    private List getOriginalChildObjectInfo() {
        if (this.originalChildObjectInfo == null) {
            this.originalChildObjectInfo = this.getResourceInfo().getObjectInfoTypes("OCT_ORIGINAL");
            Collections.sort(this.originalChildObjectInfo, new ListIndexComparator((List)this.getLoadedResource().getContents()){

                public int compare(Object obj_1, Object obj_2) {
                    return super.compare(PasteIntoParentOperation.this.getLoadedEObject(((ObjectInfo)obj_1).objId), PasteIntoParentOperation.this.getLoadedEObject(((ObjectInfo)obj_2).objId));
                }
            });
        }
        return this.originalChildObjectInfo;
    }

    private void recycleObjectIds() {
        if (this.getHintsMap().containsKey("*ignore_recycle=id")) {
            return;
        }
        Iterator childEObjectInfoIt = this.getOriginalChildObjectInfo().iterator();
        while (childEObjectInfoIt.hasNext()) {
            ObjectInfo objectInfo = (ObjectInfo)childEObjectInfoIt.next();
            if (!objectInfo.hasHint("*recycle=id")) continue;
            EObject pastedChildElement = this.getChildPasteProcess(objectInfo).getPastedElement();
            if (!this.getPastedElementSet().contains(pastedChildElement)) continue;
            this.recycleObjectId(pastedChildElement);
            TreeIterator contentIt = pastedChildElement.eAllContents();
            while (contentIt.hasNext()) {
                this.recycleObjectId((EObject)contentIt.next());
            }
        }
    }

    private void recycleObjectId(EObject pastedEObject) {
        String newId = this.getParentResource().getID(pastedEObject);
        if (newId != null) {
            String originalId = (String)this.getLoadedEObjectToIDMapCopy().get(pastedEObject);
            this.getParentResource().setID(pastedEObject, originalId);
        } else {
            this.getParentResource().setID(pastedEObject, null);
        }
    }

    private LoadingEMFResource loadEObjects() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.getResourceInfo().data.getBytes(this.getResourceInfo().encoding));
        LoadingEMFResource resource = new LoadingEMFResource(this.getParentResource().getResourceSet(), this.getResourceInfo().encoding, this.getLoadOptionsMap(), this.getClipboardOperationHelper());
        resource.load(inputStream, null);
        return resource;
    }

    private PasteChildOperation getChildPasteProcess(ObjectInfo childEObjectInfo) {
        PasteChildOperation originalChildPasteProcess = (PasteChildOperation)this.childPasteProcessMap.get(childEObjectInfo);
        if (originalChildPasteProcess == null) {
            originalChildPasteProcess = new PasteChildOperation(this, childEObjectInfo);
            this.childPasteProcessMap.put(childEObjectInfo, originalChildPasteProcess);
        }
        return originalChildPasteProcess;
    }

    private void resolveReferences() {
        Iterator it = this.getPastedElementSet().iterator();
        EObject pastedEObject = null;
        while (it.hasNext()) {
            pastedEObject = (EObject)it.next();
            this.checkReferences(pastedEObject);
            TreeIterator contentIt = pastedEObject.eAllContents();
            while (contentIt.hasNext()) {
                this.checkReferences((EObject)contentIt.next());
            }
        }
    }

    private void checkReferences(EObject pastedEObject) {
        EList references = pastedEObject.eClass().getEAllReferences();
        Iterator refIt = references.iterator();
        EReference reference = null;
        while (refIt.hasNext()) {
            Object[] currentValues;
            reference = (EReference)refIt.next();
            if (reference.isContainment() || reference.isContainer() || !reference.isChangeable()) continue;
            if (FeatureMapUtil.isMany((EObject)pastedEObject, (EStructuralFeature)reference)) {
                Collection currentList;
                if (!pastedEObject.eIsSet((EStructuralFeature)reference) || (currentList = (Collection)pastedEObject.eGet((EStructuralFeature)reference)).isEmpty()) continue;
                currentValues = currentList.toArray();
                this.resolveProxyReferences(currentValues);
                currentValues = this.removeNullEntries(currentValues);
                this.checkMergedElements(currentValues);
                List<Object> checkedList = Arrays.asList(currentValues);
                if (currentList.equals(checkedList)) continue;
                ClipboardSupportUtil.setEObjectList(pastedEObject, reference, checkedList);
                continue;
            }
            Object currentValue = pastedEObject.eGet((EStructuralFeature)reference);
            if (currentValue == null) continue;
            currentValues = new Object[]{currentValue};
            this.resolveProxyReferences(currentValues);
            if (currentValues[0] == null) {
                ClipboardSupportUtil.destroyEObject(pastedEObject, reference);
                continue;
            }
            this.checkMergedElements(currentValues);
            if (currentValues[0] == currentValue) continue;
            ClipboardSupportUtil.setEObject(pastedEObject, reference, (EObject)currentValues[0]);
        }
    }

    private Object[] removeNullEntries(Object[] objects) {
        ArrayList<Object> newList = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] != null) {
                newList.add(objects[i]);
            }
            ++i;
        }
        return newList.toArray();
    }

    /*
     * Unable to fully structure code
     */
    private void resolveProxyReferences(Object[] currentValues) {
        val = null;
        resolvedVal = null;
        i = 0;
        while (i < currentValues.length) {
            replaced = false;
            val = (EObject)currentValues[i];
            if (val.eResource() != this.getLoadedResource()) ** GOTO lbl-1000
            val = (EObject)this.getContentObject2ProxyMap().get(val);
            replaced = true;
            if (val == null) {
                currentValues[i] = null;
            } else if (val.eIsProxy()) {
                resolvedVal = ClipboardSupportUtil.resolve(val, this.getParentResource());
                if (resolvedVal.eIsProxy()) {
                    resolvedVal = EcoreUtil.resolve((EObject)val, (Resource)this.getParentResource());
                }
                if (!resolvedVal.eIsProxy()) {
                    currentValues[i] = resolvedVal;
                } else if (replaced) {
                    ((InternalEObject)currentValues[i]).eSetProxyURI(((InternalEObject)val).eProxyURI());
                }
            }
            ++i;
        }
    }

    private void checkMergedElements(Object[] resolvedReferencedEObjects) {
        int i = 0;
        while (i < resolvedReferencedEObjects.length) {
            MergedEObjectInfo info;
            if (this.getEObjectID((EObject)resolvedReferencedEObjects[i]) == null && (info = (MergedEObjectInfo)this.getAllMergedElementsMap().get(resolvedReferencedEObjects[i])) != null) {
                if (info.targetEObjects.size() == 1) {
                    resolvedReferencedEObjects[i] = info.targetEObjects.get(0);
                } else if (info.targetEObjects.size() > 1) {
                    boolean found = false;
                    Iterator it = info.targetEObjects.iterator();
                    while (it.hasNext()) {
                        EObject mergeTarget = (EObject)it.next();
                        if (!this.isChild(mergeTarget)) continue;
                        resolvedReferencedEObjects[i] = mergeTarget;
                        found = true;
                        break;
                    }
                    if (!found) {
                        resolvedReferencedEObjects[i] = info.targetEObjects.get(0);
                    }
                }
            }
            ++i;
        }
    }

    public final EObject getEObject() {
        if (!this.element.isResource()) {
            return (EObject)this.element.getObject();
        }
        return null;
    }

    public final PasteTarget getPasteTarget() {
        return this.element;
    }

    public Map getLoadedEObjectToIDMapCopy() {
        return this.getLoadedResource().getEObjectToIDMapCopy();
    }

    public Map getLoadedIDToEObjectMapCopy() {
        return this.getLoadedResource().getIDToEObjectMapCopy();
    }

    public EObject getEObject(String objId) {
        return this.getParentResource().getEObject(objId);
    }

    public String getEObjectID(EObject eObject) {
        return this.getParentResource().getID(eObject);
    }

    protected boolean isChild(EObject eObject) {
        return eObject != null ? ClipboardSupportUtil.isChild(this.getEObject(), eObject) : false;
    }

    public EReference getContainmentFeature(EObject eObject) {
        Iterator it = this.getContainmentAnnotationReferences().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Object ref = it.next();
            if (!eObject.equals(obj)) continue;
            return (EReference)ref;
        }
        return null;
    }

    private EAnnotation getSerializationAnnotation() {
        if (this.serializationAnnotation == null) {
            Iterator it = this.getLoadedResource().getContents().iterator();
            while (it.hasNext()) {
                EAnnotation eAnnotation;
                Object obj = it.next();
                if (!(obj instanceof EAnnotation) || (eAnnotation = ((EAnnotation)obj).getEAnnotation(SerializationEMFResource.SERIALIZATION_ANNOTATIONS)) == null) continue;
                this.serializationAnnotation = eAnnotation;
                break;
            }
        }
        return this.serializationAnnotation;
    }

    private Map getContentObject2ProxyMap() {
        if (this.contentObject2ProxyMap == null) {
            this.contentObject2ProxyMap = new HashMap();
            Iterator annotations = this.getSerializationAnnotation().getEAnnotations().iterator();
            while (annotations.hasNext()) {
                EAnnotation ref_obj_Annotation = (EAnnotation)annotations.next();
                EObject proxy = (EObject)ref_obj_Annotation.getReferences().get(0);
                EObject eObj = ClipboardSupportUtil.resolve(proxy, this.getLoadedIDToEObjectMapCopy());
                if (!$assertionsDisabled && proxy == eObj) {
                    throw new AssertionError((Object)"proxy is the same as eObj");
                }
                this.contentObject2ProxyMap.put(eObj, proxy);
            }
        }
        return this.contentObject2ProxyMap;
    }

    protected List getContainmentAnnotationReferences() {
        if (this.containmentAnnotationReferences == null) {
            this.containmentAnnotationReferences = new ArrayList();
            Iterator annotations = this.getSerializationAnnotation().getEAnnotations().iterator();
            while (annotations.hasNext()) {
                EAnnotation ref_obj_Annotation = (EAnnotation)annotations.next();
                if (ref_obj_Annotation.getReferences().size() < 2) continue;
                EObject eObj = ClipboardSupportUtil.resolve((EObject)ref_obj_Annotation.getReferences().get(0), this.getLoadedIDToEObjectMapCopy());
                this.containmentAnnotationReferences.add(eObj);
                EObject eRef = EcoreUtil.resolve((EObject)((EObject)ref_obj_Annotation.getReferences().get(1)), (Resource)this.getParentResource());
                this.containmentAnnotationReferences.add(eRef);
            }
        }
        return this.containmentAnnotationReferences;
    }
}

