/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.BasePasteOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.ObjectInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverridePasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteAction;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteTarget;
import org.eclipse.gmf.runtime.emf.clipboard.core.PostPasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.MergedEObjectInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.PasteIntoParentOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.l10n.EMFClipboardCoreMessages;

public class PasteChildOperation
extends BasePasteOperation {
    protected static final String COPY = EMFClipboardCoreMessages.pasteChildOperation_copyPrefix;
    protected static final PasteChildOperation[] EMPTY_ARRAY = new PasteChildOperation[0];
    private Map auxiliaryChildPasteProcessMap;
    private PasteChildOperation mainChildPasteProcess;
    private PasteChildOperation postPasteOperation;
    private List alwaysCopyObjectPasteOperations;
    private ObjectInfo childObjectInfo;
    private EObject childEObject;
    private EObject pastedElement;
    private EObject copyParentEObject;
    private ObjectInfo copyParentObjectInfo;
    private EObject directContainerEObject;
    private OverridePasteChildOperation overrideChildPasteOperation;
    private EReference containmentFeature;
    private Map embeddedCopyParentObjectInfoMap = new HashMap();

    public PasteChildOperation(PasteIntoParentOperation parentPasteProcess, ObjectInfo childEObjectInfo) {
        super(parentPasteProcess);
        this.childObjectInfo = childEObjectInfo;
        this.auxiliaryChildPasteProcessMap = new HashMap();
    }

    protected EReference getContainmentFeature() {
        if (this.containmentFeature == null) {
            this.containmentFeature = this.getParentPasteProcess().getContainmentFeature(this.getEObject());
        }
        return this.containmentFeature;
    }

    private PasteChildOperation(PasteChildOperation mainChildPasteProcess, ObjectInfo childEObjectInfo) {
        this(mainChildPasteProcess.getParentPasteProcess(), childEObjectInfo);
        this.mainChildPasteProcess = mainChildPasteProcess;
    }

    protected PasteChildOperation(PasteChildOperation mainChildPasteProcess) {
        this(mainChildPasteProcess.getParentPasteProcess(), mainChildPasteProcess.childObjectInfo);
    }

    protected EObject getLoadedDirectContainerEObject() {
        if (this.directContainerEObject == null) {
            this.directContainerEObject = this.getLoadedEObject(this.getChildObjectInfo().containerId);
        }
        return this.directContainerEObject;
    }

    public PasteIntoParentOperation getParentPasteProcess() {
        return (PasteIntoParentOperation)this.getSpawningPasteOperation();
    }

    protected PasteChildOperation getAuxiliaryChildPasteProcess(ObjectInfo auxiliaryChildEObjectInfo) {
        PasteChildOperation auxiliaryChildPasteProcess = (PasteChildOperation)this.auxiliaryChildPasteProcessMap.get(auxiliaryChildEObjectInfo);
        if (auxiliaryChildPasteProcess == null && (auxiliaryChildPasteProcess = this.makeAuxiliaryChildPasteProcess(auxiliaryChildEObjectInfo)) != null) {
            this.auxiliaryChildPasteProcessMap.put(auxiliaryChildEObjectInfo, auxiliaryChildPasteProcess);
        }
        return auxiliaryChildPasteProcess;
    }

    protected PasteChildOperation makeAuxiliaryChildPasteProcess(ObjectInfo auxiliaryChildEObjectInfo) {
        return new PasteChildOperation(this, auxiliaryChildEObjectInfo);
    }

    public EObject getEObject() {
        if (this.childEObject == null) {
            this.childEObject = this.getLoadedEObject(this.getChildObjectInfo().objId);
        }
        return this.childEObject;
    }

    public EObject getPastedElement() {
        return this.pastedElement;
    }

    protected EObject getLoadedEObject(String objId) {
        return this.getParentPasteProcess().getLoadedEObject(objId);
    }

    protected String getLoadedEObjectID(EObject eObject) {
        return this.getParentPasteProcess().getLoadedEObjectID(eObject);
    }

    protected boolean hasCopyParent() {
        return !"NONE".equals(this.getChildObjectInfo().copyParentId);
    }

    protected boolean isCopyAlways() {
        return this.getChildObjectInfo().objCopyType.equals("OCT_ALWAYS");
    }

    protected EObject getCopyParentEObject() {
        if (this.copyParentEObject == null) {
            this.copyParentEObject = this.getLoadedEObject(this.getChildObjectInfo().copyParentId);
        }
        return this.copyParentEObject;
    }

    protected EObject getEObject(String objId) {
        return this.getParentPasteProcess().getEObject(objId);
    }

    protected String getEObjectID(EObject eObject) {
        return this.getParentPasteProcess().getEObjectID(eObject);
    }

    protected PasteTarget getSuitableParentUsingAncestry(String preferredTypeName) {
        PasteTarget suitableParent = this.getSuitableParentUsingAncestry(this.getParentTarget(), preferredTypeName, true);
        if (suitableParent == null) {
            suitableParent = this.getSuitableParentUsingAncestry(this.getParentTarget(), preferredTypeName, false);
        }
        return suitableParent;
    }

    private PasteTarget getSuitableParentUsingAncestry(PasteTarget potentialParent, String preferredTypeName, boolean strictMatch) {
        PasteTarget suitableParent = this.checkPotentialParent(potentialParent, preferredTypeName, strictMatch);
        if (suitableParent == null && !potentialParent.isResource()) {
            EObject potentialParentObject = (EObject)potentialParent.getObject();
            while (suitableParent == null && potentialParentObject.eContainer() != null) {
                potentialParentObject = potentialParentObject.eContainer();
                suitableParent = this.checkPotentialParent(new PasteTarget(potentialParentObject), preferredTypeName, strictMatch);
            }
        }
        return suitableParent;
    }

    protected EObject getPastedEObject(EObject eObject) {
        String id = this.getEObjectID(eObject);
        if (id != null) {
            return eObject;
        }
        MergedEObjectInfo info = (MergedEObjectInfo)this.getAllMergedElementsMap().get(eObject);
        if (info != null) {
            if (info.targetEObjects.size() == 1) {
                return (EObject)info.targetEObjects.get(0);
            }
            if (info.targetEObjects.size() > 1) {
                Iterator it = info.targetEObjects.iterator();
                while (it.hasNext()) {
                    EObject mergeTarget = (EObject)it.next();
                    if ((!this.getParentTarget().isResource() || this.getParentTarget().getObject() != mergeTarget.eResource()) && !ClipboardSupportUtil.isChild(this.getParentEObject(), mergeTarget)) continue;
                    return mergeTarget;
                }
                return (EObject)info.targetEObjects.get(0);
            }
        }
        return null;
    }

    protected EObject getPastedDirectCopyParent() {
        return this.getPastedEObject(this.getLoadedDirectContainerEObject());
    }

    private EObject doPasteIntoNearestCopyParent(EObject topMostCopyParentEObject) throws Exception {
        EObject nearestParent = this.getLoadedEObject(this.getChildObjectInfo().containerId);
        while (!nearestParent.equals(topMostCopyParentEObject)) {
            EObject parentElement = this.doPasteIntoCopyParent(this.makeEmbeddedCopyParentObjectInfo(nearestParent));
            if (parentElement != null) {
                return parentElement;
            }
            nearestParent = nearestParent.eContainer();
        }
        return null;
    }

    private EObject doPasteIntoCopyParent(ObjectInfo theCopyParentObjectInfo) throws Exception {
        PasteChildOperation copyParentProcess = this.getAuxiliaryChildPasteProcess(theCopyParentObjectInfo);
        copyParentProcess.paste();
        EObject pastedCopyParent = copyParentProcess.getPastedElement();
        if (pastedCopyParent != null) {
            return this.doPasteInto(this.getPastedDirectCopyParent());
        }
        return null;
    }

    private ObjectInfo makeEmbeddedCopyParentObjectInfo(EObject embeddedCopyParent) {
        ObjectInfo objectInfo = (ObjectInfo)this.embeddedCopyParentObjectInfoMap.get(embeddedCopyParent);
        if (objectInfo == null) {
            objectInfo = new ObjectInfo();
            objectInfo.objCopyType = "OCT_PARENT";
            objectInfo.objId = this.getLoadedEObjectID(embeddedCopyParent);
            objectInfo.containerId = this.getLoadedEObjectID(embeddedCopyParent.eContainer());
            objectInfo.containerClass = embeddedCopyParent.eContainer().eClass().getInstanceClassName();
            objectInfo.copyParentId = !objectInfo.objId.equals(this.getChildObjectInfo().copyParentId) ? this.getChildObjectInfo().copyParentId : "NONE";
            objectInfo.hints = "NONE";
            this.embeddedCopyParentObjectInfoMap.put(embeddedCopyParent, objectInfo);
        }
        return objectInfo;
    }

    private EObject doPasteIntoCopyParent() throws Exception {
        EObject existingCopyParentEObject = this.getEObject(this.getChildObjectInfo().containerId);
        if (existingCopyParentEObject != null) {
            return this.doPasteInto(existingCopyParentEObject);
        }
        EObject pastedDirectCopyParent = this.getPastedDirectCopyParent();
        if (pastedDirectCopyParent != null) {
            return this.doPasteInto(pastedDirectCopyParent);
        }
        EObject nearestParent = null;
        if (!this.isCopyParentDirectParent()) {
            nearestParent = this.getLoadedEObject(this.getChildObjectInfo().containerId);
            EObject perent = nearestParent.eContainer();
            EObject root = this.getCopyParentEObject();
            while (perent != null && !perent.equals(root)) {
                existingCopyParentEObject = this.getPastedEObject(perent);
                if (existingCopyParentEObject != null) break;
                nearestParent = perent;
                perent = nearestParent.eContainer();
            }
            if (existingCopyParentEObject == null) {
                existingCopyParentEObject = this.getPastedEObject(root);
            }
        }
        if (existingCopyParentEObject != null) {
            return this.doPasteIntoCopyParent(this.makeEmbeddedCopyParentObjectInfo(nearestParent));
        }
        PasteTarget possibleParent = this.getSuitableParentUsingAncestry(this.getLoadedDirectContainerEObject().eClass().getInstanceClassName());
        if (possibleParent != null) {
            return this.doPasteInto(possibleParent);
        }
        EObject element = this.doPasteIntoNearestCopyParent(this.getCopyParentEObject());
        if (element != null) {
            return element;
        }
        return this.doPasteIntoCopyParent(this.getCopyParentObjectInfo());
    }

    public EObject getParentEObject() {
        return this.getParentPasteProcess().getEObject();
    }

    public PasteTarget getParentTarget() {
        return this.getParentPasteProcess().getPasteTarget();
    }

    public XMLResource getParentResource() {
        return this.getParentPasteProcess().getParentResource();
    }

    public PasteChildOperation getPostPasteOperation() {
        return this.overrideChildPasteOperation != null ? this.overrideChildPasteOperation.getPostPasteOperation() : this.doGetPostPasteOperation();
    }

    private PasteChildOperation doGetPostPasteOperation() {
        if (this.postPasteOperation == null && this.getPastedElement() != null && !this.getAlwaysCopyObjectPasteOperations().isEmpty()) {
            this.postPasteOperation = new PostPasteChildOperation(this, this.getAlwaysCopyObjectPasteOperations());
        }
        return this.postPasteOperation;
    }

    public void paste() throws Exception {
        if (this.getPastedEObject(this.getEObject()) != null) {
            this.setPastedElement(this.getEObject());
            this.addPastedElement(this.getPastedElement());
            this.postPasteOperation = PostPasteChildOperation.makeNullPostPasteChildOperation(this);
            return;
        }
        if (this.getClipboardOperationHelper().shouldOverrideChildPasteOperation(this.getParentEObject(), this.getEObject())) {
            this.overrideChildPasteOperation = this.getClipboardOperationHelper().getOverrideChildPasteOperation(this);
            if (this.overrideChildPasteOperation != null) {
                this.overrideChildPasteOperation.paste();
                this.setPastedElement(this.overrideChildPasteOperation.getPastedElement());
            } else {
                this.addPasteFailuresObject(this.getEObject());
            }
            return;
        }
        if (this.hasCopyParent()) {
            this.setPastedElement(this.doPasteIntoCopyParent());
        } else {
            PasteTarget possibleParent;
            EObject element = null;
            element = this.doPasteInto(this.getParentTarget());
            if (element == null && element == null && (this.getChildObjectInfo().hasHint("*paste=parent") || this.isCopyAlways()) && (possibleParent = this.getSuitableParentUsingAncestry(this.getChildObjectInfo().containerClass)) != null) {
                element = this.doPasteInto(possibleParent);
            }
            this.setPastedElement(element);
        }
        if (this.getPastedElement() != null) {
            this.addPastedElement(this.getPastedElement());
        } else {
            this.addPasteFailuresObject(this.getEObject());
        }
    }

    protected EObject doPasteInto(EObject pasteIntoEObject) {
        EReference reference;
        if (pasteIntoEObject != null && (reference = this.getPasteContainmentFeature(pasteIntoEObject)) != null) {
            return this.doPasteInto(pasteIntoEObject, reference);
        }
        return null;
    }

    protected EObject doPasteInto(PasteTarget pasteTarget) {
        if (pasteTarget != null) {
            if (pasteTarget.isResource()) {
                return this.doPasteInto((Resource)pasteTarget.getObject());
            }
            return this.doPasteInto((EObject)pasteTarget.getObject());
        }
        return null;
    }

    protected EObject doPasteInto(EObject pasteIntoEObject, EReference reference) {
        EObject childElement = null;
        Object value = pasteIntoEObject.eGet((EStructuralFeature)reference, true);
        if (FeatureMapUtil.isMany((EObject)pasteIntoEObject, (EStructuralFeature)reference)) {
            if (this.handleCollision(reference, (List)value, this.getEObject(), this.getChildObjectInfo())) {
                childElement = ClipboardSupportUtil.appendEObjectAt(pasteIntoEObject, reference, this.getEObject());
            } else if (this.getPastedElement() != null) {
                childElement = this.getPastedElement();
            }
        } else if (this.handleCollision(reference, (EObject)value, this.getEObject(), this.getChildObjectInfo())) {
            childElement = ClipboardSupportUtil.setEObject(pasteIntoEObject, reference, this.getEObject());
        } else if (this.getPastedElement() != null) {
            childElement = this.getPastedElement();
        }
        return childElement;
    }

    protected EObject doPasteInto(Resource pasteIntoResource) {
        EObject childElement = null;
        if (this.handleCollision(null, (List)pasteIntoResource.getContents(), this.getEObject(), this.getChildObjectInfo())) {
            childElement = ClipboardSupportUtil.appendEObject(pasteIntoResource, this.getEObject());
        } else if (this.getPastedElement() != null) {
            childElement = this.getPastedElement();
        }
        return childElement;
    }

    protected List getAlwaysCopyObjectPasteOperations() {
        if (this.alwaysCopyObjectPasteOperations == null) {
            this.alwaysCopyObjectPasteOperations = new ArrayList();
            Iterator alwaysCopyEObjectInfoIt = this.getChildObjectInfo().getCopyAlwaysObjectInfoList().iterator();
            while (alwaysCopyEObjectInfoIt.hasNext()) {
                PasteChildOperation pasteOperation;
                ObjectInfo alwaysCopyObjectInfo;
                this.getProgressMonitor().worked(1);
                if (this.isCancelled()) {
                    this.throwCancelException();
                }
                if (!this.shouldPasteAlwaysCopyObject(alwaysCopyObjectInfo = (ObjectInfo)alwaysCopyEObjectInfoIt.next()) || (pasteOperation = this.getAuxiliaryChildPasteProcess(alwaysCopyObjectInfo)) == null) continue;
                this.alwaysCopyObjectPasteOperations.add(pasteOperation);
            }
        }
        return this.alwaysCopyObjectPasteOperations;
    }

    protected boolean shouldPasteAlwaysCopyObject(ObjectInfo alwaysCopyObjectInfo) {
        EObject existingObject = this.getEObject(alwaysCopyObjectInfo.objId);
        EObject loadedEObject = this.getLoadedEObject(alwaysCopyObjectInfo.objId);
        return existingObject == null || this.getClipboardOperationHelper().getPasteCollisionAction(loadedEObject.eClass()) == PasteAction.ADD;
    }

    private PasteTarget checkPotentialParent(PasteTarget potentialParent, String preferredTypeName, boolean strictMatch) {
        if (!(potentialParent.getObject() instanceof EAnnotation)) {
            if (potentialParent.isResource()) {
                if (preferredTypeName == null || !strictMatch) {
                    return potentialParent;
                }
            } else {
                EObject potentialParentObject = (EObject)potentialParent.getObject();
                if (potentialParentObject.eClass().getInstanceClassName().equals(preferredTypeName)) {
                    return potentialParent;
                }
                if (!strictMatch && this.getPasteContainmentFeature(potentialParentObject) != null) {
                    return potentialParent;
                }
            }
        }
        return null;
    }

    public EReference getPasteContainmentFeature(EObject parentEObject) {
        return ClipboardSupportUtil.getPasteContainmentFeature(parentEObject, this.getEObject(), this.getContainmentFeature());
    }

    protected boolean handleCollision(EReference reference, List list, EObject eObject, ObjectInfo eObjectInfo) {
        PasteAction pasteCollisionAction;
        PasteAction pasteAction = pasteCollisionAction = eObjectInfo.objCopyType.equals("OCT_ALWAYS") ? PasteAction.CLONE : this.getClipboardOperationHelper().getPasteCollisionAction(eObject.eClass());
        if (pasteCollisionAction == PasteAction.DISCARD) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        EObject object = null;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            object = (EObject)it.next();
            if (!ClipboardSupportUtil.hasNameCollision(object, eObject)) continue;
            if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.ADD)) {
                ClipboardSupportUtil.rename(list, eObject, COPY);
                return true;
            }
            if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.REPLACE)) {
                if (this.canBeReplaced(object)) {
                    if (reference == null) {
                        ClipboardSupportUtil.destroyEObjectInResource(object);
                    } else {
                        ClipboardSupportUtil.destroyEObjectInCollection(object.eContainer(), reference, object);
                    }
                    return true;
                }
                return false;
            }
            if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.IGNORE)) {
                return false;
            }
            if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.MERGE)) {
                this.mergeEObjects(eObjectInfo.hasHint("*merge=weak"), object, eObject, eObjectInfo);
                this.setPastedElement(object);
                return false;
            }
            if (!((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.CLONE)) continue;
            ClipboardSupportUtil.rename(list, eObject, COPY);
            return true;
        }
        return true;
    }

    protected boolean handleCollision(EReference reference, EObject object, EObject eObject, ObjectInfo eObjectInfo) {
        PasteAction pasteCollisionAction;
        PasteAction pasteAction = pasteCollisionAction = eObjectInfo.objCopyType.equals("OCT_ALWAYS") ? PasteAction.CLONE : this.getClipboardOperationHelper().getPasteCollisionAction(eObject.eClass());
        if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.DISCARD)) {
            return false;
        }
        if (object == null) {
            return true;
        }
        if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.ADD)) {
            if (this.canBeReplaced(object)) {
                ClipboardSupportUtil.destroyEObject(object.eContainer(), reference);
                return true;
            }
            return false;
        }
        if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.REPLACE)) {
            if (this.canBeReplaced(object)) {
                ClipboardSupportUtil.destroyEObject(object.eContainer(), reference);
                return true;
            }
            return false;
        }
        if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.IGNORE)) {
            return false;
        }
        if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.MERGE)) {
            this.mergeEObjects(eObjectInfo.hasHint("*merge=weak"), object, eObject, eObjectInfo);
            this.setPastedElement(object);
            return false;
        }
        if (((Object)((Object)pasteCollisionAction)).equals((Object)PasteAction.CLONE)) {
            if (this.canBeReplaced(object)) {
                ClipboardSupportUtil.destroyEObject(object.eContainer(), reference);
                return true;
            }
            return false;
        }
        return true;
    }

    protected List mergeLists(EReference reference, List targetObjectList, List objectList, ObjectInfo objectInfo) {
        ArrayList<EObject> mergedList = new ArrayList<EObject>();
        mergedList.addAll(targetObjectList);
        if (targetObjectList.equals(objectList)) {
            return mergedList;
        }
        EObject eObject = null;
        Iterator childIt = objectList.iterator();
        while (childIt.hasNext()) {
            eObject = (EObject)childIt.next();
            if (!this.handleCollision(reference, mergedList, eObject, objectInfo)) continue;
            mergedList.add(eObject);
        }
        return mergedList;
    }

    protected void mergeEObjects(boolean weakMerge, EObject targetEObject, EObject eObject, ObjectInfo objectInfo) {
        if (targetEObject.equals(eObject)) {
            return;
        }
        MergedEObjectInfo info = (MergedEObjectInfo)this.getAllMergedElementsMap().get(eObject);
        if (info != null && info.targetEObjects.contains(targetEObject)) {
            return;
        }
        if (info == null) {
            info = new MergedEObjectInfo();
            info.mergedEObject = eObject;
            info.mergedEObjectID = this.getLoadedEObjectID(eObject);
            this.addMergedElementEntry(eObject, info);
        }
        info.targetEObjects.add(targetEObject);
        Iterator it = eObject.eClass().getEAllReferences().iterator();
        EReference reference = null;
        while (it.hasNext()) {
            EObject targetObjectValue;
            reference = (EReference)it.next();
            if (!reference.isChangeable()) continue;
            Object unresolvedEObjectValue = eObject.eGet((EStructuralFeature)reference, false);
            if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)reference)) {
                List childList = (List)unresolvedEObjectValue;
                if (childList.isEmpty()) continue;
                List targetObjectList = (List)targetEObject.eGet((EStructuralFeature)reference, true);
                List mergedList = this.mergeLists(reference, targetObjectList, childList, objectInfo);
                ClipboardSupportUtil.setEObjectList(targetEObject, reference, mergedList);
                continue;
            }
            if (unresolvedEObjectValue == null || !this.handleCollision(reference, targetObjectValue = (EObject)targetEObject.eGet((EStructuralFeature)reference, true), (EObject)unresolvedEObjectValue, objectInfo)) continue;
            ClipboardSupportUtil.setEObject(targetEObject, reference, (EObject)unresolvedEObjectValue);
        }
        if (!weakMerge) {
            it = eObject.eClass().getEAllAttributes().iterator();
            EAttribute attribute = null;
            while (it.hasNext()) {
                attribute = (EAttribute)it.next();
                ClipboardSupportUtil.setEAttribute(targetEObject, attribute, eObject.eGet((EStructuralFeature)attribute));
            }
        }
    }

    protected ObjectInfo getChildObjectInfo() {
        return this.childObjectInfo;
    }

    protected PasteChildOperation getMainChildPasteProcess() {
        return this.mainChildPasteProcess;
    }

    public boolean isAuxiliaryOperation() {
        return this.getMainChildPasteProcess() != null;
    }

    protected ObjectInfo getCopyParentObjectInfo() {
        if (this.copyParentObjectInfo == null) {
            this.copyParentObjectInfo = (ObjectInfo)this.getResourceInfo().objects.get(this.getChildObjectInfo().copyParentId);
        }
        return this.copyParentObjectInfo;
    }

    protected boolean isCopyParentDirectParent() {
        return this.getChildObjectInfo().containerId.equals(this.getCopyParentObjectInfo().objId);
    }

    protected void setPastedElement(EObject pastedElement) {
        this.pastedElement = pastedElement;
    }

    protected boolean canBeReplaced(EObject eObject) {
        if (!this.getParentTarget().isResource()) {
            if (eObject.equals(this.getParentEObject())) {
                return false;
            }
            if (ClipboardSupportUtil.isChild(eObject, this.getParentEObject())) {
                return false;
            }
        }
        return true;
    }
}

