/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.codegen.gmfgen.CompositeFeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.gmf.codegen.gmfgen.GenAuditedMetricTarget;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenDomainAttributeTarget;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenElementInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkConstraints;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenMeasurable;
import org.eclipse.gmf.codegen.gmfgen.GenMetricContainer;
import org.eclipse.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenRuleTarget;
import org.eclipse.gmf.codegen.gmfgen.GenSeverity;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.LabelOffsetAttributes;
import org.eclipse.gmf.codegen.gmfgen.LinkLabelAlignment;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ProviderPriority;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.AlignmentFacet;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.LabelOffsetFacet;
import org.eclipse.gmf.internal.bridge.History;
import org.eclipse.gmf.internal.bridge.Knowledge;
import org.eclipse.gmf.internal.bridge.NaiveIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.EcoreGenModelMatcher;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelMatcher;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.MappingTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.tooldef.PaletteHandler;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.AuditedMetricTarget;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.DiagramElementTarget;
import org.eclipse.gmf.mappings.DomainAttributeTarget;
import org.eclipse.gmf.mappings.DomainElementTarget;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.Language;
import org.eclipse.gmf.mappings.LinkConstraints;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.MetricContainer;
import org.eclipse.gmf.mappings.MetricRule;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.NotationElementTarget;
import org.eclipse.gmf.mappings.Severity;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.mappings.ValueExpression;

public class DiagramGenModelTransformer
extends MappingTransformer {
    private GenEditorGenerator myGenModel;
    protected GenModelMatcher myGenModelMatch;
    private final DiagramRunTimeModelHelper myDRTHelper;
    private final ViewmapProducer myViewmaps;
    private final VisualIdentifierDispenser myVisualIDs;
    private final History myHistory;
    private final Map myProcessedTypes = new IdentityHashMap();
    private final Set myProcessedExpressions = new HashSet();
    private final GenModelNamingMediator myNamingStrategy;
    private final PaletteHandler myPaletteProcessor;
    private final EcoreGenModelMatcher myEcoreGenModelMatch;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DiagramGenModelTransformer(DiagramRunTimeModelHelper drtHelper, GenModelNamingMediator namingStrategy) {
        this(drtHelper, namingStrategy, new InnerClassViewmapProducer(), new NaiveIdentifierDispenser());
    }

    public DiagramGenModelTransformer(DiagramRunTimeModelHelper drtHelper, GenModelNamingMediator namingStrategy, ViewmapProducer viewmaps, VisualIdentifierDispenser visualIdD) {
        if (!($assertionsDisabled || drtHelper != null && namingStrategy != null && viewmaps != null)) {
            throw new AssertionError();
        }
        this.myDRTHelper = drtHelper;
        this.myNamingStrategy = namingStrategy;
        this.myViewmaps = viewmaps;
        this.myVisualIDs = visualIdD;
        this.myHistory = new History();
        this.myPaletteProcessor = new PaletteHandler();
        this.myEcoreGenModelMatch = new EcoreGenModelMatcher();
    }

    public void setEMFGenModel(GenModel emfGenModel) {
        this.myGenModelMatch = new GenModelMatcher(emfGenModel);
    }

    public GenEditorGenerator getResult() {
        return this.getGenEssence();
    }

    private GenEditorGenerator getGenEssence() {
        if (this.myGenModel == null) {
            this.myGenModel = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        }
        if (this.myGenModel.getEditor() == null) {
            this.myGenModel.setEditor(GMFGenFactory.eINSTANCE.createGenEditorView());
        }
        return this.myGenModel;
    }

    private GenDiagram getGenDiagram() {
        if (this.getGenEssence().getDiagram() == null) {
            this.getGenEssence().setDiagram(GMFGenFactory.eINSTANCE.createGenDiagram());
        }
        return this.getGenEssence().getDiagram();
    }

    private void initGenPlugin() {
        if (this.getGenEssence().getPlugin() == null) {
            this.getGenEssence().setPlugin(GMFGenFactory.eINSTANCE.createGenPlugin());
        }
    }

    private Palette createGenPalette() {
        Palette p = this.getGenDiagram().getPalette();
        if (p == null) {
            p = GMFGenFactory.eINSTANCE.createPalette();
            this.getGenDiagram().setPalette(p);
        }
        return p;
    }

    protected void process(CanvasMapping mapping) {
        if (this.myGenModelMatch == null && mapping.getDomainModel() != null) {
            this.myGenModelMatch = new GenModelMatcher(mapping.getDomainModel());
        }
        this.myHistory.purge();
        if (mapping.getPalette() != null) {
            this.myPaletteProcessor.initialize(this.createGenPalette());
            this.myPaletteProcessor.process(mapping.getPalette());
        }
        GenPackage primaryPackage = this.findGenPackage(mapping.getDomainModel());
        this.getGenEssence().setDomainGenModel(primaryPackage == null ? null : primaryPackage.getGenModel());
        this.getGenDiagram().setDomainDiagramElement(this.findGenClass(mapping.getDomainMetaElement()));
        this.getGenDiagram().setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        this.getGenDiagram().setVisualID(this.myVisualIDs.get(this.getGenDiagram()));
        this.getGenDiagram().setViewmap(this.myViewmaps.create(mapping.getDiagramCanvas()));
        this.getGenDiagram().setIconProviderPriority(ProviderPriority.LOW_LITERAL);
        if (this.getGenDiagram().getDomainDiagramElement() != null) {
            this.getGenDiagram().setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
            this.myProcessedTypes.put(this.getGenDiagram().getDomainDiagramElement(), this.getGenDiagram().getElementType());
        } else {
            this.getGenDiagram().setElementType((ElementType)GMFGenFactory.eINSTANCE.createNotationType());
        }
        this.initGenPlugin();
        this.myNamingStrategy.feed(this.getGenDiagram(), mapping);
    }

    protected void process(TopNodeReference topNode) {
        NodeMapping nme = topNode.getChild();
        if (!$assertionsDisabled && nme == null) {
            throw new AssertionError();
        }
        this.assertNodeMapping(nme);
        GenTopLevelNode genNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        this.getGenDiagram().getTopLevelNodes().add((Object)genNode);
        genNode.setDiagramRunTimeClass(this.findRunTimeClass(nme));
        genNode.setModelFacet(this.createModelFacet((NodeReference)topNode));
        genNode.setVisualID(this.myVisualIDs.get(genNode));
        genNode.setViewmap(this.myViewmaps.create(nme.getDiagramNode()));
        this.setupElementType((GenNode)genNode);
        this.myPaletteProcessor.process(nme, (GenNode)genNode);
        this.myNamingStrategy.feed(genNode, nme);
        this.processAbstractNode(nme, (GenNode)genNode);
        this.myHistory.log(nme, genNode);
    }

    protected void process(AuditContainer audits) {
        if (audits != null) {
            this.getGenEssence().setAudits(this.createGenAuditContainer(audits));
        }
    }

    protected void process(MetricContainer metrics) {
        if (metrics != null) {
            GenMetricContainer genMetricContainer = GMFGenFactory.eINSTANCE.createGenMetricContainer();
            Iterator it = metrics.getMetrics().iterator();
            while (it.hasNext()) {
                genMetricContainer.getMetrics().add((Object)this.createGenMetric((MetricRule)it.next()));
            }
            this.getGenEssence().setMetrics(genMetricContainer);
        }
    }

    private void process(ChildReference childNodeRef, GenChildContainer container) {
        GenChildNode childNode;
        NodeMapping childNodeMapping = childNodeRef.getChild();
        if (!$assertionsDisabled && childNodeMapping == null) {
            throw new AssertionError();
        }
        this.assertNodeMapping(childNodeMapping);
        if (!this.myHistory.isKnownChildNode(childNodeMapping)) {
            childNode = this.createGenChildNode(childNodeRef);
        } else {
            GenChildNode[] alreadyKnownChildren = this.myHistory.findChildNodes(childNodeMapping);
            childNode = null;
            int i = 0;
            while (i < alreadyKnownChildren.length) {
                if (DiagramGenModelTransformer.matchChildReferenceFeatures(childNodeRef, alreadyKnownChildren[i])) {
                    childNode = alreadyKnownChildren[i];
                    break;
                }
                ++i;
            }
            if (childNode == null) {
                childNode = this.createGenChildNode(childNodeRef);
            }
        }
        if (container instanceof GenCompartment && childNodeMapping.getChildren().size() > 0) {
            ((GenCompartment)container).setListLayout(false);
        }
        container.getChildNodes().add((Object)childNode);
    }

    private static boolean matchChildReferenceFeatures(ChildReference childNodeRef, GenChildNode childNode) {
        boolean childrenFeatureMatch;
        boolean containmentFeatureMatch;
        if (childNode.getModelFacet() == null || childNode.getModelFacet().getContainmentMetaFeature() == null) {
            containmentFeatureMatch = childNodeRef.getContainmentFeature() == null;
        } else {
            boolean bl = containmentFeatureMatch = childNodeRef.getContainmentFeature() == childNode.getModelFacet().getContainmentMetaFeature().getEcoreFeature();
        }
        if (childNode.getModelFacet() == null || childNode.getModelFacet().getChildMetaFeature() == null) {
            childrenFeatureMatch = childNodeRef.getChildrenFeature() == null;
        } else if (childNodeRef.getChildrenFeature() == null) {
            childrenFeatureMatch = childNode.getModelFacet().getChildMetaFeature() == childNode.getModelFacet().getContainmentMetaFeature();
        } else {
            boolean bl = childrenFeatureMatch = childNode.getModelFacet().getChildMetaFeature().getEcoreFeature() == childNodeRef.getChildrenFeature();
        }
        return containmentFeatureMatch && childrenFeatureMatch;
    }

    private GenChildNode createGenChildNode(ChildReference childNodeRef) {
        boolean needCompartmentChildrenLabelProcessing;
        GenChildNode childNode;
        NodeMapping childNodeMapping = childNodeRef.getChild();
        if (this.isPureLabelNode(childNodeMapping)) {
            LabelMapping soleLabel = (LabelMapping)childNodeMapping.getLabelMappings().get(0);
            GenChildLabelNode childLabelNode = GMFGenFactory.eINSTANCE.createGenChildLabelNode();
            childLabelNode.setViewmap(this.myViewmaps.create(soleLabel.getDiagramLabel()));
            childLabelNode.setLabelModelFacet(this.createLabelModelFacet(soleLabel));
            childLabelNode.setLabelReadOnly(soleLabel.isReadOnly());
            childLabelNode.setLabelElementIcon(soleLabel.getDiagramLabel().isElementIcon());
            childNode = childLabelNode;
            needCompartmentChildrenLabelProcessing = false;
        } else {
            childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
            childNode.setViewmap(this.myViewmaps.create(childNodeMapping.getDiagramNode()));
            needCompartmentChildrenLabelProcessing = true;
        }
        this.myHistory.log(childNodeMapping, childNode);
        this.getGenDiagram().getChildNodes().add((Object)childNode);
        childNode.setModelFacet(this.createModelFacet((NodeReference)childNodeRef));
        childNode.setDiagramRunTimeClass(this.findRunTimeClass(childNodeMapping));
        childNode.setVisualID(this.myVisualIDs.get(childNode));
        this.setupElementType((GenNode)childNode);
        this.myNamingStrategy.feed(childNode, childNodeMapping);
        this.myPaletteProcessor.process(childNodeMapping, (GenNode)childNode);
        if (needCompartmentChildrenLabelProcessing) {
            this.processAbstractNode(childNodeMapping, (GenNode)childNode);
        }
        return childNode;
    }

    private boolean isPureLabelNode(NodeMapping childNodeMapping) {
        if (childNodeMapping.getLabelMappings().size() == 1 && childNodeMapping.getChildren().isEmpty()) {
            LabelMapping soleLabel = (LabelMapping)childNodeMapping.getLabelMappings().get(0);
            return childNodeMapping.getDiagramNode() == soleLabel.getDiagramLabel();
        }
        return false;
    }

    private void processAbstractNode(NodeMapping mapping, GenNode genNode) {
        HashMap<CompartmentMapping, GenCompartment> compartments2GenCompartmentsMap = new HashMap<CompartmentMapping, GenCompartment>();
        Iterator it = mapping.getCompartments().iterator();
        while (it.hasNext()) {
            CompartmentMapping compartmentMapping = (CompartmentMapping)it.next();
            GenCompartment compartmentGen = this.createGenCompartment(compartmentMapping, genNode);
            compartments2GenCompartmentsMap.put(compartmentMapping, compartmentGen);
        }
        it = mapping.getChildren().iterator();
        while (it.hasNext()) {
            ChildReference childNodeRef = (ChildReference)it.next();
            CompartmentMapping compartmentMapping = childNodeRef.getCompartment();
            Object genChildContainer = compartmentMapping != null && compartments2GenCompartmentsMap.containsKey(compartmentMapping) ? (GenChildContainer)compartments2GenCompartmentsMap.get(compartmentMapping) : genNode;
            this.process(childNodeRef, (GenChildContainer)genChildContainer);
        }
        Iterator labels = mapping.getLabelMappings().iterator();
        while (labels.hasNext()) {
            LabelMapping labelMapping = (LabelMapping)labels.next();
            GenNodeLabel label = this.createNodeLabel(genNode, labelMapping);
            this.myNamingStrategy.feed(label, labelMapping);
        }
    }

    private GenCompartment createGenCompartment(CompartmentMapping mapping, GenNode genNode) {
        Compartment compartment = mapping.getCompartment();
        if (!$assertionsDisabled && compartment == null) {
            throw new AssertionError();
        }
        GenCompartment childCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        this.getGenDiagram().getCompartments().add((Object)childCompartment);
        genNode.getCompartments().add((Object)childCompartment);
        childCompartment.setVisualID(this.myVisualIDs.get(childCompartment));
        childCompartment.setDiagramRunTimeClass(this.getChildContainerRunTimeClass());
        childCompartment.setViewmap(this.myViewmaps.create(mapping.getCompartment()));
        childCompartment.setCanCollapse(compartment.isCollapsible());
        childCompartment.setNeedsTitle(compartment.isNeedsTitle());
        childCompartment.setTitle(compartment.getName());
        this.myNamingStrategy.feed(childCompartment, mapping);
        return childCompartment;
    }

    protected void process(LinkMapping lme) {
        this.assertLinkMapping(lme);
        GenLink gl = GMFGenFactory.eINSTANCE.createGenLink();
        this.getGenDiagram().getLinks().add((Object)gl);
        gl.setModelFacet(this.createModelFacet(lme));
        gl.setVisualID(this.myVisualIDs.get(gl));
        this.myPaletteProcessor.process(lme, gl);
        Iterator labels = lme.getLabelMappings().iterator();
        while (labels.hasNext()) {
            LabelMapping labelMapping = (LabelMapping)labels.next();
            GenLinkLabel label = this.createLinkLabel(gl, labelMapping);
            this.myNamingStrategy.feed(label, labelMapping);
        }
        gl.setDiagramRunTimeClass(this.findRunTimeClass(lme));
        this.setupElementType(gl);
        this.myNamingStrategy.feed(gl, lme);
        gl.setViewmap(this.myViewmaps.create(lme.getDiagramLink()));
        if (lme.getCreationConstraints() != null) {
            gl.setCreationConstraints(this.createLinkCreationConstraints(lme.getCreationConstraints()));
        }
        this.myHistory.log(lme, gl);
    }

    private GenNodeLabel createNodeLabel(GenNode node, LabelMapping mapping) {
        Object label = Knowledge.isExternal(mapping.getDiagramLabel()) ? GMFGenFactory.eINSTANCE.createGenExternalNodeLabel() : GMFGenFactory.eINSTANCE.createGenNodeLabel();
        node.getLabels().add(label);
        label.setVisualID(this.myVisualIDs.get((GenNodeLabel)label));
        label.setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        label.setViewmap(this.myViewmaps.create(mapping.getDiagramLabel()));
        label.setModelFacet(this.createLabelModelFacet(mapping));
        label.setReadOnly(mapping.isReadOnly());
        label.setElementIcon(mapping.getDiagramLabel().isElementIcon());
        return label;
    }

    private GenLinkLabel createLinkLabel(GenLink link, LabelMapping mapping) {
        LabelOffsetFacet lof;
        GenLinkLabel label = GMFGenFactory.eINSTANCE.createGenLinkLabel();
        link.getLabels().add((Object)label);
        label.setVisualID(this.myVisualIDs.get(label));
        label.setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        label.setViewmap(this.myViewmaps.create(mapping.getDiagramLabel()));
        label.setModelFacet(this.createLabelModelFacet(mapping));
        label.setReadOnly(mapping.isReadOnly());
        label.setElementIcon(mapping.getDiagramLabel().isElementIcon());
        DiagramLabel diagramLabel = mapping.getDiagramLabel();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.gmfgraph.AlignmentFacet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (diagramLabel.find((Class)clazz) != null) {
            DiagramLabel diagramLabel2 = mapping.getDiagramLabel();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.gmf.gmfgraph.AlignmentFacet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            AlignmentFacet af = (AlignmentFacet)diagramLabel2.find((Class)clazz2);
            label.setAlignment(this.getLinkLabelAlignment(af.getAlignment()));
        }
        LabelOffsetAttributes loa = GMFGenFactory.eINSTANCE.createLabelOffsetAttributes();
        DiagramLabel diagramLabel3 = mapping.getDiagramLabel();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.gmf.gmfgraph.LabelOffsetFacet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((lof = (LabelOffsetFacet)diagramLabel3.find((Class)clazz3)) != null) {
            loa.setX(lof.getX());
            loa.setY(lof.getY());
        } else {
            int weight = link.getLabels().size() + 1;
            loa.setY(weight * 20);
        }
        label.getViewmap().getAttributes().add((Object)loa);
        return label;
    }

    private LinkLabelAlignment getLinkLabelAlignment(Alignment alignment) {
        switch (alignment.getValue()) {
            case 0: {
                return LinkLabelAlignment.SOURCE_LITERAL;
            }
            case 1: {
                return LinkLabelAlignment.MIDDLE_LITERAL;
            }
            case 2: {
                return LinkLabelAlignment.TARGET_LITERAL;
            }
        }
        throw new IllegalArgumentException("Link doesn't support alignment:" + alignment.getName());
    }

    private LabelModelFacet createLabelModelFacet(LabelMapping mapping) {
        if (mapping.getFeatures().size() == 1) {
            FeatureLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
            modelFacet.setMetaFeature(this.findGenFeature((EStructuralFeature)((EAttribute)mapping.getFeatures().get(0))));
            modelFacet.setViewPattern(mapping.getViewPattern());
            modelFacet.setEditPattern(mapping.getEditPattern());
            return modelFacet;
        }
        if (mapping.getFeatures().size() > 1) {
            CompositeFeatureLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createCompositeFeatureLabelModelFacet();
            Iterator features = mapping.getFeatures().iterator();
            while (features.hasNext()) {
                modelFacet.getMetaFeatures().add((Object)this.findGenFeature((EStructuralFeature)((EAttribute)features.next())));
            }
            modelFacet.setViewPattern(mapping.getViewPattern());
            modelFacet.setEditPattern(mapping.getEditPattern());
            return modelFacet;
        }
        if (this.myGenModelMatch == null) {
            return GMFGenFactory.eINSTANCE.createDesignLabelModelFacet();
        }
        return null;
    }

    private void setupElementType(GenNode genNode) {
        if (genNode.getModelFacet() != null) {
            MetamodelType metamodelType = (MetamodelType)this.myProcessedTypes.get(genNode.getModelFacet().getMetaClass());
            if (metamodelType == null) {
                genNode.setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
                this.myProcessedTypes.put(genNode.getModelFacet().getMetaClass(), genNode.getElementType());
            } else {
                SpecializationType specializationType = GMFGenFactory.eINSTANCE.createSpecializationType();
                specializationType.setMetamodelType(metamodelType);
                genNode.setElementType((ElementType)specializationType);
            }
        } else {
            genNode.setElementType((ElementType)GMFGenFactory.eINSTANCE.createNotationType());
        }
    }

    private void setupElementType(GenLink gl) {
        if (gl.getModelFacet() != null) {
            if (gl.getModelFacet() instanceof TypeModelFacet) {
                GenClass metaClass = ((TypeModelFacet)gl.getModelFacet()).getMetaClass();
                MetamodelType metamodelType = (MetamodelType)this.myProcessedTypes.get(metaClass);
                if (metamodelType == null) {
                    gl.setElementType((ElementType)GMFGenFactory.eINSTANCE.createMetamodelType());
                    this.myProcessedTypes.put(metaClass, gl.getElementType());
                } else {
                    SpecializationType specializationType = GMFGenFactory.eINSTANCE.createSpecializationType();
                    specializationType.setMetamodelType(metamodelType);
                    gl.setElementType((ElementType)specializationType);
                }
            } else {
                SpecializationType specializationType = GMFGenFactory.eINSTANCE.createSpecializationType();
                gl.setElementType((ElementType)specializationType);
            }
        } else {
            gl.setElementType((ElementType)GMFGenFactory.eINSTANCE.createNotationType());
        }
    }

    private GenClass findRunTimeClass(NodeMapping nme) {
        return this.myDRTHelper.get(nme);
    }

    private GenClass findRunTimeClass(LinkMapping lme) {
        return this.myDRTHelper.get(lme);
    }

    private GenClass findRunTimeClass(CanvasMapping mapping) {
        return this.myDRTHelper.get(mapping);
    }

    private GenClass getChildContainerRunTimeClass() {
        return this.myDRTHelper.getChildContainerDefault();
    }

    private GenClass findRunTimeClass(LabelMapping mapping) {
        return this.myDRTHelper.get(mapping);
    }

    private void assertNodeMapping(NodeMapping mapping) {
        if (!$assertionsDisabled && mapping.getDiagramNode() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !DiagramGenModelTransformer.checkLabelMappings((MappingEntry)mapping)) {
            throw new AssertionError();
        }
    }

    private void assertLinkMapping(LinkMapping linkMapping) {
        if (!$assertionsDisabled && linkMapping.getDiagramLink() == null) {
            throw new AssertionError();
        }
        if (linkMapping.getDomainMetaElement() != null && !$assertionsDisabled && linkMapping.getLinkMetaFeature() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !DiagramGenModelTransformer.checkLabelMappings((MappingEntry)linkMapping)) {
            throw new AssertionError();
        }
    }

    private static boolean checkLabelMappings(MappingEntry entry) {
        boolean ok = true;
        Iterator it = entry.getLabelMappings().iterator();
        while (ok && it.hasNext()) {
            ok = DiagramGenModelTransformer.checkLabelFeatureValidity((LabelMapping)it.next());
        }
        return ok;
    }

    private static boolean checkLabelFeatureValidity(LabelMapping labelMapping) {
        EClass domainElement = labelMapping.getMapEntry().getDomainContext();
        boolean isOk = true;
        Iterator it = labelMapping.getFeatures().iterator();
        while (isOk && it.hasNext()) {
            EClass attrContainer = ((EAttribute)it.next()).getEContainingClass();
            isOk = attrContainer.isSuperTypeOf(domainElement);
        }
        return isOk;
    }

    private GenPackage findGenPackage(EPackage ePackage) {
        if (this.myGenModelMatch == null) {
            this.warnNoGenModelMatcher((EModelElement)ePackage);
            return null;
        }
        return this.myGenModelMatch.findGenPackage(ePackage);
    }

    private GenClass findGenClass(EClass eClass) {
        if (this.myGenModelMatch == null) {
            this.warnNoGenModelMatcher((EModelElement)eClass);
            return null;
        }
        return this.myGenModelMatch.findGenClass(eClass);
    }

    private GenFeature findGenFeature(EStructuralFeature feature) {
        if (this.myGenModelMatch == null) {
            this.warnNoGenModelMatcher((EModelElement)feature);
            return null;
        }
        return this.myGenModelMatch.findGenFeature(feature);
    }

    private void warnNoGenModelMatcher(EModelElement element) {
    }

    private TypeModelFacet createModelFacet(NodeReference anm) {
        NodeMapping nodeMapping = anm.getChild();
        if (nodeMapping.getDomainContext() == null) {
            return null;
        }
        TypeModelFacet typeModelFacet = this.setupModelFacet(nodeMapping.getDomainContext(), (EStructuralFeature)anm.getContainmentFeature(), (EStructuralFeature)anm.getChildrenFeature());
        return this.setupAux(typeModelFacet, nodeMapping.getDomainSpecialization(), nodeMapping.getDomainInitializer());
    }

    private LinkModelFacet createModelFacet(LinkMapping lme) {
        if (lme.getDomainMetaElement() != null) {
            TypeLinkModelFacet mf = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
            mf.setMetaClass(this.findGenClass(lme.getDomainMetaElement()));
            mf.setContainmentMetaFeature(this.findGenFeature((EStructuralFeature)lme.getContainmentFeature()));
            mf.setChildMetaFeature(mf.getContainmentMetaFeature());
            mf.setSourceMetaFeature(this.findGenFeature(lme.getSourceMetaFeature()));
            mf.setTargetMetaFeature(this.findGenFeature(lme.getLinkMetaFeature()));
            this.setupAux((TypeModelFacet)mf, lme.getDomainSpecialization(), lme.getDomainInitializer());
            return mf;
        }
        if (lme.getLinkMetaFeature() != null) {
            FeatureLinkModelFacet mf = GMFGenFactory.eINSTANCE.createFeatureLinkModelFacet();
            mf.setMetaFeature(this.findGenFeature(lme.getLinkMetaFeature()));
            return mf;
        }
        return null;
    }

    private GenLinkConstraints createLinkCreationConstraints(LinkConstraints constraints) {
        Constraint targetConstraint;
        LinkMapping lme = constraints.getLinkMapping();
        if (lme == null) {
            return null;
        }
        GenLinkConstraints genConstraints = GMFGenFactory.eINSTANCE.createGenLinkConstraints();
        Constraint sourceConstraint = constraints.getSourceEnd();
        if (sourceConstraint != null) {
            genConstraints.setSourceEnd(this.createGenConstraint(sourceConstraint));
        }
        if ((targetConstraint = constraints.getTargetEnd()) != null) {
            genConstraints.setTargetEnd(this.createGenConstraint(targetConstraint));
        }
        return genConstraints;
    }

    private TypeModelFacet setupModelFacet(EClass domainMetaElement, EStructuralFeature containmentFeature, EStructuralFeature childFeature) {
        TypeModelFacet mf = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        mf.setMetaClass(this.findGenClass(domainMetaElement));
        mf.setContainmentMetaFeature(this.findGenFeature(containmentFeature));
        mf.setChildMetaFeature(childFeature == null ? mf.getContainmentMetaFeature() : this.findGenFeature(childFeature));
        return mf;
    }

    private TypeModelFacet setupAux(TypeModelFacet typeModelFacet, Constraint spec, ElementInitializer init) {
        if (spec != null) {
            typeModelFacet.setModelElementSelector(this.createGenConstraint(spec));
        }
        if (init != null) {
            typeModelFacet.setModelElementInitializer(this.createElementInitializer(init));
        }
        return typeModelFacet;
    }

    private GenElementInitializer createElementInitializer(ElementInitializer elementInitializer) {
        if (elementInitializer instanceof FeatureSeqInitializer) {
            FeatureSeqInitializer fsInitializer = (FeatureSeqInitializer)elementInitializer;
            GenFeatureSeqInitializer fSeqInitializer = GMFGenFactory.eINSTANCE.createGenFeatureSeqInitializer();
            Iterator it = fsInitializer.getInitializers().iterator();
            while (it.hasNext()) {
                FeatureValueSpec nextValSpec = (FeatureValueSpec)it.next();
                GenFeatureValueSpec nextGenValSpec = GMFGenFactory.eINSTANCE.createGenFeatureValueSpec();
                nextGenValSpec.setBody(nextValSpec.getBody());
                nextGenValSpec.setLanguage(DiagramGenModelTransformer.createGenLanguage(nextValSpec.getLanguage()));
                nextGenValSpec.setFeature(this.findGenFeature(nextValSpec.getFeature()));
                this.bindToProvider((ValueExpression)nextValSpec, (org.eclipse.gmf.codegen.gmfgen.ValueExpression)nextGenValSpec);
                fSeqInitializer.getInitializers().add((Object)nextGenValSpec);
            }
            return fSeqInitializer;
        }
        return null;
    }

    private static GenLanguage createGenLanguage(Language mapLang) {
        switch (mapLang.getValue()) {
            case 0: {
                return GenLanguage.OCL_LITERAL;
            }
            case 1: {
                return GenLanguage.JAVA_LITERAL;
            }
            case 2: {
                return GenLanguage.REGEXP_LITERAL;
            }
            case 3: {
                return GenLanguage.NREGEXP_LITERAL;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(mapLang);
        }
        return GenLanguage.OCL_LITERAL;
    }

    private GenConstraint createGenConstraint(Constraint constraint) {
        if (constraint.getBody() == null) {
            return null;
        }
        GenConstraint modelElementSelector = GMFGenFactory.eINSTANCE.createGenConstraint();
        modelElementSelector.setBody(constraint.getBody());
        modelElementSelector.setLanguage(DiagramGenModelTransformer.createGenLanguage(constraint.getLanguage()));
        this.bindToProvider((ValueExpression)constraint, (org.eclipse.gmf.codegen.gmfgen.ValueExpression)modelElementSelector);
        return modelElementSelector;
    }

    private GenAuditContainer createGenAuditContainer(AuditContainer ac) {
        GenAuditContainer gac = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        gac.setId(ac.getId());
        gac.setName(ac.getName());
        gac.setDescription(ac.getDescription());
        Iterator it = ac.getChildContainers().iterator();
        while (it.hasNext()) {
            AuditContainer nextChild = (AuditContainer)it.next();
            gac.getChildContainers().add((Object)this.createGenAuditContainer(nextChild));
        }
        it = ac.getAudits().iterator();
        while (it.hasNext()) {
            gac.getAudits().add((Object)this.createGenAudit((AuditRule)it.next()));
        }
        return gac;
    }

    private GenAuditRule createGenAudit(AuditRule audit) {
        Constraint rule;
        GenAuditRule genAudit = GMFGenFactory.eINSTANCE.createGenAuditRule();
        genAudit.setId(audit.getId());
        genAudit.setName(audit.getName());
        genAudit.setMessage(audit.getMessage());
        genAudit.setDescription(audit.getDescription());
        genAudit.setUseInLiveMode(audit.isUseInLiveMode());
        if (audit.getTarget() != null) {
            GenRuleTarget genTarget = this.createRuleTarget((EObject)audit.getTarget());
            if (!$assertionsDisabled && !(genTarget instanceof GenAuditable)) {
                throw new AssertionError();
            }
            if (genTarget instanceof GenAuditable) {
                genAudit.setTarget((GenAuditable)genTarget);
            }
        }
        if ((rule = audit.getRule()) != null) {
            genAudit.setRule(this.createGenConstraint(rule));
        }
        Severity severity = audit.getSeverity();
        GenSeverity genSeverity = null;
        if (severity == Severity.INFO_LITERAL) {
            genSeverity = GenSeverity.INFO_LITERAL;
        } else if (severity == Severity.WARNING_LITERAL) {
            genSeverity = GenSeverity.WARNING_LITERAL;
        } else if (severity == Severity.ERROR_LITERAL) {
            genSeverity = GenSeverity.ERROR_LITERAL;
        }
        if (genSeverity != null) {
            genAudit.setSeverity(genSeverity);
        }
        return genAudit;
    }

    private GenRuleTarget createRuleTarget(EObject ruleTarget) {
        if (ruleTarget instanceof DomainElementTarget) {
            DomainElementTarget domainTarget = (DomainElementTarget)ruleTarget;
            GenDomainElementTarget genDomainTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
            genDomainTarget.setElement(domainTarget.getElement() != null ? this.findGenClass(domainTarget.getElement()) : null);
            return genDomainTarget;
        }
        if (ruleTarget instanceof NotationElementTarget) {
            NotationElementTarget notationTarget = (NotationElementTarget)ruleTarget;
            GenNotationElementTarget genNotationTarget = GMFGenFactory.eINSTANCE.createGenNotationElementTarget();
            genNotationTarget.setElement(notationTarget.getElement() != null ? this.findGenClass(notationTarget.getElement()) : null);
            return genNotationTarget;
        }
        if (ruleTarget instanceof DiagramElementTarget) {
            GenDiagramElementTarget diagramTarget = GMFGenFactory.eINSTANCE.createGenDiagramElementTarget();
            MappingEntry mappingEntry = ((DiagramElementTarget)ruleTarget).getElement();
            if (mappingEntry != null) {
                LinkMapping lm = mappingEntry instanceof LinkMapping ? (LinkMapping)mappingEntry : null;
                GenLink genBase = null;
                if (lm != null) {
                    genBase = this.myHistory.find(lm);
                    if (!$assertionsDisabled && genBase == null) {
                        throw new AssertionError();
                    }
                    if (genBase != null) {
                        diagramTarget.getElement().add((Object)genBase);
                    }
                } else {
                    NodeMapping nm = mappingEntry instanceof NodeMapping ? (NodeMapping)mappingEntry : null;
                    genBase = this.myHistory.findTopNode(nm);
                    if (genBase != null) {
                        diagramTarget.getElement().add((Object)genBase);
                    }
                    diagramTarget.getElement().addAll(Arrays.asList(this.myHistory.findChildNodes(nm)));
                }
            }
            return diagramTarget;
        }
        if (ruleTarget instanceof AuditedMetricTarget) {
            GenAuditedMetricTarget genMetricTarget = GMFGenFactory.eINSTANCE.createGenAuditedMetricTarget();
            AuditedMetricTarget metricTarget = (AuditedMetricTarget)ruleTarget;
            if (metricTarget.getMetric() != null) {
                genMetricTarget.setMetric(this.myHistory.find(metricTarget.getMetric()));
            }
            GenClassifier resultClassifier = this.myEcoreGenModelMatch.findGenClassifier((EClassifier)EcorePackage.eINSTANCE.getEDoubleObject());
            if (!$assertionsDisabled && !(resultClassifier instanceof GenDataType)) {
                throw new AssertionError();
            }
            if (resultClassifier instanceof GenDataType) {
                genMetricTarget.setMetricValueContext((GenDataType)resultClassifier);
            }
            return genMetricTarget;
        }
        if (ruleTarget instanceof DomainAttributeTarget) {
            DomainAttributeTarget attrTarget = (DomainAttributeTarget)ruleTarget;
            GenDomainAttributeTarget genAttrTarget = GMFGenFactory.eINSTANCE.createGenDomainAttributeTarget();
            if (attrTarget.getAttribute() != null) {
                genAttrTarget.setAttribute(this.findGenFeature((EStructuralFeature)attrTarget.getAttribute()));
            }
            genAttrTarget.setNullAsError(attrTarget.isNullAsError());
            return genAttrTarget;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Uknown rule target type");
        }
        return null;
    }

    private GenMetricRule createGenMetric(MetricRule metric) {
        GenMetricRule genMetric = GMFGenFactory.eINSTANCE.createGenMetricRule();
        genMetric.setKey(metric.getKey());
        genMetric.setName(metric.getName());
        genMetric.setDescription(metric.getDescription());
        genMetric.setLowLimit(metric.getLowLimit());
        genMetric.setHighLimit(metric.getHighLimit());
        if (metric.getRule() != null) {
            org.eclipse.gmf.codegen.gmfgen.ValueExpression valueExpression = GMFGenFactory.eINSTANCE.createValueExpression();
            valueExpression.setBody(metric.getRule().getBody());
            valueExpression.setLanguage(DiagramGenModelTransformer.createGenLanguage(metric.getRule().getLanguage()));
            this.bindToProvider(metric.getRule(), valueExpression);
            genMetric.setRule(valueExpression);
        }
        GenRuleTarget genTarget = this.createRuleTarget((EObject)metric.getTarget());
        if (!$assertionsDisabled && !(genTarget instanceof GenMeasurable)) {
            throw new AssertionError();
        }
        if (genTarget instanceof GenMeasurable) {
            genMetric.setTarget((GenMeasurable)genTarget);
        }
        this.myHistory.log(metric, genMetric);
        return genMetric;
    }

    private void bindToProvider(ValueExpression expression, org.eclipse.gmf.codegen.gmfgen.ValueExpression genExpression) {
        if (!this.myProcessedExpressions.add(expression)) {
            return;
        }
        GenLanguage language = genExpression.getLanguage();
        if (language == null) {
            return;
        }
        GenExpressionProviderContainer providerContainer = this.getGenEssence().getExpressionProviders();
        if (providerContainer == null) {
            providerContainer = GMFGenFactory.eINSTANCE.createGenExpressionProviderContainer();
            this.getGenEssence().setExpressionProviders(providerContainer);
        }
        GenExpressionProviderBase provider = null;
        Iterator it = providerContainer.getProviders().iterator();
        while (it.hasNext()) {
            GenExpressionProviderBase nextProvider = (GenExpressionProviderBase)it.next();
            if (!language.equals(nextProvider.getLanguage())) continue;
            provider = nextProvider;
            break;
        }
        if (provider == null) {
            provider = this.createExpressionProvider(language);
            if (provider == null) {
                return;
            }
            providerContainer.getProviders().add((Object)provider);
        }
        provider.getExpressions().add((Object)genExpression);
    }

    private GenExpressionProviderBase createExpressionProvider(GenLanguage language) {
        GenJavaExpressionProvider newProvider = null;
        if (GenLanguage.JAVA_LITERAL.equals(language)) {
            newProvider = GMFGenFactory.eINSTANCE.createGenJavaExpressionProvider();
        } else if (GenLanguage.OCL_LITERAL.equals(language)) {
            GenExpressionInterpreter oclProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
            oclProvider.setLanguage(language);
            oclProvider.getRequiredPluginIDs().addAll(Arrays.asList("org.eclipse.emf.ocl", "org.eclipse.emf.query.ocl"));
            newProvider = oclProvider;
        } else if (GenLanguage.REGEXP_LITERAL.equals(language) || GenLanguage.NREGEXP_LITERAL.equals(language)) {
            GenExpressionInterpreter regexpProvider = GMFGenFactory.eINSTANCE.createGenExpressionInterpreter();
            regexpProvider.setLanguage(language);
            newProvider = regexpProvider;
        }
        return newProvider;
    }
}

