/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.Analyzable;
import org.eclipse.gmf.internal.xpand.expression.Evaluatable;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
extends SyntaxElement
implements Analyzable,
Evaluatable {
    public Expression(int start, int end, int line) {
        super(start, end, line);
    }

    protected EClassifier findType(Identifier type, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier toCast = ctx.getTypeForName(type.getValue());
        if (toCast == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, type.getValue(), type));
        }
        return toCast;
    }

    @Override
    public final Object evaluate(ExecutionContext ctx) {
        try {
            return this.evaluateInternal(ctx);
        }
        catch (EvaluationException eve) {
            throw eve;
        }
        catch (RuntimeException ex) {
            throw new EvaluationException(ex, (SyntaxElement)this);
        }
    }

    protected abstract Object evaluateInternal(ExecutionContext var1);
}

