/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.build;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;
import org.eclipse.gmf.internal.xpand.util.StreamConverter;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceResourceManager
extends ResourceManagerImpl {
    private final IProject contextProject;

    public WorkspaceResourceManager(IProject context) {
        this.contextProject = context;
    }

    public XtendResource loadXtendResource(IFile file) throws CoreException, IOException, ParserException {
        if (file == null) {
            return null;
        }
        assert (file.getProject() == this.contextProject);
        Reader r = null;
        try {
            r = new StreamConverter().toContentsReader(file);
            XtendResource xtendResource = this.remember(file, super.loadXtendResource(r, this.toFullyQualifiedName(file)));
            return xtendResource;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    public XpandResource loadXpandResource(IFile file) throws CoreException, IOException, ParserException {
        if (file == null) {
            return null;
        }
        assert (file.getProject() == this.contextProject);
        Reader r = null;
        try {
            r = new StreamConverter().toContentsReader(file);
            XpandResource xpandResource = this.remember(file, super.loadXpandResource(r, this.toFullyQualifiedName(file)));
            return xpandResource;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    protected <T extends ResourceMarker> T remember(IFile resource, T loadedResource) {
        return loadedResource;
    }

    public void forget(IFile resource) {
    }

    @Override
    protected Reader resolve(String fqn, String ext) throws IOException {
        IPath p = new Path(fqn.replaceAll("::", "/")).addFileExtension(ext);
        IResource r = this.contextProject.findMember(p);
        if (r == null) {
            r = this.contextProject.findMember(new Path("templates/").append(p));
        }
        if (!(r instanceof IFile)) {
            throw new FileNotFoundException(p.toString());
        }
        try {
            return new StreamConverter().toContentsReader((IFile)r);
        }
        catch (CoreException ex) {
            IOException wrap = new IOException(ex.getStatus().getMessage());
            wrap.initCause(ex);
            throw wrap;
        }
    }

    private String toFullyQualifiedName(IFile file) {
        return file.getProjectRelativePath().toString().replaceAll("/", "::");
    }
}

