/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;

class BitmapHelper {
    private static final int COMPRESSION_TYPE_OFFSET = 16;
    private static final int BMI_BITCOUNT_OFFSET = 14;
    private static final int BMI_COLORS_OFFSET = 32;
    private static final int BCH_BITCOUNT_OFFSET = 10;
    private static final int BI_BITFIELDS = 3;
    private static final int BASE_BMI_SIZE = 40;
    private static final int BASE_BCH_SIZE = 12;
    private static final int BLUE_MASK = 31;
    private static final int GREEN_MASK = 992;
    private static final int RED_MASK = 31744;

    BitmapHelper() {
    }

    static BufferedImage readBitmap(Record rec, int bmiOffset, int bmiSize, int bitOffset, int bitSize) throws IOException {
        int compressionType = rec.getIntAt(bmiOffset + 16);
        short bitCount = rec.getShortAt(bmiOffset + 14);
        int headerSize = 14;
        int size = bmiSize + bitSize + headerSize;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(66);
        out.write(77);
        BitmapHelper.writeInt(out, size);
        BitmapHelper.writeInt(out, 0);
        int dataOffset = headerSize + (bitOffset - bmiOffset);
        int numEntries = BitmapHelper.getNumberOfPaletteEntries(rec, bmiOffset);
        int requiredPaletteSize = numEntries * 4;
        int actualPaletteSize = bitOffset - bmiOffset - 40;
        int numFakePaletteEntriesToWrite = 0;
        if (bitCount <= 8 && requiredPaletteSize > actualPaletteSize) {
            numFakePaletteEntriesToWrite = (requiredPaletteSize - actualPaletteSize) / 4;
        }
        if (numFakePaletteEntriesToWrite > 0) {
            dataOffset += numFakePaletteEntriesToWrite * 4;
        }
        BitmapHelper.writeInt(out, dataOffset);
        byte[] bmi = rec.getBytesAt(bmiOffset, bmiSize);
        if (compressionType == 3) {
            bmi[16] = 0;
        }
        out.write(bmi);
        int index = 0;
        while (index < numFakePaletteEntriesToWrite) {
            BitmapHelper.writeInt(out, index);
            ++index;
        }
        byte[] bits = rec.getBytesAt(bitOffset, bitSize);
        out.write(bits);
        byte[] bmpData = out.toByteArray();
        ByteArrayInputStream stream = new ByteArrayInputStream(bmpData);
        ImageLoader imageLoader = new ImageLoader();
        ImageData[] imageData = imageLoader.load((InputStream)stream);
        BufferedImage image = new BufferedImage(imageData[0].width, imageData[0].height, 5);
        int y = 0;
        while (y < imageData[0].height) {
            int x = 0;
            while (x < imageData[0].width) {
                int color = imageData[0].getPixel(x, y);
                color = BitmapHelper.translateColor(rec, bmiOffset, bitCount, compressionType, imageData[0], color);
                image.setRGB(x, y, color);
                ++x;
            }
            ++y;
        }
        return image;
    }

    static int getNumberOfPaletteEntries(Record rec, int bmiOffset) throws IOException {
        int bmiSize = rec.getIntAt(bmiOffset);
        int numEntries = 0;
        if (bmiSize == 12) {
            short bitCount = rec.getShortAt(bmiOffset + 10);
            if (bitCount <= 8) {
                numEntries = 1 << bitCount;
            }
        } else {
            short bitCount = rec.getShortAt(bmiOffset + 14);
            numEntries = rec.getIntAt(bmiOffset + 32);
            if (numEntries == 0 && bitCount <= 8) {
                numEntries = 1 << bitCount;
            }
        }
        return numEntries;
    }

    static int getHeaderSize(Record rec, int bmiOffset, int usage) throws IOException {
        int numColorEntries = BitmapHelper.getNumberOfPaletteEntries(rec, bmiOffset);
        int bmiSize = rec.getIntAt(bmiOffset);
        int multiplier = 4;
        int size = 0;
        if (usage == 1) {
            multiplier = 2;
        }
        size = bmiSize == 12 ? 12 : 40;
        return size += numColorEntries * multiplier;
    }

    private static void writeInt(ByteArrayOutputStream out, int val) throws IOException {
        out.write((byte)(val & 0xFF));
        out.write((byte)(val >> 8 & 0xFF));
        out.write((byte)(val >> 16 & 0xFF));
        out.write((byte)(val >> 24 & 0xFF));
    }

    private static int translateColor(Record rec, int bmiOffset, int bitCount, int compressionType, ImageData imageData, int color) throws IOException {
        RGB[] rgb = imageData.getRGBs();
        if (bitCount == 1 || bitCount == 4 || bitCount == 8) {
            if (rgb != null) {
                Color foo = new Color(rgb[color].red, rgb[color].green, rgb[color].blue);
                color = foo.getRGB();
            } else {
                color = 0;
            }
        } else if (bitCount == 16) {
            if (compressionType == 3) {
                int redMask = (int)rec.getDWORDAt(bmiOffset + 40);
                int greenMask = (int)rec.getDWORDAt(bmiOffset + 40 + 4);
                int blueMask = (int)rec.getDWORDAt(bmiOffset + 40 + 8);
                color = BitmapHelper.applyRGBMask(color, redMask, greenMask, blueMask);
            } else {
                color = BitmapHelper.applyRGBMask(color, 31744, 992, 31);
            }
        } else if (bitCount == 24) {
            int blue = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int red = color & 0xFF;
            Color foo = new Color(red, green, blue);
            color = foo.getRGB();
        } else if (bitCount == 32) {
            if (compressionType == 3) {
                int redMask = (int)rec.getDWORDAt(bmiOffset + 40);
                int greenMask = (int)rec.getDWORDAt(bmiOffset + 40 + 4);
                int blueMask = (int)rec.getDWORDAt(bmiOffset + 40 + 8);
                color = BitmapHelper.flipBytes(color);
                color = BitmapHelper.applyRGBMask(color, redMask, greenMask, blueMask);
            } else {
                int blue = (color & 0xFF000000) >>> 24;
                int green = (color & 0xFF0000) >> 16;
                int red = (color & 0xFF00) >> 8;
                Color foo = new Color(red, green, blue);
                color = foo.getRGB();
            }
        }
        return color;
    }

    private static int applyRGBMask(int color, int redMask, int greenMask, int blueMask) {
        int shiftCount = BitmapHelper.getShiftCount(redMask);
        int maskSize = BitmapHelper.countBits(redMask);
        int red = (color & redMask) >>> shiftCount;
        red = red * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = BitmapHelper.getShiftCount(greenMask);
        maskSize = BitmapHelper.countBits(greenMask);
        int green = (color & greenMask) >>> shiftCount;
        green = green * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = BitmapHelper.getShiftCount(blueMask);
        maskSize = BitmapHelper.countBits(blueMask);
        int blue = (color & blueMask) >>> shiftCount;
        blue = blue * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        Color foo = new Color(red, green, blue);
        color = foo.getRGB();
        return color;
    }

    private static int getShiftCount(int mask) {
        int count = 0;
        while (mask != 0 && (mask & 1) == 0) {
            mask >>>= 1;
            ++count;
        }
        return count;
    }

    private static int countBits(int mask) {
        int count = 0;
        int index = 0;
        while (index < 32) {
            if ((mask & 1) != 0) {
                ++count;
            }
            mask >>>= 1;
            ++index;
        }
        return count;
    }

    private static int flipBytes(int data) {
        int byte1 = data & 0xFF;
        int byte2 = (data & 0xFF00) >>> 8;
        int byte3 = (data & 0xFF0000) >>> 16;
        int byte4 = (data & 0xFF000000) >>> 24;
        data = byte1 << 24;
        data += byte2 << 16;
        data += byte3 << 8;
        return data += byte4;
    }
}

