/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersPlugin;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.l10n.DiagramUIProvidersPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.PlatformUI;

public class BookmarkDecorator
extends AbstractDecorator {
    private static BookmarkObserver fileObserver = null;
    private String viewId = null;

    public BookmarkDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
        try {
            final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                public void run() {
                    BookmarkDecorator.this.viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                }
            });
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramProvidersPlugin.getInstance(), (String)DiagramProvidersDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"BookmarkDecorator::Constructor", (Throwable)e);
        }
    }

    public void refresh() {
        this.removeDecoration();
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
        if (!(editPart instanceof IPrimaryEditPart) || view == null || view.eResource() == null) {
            return;
        }
        IResource resource = BookmarkDecorator.getResource(view);
        if (resource == null || !resource.exists()) {
            return;
        }
        IMarker[] bookmarks = null;
        try {
            bookmarks = resource.findMarkers("org.eclipse.gmf.runtime.common.ui.services.bookmark", true, 2);
        }
        catch (CoreException e) {
            Trace.catching((Plugin)DiagramProvidersPlugin.getInstance(), (String)DiagramProvidersDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getDecorations", (Throwable)e);
            Log.error((Plugin)DiagramProvidersPlugin.getInstance(), (int)4, (String)e.getMessage());
        }
        if (bookmarks == null) {
            return;
        }
        IMarker foundMarker = null;
        String elementId = ((XMLResource)view.eResource()).getID((EObject)view);
        if (elementId == null) {
            return;
        }
        for (IMarker marker : Arrays.asList(bookmarks)) {
            String attribute = marker.getAttribute("elementId", "");
            if (!attribute.equals(elementId)) continue;
            foundMarker = marker;
            break;
        }
        if (foundMarker == null) {
            return;
        }
        if (editPart instanceof ShapeEditPart) {
            IMapMode mm = MapModeUtil.getMapMode((IFigure)((ShapeEditPart)editPart).getFigure());
            this.setDecoration(this.getDecoratorTarget().addShapeDecoration(DiagramUIProvidersPluginImages.get("icons/bookmark.gif"), IDecoratorTarget.Direction.NORTH_EAST, mm.DPtoLP(-4), true));
        } else if (view instanceof Edge) {
            this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(DiagramUIProvidersPluginImages.get("icons/bookmark.gif"), 50, true));
        }
    }

    private static IResource getResource(View view) {
        Resource model = view.eResource();
        if (model != null) {
            return WorkspaceSynchronizer.getFile((Resource)model);
        }
        return null;
    }

    public void activate() {
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        if (view == null) {
            return;
        }
        Diagram diagramView = view.getDiagram();
        if (diagramView == null) {
            return;
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagramView.eResource());
        if (file != null) {
            if (fileObserver == null) {
                fileObserver = new BookmarkObserver();
            }
            BookmarkDecorator.fileObserver.registerDecorator(this);
        }
    }

    public void deactivate() {
        if (fileObserver != null) {
            BookmarkDecorator.fileObserver.unregisterDecorator(this);
            if (!BookmarkDecorator.fileObserver.isRegistered()) {
                fileObserver = null;
            }
        }
        super.deactivate();
    }

    private String getViewId() {
        return this.viewId;
    }

    public class BookmarkObserver
    implements IFileObserver {
        private HashMap mapOfIdsToDecorators = null;
        private boolean isRegistered = false;

        private void registerDecorator(BookmarkDecorator decorator) {
            String decoratorViewId;
            if (decorator == null) {
                return;
            }
            if (this.mapOfIdsToDecorators == null) {
                this.mapOfIdsToDecorators = new HashMap();
            }
            if ((decoratorViewId = decorator.getViewId()) == null) {
                return;
            }
            ArrayList<BookmarkDecorator> list = (ArrayList<BookmarkDecorator>)this.mapOfIdsToDecorators.get(decoratorViewId);
            if (list == null) {
                list = new ArrayList<BookmarkDecorator>(2);
                list.add(decorator);
                this.mapOfIdsToDecorators.put(decoratorViewId, list);
            } else if (!list.contains((Object)decorator)) {
                list.add(decorator);
            }
            if (!this.isRegistered()) {
                FileChangeManager.getInstance().addFileObserver((IFileObserver)this);
                this.isRegistered = true;
            }
        }

        private void unregisterDecorator(BookmarkDecorator decorator) {
            if (decorator == null) {
                return;
            }
            String decoratorViewId = decorator.getViewId();
            if (decoratorViewId == null) {
                return;
            }
            if (this.mapOfIdsToDecorators != null) {
                List list = (List)this.mapOfIdsToDecorators.get(decoratorViewId);
                if (list != null) {
                    list.remove((Object)decorator);
                    if (list.isEmpty()) {
                        this.mapOfIdsToDecorators.remove(decoratorViewId);
                    }
                }
                if (this.mapOfIdsToDecorators.isEmpty()) {
                    this.mapOfIdsToDecorators = null;
                }
            }
            if (this.mapOfIdsToDecorators == null && this.isRegistered()) {
                FileChangeManager.getInstance().removeFileObserver((IFileObserver)this);
                this.isRegistered = false;
            }
        }

        public void handleFileRenamed(IFile oldFile, IFile file) {
        }

        public void handleFileMoved(IFile oldFile, IFile file) {
        }

        public void handleFileDeleted(IFile file) {
        }

        public void handleFileChanged(IFile file) {
        }

        public void handleMarkerAdded(IMarker marker) {
        }

        public void handleMarkerDeleted(IMarker marker, Map attributes) {
            List list;
            if (this.mapOfIdsToDecorators == null) {
                return;
            }
            Assert.isTrue((!marker.exists() ? 1 : 0) != 0);
            String elementId = (String)attributes.get("elementId");
            List list2 = list = elementId != null ? (List)this.mapOfIdsToDecorators.get(elementId) : null;
            if (list != null && !list.isEmpty()) {
                this.refreshDecorators(list);
            }
        }

        public void handleMarkerChanged(IMarker marker) {
            List list;
            if (this.mapOfIdsToDecorators == null) {
                return;
            }
            Assert.isTrue((boolean)marker.exists());
            String elementId = marker.getAttribute("elementId", "");
            List list2 = list = elementId != null ? (List)this.mapOfIdsToDecorators.get(elementId) : null;
            if (list != null && !list.isEmpty()) {
                this.refreshDecorators(list);
            }
        }

        private void refreshDecorators(final List decorators) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        TransactionUtil.getEditingDomain((Object)BookmarkDecorator.this.getDecoratorTarget().getAdapter(View.class)).runExclusive(new Runnable(){

                            public void run() {
                                for (IDecorator decorator : decorators) {
                                    if (decorator == null) continue;
                                    decorator.refresh();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        Trace.catching((Plugin)DiagramProvidersPlugin.getInstance(), (String)DiagramProvidersDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"refreshDecorators()", (Throwable)e);
                    }
                }
            });
        }

        private boolean isRegistered() {
            return this.isRegistered;
        }
    }
}

