/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.common.reconcile.Copier;
import org.eclipse.gmf.internal.common.reconcile.Decision;
import org.eclipse.gmf.internal.common.reconcile.Matcher;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reconciler {
    private final ReconcilerConfig myConfig;
    private final MatchingSession myMatchingSession;

    public Reconciler(ReconcilerConfig config) {
        this.myConfig = config;
        this.myMatchingSession = new MatchingSession();
    }

    protected void handleNotMatchedCurrent(EObject current) {
    }

    protected EObject handleNotMatchedOld(EObject currentParent, EObject notMatchedOld) {
        Copier copier = this.myConfig.getCopier(notMatchedOld.eClass());
        return copier.copyToCurrent(currentParent, notMatchedOld);
    }

    public void reconcileResource(Resource current, Resource old) {
        this.reconcileContents(null, (Collection<EObject>)current.getContents(), (Collection<EObject>)old.getContents());
    }

    public void reconcileTree(EObject currentRoot, EObject oldRoot) {
        this.reconcileVertex(currentRoot, oldRoot);
        this.reconcileContents(currentRoot, (Collection<EObject>)currentRoot.eContents(), (Collection<EObject>)oldRoot.eContents());
    }

    private void reconcileVertex(EObject current, EObject old) {
        assert (current.eClass().equals(old.eClass()));
        Decision[] decisionArray = this.myConfig.getDecisions(current.eClass());
        int n = 0;
        int n2 = decisionArray.length;
        while (n < n2) {
            Decision decision = decisionArray[n];
            decision.apply(current, old);
            ++n;
        }
    }

    private void reconcileContents(EObject currentParent, Collection<EObject> allCurrents, Collection<EObject> allOlds) {
        if (allCurrents.isEmpty() && allOlds.isEmpty()) {
            return;
        }
        LinkedList<Pair> storage = new LinkedList<Pair>();
        this.myMatchingSession.match(allCurrents, allOlds, storage);
        for (Pair next : storage) {
            EObject nextCurrent = next.current;
            EObject nextOld = next.old;
            assert (nextCurrent != null || nextOld != null);
            if (nextCurrent == null && currentParent != null) {
                nextCurrent = this.handleNotMatchedOld(currentParent, nextOld);
            }
            if (nextCurrent != null && nextOld != null) {
                this.reconcileTree(nextCurrent, nextOld);
                continue;
            }
            if (nextOld != null) continue;
            this.handleNotMatchedCurrent(nextCurrent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchingSession {
        private boolean myIsMatching;

        public void match(Collection<EObject> currents, Collection<EObject> olds, Collection<Pair> output) {
            assert (!this.myIsMatching);
            try {
                this.myIsMatching = true;
                LinkedHashSet<EObject> myOlds = new LinkedHashSet<EObject>(olds);
                LinkedList<EObject> myCurrents = new LinkedList<EObject>(currents);
                Iterator currentContents = myCurrents.iterator();
                while (!myOlds.isEmpty() && currentContents.hasNext()) {
                    EObject nextCurrent = (EObject)currentContents.next();
                    Pair nextPair = this.acquirePair();
                    nextPair.current = nextCurrent;
                    nextPair.old = this.removeMatched(nextCurrent, myOlds);
                    output.add(nextPair);
                    currentContents.remove();
                }
                Iterator notMatchedOlds = myOlds.iterator();
                while (notMatchedOlds.hasNext()) {
                    Pair nextPair = this.acquirePair();
                    nextPair.current = null;
                    nextPair.old = (EObject)notMatchedOlds.next();
                    output.add(nextPair);
                }
            }
            finally {
                this.myIsMatching = false;
            }
        }

        private EObject removeMatched(EObject current, Collection<EObject> allOld) {
            EClass eClass = current.eClass();
            Matcher matcher = Reconciler.this.myConfig.getMatcher(eClass);
            EObject result = null;
            if (matcher != Matcher.FALSE) {
                Iterator<EObject> all = allOld.iterator();
                while (all.hasNext()) {
                    EObject next = all.next();
                    if (!eClass.equals(next.eClass()) || !matcher.match(current, next)) continue;
                    result = next;
                    all.remove();
                    break;
                }
            }
            return result;
        }

        private Pair acquirePair() {
            return new Pair();
        }
    }

    private static class Pair {
        public EObject current;
        public EObject old;

        private Pair() {
        }
    }
}

