/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hierarchy {
    private final List<EReference> myRefs;
    private final EPackage myDomainModel;
    private final Map<EClass, Set<EClass>> myResult;
    private Set<EClass> myAccessibleLeaves;
    private Set<EClass> myAccessibleClasses = new HashSet<EClass>();
    private Set<EClass> myAccessibleLinkClasses = new HashSet<EClass>();
    private Set<EReference> myLinkClassContainmentRefs = new HashSet<EReference>();
    private final EClass myDiagramContainer;

    public Hierarchy(List<EReference> eRefs, EClass diagramContainer, EPackage domainModel) {
        this.myRefs = eRefs;
        this.myDiagramContainer = diagramContainer;
        this.myDomainModel = domainModel;
        this.myResult = new HashMap<EClass, Set<EClass>>();
        for (EReference element : eRefs) {
            this.myResult.put(element.getEReferenceType(), new HashSet());
        }
    }

    public Hierarchy(EClass diagramContainer) {
        this((List<EReference>)diagramContainer.getEAllContainments(), diagramContainer, diagramContainer.getEPackage());
    }

    public Hierarchy(EClass diagramContainer, EPackage domainModel) {
        this((List<EReference>)diagramContainer.getEAllContainments(), diagramContainer, domainModel);
    }

    public EClass getDiagramContainer() {
        return this.myDiagramContainer;
    }

    public EReference nodeBackRef(EClass nodeElement) {
        for (EReference r : this.myRefs) {
            if (!r.getEReferenceType().isSuperTypeOf(nodeElement)) continue;
            return r;
        }
        return null;
    }

    public EReference linkBackRef(EClass linkElement) {
        ArrayList<EReference> compatible = new ArrayList<EReference>();
        for (EReference r : this.myLinkClassContainmentRefs) {
            if (!r.getEReferenceType().isSuperTypeOf(linkElement)) continue;
            compatible.add(r);
        }
        if (compatible.isEmpty()) {
            return null;
        }
        int i = compatible.size() - 1;
        while (i >= 0) {
            EReference r;
            r = (EReference)compatible.get(i);
            if (r.getEReferenceType().equals(linkElement)) {
                return r;
            }
            --i;
        }
        return (EReference)compatible.get(0);
    }

    public boolean isLeaf(EClass element) {
        return this.myAccessibleLeaves.contains(element);
    }

    public EReference getLinkFeature(EClass element) {
        List<EReference> l = this.collectAllNonContainment(element);
        if (l.isEmpty()) {
            return null;
        }
        for (EReference ref : l) {
            if (element.isSuperTypeOf(ref.getEReferenceType())) continue;
            for (EClass c : this.myResult.keySet()) {
                if (!c.isSuperTypeOf(ref.getEReferenceType()) && !ref.getEReferenceType().isSuperTypeOf(c)) continue;
                return ref;
            }
        }
        return null;
    }

    public void collect() {
        this.collect(true);
    }

    void collect(boolean recurse) {
        HashSet nonLeaves = new HashSet();
        HashSet<EClass> leavesSet = new HashSet<EClass>();
        for (Object next : this.myDomainModel.getEClassifiers()) {
            if (!(next instanceof EClass)) continue;
            EClass eClass = (EClass)next;
            for (Map.Entry<EClass, Set<EClass>> entry : this.myResult.entrySet()) {
                EClass element = entry.getKey();
                if (!element.isSuperTypeOf(eClass)) continue;
                entry.getValue().add(eClass);
                if (recurse) {
                    Hierarchy h2 = new Hierarchy((List<EReference>)eClass.getEAllContainments(), null, this.myDomainModel);
                    h2.collect(false);
                    this.myLinkClassContainmentRefs.addAll((Collection<EReference>)eClass.getEAllContainments());
                    this.myAccessibleLinkClasses.addAll(h2.getAccessibleClasses());
                    leavesSet.addAll(h2.myAccessibleLeaves);
                }
                if (!eClass.isAbstract() && !eClass.isInterface()) {
                    this.myAccessibleClasses.add(eClass);
                }
                nonLeaves.addAll(eClass.getESuperTypes());
            }
        }
        leavesSet.addAll(this.myAccessibleClasses);
        leavesSet.removeAll(nonLeaves);
        this.myAccessibleLeaves = Collections.unmodifiableSet(leavesSet);
        this.myAccessibleClasses = Collections.unmodifiableSet(this.myAccessibleClasses);
        this.myAccessibleLinkClasses = Collections.unmodifiableSet(this.myAccessibleLinkClasses);
    }

    public Set<EClass> getAllClasses() {
        HashSet<EClass> rv = new HashSet<EClass>();
        for (Set<EClass> next : this.myResult.values()) {
            rv.addAll(next);
        }
        return rv;
    }

    public Set<EClass> getAccessibleClasses() {
        return this.myAccessibleClasses;
    }

    public Set<EClass> getAccessibleLinkClasses() {
        return this.myAccessibleLinkClasses;
    }

    public Set<EReference> getAccessibleReferences() {
        return this.getAccessibleReferences(this.myAccessibleClasses.iterator());
    }

    public Set<EReference> getAccessibleReferences(Iterator<EClass> iter) {
        HashSet<EReference> rv = new HashSet<EReference>();
        while (iter.hasNext()) {
            EClass element = iter.next();
            rv.addAll(this.collectAllNonContainment(element));
        }
        return rv;
    }

    List<EReference> collectAllNonContainment(EClass element) {
        LinkedList<EReference> l = new LinkedList<EReference>((Collection<EReference>)element.getEAllReferences());
        l.removeAll((Collection<?>)element.getEAllContainments());
        return l;
    }
}

