/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.protocol;

import java.util.List;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.impl.AbstractProtocol;
import org.eclipse.net4j.examples.prov.Category;
import org.eclipse.net4j.examples.prov.Feature;
import org.eclipse.net4j.examples.prov.ProvFactory;
import org.eclipse.net4j.examples.prov.ProvisioningProtocol;
import org.eclipse.net4j.examples.prov.Site;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProvisioningProtocol
extends AbstractProtocol
implements ProvisioningProtocol {
    public String getName() {
        return "org.eclipse.net4j.examples.prov";
    }

    public static Site receiveSite(Channel channel) {
        Site site = ProvFactory.eINSTANCE.createSite();
        AbstractProvisioningProtocol.receiveFeatures(channel, (List<Feature>)site.getFeatures());
        AbstractProvisioningProtocol.receiveCategories(channel, (List<Category>)site.getCategories());
        return site;
    }

    public static void receiveCategories(Channel channel, List<Category> categories) {
        int count = channel.receiveInt();
        int i = 0;
        while (i < count) {
            String name = channel.receiveString();
            String label = channel.receiveString();
            String description = channel.receiveString();
            Category category = ProvFactory.eINSTANCE.createCategory();
            category.setName(name);
            category.setLabel(label);
            category.setDescription(description);
            categories.add(category);
            AbstractProvisioningProtocol.receiveFeatures(channel, (List<Feature>)category.getFeatures());
            ++i;
        }
    }

    public static void receiveFeatures(Channel channel, List<Feature> features) {
        int count = channel.receiveInt();
        int i = 0;
        while (i < count) {
            String id = channel.receiveString();
            String version = channel.receiveString();
            Feature feature = ProvFactory.eINSTANCE.createFeature();
            feature.setId(id);
            feature.setVersion(version);
            features.add(feature);
            ++i;
        }
    }

    public static void transmitSite(Channel channel, Site site) {
        AbstractProvisioningProtocol.transmitFeatures(channel, (List<Feature>)site.getFeatures());
        AbstractProvisioningProtocol.transmitCategories(channel, (List<Category>)site.getCategories());
    }

    public static void transmitCategories(Channel channel, List<Category> categories) {
        channel.transmitInt(categories.size());
        for (Category category : categories) {
            channel.transmitString(category.getName());
            channel.transmitString(category.getLabel());
            channel.transmitString(category.getDescription());
            AbstractProvisioningProtocol.transmitFeatures(channel, (List<Feature>)category.getFeatures());
        }
    }

    public static void transmitFeatures(Channel channel, List<Feature> features) {
        channel.transmitInt(features.size());
        for (Feature feature : features) {
            channel.transmitString(feature.getId());
            channel.transmitString(feature.getVersion());
        }
    }
}

