/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.services;

import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.search.l10n.Messages;

public abstract class AbstractExtensionManager
implements IRegistryChangeListener {
    private String extensionPointId;

    protected AbstractExtensionManager(String extensionPointId) {
        if (extensionPointId == null || extensionPointId.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("AbstractExtensionManager.extPointIDErrorMessage"));
        }
        this.extensionPointId = extensionPointId;
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    protected abstract void addExtension(IExtension var1);

    protected abstract void removeExtension(IExtension var1);

    public void registryChanged(IRegistryChangeEvent event) {
        if (!Platform.isRunning()) {
            return;
        }
        IExtensionDelta[] delta = event.getExtensionDeltas(this.extensionPointId);
        int i = 0;
        while (i < delta.length) {
            switch (delta[i].getKind()) {
                case 1: {
                    this.addExtension(delta[i].getExtension());
                    break;
                }
                case 2: {
                    this.removeExtension(delta[i].getExtension());
                    break;
                }
            }
            ++i;
        }
    }

    protected void readRegistry() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.extensionPointId);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.addExtension(extensions[i]);
            ++i;
        }
    }
}

