/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ContentKindSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private CCombo contentKindCb;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.contentKindCb = this.getWidgetFactory().createCCombo(composite, 0x800808);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.contentKindCb, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.contentKindCb.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.contentKindCb.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ContentKindSection.this.handleComboModified();
            }
        });
    }

    protected void handleComboModified() {
        if (!this.isRefreshing) {
            final int newContentKind = this.getIndex(this.contentKindCb.getText());
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                int oldContentKind = ExtendedMetaData.INSTANCE.getContentKind((EClass)this.getEObject());
                if (oldContentKind != newContentKind) {
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)ContentKindSection.this.getEObject(), newContentKind);
                        }
                    });
                }
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (final EObject nextObject : this.getEObjectList()) {
                    int oldContentKind = ExtendedMetaData.INSTANCE.getContentKind((EClass)nextObject);
                    if (oldContentKind == newContentKind) continue;
                    compoundCommand.append((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)nextObject, newContentKind);
                        }
                    });
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.contentKindCb.setItems(ExtendedMetaData.CONTENT_KINDS);
        int contentKind = ExtendedMetaData.INSTANCE.getContentKind((EClass)this.getEObject());
        this.contentKindCb.setText(ExtendedMetaData.CONTENT_KINDS[contentKind]);
        this.isRefreshing = false;
    }

    private int getIndex(String key) {
        String[] contentKinds = ExtendedMetaData.CONTENT_KINDS;
        int i = 0;
        while (i < contentKinds.length) {
            if (contentKinds[i].equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.ContentKindSection_ContentKind;
    }
}

