/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.merge.service.MergeService;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.ui.TypedElementWrapper;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.compare.ui.util.EMFCompareEObjectUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCompareInput
implements ICompareInput {
    private Resource ancestorResource;
    private final Object diff;
    private List<DiffElement> diffList;
    private final List<ICompareInputChangeListener> inputChangeListeners = new ArrayList<ICompareInputChangeListener>();
    private Resource leftResource;
    private final Object match;
    private Resource rightResource;
    private ICompareInput initialInput;

    public ModelCompareInput(MatchModel matchModel, DiffModel diffModel) {
        this.match = matchModel;
        this.diff = diffModel;
    }

    public ModelCompareInput(MatchResourceSet matchResourceset, DiffResourceSet diffResourceSet) {
        this.match = matchResourceset;
        this.diff = diffResourceSet;
    }

    public ModelCompareInput(MatchModel matchModel, DiffModel diffModel, ModelComparator comparator) {
        this(matchModel, diffModel);
        this.leftResource = comparator.getLeftResource();
        this.rightResource = comparator.getRightResource();
        this.ancestorResource = comparator.getAncestorResource();
        this.initialInput = comparator.getCompareInput();
    }

    public ModelCompareInput(MatchResourceSet matchResourceset, DiffResourceSet diffResourceSet, ModelComparator comparator) {
        this(matchResourceset, diffResourceSet);
        this.leftResource = comparator.getLeftResource();
        this.rightResource = comparator.getRightResource();
        this.ancestorResource = comparator.getAncestorResource();
        this.initialInput = comparator.getCompareInput();
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.inputChangeListeners.add(listener);
    }

    public void copy(boolean leftToRight) {
        ArrayList<DiffElement> differences = new ArrayList<DiffElement>();
        if (this.diff instanceof DiffModel) {
            differences.addAll((Collection<DiffElement>)((DiffModel)this.diff).getOwnedElements());
        } else {
            for (DiffModel aDiff : ((DiffResourceSet)this.diff).getDiffModels()) {
                differences.addAll((Collection<DiffElement>)aDiff.getOwnedElements());
            }
        }
        this.doCopy(differences, leftToRight);
        this.fireCompareInputChanged();
    }

    public void copy(DiffElement element, boolean leftToRight) {
        this.doCopy(element, leftToRight);
        this.fireCompareInputChanged();
    }

    public void copy(List<DiffElement> elements, boolean leftToRight) {
        this.doCopy(elements, leftToRight);
        this.fireCompareInputChanged();
    }

    public ITypedElement getAncestor() {
        if (this.initialInput != null) {
            return this.initialInput.getAncestor();
        }
        TypedElementWrapper ancestor = null;
        if (this.ancestorResource != null) {
            if (this.ancestorResource.getContents().size() > 0) {
                ancestor = new TypedElementWrapper((EObject)this.ancestorResource.getContents().get(0));
            }
        } else {
            MatchModel matchModel = null;
            if (this.match instanceof MatchModel) {
                matchModel = (MatchModel)this.match;
            } else if (((MatchResourceSet)this.match).getMatchModels().size() != 0) {
                matchModel = (MatchModel)((MatchResourceSet)this.match).getMatchModels().get(0);
            }
            if (matchModel != null && !matchModel.getAncestorRoots().isEmpty()) {
                ancestor = new TypedElementWrapper((EObject)matchModel.getAncestorRoots().get(0));
            }
        }
        return ancestor;
    }

    public Resource getAncestorResource() {
        if (this.ancestorResource == null) {
            MatchModel matchModel;
            if (this.match instanceof MatchModel) {
                matchModel = (MatchModel)this.match;
            } else {
                if (this.match == null || ((MatchResourceSet)this.match).getMatchModels().size() == 0) {
                    return null;
                }
                matchModel = (MatchModel)((MatchResourceSet)this.match).getMatchModels().get(0);
            }
            if (!matchModel.getAncestorRoots().isEmpty()) {
                this.ancestorResource = ((EObject)matchModel.getAncestorRoots().get(0)).eResource();
            }
        }
        return this.ancestorResource;
    }

    public Object getDiff() {
        return this.diff;
    }

    public List<DiffElement> getDiffAsList() {
        if (this.diffList == null) {
            this.diffList = new ArrayList<DiffElement>();
            if (this.getDiff() == null) {
                return this.diffList;
            }
            ArrayList<ModelElementChange> modelElementDiffs = new ArrayList<ModelElementChange>();
            ArrayList<AttributeChange> attributeChangeDiffs = new ArrayList<AttributeChange>();
            ArrayList<ReferenceChange> referenceChangeDiffs = new ArrayList<ReferenceChange>();
            TreeIterator iterator = ((EObject)this.getDiff()).eAllContents();
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                if (next instanceof ModelElementChange) {
                    modelElementDiffs.add((ModelElementChange)next);
                    continue;
                }
                if (next instanceof AttributeChange) {
                    attributeChangeDiffs.add((AttributeChange)next);
                    continue;
                }
                if (next instanceof ReferenceChange) {
                    referenceChangeDiffs.add((ReferenceChange)next);
                    continue;
                }
                if (!(next instanceof DiffElement) || next instanceof DiffGroup) continue;
                this.diffList.add((DiffElement)next);
            }
            this.diffList.addAll(modelElementDiffs);
            this.diffList.addAll(attributeChangeDiffs);
            this.diffList.addAll(referenceChangeDiffs);
            modelElementDiffs.clear();
            attributeChangeDiffs.clear();
            referenceChangeDiffs.clear();
        }
        return this.diffList;
    }

    public Image getImage() {
        Image image = null;
        if (this.getMatch() != null) {
            image = EMFCompareEObjectUtils.computeObjectImage((EObject)this.getMatch());
        } else if (this.getDiff() != null) {
            image = EMFCompareEObjectUtils.computeObjectImage((EObject)this.getDiff());
        }
        return image;
    }

    public int getKind() {
        if (this.getAncestor() != null) {
            return 12;
        }
        return 0;
    }

    public ITypedElement getLeft() {
        if (this.initialInput != null) {
            return this.initialInput.getLeft();
        }
        TypedElementWrapper left = null;
        if (this.leftResource != null) {
            if (this.leftResource.getContents().size() > 0) {
                left = new TypedElementWrapper((EObject)this.leftResource.getContents().get(0));
            }
        } else {
            MatchModel matchModel = this.match instanceof MatchModel ? (MatchModel)this.match : (MatchModel)((MatchResourceSet)this.match).getMatchModels().get(0);
            left = matchModel.getLeftRoots().isEmpty() ? new TypedElementWrapper(null) : new TypedElementWrapper((EObject)matchModel.getLeftRoots().get(0));
        }
        return left;
    }

    public Resource getLeftResource() {
        if (this.leftResource == null) {
            MatchModel matchModel;
            if (this.match instanceof MatchModel) {
                matchModel = (MatchModel)this.match;
            } else {
                if (this.match == null || ((MatchResourceSet)this.match).getMatchModels().size() == 0) {
                    return null;
                }
                matchModel = (MatchModel)((MatchResourceSet)this.match).getMatchModels().get(0);
            }
            if (!matchModel.getLeftRoots().isEmpty()) {
                this.leftResource = ((EObject)matchModel.getLeftRoots().get(0)).eResource();
            }
        }
        return this.leftResource;
    }

    public Object getMatch() {
        return this.match;
    }

    public String getName() {
        String name = null;
        if (this.getMatch() instanceof EObject) {
            name = EMFCompareEObjectUtils.computeObjectName((EObject)this.getMatch());
        } else if (this.getDiff() instanceof EObject) {
            name = EMFCompareEObjectUtils.computeObjectName((EObject)this.getDiff());
        }
        return name;
    }

    public ITypedElement getRight() {
        if (this.initialInput != null) {
            return this.initialInput.getRight();
        }
        TypedElementWrapper right = null;
        if (this.rightResource != null) {
            if (this.rightResource.getContents().size() > 0) {
                right = new TypedElementWrapper((EObject)this.rightResource.getContents().get(0));
            }
        } else {
            MatchModel matchModel = this.match instanceof MatchModel ? (MatchModel)this.match : (MatchModel)((MatchResourceSet)this.match).getMatchModels().get(0);
            right = matchModel.getRightRoots().isEmpty() ? new TypedElementWrapper(null) : new TypedElementWrapper((EObject)matchModel.getRightRoots().get(0));
        }
        return right;
    }

    public Resource getRightResource() {
        if (this.rightResource == null) {
            MatchModel matchModel;
            if (this.match instanceof MatchModel) {
                matchModel = (MatchModel)this.match;
            } else {
                if (this.match == null || ((MatchResourceSet)this.match).getMatchModels().size() == 0) {
                    return null;
                }
                matchModel = (MatchModel)((MatchResourceSet)this.match).getMatchModels().get(0);
            }
            if (!matchModel.getRightRoots().isEmpty()) {
                this.rightResource = ((EObject)matchModel.getRightRoots().get(0)).eResource();
            }
        }
        return this.rightResource;
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        this.inputChangeListeners.remove(listener);
    }

    protected void doCopy(DiffElement element, boolean leftToRight) {
        MergeService.merge((DiffElement)element, (boolean)leftToRight);
    }

    protected void doCopy(List<DiffElement> elements, boolean leftToRight) {
        MergeService.merge(elements, (boolean)leftToRight);
    }

    protected void fireCompareInputChanged() {
        this.diffList.clear();
        this.diffList = null;
        for (ICompareInputChangeListener listener : this.inputChangeListeners) {
            listener.compareInputChanged((ICompareInput)this);
        }
    }
}

