/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mint.IMemberAnnotationListener;
import org.eclipse.emf.mint.MemberAnnotationChangedEvent;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.emf.mint.internal.ui.Messages;
import org.eclipse.emf.mint.internal.ui.search.JavaSearchMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MintUI
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.mint.ui";
    public static final String GENERATED_COLOR = "org.eclipse.emf.mint.ui.GENERATED_COLOR";
    public static final String GENERATED_NOT_COLOR = "org.eclipse.emf.mint.ui.GENERATED_NOT_COLOR";
    public static final String IMG_BLANK = "icons/blank.gif";
    private static MintUI instance;
    private final Collection<StructuredViewer> viewers = new HashSet<StructuredViewer>();
    private IMemberAnnotationListener filterUpdater;

    public MintUI() {
        instance = this;
    }

    public static MintUI getDefault() {
        return instance;
    }

    public void stop(BundleContext context) throws Exception {
        this.viewers.clear();
        this.filterUpdater = null;
        JavaSearchMonitor.stop();
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMG_BLANK, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry(IMG_BLANK)));
    }

    public IStatus logError(String message, Throwable t) {
        if (message == null) {
            message = Messages.MintUI_UnexpectedError;
        }
        Status status = new Status(4, PLUGIN_ID, 0, message, t);
        this.getLog().log((IStatus)status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installFilterUpdater(final StructuredViewer viewer) {
        Collection<StructuredViewer> collection = this.viewers;
        synchronized (collection) {
            if (this.viewers.add(viewer)) {
                this.createFilterUpdater();
                viewer.getControl().addDisposeListener(new DisposeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void widgetDisposed(DisposeEvent e) {
                        Collection collection = MintUI.this.viewers;
                        synchronized (collection) {
                            MintUI.this.viewers.remove(viewer);
                        }
                    }
                });
            }
        }
    }

    private void createFilterUpdater() {
        if (this.filterUpdater != null) {
            return;
        }
        this.filterUpdater = new IMemberAnnotationListener(){

            public void memberAnnotationChanged(final MemberAnnotationChangedEvent event) {
                MintUI.this.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MintUI.this.handleChanges(event.getChanges().keySet());
                    }
                });
            }
        };
        MintCore.getInstance().getMemberAnnotationManager().addMemberAnnotationListener(this.filterUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChanges(Collection<?> changes) {
        Collection<StructuredViewer> collection = this.viewers;
        synchronized (collection) {
            for (StructuredViewer viewer : this.viewers) {
                this.handleChanges(viewer, changes);
            }
        }
    }

    private void handleChanges(StructuredViewer viewer, Collection<?> changes) {
        IContentProvider cp = viewer.getContentProvider();
        if (viewer instanceof AbstractTreeViewer) {
            Object parent;
            HashSet<Object> parents = new HashSet<Object>();
            if (cp instanceof ITreeContentProvider) {
                ITreeContentProvider tcp = (ITreeContentProvider)cp;
                for (Iterator<Object> element : changes) {
                    parent = tcp.getParent(element);
                    if (parent == null) continue;
                    parents.add(parent);
                }
            } else if (cp instanceof ITreePathContentProvider) {
                ITreePathContentProvider tpcp = (ITreePathContentProvider)cp;
                for (Iterator<Object> element : changes) {
                    TreePath[] parentPaths = tpcp.getParents(element);
                    int k = 0;
                    while (k < parentPaths.length) {
                        parents.add(parentPaths[k].getLastSegment());
                        ++k;
                    }
                }
            } else if (cp instanceof ILazyTreeContentProvider) {
                ILazyTreeContentProvider ltcp = (ILazyTreeContentProvider)cp;
                for (Iterator<Object> element : changes) {
                    parent = ltcp.getParent(element);
                    if (parent == null) continue;
                    parents.add(parent);
                }
            }
            for (Object parent2 : parents) {
                viewer.refresh(parent2);
            }
            return;
        }
        if (cp instanceof IStructuredContentProvider) {
            Object[] elements = ((IStructuredContentProvider)cp).getElements(viewer.getInput());
            List<Object> c = Arrays.asList(elements);
            for (Object element : changes) {
                if (!c.contains(element)) continue;
                viewer.refresh();
                break;
            }
        }
    }
}

