/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.search.ui.text.Match;

public class GenModelMatch extends Match {

	private final EObject eObject;

	private final Resource resource;

	private final IFile file;

	public GenModelMatch(EObject eObject, IFile file) {
		super(new Element(eObject, file), 0, 0);
		this.eObject = eObject;
		this.file = file;
		resource = eObject.eResource();
	}

	public EObject getEObject() {
		return eObject;
	}

	public Resource getResource() {
		return resource;
	}

	public IFile getFile() {
		return file;
	}

	public static class Element implements IAdaptable {

		private final EObject eObject;

		private final IFile file;

		public Element(EObject eObject, IFile file) {
			this.eObject = eObject;
			this.file = file;
		}

		public EObject getEObject() {
			return eObject;
		}

		public IFile getFile() {
			return file;
		}

		@SuppressWarnings("unchecked")
		public Object getAdapter(Class adapter) {
			if (IResource.class.isAssignableFrom(adapter))
				return file;

			return null;
		}
	}
}
