/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.text.ui.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.henshin.presentation.ImportPackagesWizardPage;
import org.eclipse.emf.henshin.text.henshin_text.EPackageImport;
import org.eclipse.emf.henshin.text.henshin_text.Henshin_textFactory;
import org.eclipse.emf.henshin.text.henshin_text.Model;
import org.eclipse.emf.henshin.text.ui.wizard.ProjectSelectionPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class NewHenshin_textFileWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private IWorkbench workbench;
    private ProjectSelectionPage projectSelectionPage;
    private ImportPackagesWizardPage importEPackagesPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        this.setWindowTitle("New Henshin Text file");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.projectSelectionPage = new ProjectSelectionPage(this.selection);
        this.addPage((IWizardPage)this.projectSelectionPage);
        this.importEPackagesPage = new ImportPackagesWizardPage("importPackages");
        this.addPage((IWizardPage)this.importEPackagesPage);
    }

    public boolean canFinish() {
        return this.importEPackagesPage.getPackageURIs().size() > 0;
    }

    public boolean performFinish() {
        String containerName = this.projectSelectionPage.getContainerName();
        String fileName = this.projectSelectionPage.getFileName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource iresource = root.findMember((IPath)new Path(containerName));
        final IContainer container = (IContainer)iresource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            if (!container.getProject().hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                IProjectDescription description = container.getProject().getDescription();
                String[] natureList = new String[description.getNatureIds().length + 1];
                System.arraycopy(description.getNatureIds(), 0, natureList, 0, description.getNatureIds().length);
                natureList[natureList.length - 1] = "org.eclipse.xtext.ui.shared.xtextNature";
                description.setNatureIds(natureList);
                container.getProject().setDescription(description, null);
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error adding Xtext nature to Project.");
            return false;
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                Resource resource = resourceSet.createResource(fileURI);
                Model model = Henshin_textFactory.eINSTANCE.createModel();
                for (URI ePackageURI : NewHenshin_textFileWizard.this.importEPackagesPage.getPackageURIs()) {
                    EObject object = resourceSet.getEObject(ePackageURI, true);
                    if (!(object instanceof EPackage)) continue;
                    if (!NewHenshin_textFileWizard.this.projectContainsEcore(((EPackage)object).eResource().getURI(), container.getProject())) {
                        ResourceSetImpl metaResourceSet = new ResourceSetImpl();
                        metaResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new XMLResourceFactoryImpl());
                        String ecorePath = container.getFullPath() + "/" + ((EPackage)object).getName() + ".ecore";
                        Resource metaResource = metaResourceSet.createResource(URI.createPlatformResourceURI((String)ecorePath, (boolean)true));
                        if (EPackage.Registry.INSTANCE.getEPackage(((EPackage)object).getNsURI()) != null) {
                            metaResource.getContents().add((Object)((EPackage)object));
                        } else {
                            EPackage newEPackage = EcoreFactory.eINSTANCE.createEPackage();
                            newEPackage = (EPackage)EcoreUtil.copy((EObject)((EPackage)object));
                            metaResource.getContents().add((Object)newEPackage);
                            object = newEPackage;
                        }
                        try {
                            metaResource.save(null);
                        }
                        catch (IOException e) {
                            MessageDialog.openError((Shell)NewHenshin_textFileWizard.this.getShell(), (String)"Error", (String)("Error saving " + ((EPackage)object).getName() + ".ecore."));
                            e.printStackTrace();
                        }
                        resource.getResourceSet().getResources().add((Object)metaResource);
                    }
                    EPackageImport eimport = Henshin_textFactory.eINSTANCE.createEPackageImport();
                    eimport.setRef((EPackage)object);
                    model.getEPackageimports().add((Object)eimport);
                }
                resource.getContents().add((Object)model);
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", "UTF-8");
                try {
                    resource.save(options);
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)NewHenshin_textFileWizard.this.getShell(), (String)"Error", (String)("Error saving " + file.getName() + "."));
                    e.printStackTrace();
                }
            }
        };
        try {
            this.getContainer().run(true, false, operation);
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                page.openEditor((IEditorInput)new FileEditorInput(file), descriptor.getId());
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Cannot open " + file.getName() + "!"));
                e.printStackTrace();
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private boolean projectContainsEcore(URI ecoreUri, IProject project) {
        if (ecoreUri.segmentsList().size() > 1) {
            if (!project.getName().equals(ecoreUri.segmentsList().get(1))) {
                return false;
            }
            String path = "";
            int i = 2;
            while (i < ecoreUri.segmentsList().size()) {
                path = String.valueOf(path) + "/" + (String)ecoreUri.segmentsList().get(i);
                ++i;
            }
            if (project.findMember(path) != null) {
                return true;
            }
        }
        return false;
    }
}

