/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.refactoring.logic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mergeSuggestion.MergeNAC;
import mergeSuggestion.MergePAC;
import mergeSuggestion.MergeRule;
import mergeSuggestion.MergeRuleElement;
import mergeSuggestion.MergeSuggestionFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.MergeInException;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.MergeRuleElementRulesMapping;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.ParameterRulesMapping;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;

public class NewMerger {
    private static final String VAR = "Var";
    private static final String COMMA = ",";
    private static final String BRACKET_LEFT = "(";
    private static final String XOR = "xor";
    private static final String AC = "AC";
    private static final String BRACKET_RIGHT = ")";
    private static final String OR = " or ";
    private MergeRule mergeRule;
    private Rule masterRule;
    private List<Rule> furtherRules;
    private int numberOfRules;
    private Module henshinModule;
    private HashMap<Node, Node> nodesMap;
    private HashMap<Rule, String> rule2ConditionMap;
    private EList<MergeRuleElement> elementsLhs;
    private EList<MergeRuleElement> elementsRhs;
    private EList<MergeRuleElement> elementsConditions;
    private EList<MergeRuleElement> elementsNestedRules;
    private EList<ParameterRulesMapping> parameterRulesMappings;
    private EList<MergeRuleElementRulesMapping> mergeRuleElementRulesMappings;
    private boolean unifyParameters;

    public NewMerger(MergeRule m) throws MergeInException {
        this(m, false);
    }

    public NewMerger(MergeRule m, boolean unifyParams) throws MergeInException {
        this.mergeRule = m;
        this.unifyParameters = unifyParams;
        this.masterRule = this.mergeRule.getMasterRule();
        this.furtherRules = new ArrayList<Rule>();
        this.furtherRules.addAll((Collection<Rule>)this.mergeRule.getRules());
        this.furtherRules.remove(this.masterRule);
        this.numberOfRules = this.furtherRules.size() + 1;
        this.setModule();
        this.nodesMap = new HashMap();
        this.rule2ConditionMap = new LinkedHashMap<Rule, String>();
        this.elementsLhs = new BasicEList();
        this.elementsRhs = new BasicEList();
        this.elementsConditions = new BasicEList();
        this.elementsNestedRules = new BasicEList();
        this.parameterRulesMappings = new BasicEList();
        this.mergeRuleElementRulesMappings = new BasicEList();
    }

    public void saveModule(String path) throws MergeInException {
        File file = new File(path);
        HenshinResourceSet resourceSet = new HenshinResourceSet(file.getParent());
        Resource resource = resourceSet.createResource(path);
        resource.getContents().add((Object)this.henshinModule);
        try {
            resource.save(null);
        }
        catch (IOException iOException) {
            throw new MergeInException("The module can not be saved.");
        }
    }

    public void merge() throws MergeInException {
        this.prepareMerging();
        this.mergeParameters();
        this.mergeLhsRhsGraphs();
        this.mergeConditions();
        this.completeMerging();
    }

    private void prepareMerging() {
        this.sortMergeRuleElements();
        this.setPresenceConditions();
        this.fillNodesMap();
        this.partitionMergeRuleElements();
    }

    private void mergeParameters() {
        if (this.unifyParameters) {
            this.unifyParameterNames();
        }
        this.mergeParametersIntoMasterRule();
    }

    private void mergeLhsRhsGraphs() {
        this.mergeLhsGraph();
        this.mergeRhsGraph();
        this.addLhsRhsMapping();
    }

    private void mergeConditions() {
        block0: for (MergeNAC mergeNAC : this.mergeRule.getMergeNacs()) {
            for (Graph refNAC : mergeNAC.getReferenceNACs()) {
                for (NestedCondition masterNac : this.masterRule.getLhs().getNACs()) {
                    if (masterNac.getConclusion() == refNAC) continue block0;
                }
            }
            Graph nonMasterNac = (Graph)mergeNAC.getReferenceNACs().get(0);
            this.addNestedCondition2Graph((NestedCondition)nonMasterNac.eContainer(), true);
        }
        block3: for (MergePAC mergePAC : this.mergeRule.getMergePacs()) {
            for (Graph refPAC : mergePAC.getReferencePACs()) {
                for (NestedCondition masterPac : this.masterRule.getLhs().getPACs()) {
                    if (masterPac.getConclusion() == refPAC) continue block3;
                }
            }
            Graph nonMasterPac = (Graph)mergePAC.getReferencePACs().get(0);
            this.addNestedCondition2Graph((NestedCondition)nonMasterPac.eContainer(), false);
        }
        int number = 1;
        for (NestedCondition nac : this.masterRule.getLhs().getNACs()) {
            nac.getConclusion().setName("" + number);
            ++number;
        }
        for (NestedCondition pac : this.masterRule.getLhs().getPACs()) {
            pac.getConclusion().setName("" + number);
            ++number;
        }
    }

    private void completeMerging() throws MergeInException {
        this.setInjectiveMatching();
        this.setFeatureModel();
        this.setFeatures();
        this.setAnnotation();
        if (this.furtherRules.isEmpty()) {
            this.masterRule.setName(String.valueOf(this.masterRule.getName()) + "-var");
        } else {
            for (Rule rule : this.furtherRules) {
                this.masterRule.setName(String.valueOf(this.masterRule.getName()) + COMMA + rule.getName());
            }
        }
        this.removeNonMasterRules();
    }

    private void setAnnotation() {
        Annotation anno = HenshinFactory.eINSTANCE.createAnnotation();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Rule, String> entry : this.rule2ConditionMap.entrySet()) {
            sb.append(entry.getValue());
            sb.append('=');
            sb.append(entry.getKey());
            sb.append(", ");
        }
        String value = sb.toString();
        value = value.substring(0, value.length() - 2);
        anno.setKey("originalRules");
        anno.setValue(value);
        this.masterRule.getAnnotations().add((Object)anno);
    }

    private void removeNonMasterRules() throws MergeInException {
        for (Rule rule : this.furtherRules) {
            if (rule.getModule() != null) continue;
            throw new MergeInException("One of the rules is not directly contained in the module.");
        }
        this.henshinModule.getUnits().removeAll(this.furtherRules);
    }

    private void setFeatureModel() {
        String featureModel = XOR;
        VariabilityRule masterVarRule = VariabilityFactory.createVariabilityRule((Rule)this.masterRule);
        masterVarRule.addFeature(masterVarRule.getName());
        featureModel = String.valueOf(featureModel) + BRACKET_LEFT;
        featureModel = String.valueOf(featureModel) + this.getCondition(this.masterRule);
        for (Rule rule : this.furtherRules) {
            featureModel = String.valueOf(featureModel) + COMMA;
            featureModel = String.valueOf(featureModel) + this.getCondition(rule);
            masterVarRule.addFeature(rule.getName());
        }
        featureModel = String.valueOf(featureModel) + BRACKET_RIGHT;
        VariabilityFactory.createVariabilityRule((Rule)this.masterRule).setFeatureModel(featureModel);
    }

    private void setFeatures() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Rule, String> entry : this.rule2ConditionMap.entrySet()) {
            sb.append(this.getCondition(entry.getKey()));
            sb.append(COMMA);
        }
        String value = sb.toString();
        value = value.substring(0, value.length() - 1);
        VariabilityFactory.createVariabilityRule((Rule)this.masterRule).setFeatures(value);
    }

    private void addNestedCondition2Graph(NestedCondition condition, boolean nac) {
        NestedCondition formula = condition;
        if (nac) {
            formula = HenshinFactory.eINSTANCE.createNot();
            ((Not)formula).setChild((Formula)condition);
        }
        if (this.masterRule.getLhs().getFormula() == null) {
            this.masterRule.getLhs().setFormula((Formula)formula);
        } else {
            And and = HenshinFactory.eINSTANCE.createAnd();
            and.setLeft(this.masterRule.getLhs().getFormula());
            and.setRight((Formula)formula);
            this.masterRule.getLhs().setFormula((Formula)and);
        }
        this.adjustMappings((Formula)formula);
    }

    private void adjustMappings(Formula formula) {
        if (formula instanceof NestedCondition) {
            NestedCondition nestedCondition = (NestedCondition)formula;
            for (Mapping mapping : nestedCondition.getMappings()) {
                Node oldOrigin = mapping.getOrigin();
                mapping.setOrigin(this.nodesMap.get(oldOrigin));
            }
        }
        if (formula instanceof Not) {
            Not not = (Not)formula;
            this.adjustMappings(not.getChild());
        }
    }

    private EList<Rule> getRulesWithCondition() {
        BasicEList rulesWithCondition = new BasicEList();
        for (MergeRuleElementRulesMapping mapping : this.mergeRuleElementRulesMappings) {
            Rule rule = (Rule)mapping.getRules().get(0);
            if (rule == this.masterRule) continue;
            rulesWithCondition.add((Object)rule);
        }
        return rulesWithCondition;
    }

    private void prepareRuleSets() {
        for (MergeRuleElement mre : this.elementsConditions) {
            MergeRuleElementRulesMapping mapping = new MergeRuleElementRulesMapping(this, mre);
            for (GraphElement elem : mre.getReferenceElements()) {
                mapping.addRule(elem.getGraph().getRule());
            }
            if (!this.mappingContainsRuleList(mapping)) {
                this.mergeRuleElementRulesMappings.add((Object)mapping);
            }
            this.setConditionName(mre);
        }
    }

    private void setConditionName(MergeRuleElement mre) {
        for (GraphElement elem : mre.getReferenceElements()) {
            if (!elem.getGraph().isNestedCondition()) continue;
            EList<Rule> affectedRules = this.getRulesFromMergeRuleElement(mre);
            String str = "";
            for (Rule rule : affectedRules) {
                str = String.valueOf(str) + rule.getName();
            }
            elem.getGraph().setName(AC + str);
        }
    }

    private boolean mappingContainsRuleList(MergeRuleElementRulesMapping mapping) {
        for (MergeRuleElementRulesMapping m : this.mergeRuleElementRulesMappings) {
            if (!m.hasSameRuleList(mapping)) continue;
            return true;
        }
        return false;
    }

    private void addLhsRhsMapping() {
        for (Rule rule : this.furtherRules) {
            MappingList mappingList = rule.getMappings();
            this.addMappings2Rule(this.masterRule, mappingList);
        }
    }

    private void addMappings2Rule(Rule rule, MappingList mappingList) {
        for (Mapping mapping : mappingList) {
            Node origin = this.nodesMap.get(mapping.getOrigin());
            Node image = this.nodesMap.get(mapping.getImage());
            if (rule.getMappings().get(origin, image) != null) continue;
            rule.getMappings().add((Object)HenshinFactory.eINSTANCE.createMapping(origin, image));
        }
    }

    private void mergeRhsGraph() {
        ArrayList<Node> nodesRhs = new ArrayList<Node>();
        ArrayList<Edge> edgesRhs = new ArrayList<Edge>();
        ArrayList<Attribute> attributesRhs = new ArrayList<Attribute>();
        this.fillLists(nodesRhs, edgesRhs, attributesRhs, this.elementsRhs);
        this.addNodes2GraphOfMasterRule(this.masterRule.getRhs(), nodesRhs);
        this.addAttributes2Nodes(attributesRhs);
        this.addEdges2Graph(this.masterRule.getRhs(), edgesRhs);
    }

    private void mergeLhsGraph() {
        ArrayList<Node> nodesLhs = new ArrayList<Node>();
        ArrayList<Edge> edgesLhs = new ArrayList<Edge>();
        ArrayList<Attribute> attributesLhs = new ArrayList<Attribute>();
        this.fillLists(nodesLhs, edgesLhs, attributesLhs, this.elementsLhs);
        this.addNodes2GraphOfMasterRule(this.masterRule.getLhs(), nodesLhs);
        this.addAttributes2Nodes(attributesLhs);
        this.addEdges2Graph(this.masterRule.getLhs(), edgesLhs);
    }

    private void addEdges2Graph(Graph graph, List<Edge> edges) {
        for (Edge edge : edges) {
            Node sourceNew = this.nodesMap.get(edge.getSource());
            Node targetNew = this.nodesMap.get(edge.getTarget());
            Edge e = sourceNew.getOutgoing(edge.getType(), targetNew);
            if (e == null) {
                edge.setSource(sourceNew);
                edge.setTarget(targetNew);
                graph.getEdges().add((Object)edge);
                continue;
            }
            if (e != edge || graph.getEdges().contains((Object)edge)) continue;
            graph.getEdges().add((Object)edge);
        }
    }

    private void addAttributes2Nodes(List<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            Node newOwningNode = this.nodesMap.get(attribute.getNode());
            newOwningNode.getAttributes().add((Object)attribute);
        }
    }

    private void addNodes2GraphOfMasterRule(Graph graph, List<Node> nodes) {
        for (Node node : nodes) {
            if (this.nodesMap.get(node) != node || node.getGraph().getRule() == this.masterRule) continue;
            graph.getNodes().add((Object)node);
        }
    }

    private void fillLists(List<Node> nodes, List<Edge> edges, List<Attribute> attributes, EList<MergeRuleElement> elements) {
        for (MergeRuleElement mre : elements) {
            for (GraphElement elem : mre.getReferenceElements()) {
                if (elem instanceof Node) {
                    nodes.add((Node)elem);
                }
                if (elem instanceof Edge) {
                    edges.add((Edge)elem);
                }
                if (!(elem instanceof Attribute)) continue;
                attributes.add((Attribute)elem);
            }
        }
    }

    private void mergeParametersIntoMasterRule() {
        for (Rule rule : this.furtherRules) {
            for (Parameter param : rule.getParameters()) {
                if (this.masterRuleContainsParameter(param)) continue;
                Parameter paramCopy = HenshinFactory.eINSTANCE.createParameter();
                paramCopy.setName(param.getName());
                if (param.getType() != null) {
                    paramCopy.setType(param.getType());
                }
                this.masterRule.getParameters().add((Object)paramCopy);
            }
        }
    }

    private boolean masterRuleContainsParameter(Parameter param) {
        for (Parameter p : this.masterRule.getParameters()) {
            if (!p.getName().equals(param.getName())) continue;
            if (p.getType() == null && param.getType() == null) {
                return true;
            }
            if (p.getType() == null || param.getType() == null || p.getType() != param.getType()) continue;
            return true;
        }
        return false;
    }

    private void unifyParameterNames() {
        for (Parameter param : this.masterRule.getParameters()) {
            ParameterRulesMapping parameterRulesMapping = new ParameterRulesMapping(param, this);
            this.assignRules2Parameter(parameterRulesMapping);
            this.parameterRulesMappings.add((Object)parameterRulesMapping);
        }
        for (Rule rule : this.furtherRules) {
            for (Parameter param : rule.getParameters()) {
                ParameterRulesMapping parameterRulesMapping = new ParameterRulesMapping(param, this);
                this.assignRules2Parameter(parameterRulesMapping);
                this.parameterRulesMappings.add((Object)parameterRulesMapping);
            }
        }
        for (ParameterRulesMapping mapping : this.parameterRulesMappings) {
            Parameter param;
            param = mapping.getParameter();
            String oldName = param.getName();
            String newName = "";
            for (Rule rule : mapping.getRules()) {
                if (rule.getName() == null || rule.getName().isEmpty()) continue;
                newName = String.valueOf(newName) + this.firstToUpper(rule.getName().toLowerCase());
            }
            newName = String.valueOf(newName) + this.firstToUpper(oldName);
            param.setName(newName);
            this.updateReferences2Parameter((Rule)param.getUnit(), oldName, newName);
        }
    }

    private void updateReferences2Parameter(Rule rule, String oldName, String newName) {
        for (MergeRuleElement mre : this.mergeRule.getElements()) {
            for (GraphElement ge : mre.getReferenceElements()) {
                if (ge instanceof Node && ((Node)ge).getName() != null && ((Node)ge).getName().equals(oldName)) {
                    if (ge.getGraph().getRule().getKernelRule() != null) {
                        if (ge.getGraph().getRule().getKernelRule() == rule) {
                            ((Node)ge).setName(newName);
                        }
                    } else if (ge.getGraph().getRule() == rule) {
                        ((Node)ge).setName(newName);
                    }
                }
                if (!(ge instanceof Attribute) || !((Attribute)ge).getValue().equals(oldName)) continue;
                if (ge.getGraph().getRule().getKernelRule() != null) {
                    if (ge.getGraph().getRule().getKernelRule() != rule) continue;
                    ((Attribute)ge).setValue(newName);
                    continue;
                }
                if (ge.getGraph().getRule() != rule) continue;
                ((Attribute)ge).setValue(newName);
            }
        }
    }

    private String firstToUpper(String str) {
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    private void assignRules2Parameter(ParameterRulesMapping mapping) {
        Parameter param = mapping.getParameter();
        for (MergeRuleElement mre : this.mergeRule.getElements()) {
            if (!this.getRulesFromMergeRuleElement(mre).contains((Object)((Rule)param.getUnit()))) continue;
            for (GraphElement ge : mre.getReferenceElements()) {
                if (ge instanceof Node && ((Node)ge).getName() != null && ((Node)ge).getName().equals(param.getName())) {
                    if (ge.getGraph().getRule().getKernelRule() != null) {
                        mapping.addRule(ge.getGraph().getRule().getKernelRule());
                    } else {
                        mapping.addRule(ge.getGraph().getRule());
                    }
                }
                if (!(ge instanceof Attribute) || !((Attribute)ge).getValue().equals(param.getName())) continue;
                if (ge.getGraph().getRule().getKernelRule() != null) {
                    mapping.addRule(ge.getGraph().getRule().getKernelRule());
                    continue;
                }
                mapping.addRule(ge.getGraph().getRule());
            }
        }
    }

    private EList<Rule> getRulesFromMergeRuleElement(MergeRuleElement mre) {
        BasicEList rules = new BasicEList();
        for (GraphElement ge : mre.getReferenceElements()) {
            if (ge.getGraph().getRule().getKernelRule() != null) {
                rules.add((Object)ge.getGraph().getRule().getKernelRule());
                continue;
            }
            rules.add((Object)ge.getGraph().getRule());
        }
        return rules;
    }

    private void partitionMergeRuleElements() {
        for (MergeRuleElement mre : this.mergeRule.getElements()) {
            GraphElement elem = (GraphElement)mre.getReferenceElements().get(0);
            if (elem.getGraph().getRule().getKernelRule() != null) {
                this.elementsNestedRules.add((Object)mre);
                continue;
            }
            if (elem.getGraph().isLhs()) {
                this.elementsLhs.add((Object)mre);
                continue;
            }
            if (elem.getGraph().isRhs()) {
                this.elementsRhs.add((Object)mre);
                continue;
            }
            if (!elem.getGraph().isNestedCondition()) continue;
            this.elementsConditions.add((Object)mre);
            this.setPresenceCondition(mre);
        }
    }

    private void setPresenceCondition(MergeRuleElement mre) {
        for (GraphElement elem : mre.getReferenceElements()) {
            String presenceCondition = VariabilityFactory.createVariabilityGraphElement((GraphElement)elem).getPresenceCondition();
            if (!elem.getGraph().isNestedCondition()) continue;
            NestedCondition condition = (NestedCondition)elem.getGraph().eContainer();
            VariabilityFactory.createVariabilityNestedCondition((NestedCondition)condition).setPresenceCondition(presenceCondition);
        }
    }

    private void fillNodesMap() {
        for (MergeRuleElement mre : this.mergeRule.getElements()) {
            if (!(mre.getReferenceElements().get(0) instanceof Node)) continue;
            Node baseNode = (Node)mre.getReferenceElements().get(0);
            for (GraphElement elem : mre.getReferenceElements()) {
                Node node = (Node)elem;
                this.nodesMap.put(node, baseNode);
            }
        }
    }

    private void setPresenceConditions() {
        int i = 0;
        for (Rule rule : this.mergeRule.getRules()) {
            this.rule2ConditionMap.put(rule, NewMerger.str(i));
            ++i;
        }
        for (MergeRuleElement mre : this.mergeRule.getElements()) {
            if (mre.getReferenceElements().size() == this.numberOfRules) continue;
            for (GraphElement elem : mre.getReferenceElements()) {
                String condition = this.getCondition(mre);
                VariabilityFactory.createVariabilityGraphElement((GraphElement)elem).setPresenceCondition(condition);
            }
        }
        for (MergeNAC nac : this.mergeRule.getMergeNacs()) {
            if (nac.getReferenceNACs().size() == this.numberOfRules) continue;
            for (Graph g : nac.getReferenceNACs()) {
                this.setPresenceCondition(nac, g);
            }
        }
    }

    static String str(int i) {
        return i < 0 ? "" : String.valueOf(NewMerger.str(i / 26 - 1)) + (char)(65 + i % 26);
    }

    private void setPresenceCondition(MergeNAC nac, Graph g) {
        String condition = this.getCondition(nac);
        VariabilityFactory.createVariabilityNestedCondition((NestedCondition)((NestedCondition)g.eContainer())).setPresenceCondition(condition);
        for (Node node : g.getNodes()) {
            if (node.getActionNode() == node) {
                VariabilityFactory.createVariabilityNode((Node)node).setPresenceCondition(condition);
            }
            for (Attribute attribute : node.getAttributes()) {
                if (attribute.getActionAttribute() != attribute) continue;
                VariabilityFactory.createVariabilityAttribute((Attribute)attribute).setPresenceCondition(condition);
            }
        }
        for (Edge edge : g.getEdges()) {
            if (edge.getActionEdge() != edge) continue;
            VariabilityFactory.createVariabilityEdge((Edge)edge).setPresenceCondition(condition);
        }
    }

    private String getCondition(MergeNAC nac) {
        ArrayList<Rule> affectedRules = new ArrayList<Rule>();
        for (Graph el : nac.getReferenceNACs()) {
            affectedRules.add(el.getRule());
        }
        return this.getCondition(affectedRules);
    }

    private String getCondition(MergeRuleElement mre) {
        ArrayList<Rule> affectedRules = new ArrayList<Rule>();
        for (GraphElement elem : mre.getReferenceElements()) {
            affectedRules.add(elem.getGraph().getRule());
        }
        return this.getCondition(affectedRules);
    }

    private String getCondition(List<Rule> affectedRules) {
        String condition = "";
        if (!affectedRules.isEmpty()) {
            condition = this.getCondition(affectedRules.get(0));
        }
        int i = 1;
        while (i < affectedRules.size()) {
            condition = String.valueOf(condition) + OR + this.getCondition(affectedRules.get(i));
            ++i;
        }
        return condition;
    }

    private String getCondition(Rule rule) {
        String ruleName = rule.getName();
        ruleName = ruleName.replaceAll("\\W", "");
        ruleName = ruleName.replaceAll("_", "");
        return "def(" + ruleName.toLowerCase() + BRACKET_RIGHT;
    }

    private void sortMergeRuleElements() {
        BasicEList elements = new BasicEList();
        for (MergeRuleElement mre : this.mergeRule.getElements()) {
            elements.add((Object)this.getSortedElement(mre));
        }
        this.mergeRule.getElements().clear();
        this.mergeRule.getElements().addAll((Collection)elements);
    }

    private MergeRuleElement getSortedElement(MergeRuleElement mre) {
        int oldSize = mre.getReferenceElements().size();
        MergeRuleElement elem = MergeSuggestionFactory.eINSTANCE.createMergeRuleElement();
        for (GraphElement ge : mre.getReferenceElements()) {
            if (ge.getGraph().getRule() != this.masterRule) continue;
            elem.getReferenceElements().add((Object)ge);
            break;
        }
        int i = 0;
        while (i < this.furtherRules.size()) {
            Rule rule = this.furtherRules.get(i);
            for (GraphElement ge : mre.getReferenceElements()) {
                if (ge.getGraph().getRule() != rule) continue;
                elem.getReferenceElements().add((Object)ge);
                break;
            }
            ++i;
        }
        if (elem.getReferenceElements().size() != oldSize) {
            throw new RuntimeException("Error during sorting!");
        }
        return elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setModule() throws MergeInException {
        if (this.mergeRule == null) throw new MergeInException("There is no merge rule.");
        if (this.masterRule == null) throw new MergeInException("The merge rule does not have a master rule.");
        if (this.masterRule.getModule() == null) {
            throw new MergeInException("The master rule is not contained in a module.");
        }
        this.henshinModule = this.masterRule.getModule();
    }

    private void setInjectiveMatching() {
        ArrayList<Rule> injective = new ArrayList<Rule>();
        for (Rule rule : this.mergeRule.getRules()) {
            if (!rule.isInjectiveMatching()) continue;
            injective.add(rule);
        }
        if (injective.isEmpty()) {
            VariabilityFactory.createVariabilityRule((Rule)this.masterRule).setInjectiveMatchingPresenceCondition("false");
        } else if (injective.size() != this.mergeRule.getRules().size()) {
            String condition = this.getCondition((Rule)injective.get(0));
            int i = 1;
            while (i < injective.size()) {
                condition = String.valueOf(condition) + OR + this.getCondition((Rule)injective.get(i));
                ++i;
            }
            VariabilityFactory.createVariabilityRule((Rule)this.masterRule).setInjectiveMatchingPresenceCondition(condition);
        }
    }

    MergeRule getMergeRule() {
        return this.mergeRule;
    }

    HashMap<Node, Node> getNodesMap() {
        return this.nodesMap;
    }

    EList<MergeRuleElement> getElementsLhs() {
        return this.elementsLhs;
    }

    EList<MergeRuleElement> getElementsRhs() {
        return this.elementsRhs;
    }

    EList<MergeRuleElement> getElementsConditions() {
        return this.elementsConditions;
    }

    EList<MergeRuleElement> getElementsNestedRules() {
        return this.elementsNestedRules;
    }

    Rule getMasterRule() {
        return this.masterRule;
    }

    List<Rule> getFurtherRules() {
        return this.furtherRules;
    }

    EList<MergeRuleElementRulesMapping> getMergeRuleElementRulesMappings() {
        return this.mergeRuleElementRulesMappings;
    }

    Module getModule() {
        return this.henshinModule;
    }
}

