/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.agt;

import agg.attribute.impl.ContextView;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.agt.RuleScheme;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class MultiRule
extends Rule
implements Observer {
    private RuleScheme itsRuleScheme;
    private OrdinaryMorphism embeddingLeft;
    private OrdinaryMorphism embeddingRight;
    private final Hashtable<GraphObject, GraphObject> kernel2objects = new Hashtable();
    private final Hashtable<GraphObject, GraphObject> objects2kernel = new Hashtable();
    private List<OrdinaryMorphism> shiftedApplConds = new Vector<OrdinaryMorphism>();

    public MultiRule(TypeSet types) {
        super(types);
        this.itsName = "MultiRule";
    }

    public MultiRule(Rule kernelRule, OrdinaryMorphism embeddingLeft, OrdinaryMorphism embeddingRight) {
        super(embeddingLeft.getTarget(), embeddingRight.getTarget());
        this.itsName = "MultiRule";
        this.embeddingLeft = embeddingLeft;
        this.embeddingRight = embeddingRight;
        this.applyEmbeddedRuleMapping(kernelRule);
        this.itsOrig.setKind("LHS");
        this.itsImag.setKind("RHS");
        kernelRule.getLeft().setKind("LHS");
        kernelRule.getRight().setKind("RHS");
        this.mapKernel2MultiObject();
    }

    @Override
    public String getQualifiedName() {
        if (this.itsRuleScheme != null) {
            return this.itsRuleScheme.getName().concat(".").concat(this.itsName);
        }
        return this.itsName;
    }

    public void addShiftedKernelApplCond(OrdinaryMorphism cond, boolean pac) {
        this.shiftedApplConds.add(cond);
        if (pac) {
            this.itsPACs.add(0, cond);
        } else {
            this.itsNACs.add(0, cond);
        }
    }

    public void addShiftedKernelNestedApplCond(NestedApplCond cond) {
        this.shiftedApplConds.add(cond);
        this.itsACs.add(0, cond);
    }

    public void removeShiftedKernelApplConds() {
        int i = 0;
        while (i < this.shiftedApplConds.size()) {
            OrdinaryMorphism cond = this.shiftedApplConds.get(i);
            if (this.itsACs.contains(cond)) {
                this.destroyNestedAC(cond);
            } else if (this.itsPACs.contains(cond)) {
                this.destroyPAC(cond);
            } else if (this.itsNACs.contains(cond)) {
                this.destroyNAC(cond);
            }
            ++i;
        }
        this.shiftedApplConds.clear();
    }

    public void removeShiftedKernelApplCond(OrdinaryMorphism cond, boolean pac) {
        if (this.shiftedApplConds.remove(cond)) {
            if (pac) {
                this.destroyPAC(cond);
            } else {
                this.destroyNAC(cond);
            }
        }
    }

    public Match getMatch(Rule kernelRule) {
        if (this.itsMatch == null && kernelRule == this.itsRuleScheme.getKernelRule()) {
            if (this.itsRuleScheme.getKernelRule().getMatch() != null) {
                this.itsMatch = BaseFactory.theFactory().createMatch(this, this.itsRuleScheme.getKernelRule().getMatch().getTarget());
            }
            if (!this.setPartialMultiMatch(this.itsRuleScheme.getKernelRule().getMatch())) {
                this.itsMatch.dispose();
                this.itsMatch = null;
            }
        }
        return this.itsMatch;
    }

    private boolean setPartialMultiMatch(Match kernelMatch) {
        if (kernelMatch != null) {
            for (GraphObject graphObject : kernelMatch.getSource().getNodesSet()) {
                GraphObject graphObject2 = this.embeddingLeft.getImage(graphObject);
                GraphObject imgKernMatch = kernelMatch.getImage(graphObject);
                if (graphObject2 == null || imgKernMatch == null) continue;
                try {
                    this.itsMatch.addMapping(graphObject2, imgKernMatch);
                }
                catch (BadMappingException ex) {
                    return false;
                }
            }
            for (GraphObject graphObject : kernelMatch.getSource().getArcsSet()) {
                GraphObject objLmulti = this.embeddingLeft.getImage(graphObject);
                GraphObject imgKernMatch = kernelMatch.getImage(graphObject);
                if (objLmulti == null || imgKernMatch == null) continue;
                try {
                    this.itsMatch.addMapping(objLmulti, imgKernMatch);
                }
                catch (BadMappingException ex) {
                    return false;
                }
            }
            this.itsMatch.adaptAttrContextValues(kernelMatch.getAttrContext());
            this.setTempInputParameter(kernelMatch);
            if (this.itsMatch.getSize() > 0) {
                this.itsMatch.setPartialMorphismCompletion(true);
            }
        }
        return true;
    }

    private void setTempInputParameter(Match kernelMatch) {
        VarTuple kernVars = (VarTuple)kernelMatch.getAttrContext().getVariables();
        VarTuple matchVars = (VarTuple)this.itsMatch.getAttrContext().getVariables();
        int i = 0;
        while (i < kernVars.getNumberOfEntries()) {
            VarMember kernVar = kernVars.getVarMemberAt(i);
            VarMember var = matchVars.getVarMemberAt(kernVar.getName());
            if (var != null && kernVar.getDeclaration().getTypeName().equals(var.getDeclaration().getTypeName()) && kernVar.isSet()) {
                var.setExprAsText(kernVar.getExprAsText());
                if (!var.isInputParameter()) {
                    var.setInputParameter(true);
                }
            }
            ++i;
        }
    }

    public boolean isLeftEmbeddingValid() {
        GraphObject img;
        GraphObject obj;
        Iterator<GraphObject> kernelElems = this.embeddingLeft.getSource().getNodesSet().iterator();
        while (kernelElems.hasNext()) {
            obj = kernelElems.next();
            if (this.embeddingLeft.getImage(obj) == null) {
                return false;
            }
            img = this.embeddingLeft.getImage(obj);
            this.adoptEntriesWhereEmpty(this.embeddingLeft, obj, img);
        }
        if (kernelElems.hasNext()) {
            return false;
        }
        kernelElems = this.embeddingLeft.getSource().getArcsSet().iterator();
        while (kernelElems.hasNext()) {
            obj = kernelElems.next();
            if (this.embeddingLeft.getImage(obj) == null) {
                return false;
            }
            img = this.embeddingLeft.getImage(obj);
            this.adoptEntriesWhereEmpty(this.embeddingLeft, obj, img);
        }
        return !kernelElems.hasNext();
    }

    public boolean isRightEmbeddingValid() {
        GraphObject img;
        GraphObject obj;
        Iterator<GraphObject> kernelElems = this.itsRuleScheme.getKernelRule().getRight().getNodesSet().iterator();
        while (kernelElems.hasNext()) {
            obj = kernelElems.next();
            if (this.embeddingRight.getImage(obj) == null) {
                return false;
            }
            img = this.embeddingRight.getImage(obj);
            this.adoptEntriesWhereEmpty(this.embeddingRight, obj, img);
        }
        if (kernelElems.hasNext()) {
            return false;
        }
        kernelElems = this.itsRuleScheme.getKernelRule().getRight().getArcsSet().iterator();
        while (kernelElems.hasNext()) {
            obj = kernelElems.next();
            if (this.embeddingRight.getImage(obj) == null) {
                return false;
            }
            img = this.embeddingRight.getImage(obj);
            this.adoptEntriesWhereEmpty(this.embeddingRight, obj, img);
        }
        return !kernelElems.hasNext();
    }

    public boolean isMorphismEmbeddingValid() {
        Enumeration<GraphObject> kernelDom = this.itsRuleScheme.getKernelRule().getDomain();
        while (kernelDom.hasMoreElements()) {
            GraphObject goKern = kernelDom.nextElement();
            GraphObject imgKern = this.itsRuleScheme.getKernelRule().getImage(goKern);
            GraphObject go = this.embeddingLeft.getImage(goKern);
            if (go == null) {
                return false;
            }
            if (imgKern != null && this.embeddingRight.getImage(imgKern) != this.getImage(go)) {
                return false;
            }
            if (imgKern != null || this.getImage(go) == null) continue;
            return false;
        }
        return true;
    }

    public boolean applyEmbeddedRuleMapping(Rule kernelRule) {
        Enumeration<GraphObject> kernelDom = kernelRule.getDomain();
        while (kernelDom.hasMoreElements()) {
            GraphObject goKern = kernelDom.nextElement();
            GraphObject imgKern = kernelRule.getImage(goKern);
            if (imgKern == null || this.getImage(this.embeddingLeft.getImage(goKern)) == this.embeddingRight.getImage(imgKern)) continue;
            try {
                this.addPlainMapping(this.embeddingLeft.getImage(goKern), this.embeddingRight.getImage(imgKern));
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        return true;
    }

    private void mapKernel2MultiObject() {
        for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
            if (!this.embeddingLeft.getInverseImage(graphObject).hasMoreElements()) continue;
            this.mapKernel2MultiObject(this.embeddingLeft.getInverseImage(graphObject).nextElement(), graphObject);
        }
        for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
            if (!this.embeddingLeft.getInverseImage(graphObject).hasMoreElements()) continue;
            this.mapKernel2MultiObject(this.embeddingLeft.getInverseImage(graphObject).nextElement(), graphObject);
        }
        for (GraphObject graphObject : this.itsImag.getNodesSet()) {
            if (!this.embeddingRight.getInverseImage(graphObject).hasMoreElements()) continue;
            this.mapKernel2MultiObject(this.embeddingRight.getInverseImage(graphObject).nextElement(), graphObject);
        }
        for (GraphObject graphObject : this.itsImag.getArcsSet()) {
            if (!this.embeddingRight.getInverseImage(graphObject).hasMoreElements()) continue;
            this.mapKernel2MultiObject(this.embeddingRight.getInverseImage(graphObject).nextElement(), graphObject);
        }
    }

    @Override
    public boolean isReadyToTransform() {
        return this.isLeftEmbeddingValid() && this.isRightEmbeddingValid() && this.isMorphismEmbeddingValid() && super.isReadyToTransform();
    }

    public void setRuleScheme(RuleScheme rs) {
        this.itsRuleScheme = rs;
    }

    @Override
    public RuleScheme getRuleScheme() {
        return this.itsRuleScheme;
    }

    public void setEmbeddingLeft(OrdinaryMorphism left) {
        this.embeddingLeft = left;
    }

    public void setEmbeddingRight(OrdinaryMorphism right) {
        this.embeddingRight = right;
    }

    public OrdinaryMorphism getEmbeddingLeft() {
        return this.embeddingLeft;
    }

    public OrdinaryMorphism getEmbeddingRight() {
        return this.embeddingRight;
    }

    public void addEmbeddingLeft(GraphObject kern, GraphObject obj) {
        this.embeddingLeft.addMapping(kern, obj);
        this.kernel2objects.put(kern, obj);
        this.objects2kernel.put(obj, kern);
    }

    public void addEmbeddingRight(GraphObject kern, GraphObject obj) {
        this.embeddingRight.addMapping(kern, obj);
        this.kernel2objects.put(kern, obj);
        this.objects2kernel.put(obj, kern);
    }

    public void removeEmbeddingLeft(GraphObject obj) {
        if (this.kernel2objects.get(obj) != null) {
            GraphObject obj2 = this.kernel2objects.get(obj);
            this.embeddingLeft.removeMappingFast(obj, true);
            this.kernel2objects.remove(obj);
            this.objects2kernel.remove(obj2);
        } else if (this.objects2kernel.get(obj) != null) {
            GraphObject obj2 = this.objects2kernel.get(obj);
            this.embeddingLeft.removeMappingFast(obj2, true);
            this.kernel2objects.remove(obj2);
            this.objects2kernel.remove(obj);
        }
    }

    public void removeEmbeddingRight(GraphObject obj) {
        if (this.kernel2objects.get(obj) != null) {
            GraphObject obj2 = this.kernel2objects.get(obj);
            this.embeddingRight.removeMappingFast(obj, false);
            this.kernel2objects.remove(obj);
            this.objects2kernel.remove(obj2);
        } else if (this.objects2kernel.get(obj) != null) {
            GraphObject obj2 = this.objects2kernel.get(obj);
            this.embeddingRight.removeMappingFast(obj2, false);
            this.kernel2objects.remove(obj2);
            this.objects2kernel.remove(obj);
        }
    }

    public List<Node> getOwnNodesLeft() {
        Vector<Node> list = new Vector<Node>();
        for (Node n : this.itsOrig.getNodesSet()) {
            if (this.embeddingLeft.getCodomainObjects().contains(n)) continue;
            list.add(n);
        }
        return list;
    }

    public List<Node> getOwnNodesRight() {
        Vector<Node> list = new Vector<Node>();
        for (Node n : this.itsImag.getNodesSet()) {
            if (this.embeddingRight.getCodomainObjects().contains(n)) continue;
            list.add(n);
        }
        return list;
    }

    public List<Arc> getOwnArcsLeft() {
        Vector<Arc> list = new Vector<Arc>();
        for (Arc a : this.itsOrig.getArcsSet()) {
            if (this.embeddingLeft.getCodomainObjects().contains(a)) continue;
            list.add(a);
        }
        return list;
    }

    public List<Arc> getOwnArcsRight() {
        Vector<Arc> list = new Vector<Arc>();
        for (Arc a : this.itsImag.getArcsSet()) {
            if (this.embeddingRight.getCodomainObjects().contains(a)) continue;
            list.add(a);
        }
        return list;
    }

    public void removeOwnMappings() {
        List<Arc> arcs = this.getOwnArcsLeft();
        int i = 0;
        while (i < arcs.size()) {
            this.removeMappingFast(arcs.get(i), true);
            ++i;
        }
        List<Node> nodes = this.getOwnNodesLeft();
        int i2 = 0;
        while (i2 < nodes.size()) {
            this.removeMappingFast(nodes.get(i2), true);
            ++i2;
        }
    }

    public void removeOwnNodesLeft() {
        List<Node> nodes = this.getOwnNodesLeft();
        int i = 0;
        while (i < nodes.size()) {
            try {
                this.itsOrig.destroyNode(nodes.get(i), false, true);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void removeOwnNodesRight() {
        List<Node> nodes = this.getOwnNodesRight();
        int i = 0;
        while (i < nodes.size()) {
            try {
                this.itsImag.destroyNode(nodes.get(i), false, true);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void removeOwnArcsLeft() {
        List<Arc> arcs = this.getOwnArcsLeft();
        int i = 0;
        while (i < arcs.size()) {
            try {
                this.itsOrig.destroyArc(arcs.get(i), false, true);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void removeOwnArcsRight() {
        List<Arc> arcs = this.getOwnArcsRight();
        int i = 0;
        while (i < arcs.size()) {
            try {
                this.itsImag.destroyArc(arcs.get(i), false, true);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            ++i;
        }
    }

    public boolean isSourceOfEmbeddingLeft(GraphObject obj) {
        return this.embeddingLeft.getImage(obj) != null;
    }

    public boolean isSourceOfEmbeddingRight(GraphObject obj) {
        return this.embeddingRight.getImage(obj) != null;
    }

    public boolean isTargetOfEmbeddingLeft(GraphObject obj) {
        return this.embeddingLeft.getInverseImage(obj).hasMoreElements();
    }

    public boolean isTargetOfEmbeddingRight(GraphObject obj) {
        return this.embeddingRight.getInverseImage(obj).hasMoreElements();
    }

    public final void setLeft(Graph left) {
        this.clear();
        this.itsOrig = left;
    }

    public final void setRight(Graph right) {
        this.clear();
        this.itsImag = right;
    }

    public void mapKernel2MultiObject(GraphObject kernelObj, GraphObject obj) {
        this.kernel2objects.put(kernelObj, obj);
        this.objects2kernel.put(obj, kernelObj);
    }

    @Override
    public void update(Observable o, Object arg) {
        GraphObject go = null;
        Graph graph = null;
        if (arg instanceof Change) {
            GraphObject mgo;
            Change change = (Change)arg;
            if (change.getItem() instanceof GraphObject) {
                go = (GraphObject)change.getItem();
            } else if (change.getItem() instanceof Pair) {
                Pair p = (Pair)change.getItem();
                if (p.first instanceof GraphObject) {
                    go = (GraphObject)p.first;
                }
            }
            if (o instanceof Graph) {
                if (this.itsRuleScheme.getKernelRule().getLeft() == o) {
                    graph = this.itsOrig;
                } else if (this.itsRuleScheme.getKernelRule().getRight() == o) {
                    graph = this.itsImag;
                }
            }
            if (go != null && graph != null && change.getEvent() == 11 && (mgo = this.kernel2objects.get(go)) != null) {
                mgo.copyAttributes(go);
            }
        }
    }

    private void adoptEntriesWhereEmpty(OrdinaryMorphism morph, GraphObject from, GraphObject to) {
        ContextView context;
        Vector<TupleMapping> mappings;
        if (morph.getImage(from) != null && from.getAttribute() != null && to.getAttribute() != null && (mappings = (context = (ContextView)morph.getAttrContext()).getMappingsToTarget((ValueTuple)to.getAttribute())) != null) {
            mappings.elementAt(0).adoptEntriesWhereEmpty((ValueTuple)from.getAttribute(), (ValueTuple)to.getAttribute());
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        super.XwriteObject(h);
    }

    @Override
    public void XreadObject(XMLHelper h) {
        super.XreadObject(h);
    }
}

