/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrInstance;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.util.Change;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.UndirectedTypeGraph;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.w3c.dom.Element;

public class TypeGraph
extends Graph {
    public TypeGraph(TypeSet aTypeSet) {
        super(aTypeSet);
        this.completeGraph = false;
        this.kind = "TG";
    }

    @Override
    public void dispose() {
        this.observer.removeAllElements();
        this.itsTypes.setLevelOfTypeGraph(0);
        Iterator iter = this.itsArcs.iterator();
        while (iter.hasNext()) {
            try {
                this.destroyArc((Arc)iter.next(), false, false);
                iter = this.itsArcs.iterator();
            }
            catch (TypeException e) {
                System.out.println("TypeGraph.dispose:: destroyArc  FAILED!:  " + e.getMessage());
            }
        }
        iter = this.itsNodes.iterator();
        while (iter.hasNext()) {
            try {
                Node n = (Node)iter.next();
                if (n.getType().hasChild()) continue;
                this.destroyNode(n, false, false);
                iter = this.itsNodes.iterator();
            }
            catch (TypeException e) {
                System.out.println("TypeGraph.dispose:: destroyNode  FAILED!:  " + e.getMessage());
            }
        }
        super.dispose();
    }

    @Override
    public void finalize() {
    }

    public void tryToExtendByTypeNodes(Vector<Type> types) {
        int i = 0;
        while (i < types.size()) {
            Type t = types.get(i);
            if (this.itsTypes.containsType(t) && !this.getElementsOfType(t).hasMoreElements()) {
                if (t.isNodeType()) {
                    try {
                        this.createNode(t);
                    }
                    catch (TypeException typeException) {}
                } else {
                    t.isArcType();
                }
            }
            ++i;
        }
    }

    private void refreshGraph() {
        GraphObject o;
        Iterator iter = this.itsArcs.iterator();
        while (iter.hasNext()) {
            o = (Arc)iter.next();
            if (o.getType() != null && ((Arc)o).getSource() != null && ((Arc)o).getTarget() != null) continue;
            this.removeArc((Arc)o);
            iter = this.itsArcs.iterator();
        }
        iter = this.itsNodes.iterator();
        while (iter.hasNext()) {
            o = (Node)iter.next();
            if (o.getType() != null) continue;
            this.removeNode((Node)o);
            iter = this.itsNodes.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCopyOfGraph(Graph g) {
        TypeGraph typeGraph = this;
        synchronized (typeGraph) {
            if (g instanceof TypeGraph) {
                boolean failed = false;
                if (this.itsTypes.getLevelOfTypeGraphCheck() == 0) {
                    Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(g.getSize());
                    for (Node vtxOrig : g.getNodesSet()) {
                        Node vtxCopy = null;
                        Type type = this.itsTypes.getSimilarType(vtxOrig.getType());
                        if (type == null && (type = this.itsTypes.getTypeByName(vtxOrig.getType().getName())) != null && !type.isNodeType()) {
                            type = null;
                        }
                        if (type == null) continue;
                        if (type.getTypeGraphNodeObject() == null) {
                            try {
                                vtxCopy = this.newNode(type);
                                if (vtxCopy == null) continue;
                                int i = 0;
                                while (i < vtxOrig.getType().getParents().size()) {
                                    Type parentOrig = vtxOrig.getType().getParents().get(i);
                                    Type parent = this.itsTypes.getSimilarType(parentOrig);
                                    if (parent == null && (parent = this.itsTypes.getTypeByName(parentOrig.getName())) != null && !parent.isNodeType()) {
                                        parent = null;
                                    }
                                    if (parent != null) {
                                        this.itsTypes.addInheritanceRelation(type, parent);
                                    }
                                    ++i;
                                }
                                vtxCopy.copyAttributes(vtxOrig);
                                vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                                memo1.put(vtxOrig, vtxCopy);
                                if (!this.notificationRequired) continue;
                                this.propagateChange(new Change(10, vtxCopy));
                            }
                            catch (TypeException e) {
                                Node node = this.itsTypes.getTypeGraphNode(type);
                                memo1.put(vtxOrig, node);
                            }
                            continue;
                        }
                        memo1.put(vtxOrig, type.getTypeGraphNodeObject());
                    }
                    for (Arc arcOrig : g.getArcsSet()) {
                        Arc arcCopy = null;
                        Type type = this.itsTypes.getSimilarType(arcOrig.getType());
                        if (type == null && (type = this.itsTypes.getTypeByName(arcOrig.getType().getName())) != null && !type.isArcType()) {
                            type = null;
                        }
                        if (type == null) continue;
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)memo1.get(source);
                        Node tgtImg = (Node)memo1.get(target);
                        if (type.getTypeGraphArcObject(srcImg.getType(), tgtImg.getType()) != null) continue;
                        if (type.getName().equals("next")) {
                            if (srcImg.getType().getName().equals("Activity") && tgtImg.getType().getName().equals("Activity")) {
                                System.out.println("Activity - next - Activity");
                            } else if (srcImg.getType().getName().equals("BusinessActivity") && tgtImg.getType().getName().equals("BusinessActivity")) {
                                System.out.println("BusinessActivity - next - BusinessActivity");
                            }
                        }
                        try {
                            arcCopy = this.newArc(type, srcImg, tgtImg);
                            if (arcCopy == null) continue;
                            arcCopy.copyAttributes(arcOrig);
                            arcCopy.setContextUsage(arcOrig.getContextUsage());
                            Type srctype = arcCopy.getSource().getType();
                            Type tartype = arcCopy.getTarget().getType();
                            int m1 = arcOrig.getType().getSourceMin(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                            type.setSourceMin(srctype, tartype, m1);
                            m1 = arcOrig.getType().getSourceMax(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                            type.setSourceMax(srctype, tartype, m1);
                            m1 = arcOrig.getType().getTargetMin(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                            type.setTargetMin(srctype, tartype, m1);
                            m1 = arcOrig.getType().getTargetMax(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                            type.setTargetMax(srctype, tartype, m1);
                            if (!this.notificationRequired) continue;
                            this.propagateChange(new Change(10, arcCopy));
                        }
                        catch (TypeException typeException) {
                            // empty catch block
                        }
                    }
                    memo1.clear();
                    this.refreshGraph();
                } else {
                    failed = true;
                }
                return !failed;
            }
            return false;
        }
    }

    public boolean makeFromPlainGraph(Graph g) {
        boolean failed = false;
        if (this.itsTypes.getLevelOfTypeGraphCheck() == 0) {
            Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(g.getSize());
            for (Node vtxOrig : g.getNodesSet()) {
                Node vtxCopy = null;
                Type type = this.itsTypes.getSimilarType(vtxOrig.getType());
                if (type == null && (type = this.itsTypes.getTypeByName(vtxOrig.getType().getName())) != null && !type.isNodeType()) {
                    type = null;
                }
                if (type == null) continue;
                if (type.getTypeGraphNodeObject() == null) {
                    try {
                        vtxCopy = this.newNode(type);
                        if (vtxCopy == null) continue;
                        int i = 0;
                        while (i < vtxOrig.getType().getParents().size()) {
                            Type parentOrig = vtxOrig.getType().getParents().get(i);
                            Type parent = this.itsTypes.getSimilarType(parentOrig);
                            if (parent == null && (parent = this.itsTypes.getTypeByName(parentOrig.getName())) != null && !parent.isNodeType()) {
                                parent = null;
                            }
                            if (parent != null) {
                                this.itsTypes.addInheritanceRelation(type, parent);
                            }
                            ++i;
                        }
                        vtxCopy.copyAttributes(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                        if (!this.notificationRequired) continue;
                        this.propagateChange(new Change(10, vtxCopy));
                    }
                    catch (TypeException e) {
                        Node node = this.itsTypes.getTypeGraphNode(type);
                        memo1.put(vtxOrig, node);
                    }
                    continue;
                }
                memo1.put(vtxOrig, type.getTypeGraphNodeObject());
            }
            for (Arc arcOrig : g.getArcsSet()) {
                Arc arcCopy = null;
                Type type = this.itsTypes.getSimilarType(arcOrig.getType());
                if (type == null && (type = this.itsTypes.getTypeByName(arcOrig.getType().getName())) != null && !type.isArcType()) {
                    type = null;
                }
                if (type == null) continue;
                Node source = (Node)arcOrig.getSource();
                Node target = (Node)arcOrig.getTarget();
                Node srcImg = (Node)memo1.get(source);
                Node tgtImg = (Node)memo1.get(target);
                if (type.getTypeGraphArcObject(srcImg.getType(), tgtImg.getType()) != null) continue;
                try {
                    arcCopy = this.newArc(type, srcImg, tgtImg);
                    if (arcCopy == null) continue;
                    arcCopy.copyAttributes(arcOrig);
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    Type srctype = arcCopy.getSource().getType();
                    Type tartype = arcCopy.getTarget().getType();
                    int m1 = arcOrig.getType().getSourceMin(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                    type.setSourceMin(srctype, tartype, m1);
                    m1 = arcOrig.getType().getSourceMax(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                    type.setSourceMax(srctype, tartype, m1);
                    m1 = arcOrig.getType().getTargetMin(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                    type.setTargetMin(srctype, tartype, m1);
                    m1 = arcOrig.getType().getTargetMax(arcOrig.getSource().getType(), arcOrig.getTarget().getType());
                    type.setTargetMax(srctype, tartype, m1);
                    if (!this.notificationRequired) continue;
                    this.propagateChange(new Change(10, arcCopy));
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            memo1.clear();
            this.refreshGraph();
        } else {
            failed = true;
        }
        return !failed;
    }

    @Override
    public boolean addCopyOfGraph(Graph g, boolean disabledTypeGraph) {
        return this.addCopyOfGraph(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graph copyLight(TypeSet typeSet) {
        TypeGraph typeGraph = this;
        synchronized (typeGraph) {
            TypeGraph theCopy;
            block14: {
                Type type;
                typeSet.getLevelOfTypeGraphCheck();
                boolean failed = false;
                Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
                theCopy = typeSet.isArcDirected() ? new TypeGraph(typeSet) : new UndirectedTypeGraph(typeSet);
                Iterator iter = this.itsNodes.iterator();
                while (!failed && iter.hasNext()) {
                    Node vtxOrig = (Node)iter.next();
                    Node vtxCopy = null;
                    type = typeSet.getSimilarType(vtxOrig.getType());
                    if (type == null && (type = typeSet.getTypeByName(vtxOrig.getType().getName())) != null && !type.isNodeType()) {
                        type = null;
                    }
                    if (type == null) continue;
                    try {
                        vtxCopy = theCopy.newNode(type);
                        if (vtxCopy == null) continue;
                        if (vtxCopy.getAttribute() != null && vtxOrig.getAttribute() != null) {
                            ((ValueTuple)vtxCopy.getAttribute()).copyEntriesToSimilarMembers(vtxOrig.getAttribute());
                        }
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                iter = this.itsArcs.iterator();
                while (!failed && iter.hasNext()) {
                    Arc arcOrig = (Arc)iter.next();
                    Arc arcCopy = null;
                    type = typeSet.getSimilarType(arcOrig.getType());
                    if (type == null && (type = typeSet.getTypeByName(arcOrig.getType().getName())) != null && !type.isArcType()) {
                        type = null;
                    }
                    if (type == null) continue;
                    try {
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)memo1.get(source);
                        Node tgtImg = (Node)memo1.get(target);
                        arcCopy = theCopy.createArc(type, srcImg, tgtImg);
                        if (arcCopy == null) continue;
                        if (arcCopy.getAttribute() != null && arcOrig.getAttribute() != null) {
                            ((ValueTuple)arcCopy.getAttribute()).copyEntriesToSimilarMembers(arcOrig.getAttribute());
                        }
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                memo1.clear();
                if (!failed) break block14;
                return null;
            }
            return theCopy;
        }
    }

    @Override
    public Graph copy(TypeSet types) {
        return this.graphcopy(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph graphcopy(TypeSet typeSet) {
        TypeGraph typeGraph = this;
        synchronized (typeGraph) {
            TypeGraph theCopy;
            block10: {
                Type type;
                typeSet.getLevelOfTypeGraphCheck();
                boolean failed = false;
                Iterator<Arc> arcList = this.getArcsSet().iterator();
                Iterator<Node> vtxList = this.getNodesSet().iterator();
                theCopy = typeSet.isArcDirected() ? new TypeGraph(typeSet) : new UndirectedTypeGraph(typeSet);
                Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
                while (vtxList.hasNext() && !failed) {
                    Node vtxOrig = vtxList.next();
                    Node vtxCopy = null;
                    try {
                        type = typeSet.getSimilarType(vtxOrig.getType());
                        if (type == null || (vtxCopy = theCopy.newNode(type)) == null) continue;
                        vtxCopy.copyAttributes(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                while (arcList.hasNext() && !failed) {
                    Arc arcOrig = arcList.next();
                    Arc arcCopy = null;
                    try {
                        Node tgtImg;
                        type = typeSet.getSimilarType(arcOrig.getType());
                        if (type == null) continue;
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)memo1.get(source);
                        arcCopy = theCopy.createArc(type, srcImg, tgtImg = (Node)memo1.get(target));
                        if (arcCopy == null) continue;
                        arcCopy.copyAttributes(arcOrig);
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                memo1.clear();
                if (!failed) break block10;
                return null;
            }
            return theCopy;
        }
    }

    @Override
    public Graph copy(Hashtable<GraphObject, GraphObject> orig2copy) {
        return this.graphcopy(orig2copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Graph graphcopy(Hashtable<GraphObject, GraphObject> orig2copy) {
        TypeGraph typeGraph = this;
        synchronized (typeGraph) {
            TypeGraph theCopy;
            block10: {
                boolean failed = false;
                theCopy = new TypeGraph(this.getTypeSet());
                Iterator iter = this.itsNodes.iterator();
                while (!failed && iter.hasNext()) {
                    Node vtxOrig = (Node)iter.next();
                    Node vtxCopy = null;
                    Type type = this.itsTypes.getSimilarType(vtxOrig.getType());
                    if (type == null) continue;
                    try {
                        vtxCopy = theCopy.newNode(type);
                        if (vtxCopy == null) continue;
                        vtxCopy.copyAttributes(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        orig2copy.put(vtxOrig, vtxCopy);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                iter = this.itsArcs.iterator();
                while (!failed && iter.hasNext()) {
                    Arc arcOrig = (Arc)iter.next();
                    Type type = this.itsTypes.getSimilarType(arcOrig.getType());
                    if (type == null) continue;
                    try {
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)orig2copy.get(source);
                        Node tgtImg = (Node)orig2copy.get(target);
                        Arc arcCopy = theCopy.createArc(type, srcImg, tgtImg);
                        if (arcCopy == null) continue;
                        arcCopy.copyAttributes(arcOrig);
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                        orig2copy.put(arcOrig, arcCopy);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                if (!failed) break block10;
                return null;
            }
            return theCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Graph graphcopy() {
        TypeGraph typeGraph = this;
        synchronized (typeGraph) {
            TypeGraph theCopy;
            block10: {
                boolean failed = false;
                Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
                theCopy = new TypeGraph(this.getTypeSet());
                Iterator iter = this.itsNodes.iterator();
                while (!failed && iter.hasNext()) {
                    Node vtxOrig = (Node)iter.next();
                    Node vtxCopy = null;
                    try {
                        vtxCopy = theCopy.createNode(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                iter = this.itsArcs.iterator();
                while (!failed && iter.hasNext()) {
                    Arc arcOrig = (Arc)iter.next();
                    try {
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)memo1.get(source);
                        Node tgtImg = (Node)memo1.get(target);
                        Arc arcCopy = theCopy.copyArc(arcOrig, srcImg, tgtImg);
                        if (arcCopy == null) continue;
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                memo1.clear();
                if (!failed) break block10;
                return null;
            }
            return theCopy;
        }
    }

    @Override
    public Graph copy() {
        return this.graphcopy();
    }

    public Graph graphcopy(TypeGraph g) {
        return null;
    }

    @Override
    public void addNode(Node n) {
        if (!this.itsNodes.contains(n)) {
            TypeError typeError = this.itsTypes.addTypeGraphObject(n);
            if (typeError != null) {
                n.dispose();
            } else {
                this.itsNodes.add(n);
                this.addNodeToTypeObjectsMap(n);
                if (n.getAttribute() != null) {
                    ((ValueTuple)n.getAttribute()).addObserver(n);
                    this.attributed = true;
                }
                this.changed = true;
            }
        }
    }

    @Override
    public Node copyNode(Node orig) throws TypeException {
        Node aNode = this.createNode(orig.getType());
        if (aNode != null && orig.getAttribute() != null && aNode.getAttribute() == null) {
            aNode.createAttributeInstance();
        }
        return aNode;
    }

    @Override
    protected void removeNode(Node n) {
        if (this.itsNodes.contains(n)) {
            Arc aNeighbor;
            Iterator<Arc> anIter = n.getIncomingArcsSet().iterator();
            while (anIter.hasNext()) {
                aNeighbor = anIter.next();
                this.removeArc(aNeighbor);
                anIter = n.getIncomingArcsSet().iterator();
            }
            anIter = n.getOutgoingArcsSet().iterator();
            while (anIter.hasNext()) {
                aNeighbor = anIter.next();
                this.removeArc(aNeighbor);
                anIter = n.getOutgoingArcsSet().iterator();
            }
            this.itsNodes.remove(n);
            this.removeNodeFromTypeObjectsMap(n);
            this.changed = true;
        }
    }

    @Override
    public void addArc(Arc a) {
        if (!this.itsArcs.contains(a)) {
            TypeError typeError = this.itsTypes.addTypeGraphObject(a);
            if (typeError != null) {
                a.dispose();
            } else {
                this.itsArcs.add(a);
                this.addArcToTypeObjectsMap(a);
                if (a.getAttribute() != null) {
                    ((ValueTuple)a.getAttribute()).addObserver(a);
                }
                this.changed = true;
            }
        }
    }

    @Override
    protected void removeArc(Arc a) {
        if (this.itsArcs.contains(a)) {
            ((Node)a.getSource()).removeOut(a);
            ((Node)a.getTarget()).removeIn(a);
            this.itsArcs.remove(a);
            this.removeArcFromTypeObjectsMap(a);
            this.changed = true;
        }
    }

    @Override
    protected Node newNode(Type t) throws TypeException {
        Node aNode = new Node(t, (Graph)this);
        TypeError typeError = this.itsTypes.addTypeGraphObject(aNode);
        if (typeError != null) {
            aNode.dispose();
            throw new TypeException(typeError);
        }
        this.attributed = aNode.getAttribute() != null;
        this.itsNodes.add(aNode);
        this.addNodeToTypeObjectsMap(aNode);
        this.changed = true;
        if (this.notificationRequired) {
            this.propagateChange(new Change(10, aNode));
        }
        return aNode;
    }

    @Override
    public Node createNode(Type type) throws TypeException {
        Type t = this.itsTypes.adoptClan(type);
        Node aNode = this.newNode(t);
        return aNode;
    }

    public Node createTypeNode(Type type) throws TypeException {
        return this.createNode(type);
    }

    public Node getTypeNode(Type type) {
        return this.itsTypes.getTypeGraphNode(type);
    }

    public AttrInstance getAttrValueOfTypeNode(Type type) {
        Node n = this.itsTypes.getTypeGraphNode(type);
        if (n != null && !type.isAttrTypeEmpty()) {
            return n.getAttribute();
        }
        return null;
    }

    @Override
    public Node createNode(Node orig) throws TypeException {
        Node aNode = this.createNode(orig.getType());
        if (aNode != null && orig.getAttribute() != null && aNode.getAttribute() == null) {
            aNode.createAttributeInstance();
        }
        return aNode;
    }

    @Override
    public synchronized void destroyNode(Node node, boolean checkFirst, boolean forceDestroy) throws TypeException {
        Arc a;
        TypeError typeError = null;
        if (forceDestroy || this.itsTypes.getLevelOfTypeGraphCheck() <= 0) {
            this.itsTypes.forceRemoveTypeGraphObject(node);
        } else {
            typeError = this.itsTypes.removeTypeGraphObject(node);
            if (!forceDestroy && typeError != null) {
                throw new TypeException(typeError);
            }
        }
        boolean clanUsed = false;
        if (clanUsed && this.itsTypes.getLevelOfTypeGraphCheck() != 0 && this.itsTypes.getLevelOfTypeGraphCheck() != 5) {
            typeError = new TypeError(4, "\nThe type \"" + node.getType().getName() + "\" cannot be deleted from the type graph," + "\nbecause at least one graph object uses it." + "\nPlease disable the type graph before delete a type.", node, node.getType());
            typeError.setContainingGraph(this);
        }
        if (!forceDestroy && typeError != null) {
            throw new TypeException(typeError);
        }
        Type myType = node.getType();
        this.itsTypes.removeAllInheritanceRelations(myType);
        block0: for (Node currentNode : this.getNodesSet()) {
            Type currentType = currentNode.getType();
            int i = 0;
            while (i < currentType.getParents().size()) {
                Type p = currentType.getParents().get(i);
                if (p == myType) {
                    this.itsTypes.removeInheritanceRelation(currentType, p);
                    if (currentNode.getAttribute() == null) continue block0;
                    ((ValueTuple)currentNode.getAttribute()).refreshParents();
                    continue block0;
                }
                ++i;
            }
        }
        this.itsTypes.refreshInheritanceArcs();
        Iterator<Arc> iter = node.getIncomingArcsSet().iterator();
        while (iter.hasNext()) {
            a = iter.next();
            this.destroyArc(a, false, false);
            iter = node.getIncomingArcsSet().iterator();
        }
        iter = node.getOutgoingArcsSet().iterator();
        while (iter.hasNext()) {
            a = iter.next();
            this.destroyArc(a, false, false);
            iter = node.getOutgoingArcsSet().iterator();
        }
        if (this.notificationRequired) {
            this.propagateChange(new Change(120, node));
        }
        this.itsNodes.remove(node);
        this.changed = true;
        if (this.notificationRequired) {
            this.propagateChange(new Change(12, node));
        }
        node.dispose();
    }

    @Override
    protected Arc newArc(Type t, Node src, Node tar) throws TypeException {
        TypeError typeError;
        Arc anArc = new Arc(t, (GraphObject)src, (GraphObject)tar, (Graph)this);
        if (t.getAttrType() != null && t.getAttrType().getNumberOfEntries() != 0) {
            anArc.createAttributeInstance();
        }
        if ((typeError = this.itsTypes.addTypeGraphObject(anArc)) != null) {
            anArc.dispose();
            throw new TypeException(typeError);
        }
        if (anArc.getAttribute() != null) {
            this.attributed = true;
        }
        this.itsArcs.add(anArc);
        this.addArcToTypeObjectsMap(anArc);
        this.changed = true;
        if (this.notificationRequired) {
            this.propagateChange(new Change(10, anArc));
        }
        return anArc;
    }

    @Override
    protected Arc newArcFast(Type t, Node src, Node tar) {
        try {
            return this.newArc(t, src, tar);
        }
        catch (TypeException ex) {
            return null;
        }
    }

    @Override
    public Arc createArc(Type type, Node src, Node tar) throws TypeException {
        if (src == null || tar == null) {
            return null;
        }
        if (!this.isElement(src) || !this.isElement(tar)) {
            return null;
        }
        Type t = null;
        if (this.itsTypes.containsType(type)) {
            t = type;
        }
        if (t == null && (t = this.itsTypes.getSimilarType(type)) == null) {
            t = this.itsTypes.addType(type);
        }
        Arc anArc = this.newArc(t, src, tar);
        return anArc;
    }

    public Arc createTypeArc(Type type, Node src, Node tar) throws TypeException {
        return this.createArc(type, src, tar);
    }

    public Arc getTypeGraphArc(Type t, Type source, Type target) {
        for (Arc a : this.itsArcs) {
            if (!a.getType().compareTo(t) || !a.getSource().getType().isParentOf(source) || !a.getTarget().getType().isParentOf(target)) continue;
            return a;
        }
        return null;
    }

    public Arc getTypeGraphParentArc(Type t, Type source, Type target) {
        for (Arc a : this.itsArcs) {
            if (!a.getType().compareTo(t) || !a.getSource().getType().isParentOf(source) || !a.getTarget().getType().isParentOf(target)) continue;
            return a;
        }
        return null;
    }

    public Arc getTypeGraphChildArc(Type t, Type source, Type target) {
        for (Arc a : this.itsArcs) {
            if (!a.getType().compareTo(t) || !a.getSource().getType().isChildOf(source) || !a.getTarget().getType().isChildOf(target)) continue;
            return a;
        }
        return null;
    }

    @Override
    public Arc copyArc(Arc orig, Node src, Node tar) throws TypeException {
        try {
            Arc anArc = this.createArc(orig.getType(), src, tar);
            if (anArc != null && orig.getAttribute() != null && anArc.getAttribute() == null) {
                anArc.createAttributeInstance();
                this.attributed = true;
            }
            return anArc;
        }
        catch (TypeException ex) {
            throw new TypeException("TypeGraph.copyArc:: Cannot create an Arc of type : " + orig.getType().getName() + " from  " + src.getType().getName() + " to  " + tar.getType().getName() + "   " + ex.getLocalizedMessage());
        }
    }

    @Override
    public synchronized void destroyArc(Arc arc, boolean checkFirst, boolean forceDestroy) throws TypeException {
        if (arc == null) {
            return;
        }
        TypeError typeError = null;
        if (forceDestroy || this.itsTypes.getLevelOfTypeGraphCheck() <= 0) {
            this.itsTypes.forceRemoveTypeGraphObject(arc);
        } else {
            typeError = this.itsTypes.removeTypeGraphObject(arc);
            if (!forceDestroy && typeError != null) {
                throw new TypeException(typeError);
            }
        }
        if (this.notificationRequired) {
            this.propagateChange(new Change(120, arc));
        }
        this.itsArcs.remove(arc);
        arc.dispose();
        this.changed = true;
        this.propagateChange(new Change(12, arc));
    }

    @Override
    public boolean contains(Graph g) {
        boolean result = false;
        if (g.isEmpty()) {
            result = true;
        } else if (this.getSize() >= g.getSize()) {
            GraphObject elemi;
            Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
            boolean found = true;
            Iterator<GraphObject> iterG = g.getArcsSet().iterator();
            block0: while (found && iterG.hasNext()) {
                elemi = iterG.next();
                found = false;
                for (GraphObject elemj : this.itsArcs) {
                    if (!elemi.getType().compareTo(elemj.getType())) continue;
                    if (((Arc)elemi).getSource() == ((Arc)elemi).getTarget() && ((Arc)elemj).getSource() == ((Arc)elemj).getTarget()) {
                        if (!((Arc)elemi).getSource().compareTo(((Arc)elemj).getSource())) continue;
                        found = true;
                        table.put(elemi, elemj);
                        table.put(((Arc)elemi).getSource(), ((Arc)elemj).getSource());
                        continue block0;
                    }
                    if (((Arc)elemi).getSource() == ((Arc)elemi).getTarget() || ((Arc)elemj).getSource() == ((Arc)elemj).getTarget() || !((Arc)elemi).getSource().compareTo(((Arc)elemj).getSource()) || !((Arc)elemi).getTarget().compareTo(((Arc)elemj).getTarget())) continue;
                    found = true;
                    table.put(elemi, elemj);
                    table.put(((Arc)elemi).getSource(), ((Arc)elemj).getSource());
                    table.put(((Arc)elemi).getTarget(), ((Arc)elemj).getTarget());
                    continue block0;
                }
            }
            iterG = g.getNodesSet().iterator();
            block2: while (found && iterG.hasNext()) {
                elemi = (Node)iterG.next();
                found = false;
                for (GraphObject elemj : this.itsNodes) {
                    if (table.get(elemi) != null || !((Node)elemi).compareTo(elemj)) continue;
                    found = true;
                    table.put(elemi, elemj);
                    continue block2;
                }
            }
            if (table.size() == g.getSize()) {
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    protected void addNodeToTypeObjectsMap(Node n) {
        String keystr = n.getType().convertToKey();
        LinkedHashSet<Node> anObjVec = new LinkedHashSet<Node>(1);
        anObjVec.add(n);
        this.itsTypeObjectsMap.put(keystr, anObjVec);
    }

    protected void addArcToTypeObjectsMap(Arc arc) {
        Vector<Type> mySrcChildren = arc.getSource().getType().getAllChildren();
        Vector<Type> myTarChildren = arc.getTarget().getType().getAllChildren();
        int i = 0;
        while (i < mySrcChildren.size()) {
            int j = 0;
            while (j < myTarChildren.size()) {
                String keystr = String.valueOf(mySrcChildren.get(i).convertToKey()) + arc.getType().convertToKey() + myTarChildren.get(j).convertToKey();
                LinkedHashSet<Arc> anObjVec = new LinkedHashSet<Arc>(1);
                anObjVec.add(arc);
                this.itsTypeObjectsMap.put(keystr, anObjVec);
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void addToTypeObjectsMap(GraphObject anObj) {
        if (anObj.isNode()) {
            this.addNodeToTypeObjectsMap((Node)anObj);
        } else {
            this.addArcToTypeObjectsMap((Arc)anObj);
        }
    }

    @Override
    protected void removeNodeFromTypeObjectsMap(Node anObj) {
        String keystr = anObj.getType().convertToKey();
        this.itsTypeObjectsMap.remove(keystr);
    }

    @Override
    protected void removeArcFromTypeObjectsMap(Arc anObj) {
        if (anObj.getSource() != null && anObj.getTarget() != null) {
            Vector<Type> mySrcChildren = anObj.getSource().getType().getAllChildren();
            Vector<Type> myTarChildren = anObj.getTarget().getType().getAllChildren();
            int i = 0;
            while (i < mySrcChildren.size()) {
                int j = 0;
                while (j < myTarChildren.size()) {
                    String keystr = String.valueOf(mySrcChildren.get(i).convertToKey()) + anObj.getType().convertToKey() + myTarChildren.get(j).convertToKey();
                    this.itsTypeObjectsMap.remove(keystr);
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void extendTypeObjectsMap(Type nodeType) {
        Node parNode = null;
        Vector<Type> parents = nodeType.getAllParents();
        int i = 0;
        while (i < parents.size()) {
            Type parType = (Type)parents.get(i);
            String typeKey = parType.convertToKey();
            if (this.itsTypeObjectsMap.get(typeKey) != null && !((HashSet)this.itsTypeObjectsMap.get(typeKey)).isEmpty()) {
                parNode = (Node)((HashSet)this.itsTypeObjectsMap.get(typeKey)).iterator().next();
            }
            if (parNode != null) {
                LinkedHashSet<Arc> anObjVec;
                String keystr;
                for (Arc a : parNode.getOutgoingArcsSet()) {
                    if (a.isInheritance()) continue;
                    keystr = nodeType.convertToKey().concat(a.getType().convertToKey()).concat(a.getTargetType().convertToKey());
                    anObjVec = new LinkedHashSet<Arc>(1);
                    anObjVec.add(a);
                    this.itsTypeObjectsMap.put(keystr, anObjVec);
                }
                for (Arc a : parNode.getIncomingArcsSet()) {
                    if (a.isInheritance()) continue;
                    keystr = a.getSourceType().convertToKey().concat(a.getType().convertToKey()).concat(nodeType.convertToKey());
                    anObjVec = new LinkedHashSet(1);
                    anObjVec.add(a);
                    this.itsTypeObjectsMap.put(keystr, anObjVec);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean isUsingVariable(VarMember v) {
        return false;
    }

    @Override
    public synchronized boolean glue(GraphObject keep, GraphObject glue) {
        return false;
    }

    @Override
    public boolean isReadyForTransform() {
        return false;
    }

    @Override
    public boolean isReadyForTransform(Vector<GraphObject> storeOfFailedObjs) {
        return false;
    }

    @Override
    public OrdinaryMorphism isomorphicCopy() {
        return null;
    }

    public OrdinaryMorphism isoToCopy() {
        return null;
    }

    @Override
    public OrdinaryMorphism isoToCopy(int n) {
        return null;
    }

    @Override
    public OrdinaryMorphism reverseIsomorphicCopy() {
        return null;
    }

    @Override
    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, boolean withIsomorphic) {
        return null;
    }

    @Override
    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, boolean disjunion, boolean withIsomorphic) {
        return null;
    }

    @Override
    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, int sizeOfInclusions, boolean withIsomorphic) {
        return null;
    }

    @Override
    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, int sizeOfInclusions, boolean disjunion, boolean withIsomorphic) {
        return null;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Graph", this);
        h.addAttr("name", this.getName());
        if (!this.kind.equals("")) {
            h.addAttr("kind", this.kind);
        }
        if (!this.comment.equals("")) {
            h.addAttr("comment", this.comment);
        }
        if (!this.info.equals("")) {
            h.addAttr("info", this.info);
        }
        h.addIteration("", this.itsNodes.iterator(), true);
        h.addIteration("", this.itsArcs.iterator(), true);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Graph", this)) {
            Type t;
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            str = h.readAttr("comment");
            if (!str.equals("")) {
                this.comment = str.toString();
            }
            if (!(str = h.readAttr("kind")).equals("")) {
                this.kind = str.toString();
            }
            if (!(str = h.readAttr("info")).equals("")) {
                this.info = str.toString();
            }
            Enumeration<Element> en = h.getEnumeration("", null, true, "Node");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = (Type)h.getObject("type", null, false);
                if (t != null) {
                    Node n = null;
                    try {
                        n = this.newNode(t);
                        n = (Node)h.loadObject(n);
                    }
                    catch (TypeException e) {
                        System.out.println("TypeGraph.XreadObject: cannot load a Node: " + e.getMessage());
                    }
                    String m = h.readAttr("sourcemin");
                    if (!"".equals(m)) {
                        try {
                            t.setSourceMin(Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMin(-1);
                        }
                    } else {
                        t.setSourceMin(-1);
                    }
                    m = h.readAttr("sourcemax");
                    if (!"".equals(m)) {
                        try {
                            t.setSourceMax(Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMax(-1);
                        }
                    } else {
                        t.setSourceMax(-1);
                    }
                }
                h.close();
            }
            en = h.getEnumeration("", null, true, "Edge");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = (Type)h.getObject("type", null, false);
                Node n1 = (Node)h.getObject("source", null, false);
                Node n2 = (Node)h.getObject("target", null, false);
                if (t != null && n1 != null && n2 != null) {
                    Arc a = null;
                    try {
                        a = this.newArc(t, n1, n2);
                        a = (Arc)h.loadObject(a);
                    }
                    catch (TypeException e) {
                        System.out.println("TypeGraph.XreadObject: cannot load an Arc: " + e.getMessage());
                    }
                    Type sourceType = n1.getType();
                    Type targetType = n2.getType();
                    String m = h.readAttr("sourcemin");
                    if (!"".equals(m)) {
                        try {
                            t.setSourceMin(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMin(sourceType, targetType, -1);
                        }
                    } else {
                        t.setSourceMin(sourceType, targetType, -1);
                    }
                    m = h.readAttr("sourcemax");
                    if (!"".equals(m)) {
                        try {
                            t.setSourceMax(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setSourceMax(sourceType, targetType, -1);
                        }
                    } else {
                        t.setSourceMax(sourceType, targetType, -1);
                    }
                    m = h.readAttr("targetmin");
                    if (!"".equals(m)) {
                        try {
                            t.setTargetMin(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setTargetMin(sourceType, targetType, -1);
                        }
                    } else {
                        t.setTargetMin(sourceType, targetType, -1);
                    }
                    m = h.readAttr("targetmax");
                    if (!"".equals(m)) {
                        try {
                            t.setTargetMax(sourceType, targetType, Integer.parseInt(m));
                        }
                        catch (NumberFormatException e) {
                            t.setTargetMax(sourceType, targetType, -1);
                        }
                    } else {
                        t.setTargetMax(sourceType, targetType, -1);
                    }
                }
                h.close();
            }
            h.close();
        }
    }

    public Vector<OrdinaryMorphism> generateAllSubgraphs(int sizeOfInclusions, boolean union, boolean withIsomorphic) {
        return null;
    }

    public Vector<OrdinaryMorphism> generateAllSubgraphsWithInclusionsOfSize(int i, Vector<GraphObject> itsGOSet, Vector<OrdinaryMorphism> inclusions, boolean withIsomorphic) {
        return null;
    }

    @Override
    public boolean isTypeGraph() {
        return true;
    }

    @Override
    public boolean isCompleteGraph() {
        return false;
    }

    @Override
    public boolean isNacGraph() {
        return false;
    }

    @Override
    public Vector<String> getVariableNamesOfAttributes() {
        return null;
    }

    @Override
    public Vector<VarMember> getSameVariablesOfAttributes() {
        return null;
    }

    @Override
    public void unsetCriticalObjects() {
    }

    @Override
    public void unsetTransientAttrValues() {
    }

    @Override
    public Vector<Hashtable<GraphObject, GraphObject>> getPartialMorphismIntoSet(Vector<GraphObject> set) {
        return null;
    }
}

