/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.util.Pair;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.HashMap;

public class EdMorphism {
    HashMap<GraphObject, Integer> source = new HashMap();
    HashMap<GraphObject, Integer> target1 = new HashMap();
    HashMap<GraphObject, Integer> target2 = new HashMap();

    public EdMorphism(OrdinaryMorphism o) {
        if (o != null) {
            this.makeSourceTarget(o);
        }
    }

    private void makeSourceTarget(OrdinaryMorphism o) {
        Enumeration<GraphObject> graphObjects = o.getDomain();
        int i = 1;
        while (graphObjects.hasMoreElements()) {
            GraphObject go = graphObjects.nextElement();
            this.source.put(go, new Integer(i));
            this.target1.put(o.getImage(go), new Integer(i));
            ++i;
        }
    }

    public int makeVDiagram(Rule r1, Rule r2, OrdinaryMorphism o1, OrdinaryMorphism o2, int lastIndx) {
        Enumeration<GraphObject> inverse;
        GraphObject go;
        int i = lastIndx;
        Enumeration<GraphObject> graphObjects = o1.getCodomain();
        while (graphObjects.hasMoreElements()) {
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            inverse = o1.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                GraphObject inv1 = inverse.nextElement();
                if (o1.getSource() == r1.getLeft()) {
                    this.target1.put(inv1, this.source.get(go));
                    continue;
                }
                if (o1.getSource() != r1.getRight()) continue;
                GraphObject inv2 = null;
                Enumeration<GraphObject> inverse1 = r1.getInverseImage(inv1);
                while (inverse1.hasMoreElements()) {
                    inv2 = inverse1.nextElement();
                    this.target1.put(inv2, this.source.get(go));
                }
                this.target1.put(inv1, this.source.get(go));
            }
        }
        graphObjects = o2.getCodomain();
        while (graphObjects.hasMoreElements()) {
            GraphObject inv;
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            if (o2.getSource() == r2.getLeft()) {
                inverse = o2.getInverseImage(go);
                while (inverse.hasMoreElements()) {
                    inv = inverse.nextElement();
                    this.target2.put(inv, this.source.get(go));
                }
                continue;
            }
            if (o2.getSource() != r2.getRight()) continue;
            inverse = o2.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                inv = inverse.nextElement();
                this.target2.put(inv, this.source.get(go));
                Enumeration<GraphObject> inverse1 = r2.getInverseImage(inv);
                while (inverse1.hasMoreElements()) {
                    GraphObject inv2 = inverse1.nextElement();
                    this.target2.put(inv2, this.target2.get(inv));
                }
            }
        }
        i = this.completeMorphismMarks(r1, this.target1, i);
        i = this.completeMorphismMarks(r2, this.target2, i);
        return i;
    }

    public int makeVDiagram_NAC(Rule r1, Rule r2, OrdinaryMorphism o1, OrdinaryMorphism o2, Pair<OrdinaryMorphism, OrdinaryMorphism> morphsNAC2, int lastIndx) {
        OrdinaryMorphism nac;
        Enumeration<GraphObject> inverse;
        GraphObject go;
        int i = lastIndx;
        Enumeration<GraphObject> graphObjects = o1.getCodomain();
        while (graphObjects.hasMoreElements()) {
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            inverse = o1.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                GraphObject inv1 = inverse.nextElement();
                if (o1.getSource() == r1.getLeft()) {
                    this.target1.put(inv1, this.source.get(go));
                    continue;
                }
                if (o1.getSource() != r1.getRight()) continue;
                GraphObject inv2 = null;
                Enumeration<GraphObject> inverse1 = r1.getInverseImage(inv1);
                while (inverse1.hasMoreElements()) {
                    inv2 = inverse1.nextElement();
                    this.target1.put(inv2, this.source.get(go));
                }
                this.target1.put(inv1, this.source.get(go));
            }
        }
        graphObjects = o2.getCodomain();
        while (graphObjects.hasMoreElements()) {
            GraphObject inv;
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            if (o2.getSource() == r2.getLeft()) {
                inverse = o2.getInverseImage(go);
                while (inverse.hasMoreElements()) {
                    inv = inverse.nextElement();
                    this.target2.put(inv, this.source.get(go));
                }
                continue;
            }
            if (o2.getSource() != r2.getRight()) continue;
            inverse = o2.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                inv = inverse.nextElement();
                this.target2.put(inv, this.source.get(go));
                Enumeration<GraphObject> inverse1 = r2.getInverseImage(inv);
                while (inverse1.hasMoreElements()) {
                    GraphObject inv2 = inverse1.nextElement();
                    this.target2.put(inv2, this.target2.get(inv));
                }
            }
        }
        if (morphsNAC2 != null) {
            OrdinaryMorphism morphL2N2 = (OrdinaryMorphism)morphsNAC2.first;
            OrdinaryMorphism morphNac2N2 = (OrdinaryMorphism)morphsNAC2.second;
            graphObjects = o2.getCodomain();
            while (graphObjects.hasMoreElements()) {
                GraphObject inv;
                Enumeration<GraphObject> inverse2;
                GraphObject go2 = graphObjects.nextElement();
                if (this.source.get(go2) == null) {
                    this.source.put(go2, new Integer(++i));
                }
                if (!(inverse2 = o2.getInverseImage(go2)).hasMoreElements()) continue;
                GraphObject go22 = inverse2.nextElement();
                Enumeration<GraphObject> inverse22 = morphL2N2.getInverseImage(go22);
                if (inverse22.hasMoreElements()) {
                    inv = inverse22.nextElement();
                    this.target2.put(inv, this.source.get(go2));
                    continue;
                }
                inverse22 = morphNac2N2.getInverseImage(go22);
                if (!inverse22.hasMoreElements()) continue;
                inv = inverse22.nextElement();
                this.target2.put(inv, this.source.get(go2));
            }
        }
        i = this.completeMorphismMarks(r1, this.target1, i);
        i = this.completeMorphismMarks(r2, this.target2, i);
        if (morphsNAC2 != null && (nac = r2.getNAC(((OrdinaryMorphism)morphsNAC2.second).getSource())) != null) {
            i = this.completeMorphismMarks(nac, this.target2, i);
        }
        return i;
    }

    public int completeMorphismMarks(OrdinaryMorphism m, HashMap<GraphObject, Integer> target, int lastIndx) {
        int i = lastIndx;
        Enumeration<GraphObject> dom = m.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject ol = dom.nextElement();
            GraphObject or = m.getImage(ol);
            if (target.get(ol) == null && target.get(or) == null) {
                target.put(ol, ++i);
                target.put(or, i);
                continue;
            }
            if (target.get(ol) != null && target.get(or) == null) {
                target.put(or, target.get(ol));
                continue;
            }
            if (target.get(ol) != null || target.get(or) == null) continue;
            target.put(ol, target.get(or));
        }
        return i;
    }

    public int makeVDiagram_PAC(Rule r1, Rule r2, OrdinaryMorphism o1, OrdinaryMorphism o2, Pair<OrdinaryMorphism, OrdinaryMorphism> morphsPAC2, OrdinaryMorphism pac2, int lastIndx) {
        OrdinaryMorphism pac;
        Enumeration<GraphObject> inverse;
        GraphObject go;
        int i = lastIndx;
        Enumeration<GraphObject> graphObjects = o1.getCodomain();
        while (graphObjects.hasMoreElements()) {
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            inverse = o1.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                GraphObject inv1 = inverse.nextElement();
                if (o1.getSource() == r1.getLeft()) {
                    this.target1.put(inv1, this.source.get(go));
                    continue;
                }
                if (o1.getSource() != r1.getRight()) continue;
                GraphObject inv2 = null;
                Enumeration<GraphObject> inverse1 = r1.getInverseImage(inv1);
                while (inverse1.hasMoreElements()) {
                    inv2 = inverse1.nextElement();
                    this.target1.put(inv2, this.source.get(go));
                }
                this.target1.put(inv1, this.source.get(go));
            }
        }
        graphObjects = o2.getCodomain();
        while (graphObjects.hasMoreElements()) {
            GraphObject inv;
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            if (o2.getSource() == r2.getLeft()) {
                inverse = o2.getInverseImage(go);
                while (inverse.hasMoreElements()) {
                    inv = inverse.nextElement();
                    this.target2.put(inv, this.source.get(go));
                }
                continue;
            }
            if (o2.getSource() != r2.getRight()) continue;
            inverse = o2.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                inv = inverse.nextElement();
                this.target2.put(inv, this.source.get(go));
                Enumeration<GraphObject> inverse1 = r2.getInverseImage(inv);
                while (inverse1.hasMoreElements()) {
                    GraphObject inv2 = inverse1.nextElement();
                    this.target2.put(inv2, this.target2.get(inv));
                }
            }
        }
        if (morphsPAC2 != null) {
            OrdinaryMorphism morphPac2G = ((OrdinaryMorphism)morphsPAC2.first).compose((OrdinaryMorphism)morphsPAC2.second);
            BaseFactory.theFactory().unsetAllTransientAttrValues(morphPac2G);
            graphObjects = o2.getTarget().getElements();
            while (graphObjects.hasMoreElements()) {
                Enumeration<GraphObject> inverse1;
                GraphObject go2 = graphObjects.nextElement();
                if (this.source.get(go2) == null) {
                    this.source.put(go2, new Integer(++i));
                }
                if (!(inverse1 = morphPac2G.getInverseImage(go2)).hasMoreElements()) continue;
                GraphObject go1 = inverse1.nextElement();
                Enumeration<GraphObject> inverse2 = pac2.getInverseImage(go1);
                if (inverse2.hasMoreElements()) {
                    GraphObject inv = inverse2.nextElement();
                    this.target2.put(inv, this.source.get(go2));
                    continue;
                }
                this.target2.put(go1, this.source.get(go2));
            }
        }
        i = this.completeMorphismMarks(r1, this.target1, i);
        i = this.completeMorphismMarks(r2, this.target2, i);
        if (morphsPAC2 != null && (pac = r2.getPAC(((OrdinaryMorphism)morphsPAC2.first).getSource())) != null) {
            i = this.completeMorphismMarks(pac, this.target2, i);
        }
        return i;
    }

    public int makeVDiagram(OrdinaryMorphism o1, OrdinaryMorphism o2, int lastIndx) {
        GraphObject inv;
        Enumeration<GraphObject> inverse;
        GraphObject go;
        int i = lastIndx;
        Enumeration<GraphObject> graphObjects = o1.getCodomain();
        while (graphObjects.hasMoreElements()) {
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            inverse = o1.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                inv = inverse.nextElement();
                this.target1.put(inv, this.source.get(go));
            }
        }
        graphObjects = o2.getCodomain();
        while (graphObjects.hasMoreElements()) {
            go = graphObjects.nextElement();
            if (this.source.get(go) == null) {
                this.source.put(go, new Integer(++i));
            }
            inverse = o2.getInverseImage(go);
            while (inverse.hasMoreElements()) {
                inv = inverse.nextElement();
                this.target2.put(inv, this.source.get(go));
            }
        }
        return i;
    }

    private HashMap<GraphObject, String> convertToStringHashMap(HashMap<GraphObject, Integer> h) {
        HashMap<GraphObject, String> result = new HashMap<GraphObject, String>();
        for (GraphObject key : h.keySet()) {
            result.put(key, h.get(key).toString());
        }
        return result;
    }

    public HashMap<GraphObject, Integer> getFirstTarget() {
        return this.target1;
    }

    public HashMap<GraphObject, Integer> getSecondTarget() {
        return this.target2;
    }

    public HashMap<?, ?> getSourceOfMorphism() {
        return this.convertToStringHashMap(this.source);
    }

    public HashMap<?, ?> getTargetOfMorphism() {
        return this.convertToStringHashMap(this.target1);
    }

    public HashMap<?, ?> getTargetOfMorphism(int i) {
        if (i == 1) {
            return this.convertToStringHashMap(this.target1);
        }
        if (i == 2) {
            return this.convertToStringHashMap(this.target2);
        }
        return this.convertToStringHashMap(this.target1);
    }
}

