/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraphObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class BoundingBox
extends Rectangle {
    private Vector<EdGraphObject> objs;
    private int space = 50;
    private Point min;
    private Point max;
    private Point upper_left = new Point(0, 0);
    private Rectangle anchorUL;
    private Rectangle anchorUR;
    private Rectangle anchorBR;
    private Rectangle anchorBL;
    private Point anchor;
    private int dx;
    private int dy;
    private int maxX;

    public BoundingBox(Vector<EdGraphObject> objs) {
        this.objs = objs;
        this.min = new Point(10000, 10000);
        this.max = new Point(0, 0);
        this.init();
    }

    public BoundingBox(Vector<EdGraphObject> objs, Point upper_left) {
        this.objs = objs;
        this.min = new Point(10000, 10000);
        this.max = new Point(0, 0);
        this.upper_left = upper_left;
        this.init();
    }

    private void init() {
        int i = 0;
        while (i < this.objs.size()) {
            EdGraphObject elem = this.objs.elementAt(i);
            if (elem.isNode() || elem.isArc() && !((EdArc)elem).isLine()) {
                if (elem.getX() - elem.getWidth() / 2 < this.min.x) {
                    this.min.x = elem.getX() - elem.getWidth() / 2;
                }
                if (elem.getY() - elem.getHeight() / 2 < this.min.y) {
                    this.min.y = elem.getY() - elem.getHeight() / 2;
                }
                if (elem.getX() + elem.getWidth() / 2 > this.max.x) {
                    this.max.x = elem.getX() + elem.getWidth() / 2;
                }
                if (elem.getY() + elem.getHeight() / 2 > this.max.y) {
                    this.max.y = elem.getY() + elem.getHeight() / 2;
                }
            }
            ++i;
        }
        this.max.x += this.space;
        this.max.y += this.space / 2;
        this.setBounds(this.min.x, this.min.y, this.max.x - this.min.x, this.max.y - this.min.y);
        this.maxX = 700;
        this.anchorUL = new Rectangle(this.min.x, this.min.y, 2, 2);
        this.anchorUR = new Rectangle(this.max.x, this.min.y, 2, 2);
        this.anchorBR = new Rectangle(this.max.x, this.max.y, 2, 2);
        this.anchorBL = new Rectangle(this.min.x, this.max.y, 2, 2);
        this.anchor = new Point(-1, -1);
        this.dx = 0;
        this.dy = 0;
    }

    @Override
    public boolean contains(int ax, int ay) {
        if (super.contains(ax, ay)) {
            this.anchor.x = ax;
            this.anchor.y = ay;
            return true;
        }
        this.anchor.x = -1;
        this.anchor.y = -1;
        return false;
    }

    public void compute() {
        EdGraphObject elem;
        int newX = 0;
        int newY = 0;
        int i = 0;
        while (i < this.objs.size()) {
            elem = this.objs.elementAt(i);
            elem.setXY(elem.getX() - this.min.x, elem.getY() - this.min.y);
            if (elem.isArc() && elem.getArc().isLine()) {
                if (elem.getArc().hasAnchor()) {
                    elem.getArc().setAnchor(new Point(elem.getArc().getAnchor().x - this.min.x, elem.getArc().getAnchor().y - this.min.y));
                }
            } else if (elem.isArc() && !elem.getArc().isLine()) {
                elem.getArc().setAnchor(1, new Point(elem.getArc().getAnchor((int)1).x - this.min.x, elem.getArc().getAnchor((int)1).y - this.min.y));
            }
            ++i;
        }
        if (this.upper_left.x != 0 && this.upper_left.y != 0) {
            newX = this.upper_left.x;
            newY = this.upper_left.y;
        } else {
            newX = this.min.x + this.dx;
            newY = this.min.y + this.dy;
        }
        if (newX + this.getSize().width > this.maxX) {
            newX = 0;
            newY = newY + this.getSize().height + 10;
        }
        this.min.x = newX;
        this.min.y = newY;
        this.max.x = this.min.x + this.getSize().width;
        this.max.y = this.min.y + this.getSize().height;
        this.setBounds(this.min.x, this.min.y, this.getSize().width, this.getSize().height);
        i = 0;
        while (i < this.objs.size()) {
            elem = this.objs.elementAt(i);
            if (elem.isNode()) {
                elem.setXY(elem.getX() + this.min.x, elem.getY() + this.min.y);
                if (elem.getX() - elem.getWidth() / 2 < 0) {
                    elem.setX(elem.getX() + elem.getWidth() / 2 + 10);
                }
            } else if (elem.isArc() && elem.getArc().isLine()) {
                if (elem.getArc().hasAnchor()) {
                    elem.getArc().setAnchor(new Point(elem.getArc().getAnchor().x + this.min.x, elem.getArc().getAnchor().y + this.min.y));
                }
            } else if (elem.isArc() && !elem.getArc().isLine()) {
                elem.getArc().setAnchor(1, new Point(elem.getArc().getAnchor((int)1).x + this.min.x, elem.getArc().getAnchor((int)1).y + this.min.y));
            }
            ++i;
        }
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int x, int y) {
        this.anchor.x = x;
        this.anchor.y = y;
    }

    public boolean isUpperLeft() {
        return this.anchorUL.contains(this.anchor.x, this.anchor.y);
    }

    public boolean isUpperRight() {
        return this.anchorUR.contains(this.anchor.x, this.anchor.y);
    }

    public boolean isBottomRight() {
        return this.anchorBR.contains(this.anchor.x, this.anchor.y);
    }

    public boolean isBottomLeft() {
        return this.anchorBL.contains(this.anchor.x, this.anchor.y);
    }

    public Point getUpperLeft() {
        return new Point(this.min.x, this.min.y);
    }

    public Point getUpperRight() {
        return new Point(this.max.x, this.min.y);
    }

    public void setUpperLeft(Point p) {
        this.min = p;
    }

    public void moveTo(int ax, int ay) {
        if (this.anchor.x == -1 || this.anchor.y == -1) {
            return;
        }
        int diffX = ax - this.anchor.x;
        int diffY = ay - this.anchor.y;
        this.min.x += diffX;
        this.min.y += diffY;
        this.max.x += diffX;
        this.max.y += diffY;
        this.makeAnchors();
    }

    public void resizeTo(int ax, int ay) {
        if (this.anchor.x == -1 || this.anchor.y == -1) {
            return;
        }
        if (this.isUpperLeft()) {
            this.min.x = ax;
            this.min.y = ay;
            this.setBounds(this.min.x, this.min.y, this.max.x - this.min.x, this.max.y - this.min.y);
            this.makeAnchors();
        } else if (this.isUpperRight()) {
            this.max.x = ax;
            this.min.y = ay;
            this.setBounds(this.min.x, this.min.y, this.max.x - this.min.x, this.max.y - this.min.y);
            this.makeAnchors();
        } else if (this.isBottomLeft()) {
            this.min.x = ax;
            this.max.y = ay;
            this.setBounds(this.min.x, this.min.y, this.max.x - this.min.x, this.max.y - this.min.y);
            this.makeAnchors();
        } else if (this.isBottomRight()) {
            this.max.x = ax;
            this.max.y = ay;
            this.setBounds(this.min.x, this.min.y, this.max.x - this.min.x, this.max.y - this.min.y);
            this.makeAnchors();
        }
    }

    public void setMaxX(int aMax) {
        this.maxX = aMax;
    }

    public void setOverlap(int overX, int overY) {
        this.dx = overX;
        this.dy = overY;
    }

    public void setOverlap(Rectangle rect) {
    }

    public void show(Graphics g) {
        g.setColor(Color.black);
        g.drawRect(this.min.x, this.min.y, this.getSize().width, this.getSize().height);
    }

    public void hide(Graphics g) {
        g.setColor(Color.white);
        g.drawRect(this.min.x, this.min.y, this.getSize().width, this.getSize().height);
    }

    private void makeAnchors() {
        this.anchorUL = new Rectangle(this.min.x, this.min.y, 2, 2);
        this.anchorUR = new Rectangle(this.max.x, this.min.y, 2, 2);
        this.anchorBR = new Rectangle(this.max.x, this.max.y, 2, 2);
        this.anchorBL = new Rectangle(this.min.x, this.max.y, 2, 2);
    }
}

