/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.giraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.henshin.interpreter.giraph.GiraphRuleData;
import org.eclipse.emf.henshin.interpreter.giraph.GiraphUtil;
import org.eclipse.emf.henshin.interpreter.info.RuleChangeInfo;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.staticanalysis.NodeEquivalence;

public class GiraphRuleTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "/*" + this.NL + " * Licensed to the Apache Software Foundation (ASF) under one" + this.NL + " * or more contributor license agreements.  See the NOTICE file" + this.NL + " * distributed with this work for additional information" + this.NL + " * regarding copyright ownership.  The ASF licenses this file" + this.NL + " * to you under the Apache License, Version 2.0 (the" + this.NL + " * \"License\"); you may not use this file except in compliance" + this.NL + " * with the License.  You may obtain a copy of the License at" + this.NL + " *" + this.NL + " *     http://www.apache.org/licenses/LICENSE-2.0" + this.NL + " *" + this.NL + " * Unless required by applicable law or agreed to in writing, software" + this.NL + " * distributed under the License is distributed on an \"AS IS\" BASIS," + this.NL + " * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied." + this.NL + " * See the License for the specific language governing permissions and" + this.NL + " * limitations under the License." + this.NL + " */" + this.NL + "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import java.io.IOException;" + this.NL + "import java.util.ArrayDeque;" + this.NL + "import java.util.ArrayList;";
    protected final String TEXT_3 = String.valueOf(this.NL) + "import java.util.Collections;";
    protected final String TEXT_4 = String.valueOf(this.NL) + "import java.util.Deque;" + this.NL + "import java.util.HashSet;" + this.NL + "import java.util.List;" + this.NL + "import java.util.Set;" + this.NL + this.NL + "import org.apache.giraph.aggregators.LongSumAggregator;";
    protected final String TEXT_5 = String.valueOf(this.NL) + "import org.apache.giraph.edge.Edge;";
    protected final String TEXT_6 = String.valueOf(this.NL) + "import org.apache.giraph.edge.EdgeFactory;";
    protected final String TEXT_7 = String.valueOf(this.NL) + "import org.apache.giraph.graph.BasicComputation;" + this.NL + "import org.apache.giraph.graph.Vertex;" + this.NL + "import org.apache.giraph.master.DefaultMasterCompute;" + this.NL + "import org.apache.hadoop.io.ByteWritable;" + this.NL + "import org.apache.hadoop.io.LongWritable;";
    protected final String TEXT_8 = String.valueOf(this.NL) + "import org.apache.log4j.Logger;";
    protected final String TEXT_9 = String.valueOf(this.NL) + "import static ";
    protected final String TEXT_10 = ".HenshinUtil" + this.NL + "  .ApplicationStack;" + this.NL + "import static ";
    protected final String TEXT_11 = ".HenshinUtil" + this.NL + "  .ApplicationStackAggregator;" + this.NL + "import static ";
    protected final String TEXT_12 = ".HenshinUtil" + this.NL + "  .Match;" + this.NL + "import static ";
    protected final String TEXT_13 = ".HenshinUtil" + this.NL + "  .VertexId;" + this.NL + this.NL + "/**" + this.NL + " * Generated implementation of the Henshin unit \"";
    protected final String TEXT_14 = "\"." + this.NL + " */" + this.NL + "@Algorithm(" + this.NL + "    name = \"";
    protected final String TEXT_15 = "\"" + this.NL + ")" + this.NL + "public class ";
    protected final String TEXT_16 = " extends" + this.NL + "  BasicComputation<VertexId, ByteWritable, ByteWritable, Match> {" + this.NL + this.NL + "  /**" + this.NL + "   * Name of the match count aggregator." + this.NL + "   */" + this.NL + "  public static final String AGGREGATOR_MATCHES = \"matches\";" + this.NL + this.NL + "  /**" + this.NL + "   * Name of the rule application count aggregator." + this.NL + "   */" + this.NL + "  public static final String AGGREGATOR_RULE_APPLICATIONS = \"ruleApps\";" + this.NL + this.NL + "  /**" + this.NL + "   * Name of the node generation aggregator." + this.NL + "   */" + this.NL + "  public static final String AGGREGATOR_NODE_GENERATION = \"nodeGen\";" + this.NL + this.NL + "  /**" + this.NL + "   * Name of the application stack aggregator." + this.NL + "   */" + this.NL + "  public static final String AGGREGATOR_APPLICATION_STACK = \"appStack\";";
    protected final String TEXT_17 = String.valueOf(this.NL) + this.NL + "  /**" + this.NL + "   * Type constant for \"";
    protected final String TEXT_18 = "\"." + this.NL + "   */" + this.NL + "  public static final byte ";
    protected final String TEXT_19 = " = ";
    protected final String TEXT_20 = ";";
    protected final String TEXT_21 = String.valueOf(this.NL) + this.NL + "  /**" + this.NL + "   * ";
    protected final String TEXT_22 = " constant for \"";
    protected final String TEXT_23 = "\"." + this.NL + "   */" + this.NL + "  public static final int ";
    protected final String TEXT_24 = " = ";
    protected final String TEXT_25 = ";";
    protected final String TEXT_26 = String.valueOf(this.NL) + this.NL + "  /**" + this.NL + "   * Logging support." + this.NL + "   */" + this.NL + "  protected static final Logger LOG = Logger.getLogger(";
    protected final String TEXT_27 = ".class);";
    protected final String TEXT_28 = String.valueOf(this.NL) + this.NL + "  /**" + this.NL + "   * Default segment count." + this.NL + "   */" + this.NL + "  private static int SEGMENT_COUNT = ";
    protected final String TEXT_29 = ";" + this.NL + this.NL + "  /**" + this.NL + "   * Currently active rule." + this.NL + "   */" + this.NL + "  private int rule;" + this.NL + this.NL + "  /**" + this.NL + "   * Current segment." + this.NL + "   */" + this.NL + "  private int segment;" + this.NL + this.NL + "  /**" + this.NL + "   * Current microstep." + this.NL + "   */" + this.NL + "  private int microstep;" + this.NL + this.NL + "  /**" + this.NL + "   * Finished flag." + this.NL + "   */" + this.NL + "  private boolean finished;" + this.NL + this.NL + "  /*" + this.NL + "   * (non-Javadoc)" + this.NL + "   * @see org.apache.giraph.graph.Computation#preSuperstep()" + this.NL + "   */" + this.NL + "  @Override" + this.NL + "  public void preSuperstep() {" + this.NL + "    ApplicationStack stack =" + this.NL + "      getAggregatedValue(AGGREGATOR_APPLICATION_STACK);" + this.NL + "    if (stack.getStackSize() == 0) {" + this.NL + "      long ruleApps = ((LongWritable)" + this.NL + "        getAggregatedValue(AGGREGATOR_RULE_APPLICATIONS)).get();" + this.NL + "      finished = ruleApps == 0;" + this.NL + "      rule = -1;" + this.NL + "    } else {" + this.NL + "      finished = false;" + this.NL + "      rule = stack.getLastUnit();" + this.NL + "      segment = stack.getLastSegment();" + this.NL + "      microstep = stack.getLastMicrostep();" + this.NL + "    }" + this.NL + "  }" + this.NL + this.NL + "  /*" + this.NL + "   * (non-Javadoc)" + this.NL + "   * @see org.apache.giraph.graph.Computation#compute(" + this.NL + "   *        org.apache.giraph.graph.Vertex, java.lang.Iterable)" + this.NL + "   */" + this.NL + "  @Override" + this.NL + "  public void compute(" + this.NL + "      Vertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "      Iterable<Match> matches) throws IOException {" + this.NL + "    if (finished) {" + this.NL + "      vertex.voteToHalt();" + this.NL + "      return;" + this.NL + "    }" + this.NL + "    switch (rule) {";
    protected final String TEXT_30 = String.valueOf(this.NL) + "    case ";
    protected final String TEXT_31 = ":" + this.NL + "      match";
    protected final String TEXT_32 = "(" + this.NL + "        vertex, matches, segment, microstep);" + this.NL + "      break;";
    protected final String TEXT_33 = String.valueOf(this.NL) + "    default:" + this.NL + "      break;" + this.NL + "    }" + this.NL + "  }";
    protected final String TEXT_34 = String.valueOf(this.NL) + this.NL + "  /**" + this.NL + "   * Match (and apply) the rule \"";
    protected final String TEXT_35 = "\"." + this.NL + "   * This takes ";
    protected final String TEXT_36 = " microsteps." + this.NL + "   * @param vertex The current vertex." + this.NL + "   * @param matches The current matches." + this.NL + "   * @param segment The current segment." + this.NL + "   * @param microstep The current microstep." + this.NL + "   */" + this.NL + "  protected void match";
    protected final String TEXT_37 = "(" + this.NL + "    Vertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "    Iterable<Match> matches, int segment, int microstep)" + this.NL + "    throws IOException {" + this.NL;
    protected final String TEXT_38 = String.valueOf(this.NL) + "    LOG.info(\"Vertex \" + vertex.getId() + \" in superstep \" + getSuperstep() +" + this.NL + "      \" matching rule ";
    protected final String TEXT_39 = " on segment \" + segment +" + this.NL + "      \" in microstep \" + microstep);" + this.NL + "    for (Match match : matches) {" + this.NL + "      LOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "        \" in superstep \" + getSuperstep() +" + this.NL + "        \" received (partial) match \" + match);" + this.NL + "    }";
    protected final String TEXT_40 = String.valueOf(this.NL) + "    Set<Match> finalMatches = new HashSet<Match>();";
    protected final String TEXT_41 = String.valueOf(this.NL) + "    ";
    protected final String TEXT_42 = "filter";
    protected final String TEXT_43 = "(" + this.NL + "      vertex, matches, segment, microstep, finalMatches);" + this.NL + "    long matchCount = 0;" + this.NL + "    long appCount = 0;" + this.NL;
    protected final String TEXT_44 = " if (microstep == ";
    protected final String TEXT_45 = ") {";
    protected final String TEXT_46 = String.valueOf(this.NL) + "      // Joining matches at node ";
    protected final String TEXT_47 = ":" + this.NL + "      List<Match> matches1 = new ArrayList<Match>();" + this.NL + "      List<Match> matches2 = new ArrayList<Match>();" + this.NL + "      VertexId id = vertex.getId();" + this.NL + "      for (Match match : matches) {" + this.NL + "        if (id.equals(match.getVertexId(";
    protected final String TEXT_48 = "))) {" + this.NL + "          matches1.add(match.copy());" + this.NL + "        } else {" + this.NL + "          matches2.add(match.copy());" + this.NL + "        }" + this.NL + "      }";
    protected final String TEXT_49 = String.valueOf(this.NL) + "      LOG.info(\"Vertex \" + id + \" in superstep \" + getSuperstep() +" + this.NL + "        \" joining \" + matches1.size() + \" x \" + matches2.size() +" + this.NL + "        \" partial matches of rule ";
    protected final String TEXT_50 = "\");";
    protected final String TEXT_51 = String.valueOf(this.NL) + "      for (Match m1 : matches1) {" + this.NL + "        for (Match m2 : matches2) {" + this.NL + "          Match match = m1.append(m2);";
    protected final String TEXT_52 = String.valueOf(this.NL) + "          if (!match.isInjective()) {" + this.NL + "            continue;" + this.NL + "          }";
    protected final String TEXT_53 = String.valueOf(this.NL) + "          matchCount++;";
    protected final String TEXT_54 = String.valueOf(this.NL) + "          LOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "            \" sending (partial) match \" + match +" + this.NL + "            \" back to vertex \" + match.getVertexId(";
    protected final String TEXT_55 = "));";
    protected final String TEXT_56 = String.valueOf(this.NL) + "          sendMessage(match.getVertexId(";
    protected final String TEXT_57 = "), match);";
    protected final String TEXT_58 = String.valueOf(this.NL) + "          match = match.remove(";
    protected final String TEXT_59 = ");";
    protected final String TEXT_60 = String.valueOf(this.NL) + "          if (!finalMatches.add(match)) {" + this.NL + "            continue;" + this.NL + "          }" + this.NL + "          matchCount++;" + this.NL + "          if (segment == SEGMENT_COUNT - 1) {" + this.NL + "            apply";
    protected final String TEXT_61 = "(" + this.NL + "              vertex, match, appCount++);" + this.NL + "          } else {" + this.NL + "            sendMessage(vertex.getId(), match);" + this.NL + "          }";
    protected final String TEXT_62 = String.valueOf(this.NL) + "        }" + this.NL + "      }";
    protected final String TEXT_63 = String.valueOf(this.NL) + "      // Matching node ";
    protected final String TEXT_64 = ":";
    protected final String TEXT_65 = String.valueOf(this.NL) + "      ";
    protected final String TEXT_66 = "vertex.getValue().get() == ";
    protected final String TEXT_67 = String.valueOf(this.NL) + "      ok = ok && vertex.getNumEdges() >= ";
    protected final String TEXT_68 = ";";
    protected final String TEXT_69 = String.valueOf(this.NL) + "      ok = ok && (SEGMENT_COUNT == 1 || getSegment(vertex.getId()) == segment);";
    protected final String TEXT_70 = String.valueOf(this.NL) + "      if (ok) {";
    protected final String TEXT_71 = String.valueOf(this.NL) + "        Match match = new Match(segment).append(vertex.getId());";
    protected final String TEXT_72 = this.NL;
    protected final String TEXT_73 = "      for (Match match : matches) {";
    protected final String TEXT_74 = this.NL;
    protected final String TEXT_75 = "        match = match.append(vertex.getId());";
    protected final String TEXT_76 = this.NL;
    protected final String TEXT_77 = "        if (!match.isInjective()) {";
    protected final String TEXT_78 = this.NL;
    protected final String TEXT_79 = "          continue;";
    protected final String TEXT_80 = this.NL;
    protected final String TEXT_81 = "        }";
    protected final String TEXT_82 = this.NL;
    protected final String TEXT_83 = "        if (vertex.getId().compareTo(match.getVertexId(";
    protected final String TEXT_84 = ")) < 0) {";
    protected final String TEXT_85 = this.NL;
    protected final String TEXT_86 = "          continue;";
    protected final String TEXT_87 = this.NL;
    protected final String TEXT_88 = "        }";
    protected final String TEXT_89 = this.NL;
    protected final String TEXT_90 = "    // Node ";
    protected final String TEXT_91 = ": check for edge to match of ";
    protected final String TEXT_92 = " of type \"";
    protected final String TEXT_93 = "\":";
    protected final String TEXT_94 = this.NL;
    protected final String TEXT_95 = "    VertexId targetId = match.getVertexId(";
    protected final String TEXT_96 = ");";
    protected final String TEXT_97 = this.NL;
    protected final String TEXT_98 = "    for (Edge<VertexId, ByteWritable> edge :";
    protected final String TEXT_99 = this.NL;
    protected final String TEXT_100 = "      vertex.getEdges()) {";
    protected final String TEXT_101 = this.NL;
    protected final String TEXT_102 = "      if (edge.getValue().get() ==";
    protected final String TEXT_103 = this.NL;
    protected final String TEXT_104 = "        ";
    protected final String TEXT_105 = " &&";
    protected final String TEXT_106 = this.NL;
    protected final String TEXT_107 = "        edge.getTargetVertexId().equals(targetId)) {";
    protected final String TEXT_108 = this.NL;
    protected final String TEXT_109 = "        matchCount++;";
    protected final String TEXT_110 = this.NL;
    protected final String TEXT_111 = "        LOG.info(\"Vertex \" + vertex.getId() +";
    protected final String TEXT_112 = this.NL;
    protected final String TEXT_113 = "          \" sending (partial) match \" + match +";
    protected final String TEXT_114 = this.NL;
    protected final String TEXT_115 = "          \" back to vertex \" + match.getVertexId(";
    protected final String TEXT_116 = "));";
    protected final String TEXT_117 = this.NL;
    protected final String TEXT_118 = "        sendMessage(match.getVertexId(";
    protected final String TEXT_119 = "), match);";
    protected final String TEXT_120 = this.NL;
    protected final String TEXT_121 = "        match = match.remove(";
    protected final String TEXT_122 = ");";
    protected final String TEXT_123 = this.NL;
    protected final String TEXT_124 = "        if (finalMatches.add(match)) {";
    protected final String TEXT_125 = this.NL;
    protected final String TEXT_126 = "          matchCount++;";
    protected final String TEXT_127 = this.NL;
    protected final String TEXT_128 = "          if (segment == SEGMENT_COUNT - 1) {";
    protected final String TEXT_129 = this.NL;
    protected final String TEXT_130 = "            apply";
    protected final String TEXT_131 = "(";
    protected final String TEXT_132 = this.NL;
    protected final String TEXT_133 = "              vertex, match, appCount++);";
    protected final String TEXT_134 = this.NL;
    protected final String TEXT_135 = "          } else {";
    protected final String TEXT_136 = this.NL;
    protected final String TEXT_137 = "            sendMessage(vertex.getId(), match);";
    protected final String TEXT_138 = this.NL;
    protected final String TEXT_139 = "          }";
    protected final String TEXT_140 = this.NL;
    protected final String TEXT_141 = "        }";
    protected final String TEXT_142 = this.NL;
    protected final String TEXT_143 = "        break;";
    protected final String TEXT_144 = this.NL;
    protected final String TEXT_145 = "      }";
    protected final String TEXT_146 = this.NL;
    protected final String TEXT_147 = "    }";
    protected final String TEXT_148 = this.NL;
    protected final String TEXT_149 = "        matchCount++;";
    protected final String TEXT_150 = this.NL;
    protected final String TEXT_151 = "        Set<VertexId> targets = new HashSet<VertexId>();";
    protected final String TEXT_152 = this.NL;
    protected final String TEXT_153 = "        for (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {";
    protected final String TEXT_154 = this.NL;
    protected final String TEXT_155 = "          if (edge.getValue().get() ==";
    protected final String TEXT_156 = this.NL;
    protected final String TEXT_157 = "            ";
    protected final String TEXT_158 = " &&";
    protected final String TEXT_159 = this.NL;
    protected final String TEXT_160 = "            targets.add(edge.getTargetVertexId())) {";
    protected final String TEXT_161 = this.NL;
    protected final String TEXT_162 = "            LOG.info(\"Vertex \" + vertex.getId() +";
    protected final String TEXT_163 = this.NL;
    protected final String TEXT_164 = "              \" sending (partial) match \" + match +";
    protected final String TEXT_165 = this.NL;
    protected final String TEXT_166 = "              \" forward to vertex \" + edge.getTargetVertexId());";
    protected final String TEXT_167 = this.NL;
    protected final String TEXT_168 = "            sendMessage(edge.getTargetVertexId(), match);";
    protected final String TEXT_169 = this.NL;
    protected final String TEXT_170 = "          }";
    protected final String TEXT_171 = this.NL;
    protected final String TEXT_172 = "        }";
    protected final String TEXT_173 = this.NL;
    protected final String TEXT_174 = "      }";
    protected final String TEXT_175 = String.valueOf(this.NL) + "      }";
    protected final String TEXT_176 = String.valueOf(this.NL) + "      for (Match match : matches) {" + this.NL + "        VertexId id = match.getVertexId(";
    protected final String TEXT_177 = ");" + this.NL + "        if (vertex.getId().equals(id)) {" + this.NL + "          matchCount++;";
    protected final String TEXT_178 = String.valueOf(this.NL) + "          LOG.info(\"Vertex \" + id + \" in superstep \" + getSuperstep() +" + this.NL + "            \" sending (partial) match \" + match + \" to myself\");";
    protected final String TEXT_179 = String.valueOf(this.NL) + "          sendMessage(id, match);" + this.NL + "        }" + this.NL + "      }";
    protected final String TEXT_180 = String.valueOf(this.NL) + "    }";
    protected final String TEXT_181 = " else {" + this.NL + "      throw new RuntimeException(\"Illegal microstep for rule \" +" + this.NL + "        \"";
    protected final String TEXT_182 = ": \" + microstep);" + this.NL + "    }" + this.NL + "    if (matchCount > 0) {" + this.NL + "      aggregate(AGGREGATOR_MATCHES," + this.NL + "        new LongWritable(matchCount));" + this.NL + "    }" + this.NL + "    if (appCount > 0) {" + this.NL + "      aggregate(AGGREGATOR_RULE_APPLICATIONS," + this.NL + "        new LongWritable(appCount));" + this.NL + "    }" + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Filter matches per segment for the rule \"";
    protected final String TEXT_183 = "\"." + this.NL + "   * @param vertex The current vertex." + this.NL + "   * @param matches The current matches." + this.NL + "   * @param segment The current segment." + this.NL + "   * @param microstep The current microstep." + this.NL + "   * @param finalMatches Set of final matches." + this.NL + "   * @return The filtered matches." + this.NL + "   */" + this.NL + "  protected Iterable<Match> filter";
    protected final String TEXT_184 = "(" + this.NL + "    Vertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "    Iterable<Match> matches, int segment, int microstep," + this.NL + "    Set<Match> finalMatches)" + this.NL + "    throws IOException {" + this.NL + "    if (segment > 0) {" + this.NL + "      List<Match> filtered = new ArrayList<Match>();" + this.NL + "      long matchCount = 0;" + this.NL + "      long appCount = 0;" + this.NL + "      for (Match match : matches) {" + this.NL + "        int matchSegment = match.getSegment();" + this.NL + "        if (matchSegment < segment) {" + this.NL + "          if (!finalMatches.add(match)) {" + this.NL + "            continue;" + this.NL + "          }" + this.NL + "          matchCount++;" + this.NL + "          if (segment == SEGMENT_COUNT - 1 && microstep == ";
    protected final String TEXT_185 = ") {" + this.NL + "            apply";
    protected final String TEXT_186 = "(" + this.NL + "              vertex, match, appCount++);" + this.NL + "          } else {" + this.NL + "            sendMessage(vertex.getId(), match);" + this.NL + "          }" + this.NL + "        } else if (matchSegment > segment) {" + this.NL + "          throw new RuntimeException(\"Received match \" + match +" + this.NL + "            \" of rule ";
    protected final String TEXT_187 = " of segment \" +" + this.NL + "            matchSegment + \", but current segment is only \" + segment);" + this.NL + "        } else {" + this.NL + "          filtered.add(match.copy());" + this.NL + "        }" + this.NL + "      }" + this.NL + "      if (matchCount > 0) {" + this.NL + "        aggregate(AGGREGATOR_MATCHES," + this.NL + "          new LongWritable(matchCount));" + this.NL + "      }" + this.NL + "      if (appCount > 0) {" + this.NL + "        aggregate(AGGREGATOR_RULE_APPLICATIONS," + this.NL + "          new LongWritable(appCount));" + this.NL + "      }" + this.NL + "      return filtered;" + this.NL + "    }" + this.NL + "    return matches;" + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Apply the rule \"";
    protected final String TEXT_188 = "\" to a given match." + this.NL + "   * @param vertex The base vertex." + this.NL + "   * @param match The match object." + this.NL + "   * @param matchIndex Match index." + this.NL + "   * @return true if the rule was applied." + this.NL + "   * @throws IOException On I/O errors." + this.NL + "   */" + this.NL + "  protected boolean apply";
    protected final String TEXT_189 = "(" + this.NL + "    Vertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "    Match match, long matchIndex) throws IOException {";
    protected final String TEXT_190 = String.valueOf(this.NL) + "    VertexId cur";
    protected final String TEXT_191 = " = match.getVertexId(";
    protected final String TEXT_192 = ");";
    protected final String TEXT_193 = String.valueOf(this.NL) + "    LOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "      \" applying rule ";
    protected final String TEXT_194 = " with match \" + match);";
    protected final String TEXT_195 = String.valueOf(this.NL) + "    removeEdgesRequest(cur";
    protected final String TEXT_196 = ", cur";
    protected final String TEXT_197 = ");";
    protected final String TEXT_198 = String.valueOf(this.NL) + "    removeVertexRequest(cur";
    protected final String TEXT_199 = ");";
    protected final String TEXT_200 = String.valueOf(this.NL) + "    VertexId new";
    protected final String TEXT_201 = " =";
    protected final String TEXT_202 = String.valueOf(this.NL) + "      VertexId.randomVertexId();";
    protected final String TEXT_203 = String.valueOf(this.NL) + "      deriveVertexId(vertex.getId(), (int) matchIndex, ";
    protected final String TEXT_204 = ");";
    protected final String TEXT_205 = String.valueOf(this.NL) + "    addVertexRequest(new";
    protected final String TEXT_206 = "," + this.NL + "      new ByteWritable(";
    protected final String TEXT_207 = "));";
    protected final String TEXT_208 = String.valueOf(this.NL) + "    VertexId src";
    protected final String TEXT_209 = " = new";
    protected final String TEXT_210 = ";";
    protected final String TEXT_211 = String.valueOf(this.NL) + "    VertexId src";
    protected final String TEXT_212 = " = cur";
    protected final String TEXT_213 = ";";
    protected final String TEXT_214 = String.valueOf(this.NL) + "    VertexId trg";
    protected final String TEXT_215 = " = new";
    protected final String TEXT_216 = ";";
    protected final String TEXT_217 = String.valueOf(this.NL) + "    VertexId trg";
    protected final String TEXT_218 = " = cur";
    protected final String TEXT_219 = ";";
    protected final String TEXT_220 = String.valueOf(this.NL) + "    Edge<VertexId, ByteWritable> edge";
    protected final String TEXT_221 = " =" + this.NL + "      EdgeFactory.create(trg";
    protected final String TEXT_222 = "," + this.NL + "        new ByteWritable(";
    protected final String TEXT_223 = "));" + this.NL + "    addEdgeRequest(src";
    protected final String TEXT_224 = ", edge";
    protected final String TEXT_225 = ");";
    protected final String TEXT_226 = String.valueOf(this.NL) + "    return true;" + this.NL + "  }";
    protected final String TEXT_227 = this.NL;
    protected final String TEXT_228 = String.valueOf(this.NL) + "  /**" + this.NL + "   * Derive a new vertex Id from an exiting one." + this.NL + "   * @param baseId The base vertex Id." + this.NL + "   * @param matchIndex The index of the match." + this.NL + "   * @param vertexIndex The index of the new vertex." + this.NL + "   * @return The derived vertex Id." + this.NL + "   */" + this.NL + "  private VertexId deriveVertexId(VertexId baseId, int matchIndex," + this.NL + "    int vertexIndex) {" + this.NL + "    long generation = ((LongWritable) getAggregatedValue(" + this.NL + "        AGGREGATOR_NODE_GENERATION)).get();" + this.NL + "    return baseId" + this.NL + "      .append((byte) generation)" + this.NL + "      .append((byte) matchIndex)" + this.NL + "      .append((byte) vertexIndex);" + this.NL + "  }" + this.NL;
    protected final String TEXT_229 = String.valueOf(this.NL) + "  /**" + this.NL + "   * Get the segment that a vertex belongs to." + this.NL + "   * @param vertexId The ID of the vertex." + this.NL + "   * @return The segment of the vertex." + this.NL + "   */" + this.NL + "  private int getSegment(VertexId vertexId) {" + this.NL + "    return Math.abs(vertexId.hashCode()) % SEGMENT_COUNT;" + this.NL + "  }" + this.NL + this.NL + "  /**" + this.NL + "   * Master compute which registers and updates the required aggregators." + this.NL + "   */" + this.NL + "  public static class MasterCompute extends DefaultMasterCompute {" + this.NL + this.NL + "    /**" + this.NL + "     * Stack for storing unit success flags." + this.NL + "     */" + this.NL + "    private final Deque<Boolean> unitSuccesses =" + this.NL + "      new ArrayDeque<Boolean>();" + this.NL + this.NL + "    /**" + this.NL + "     * Stack for storing the execution orders of independent units." + this.NL + "     */" + this.NL + "    private final Deque<List<Integer>> unitOrders =" + this.NL + "      new ArrayDeque<List<Integer>>();" + this.NL + this.NL + "    /*" + this.NL + "     * (non-Javadoc)" + this.NL + "     * @see org.apache.giraph.master.DefaultMasterCompute#compute()" + this.NL + "     */" + this.NL + "    @Override" + this.NL + "    public void compute() {" + this.NL + "      long ruleApps = ((LongWritable)" + this.NL + "        getAggregatedValue(AGGREGATOR_RULE_APPLICATIONS)).get();";
    protected final String TEXT_230 = String.valueOf(this.NL) + "      long matches = ((LongWritable)" + this.NL + "        getAggregatedValue(AGGREGATOR_MATCHES)).get();" + this.NL + "      if (getSuperstep() > 0) {" + this.NL + "        LOG.info(matches + \" (partial) matches computed and \" +" + this.NL + "          ruleApps + \" rule applications conducted in superstep \" +" + this.NL + "          (getSuperstep() - 1));" + this.NL + "      }";
    protected final String TEXT_231 = String.valueOf(this.NL) + "      if (ruleApps > 0) {" + this.NL + "        long nodeGen = ((LongWritable)" + this.NL + "          getAggregatedValue(AGGREGATOR_NODE_GENERATION)).get();" + this.NL + "        setAggregatedValue(AGGREGATOR_NODE_GENERATION," + this.NL + "          new LongWritable(nodeGen + 1));" + this.NL + "      }" + this.NL + "      ApplicationStack stack;" + this.NL + "      if (getSuperstep() == 0) {" + this.NL + "        stack = new ApplicationStack();" + this.NL + "        stack = stack.append(";
    protected final String TEXT_232 = ", 0, 0);";
    protected final String TEXT_233 = String.valueOf(this.NL) + "        stack = nextRuleStep(stack, ruleApps);";
    protected final String TEXT_234 = String.valueOf(this.NL) + "      } else {" + this.NL + "        stack = getAggregatedValue(AGGREGATOR_APPLICATION_STACK);" + this.NL + "        stack = nextRuleStep(stack, ruleApps);" + this.NL + "      }" + this.NL + "      setAggregatedValue(AGGREGATOR_APPLICATION_STACK, stack);" + this.NL + "    }" + this.NL + this.NL + "    /**" + this.NL + "     * Compute the next rule application stack." + this.NL + "     * @param stack The current application stack." + this.NL + "     * @param ruleApps Number of rule applications in last superstep." + this.NL + "     * @return The new application stack." + this.NL + "     */" + this.NL + "    private ApplicationStack nextRuleStep(" + this.NL + "      ApplicationStack stack, long ruleApps) {" + this.NL + "      while (stack.getStackSize() > 0) {" + this.NL + "        int unit = stack.getLastUnit();" + this.NL + "        int segment = stack.getLastSegment();" + this.NL + "        int microstep = stack.getLastMicrostep();" + this.NL + "        stack = stack.removeLast();" + this.NL + "        switch (unit) {";
    protected final String TEXT_235 = String.valueOf(this.NL) + "        case ";
    protected final String TEXT_236 = ":" + this.NL + "          stack = process";
    protected final String TEXT_237 = "(" + this.NL + "            stack";
    protected final String TEXT_238 = ", microstep";
    protected final String TEXT_239 = ");" + this.NL + "          break;";
    protected final String TEXT_240 = String.valueOf(this.NL) + "        default:" + this.NL + "          throw new RuntimeException(\"Unknown unit \" + unit);" + this.NL + "        }" + this.NL + "        if (stack.getStackSize() > 0) {" + this.NL + "          unit = stack.getLastUnit();";
    protected final String TEXT_241 = String.valueOf(this.NL) + "          ";
    protected final String TEXT_242 = "unit == ";
    protected final String TEXT_243 = String.valueOf(this.NL) + "            break;" + this.NL + "          }" + this.NL + "        }" + this.NL + "      }" + this.NL + "      return stack;" + this.NL + "    }";
    protected final String TEXT_244 = String.valueOf(this.NL) + this.NL + "   /**" + this.NL + "     * Process ";
    protected final String TEXT_245 = " \"";
    protected final String TEXT_246 = "\"." + this.NL + "     * @param stack The current application stack.";
    protected final String TEXT_247 = String.valueOf(this.NL) + "     * @param segment The current segment.";
    protected final String TEXT_248 = String.valueOf(this.NL) + "     * @param microstep The current microstep.";
    protected final String TEXT_249 = String.valueOf(this.NL) + "     * @param ruleApps Number of rule applications in last superstep.";
    protected final String TEXT_250 = String.valueOf(this.NL) + "     * @return The new application stack." + this.NL + "     */" + this.NL + "    private ApplicationStack process";
    protected final String TEXT_251 = "(" + this.NL + "      ApplicationStack stack";
    protected final String TEXT_252 = ", int microstep";
    protected final String TEXT_253 = ") {";
    protected final String TEXT_254 = String.valueOf(this.NL) + "      if (microstep > 0 && !unitSuccesses.pop()) {" + this.NL + "        unitSuccesses.push(false);" + this.NL + "      } else if (microstep == ";
    protected final String TEXT_255 = ") {" + this.NL + "        unitSuccesses.push(true);" + this.NL + "      } else if (microstep < ";
    protected final String TEXT_256 = ") {" + this.NL + "        stack = stack.append(";
    protected final String TEXT_257 = ", 0, microstep + 1);" + this.NL + "        stack = stack.append(";
    protected final String TEXT_258 = ", 0, 0);" + this.NL + "      }";
    protected final String TEXT_259 = String.valueOf(this.NL) + "      if (microstep > 0 && !unitSuccesses.pop()) {" + this.NL + "        unitSuccesses.push(false);" + this.NL + "      } else if (microstep == ";
    protected final String TEXT_260 = ") {" + this.NL + "        unitSuccesses.push(true);" + this.NL + "      } else {" + this.NL + "        switch (microstep) {";
    protected final String TEXT_261 = String.valueOf(this.NL) + "        case ";
    protected final String TEXT_262 = ":" + this.NL + "          stack = stack.append(";
    protected final String TEXT_263 = ", 0, ";
    protected final String TEXT_264 = ");" + this.NL + "          stack = stack.append(";
    protected final String TEXT_265 = ", 0, 0);" + this.NL + "          break;";
    protected final String TEXT_266 = String.valueOf(this.NL) + "        default:" + this.NL + "          break;" + this.NL + "        }" + this.NL + "      }";
    protected final String TEXT_267 = String.valueOf(this.NL) + "      if (microstep == 0) {" + this.NL + "        List<Integer> order = new ArrayList<Integer>();" + this.NL + "        for (int i = 0; i < ";
    protected final String TEXT_268 = "; i++) {" + this.NL + "          order.add(i);" + this.NL + "        }" + this.NL + "        Collections.shuffle(order);" + this.NL + "        unitOrders.push(order);" + this.NL + "      }" + this.NL + "      if (microstep > 0 && unitSuccesses.pop()) {" + this.NL + "        unitOrders.pop();" + this.NL + "        unitSuccesses.push(true);" + this.NL + "      } else if (microstep == ";
    protected final String TEXT_269 = ") {" + this.NL + "        unitOrders.pop();" + this.NL + "        unitSuccesses.push(false);" + this.NL + "      } else {" + this.NL + "        int next = unitOrders.peek().get(microstep);" + this.NL + "        switch (next) {";
    protected final String TEXT_270 = String.valueOf(this.NL) + "        case ";
    protected final String TEXT_271 = ":" + this.NL + "          stack = stack.append(";
    protected final String TEXT_272 = ", 0, microstep + 1);" + this.NL + "          stack = stack.append(";
    protected final String TEXT_273 = ", 0, 0);" + this.NL + "          break;";
    protected final String TEXT_274 = String.valueOf(this.NL) + "        default:" + this.NL + "          break;" + this.NL + "        }" + this.NL + "      }";
    protected final String TEXT_275 = String.valueOf(this.NL) + "      if (microstep == 0 || unitSuccesses.pop()) {" + this.NL + "        stack = stack.append(";
    protected final String TEXT_276 = ", 0, 1);" + this.NL + "        stack = stack.append(";
    protected final String TEXT_277 = ", 0, 0);" + this.NL + "      } else {" + this.NL + "        unitSuccesses.push(true);" + this.NL + "      }";
    protected final String TEXT_278 = String.valueOf(this.NL) + "      if (microstep < ";
    protected final String TEXT_279 = ") {" + this.NL + "        stack = stack.append(";
    protected final String TEXT_280 = ", segment, microstep + 1);" + this.NL + "      } else if (segment < SEGMENT_COUNT - 1) {" + this.NL + "        stack = stack.append(";
    protected final String TEXT_281 = ", segment + 1, 0);" + this.NL + "      } else {" + this.NL + "        unitSuccesses.push(ruleApps > 0);" + this.NL + "      }";
    protected final String TEXT_282 = String.valueOf(this.NL) + "      return stack;" + this.NL + "    }";
    protected final String TEXT_283 = String.valueOf(this.NL) + this.NL + "    /*" + this.NL + "     * (non-Javadoc)" + this.NL + "     * @see org.apache.giraph.master.DefaultMasterCompute#initialize()" + this.NL + "     */" + this.NL + "    @Override" + this.NL + "    public void initialize() throws InstantiationException," + this.NL + "        IllegalAccessException {" + this.NL + "      registerAggregator(AGGREGATOR_MATCHES," + this.NL + "        LongSumAggregator.class);" + this.NL + "      registerAggregator(AGGREGATOR_RULE_APPLICATIONS," + this.NL + "        LongSumAggregator.class);" + this.NL + "      registerPersistentAggregator(AGGREGATOR_NODE_GENERATION," + this.NL + "        LongSumAggregator.class);" + this.NL + "      registerPersistentAggregator(AGGREGATOR_APPLICATION_STACK," + this.NL + "        ApplicationStackAggregator.class);" + this.NL + "    }" + this.NL + this.NL + "  }" + this.NL + "}";
    protected final String TEXT_284 = this.NL;

    public static synchronized GiraphRuleTemplate create(String lineSeparator) {
        nl = lineSeparator;
        GiraphRuleTemplate result = new GiraphRuleTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Map args = (Map)argument;
        Map ruleData = (Map)args.get("ruleData");
        Unit mainUnit = (Unit)args.get("mainUnit");
        String className = (String)args.get("className");
        String packageName = (String)args.get("packageName");
        boolean masterLogging = (Boolean)args.get("masterLogging");
        boolean vertexLogging = (Boolean)args.get("vertexLogging");
        boolean useUUIDs = (Boolean)args.get("useUUIDs");
        int segmentCount = (Integer)args.get("segmentCount");
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        allUnits.add(mainUnit);
        allUnits.addAll((Collection<Unit>)mainUnit.getSubUnits(true));
        ArrayList rules = new ArrayList(ruleData.keySet());
        boolean needsEdgeFactory = false;
        boolean needsVertexIdFactory = false;
        int maxCreatedNodes = 0;
        for (GiraphRuleData data : ruleData.values()) {
            if (!data.changeInfo.getCreatedEdges().isEmpty()) {
                needsEdgeFactory = true;
            }
            if (!data.changeInfo.getCreatedNodes().isEmpty()) {
                needsVertexIdFactory = true;
            }
            maxCreatedNodes = Math.max(maxCreatedNodes, data.changeInfo.getCreatedNodes().size());
        }
        boolean needsCollections = false;
        for (Unit unit : allUnits) {
            if (!(unit instanceof IndependentUnit)) continue;
            needsCollections = true;
            break;
        }
        boolean needsEdgeClass = false;
        for (Rule rule : rules) {
            if (rule.getLhs().getEdges().isEmpty() && rule.getRhs().getEdges().isEmpty()) continue;
            needsEdgeClass = true;
            break;
        }
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        if (needsCollections) {
            stringBuffer.append(this.TEXT_3);
        }
        stringBuffer.append(this.TEXT_4);
        if (needsEdgeClass) {
            stringBuffer.append(this.TEXT_5);
        }
        if (needsEdgeFactory) {
            stringBuffer.append(this.TEXT_6);
        }
        stringBuffer.append(this.TEXT_7);
        if (masterLogging || vertexLogging) {
            stringBuffer.append(this.TEXT_8);
        }
        stringBuffer.append(this.TEXT_9);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_10);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_11);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_12);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_13);
        stringBuffer.append(mainUnit.getName());
        stringBuffer.append(this.TEXT_14);
        stringBuffer.append(mainUnit.getName());
        stringBuffer.append(this.TEXT_15);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_16);
        Map<ENamedElement, String> typeConstants = GiraphUtil.getTypeConstants(mainUnit.getModule());
        int value = 0;
        for (ENamedElement type : typeConstants.keySet()) {
            stringBuffer.append(this.TEXT_17);
            stringBuffer.append(type.getName());
            stringBuffer.append(this.TEXT_18);
            stringBuffer.append(typeConstants.get(type));
            stringBuffer.append(" = ");
            stringBuffer.append(value++);
            stringBuffer.append(";");
        }
        Map<Unit, String> unitConstants = GiraphUtil.getUnitConstants(mainUnit);
        value = 0;
        for (Unit unit : unitConstants.keySet()) {
            stringBuffer.append(this.TEXT_21);
            stringBuffer.append(unit instanceof Rule ? "Rule" : "Unit");
            stringBuffer.append(" constant for \"");
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_23);
            stringBuffer.append(unitConstants.get(unit));
            stringBuffer.append(" = ");
            stringBuffer.append(value++);
            stringBuffer.append(";");
        }
        if (masterLogging || vertexLogging) {
            stringBuffer.append(this.TEXT_26);
            stringBuffer.append(className);
            stringBuffer.append(".class);");
        }
        stringBuffer.append(this.TEXT_28);
        stringBuffer.append(segmentCount);
        stringBuffer.append(this.TEXT_29);
        for (Rule rule : rules) {
            stringBuffer.append(this.TEXT_30);
            stringBuffer.append(unitConstants.get(rule));
            stringBuffer.append(this.TEXT_31);
            stringBuffer.append(((GiraphRuleData)ruleData.get((Object)rule)).rule.getName());
            stringBuffer.append(this.TEXT_32);
        }
        stringBuffer.append(this.TEXT_33);
        for (GiraphRuleData data : ruleData.values()) {
            Rule rule = data.rule;
            RuleChangeInfo changeInfo = data.changeInfo;
            ArrayList<Integer> required = new ArrayList<Integer>();
            for (Node node : data.requiredNodes) {
                required.add(data.orderedLhsNodes.indexOf(node));
            }
            Collections.sort(required);
            Collections.reverse(required);
            stringBuffer.append(this.TEXT_34);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_35);
            stringBuffer.append(data.matchingSteps.size());
            stringBuffer.append(this.TEXT_36);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_37);
            if (vertexLogging) {
                stringBuffer.append(this.TEXT_38);
                stringBuffer.append(rule.getName());
                stringBuffer.append(this.TEXT_39);
            }
            stringBuffer.append(this.TEXT_40);
            stringBuffer.append(this.TEXT_41);
            stringBuffer.append(data.matchingSteps.size() > 1 ? "matches = " : "");
            stringBuffer.append("filter");
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_43);
            int i = 0;
            while (i < data.matchingSteps.size()) {
                GiraphRuleData.MatchingStep step = data.matchingSteps.get(i);
                stringBuffer.append(i > 0 ? " else" : "   ");
                stringBuffer.append(" if (microstep == ");
                stringBuffer.append(i);
                stringBuffer.append(") {");
                if (step.isJoin) {
                    stringBuffer.append(this.TEXT_46);
                    stringBuffer.append(GiraphUtil.getNodeName(step.node));
                    stringBuffer.append(this.TEXT_47);
                    stringBuffer.append(data.orderedLhsNodes.indexOf(step.node));
                    stringBuffer.append(this.TEXT_48);
                    if (vertexLogging) {
                        stringBuffer.append(this.TEXT_49);
                        stringBuffer.append(rule.getName());
                        stringBuffer.append("\");");
                    }
                    stringBuffer.append(this.TEXT_51);
                    if (rule.isInjectiveMatching()) {
                        stringBuffer.append(this.TEXT_52);
                    }
                    if (step.sendBackTo != null) {
                        stringBuffer.append(this.TEXT_53);
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_54);
                            stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                            stringBuffer.append("));");
                        }
                        stringBuffer.append(this.TEXT_56);
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                        stringBuffer.append("), match);");
                    } else if (i == data.matchingSteps.size() - 1) {
                        for (Integer req : required) {
                            stringBuffer.append(this.TEXT_58);
                            stringBuffer.append(req);
                            stringBuffer.append(");");
                        }
                        stringBuffer.append(this.TEXT_60);
                        stringBuffer.append(data.rule.getName());
                        stringBuffer.append(this.TEXT_61);
                    }
                    stringBuffer.append(this.TEXT_62);
                } else {
                    String xx = "";
                    if (step.isMatching) {
                        xx = "  ";
                        List<EClass> validTypes = GiraphUtil.getValidTypes(step.node, mainUnit.getModule());
                        stringBuffer.append(this.TEXT_63);
                        stringBuffer.append(GiraphUtil.getNodeName(step.node));
                        stringBuffer.append(":");
                        int j = 0;
                        while (j < validTypes.size()) {
                            stringBuffer.append(this.TEXT_65);
                            stringBuffer.append(j == 0 ? "boolean ok = " : "  ");
                            stringBuffer.append("vertex.getValue().get() == ");
                            stringBuffer.append(typeConstants.get(validTypes.get(j)));
                            stringBuffer.append(j == validTypes.size() - 1 ? ";" : " ||");
                            ++j;
                        }
                        if (rule.isInjectiveMatching() && !step.node.getOutgoing().isEmpty()) {
                            stringBuffer.append(this.TEXT_67);
                            stringBuffer.append(step.node.getOutgoing().size());
                            stringBuffer.append(";");
                        }
                        if (i == 0) {
                            stringBuffer.append(this.TEXT_69);
                        }
                        stringBuffer.append(this.TEXT_70);
                    }
                    if (step.isStart) {
                        stringBuffer.append(this.TEXT_71);
                    } else {
                        stringBuffer.append(this.TEXT_72);
                        stringBuffer.append(xx);
                        stringBuffer.append("      for (Match match : matches) {");
                        if (step.isMatching) {
                            NodeEquivalence equi;
                            stringBuffer.append(this.TEXT_74);
                            stringBuffer.append(xx);
                            stringBuffer.append("        match = match.append(vertex.getId());");
                            if (rule.isInjectiveMatching()) {
                                stringBuffer.append(this.TEXT_76);
                                stringBuffer.append(xx);
                                stringBuffer.append("        if (!match.isInjective()) {");
                                stringBuffer.append(this.TEXT_78);
                                stringBuffer.append(xx);
                                stringBuffer.append("          continue;");
                                stringBuffer.append(this.TEXT_80);
                                stringBuffer.append(xx);
                                stringBuffer.append("        }");
                            }
                            if ((equi = data.requiredNodesEquivalences.get(step.node)) != null && equi.indexOf((Object)step.node) > 0) {
                                Node compareTo = (Node)equi.get(equi.indexOf((Object)step.node) - 1);
                                stringBuffer.append(this.TEXT_82);
                                stringBuffer.append(xx);
                                stringBuffer.append("        if (vertex.getId().compareTo(match.getVertexId(");
                                stringBuffer.append(data.orderedLhsNodes.indexOf(compareTo));
                                stringBuffer.append(")) < 0) {");
                                stringBuffer.append(this.TEXT_85);
                                stringBuffer.append(xx);
                                stringBuffer.append("          continue;");
                                stringBuffer.append(this.TEXT_87);
                                stringBuffer.append(xx);
                                stringBuffer.append("        }");
                            }
                        }
                    }
                    if (step.edge != null && step.verifyEdgeTo != null) {
                        xx = String.valueOf(xx) + "    ";
                        stringBuffer.append(this.TEXT_89);
                        stringBuffer.append(xx);
                        stringBuffer.append("    // Node ");
                        stringBuffer.append(GiraphUtil.getNodeName(step.edge.getSource()));
                        stringBuffer.append(": check for edge to match of ");
                        stringBuffer.append(GiraphUtil.getNodeName(step.edge.getTarget()));
                        stringBuffer.append(" of type \"");
                        stringBuffer.append(step.edge.getType().getName());
                        stringBuffer.append("\":");
                        stringBuffer.append(this.TEXT_94);
                        stringBuffer.append(xx);
                        stringBuffer.append("    VertexId targetId = match.getVertexId(");
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.verifyEdgeTo));
                        stringBuffer.append(");");
                        stringBuffer.append(this.TEXT_97);
                        stringBuffer.append(xx);
                        stringBuffer.append("    for (Edge<VertexId, ByteWritable> edge :");
                        stringBuffer.append(this.TEXT_99);
                        stringBuffer.append(xx);
                        stringBuffer.append("      vertex.getEdges()) {");
                        stringBuffer.append(this.TEXT_101);
                        stringBuffer.append(xx);
                        stringBuffer.append("      if (edge.getValue().get() ==");
                        stringBuffer.append(this.TEXT_103);
                        stringBuffer.append(xx);
                        stringBuffer.append("        ");
                        stringBuffer.append(typeConstants.get(step.edge.getType()));
                        stringBuffer.append(" &&");
                        stringBuffer.append(this.TEXT_106);
                        stringBuffer.append(xx);
                        stringBuffer.append("        edge.getTargetVertexId().equals(targetId)) {");
                    }
                    if (step.sendBackTo != null) {
                        stringBuffer.append(this.TEXT_108);
                        stringBuffer.append(xx);
                        stringBuffer.append("        matchCount++;");
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_110);
                            stringBuffer.append(xx);
                            stringBuffer.append("        LOG.info(\"Vertex \" + vertex.getId() +");
                            stringBuffer.append(this.TEXT_112);
                            stringBuffer.append(xx);
                            stringBuffer.append("          \" sending (partial) match \" + match +");
                            stringBuffer.append(this.TEXT_114);
                            stringBuffer.append(xx);
                            stringBuffer.append("          \" back to vertex \" + match.getVertexId(");
                            stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                            stringBuffer.append("));");
                        }
                        stringBuffer.append(this.TEXT_117);
                        stringBuffer.append(xx);
                        stringBuffer.append("        sendMessage(match.getVertexId(");
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                        stringBuffer.append("), match);");
                    } else if (i == data.matchingSteps.size() - 1) {
                        if (step.isStart) {
                            xx = "";
                        }
                        for (Integer req : required) {
                            stringBuffer.append(this.TEXT_120);
                            stringBuffer.append(xx);
                            stringBuffer.append("        match = match.remove(");
                            stringBuffer.append(req);
                            stringBuffer.append(");");
                        }
                        stringBuffer.append(this.TEXT_123);
                        stringBuffer.append(xx);
                        stringBuffer.append("        if (finalMatches.add(match)) {");
                        stringBuffer.append(this.TEXT_125);
                        stringBuffer.append(xx);
                        stringBuffer.append("          matchCount++;");
                        stringBuffer.append(this.TEXT_127);
                        stringBuffer.append(xx);
                        stringBuffer.append("          if (segment == SEGMENT_COUNT - 1) {");
                        stringBuffer.append(this.TEXT_129);
                        stringBuffer.append(xx);
                        stringBuffer.append("            apply");
                        stringBuffer.append(data.rule.getName());
                        stringBuffer.append("(");
                        stringBuffer.append(this.TEXT_132);
                        stringBuffer.append(xx);
                        stringBuffer.append("              vertex, match, appCount++);");
                        stringBuffer.append(this.TEXT_134);
                        stringBuffer.append(xx);
                        stringBuffer.append("          } else {");
                        stringBuffer.append(this.TEXT_136);
                        stringBuffer.append(xx);
                        stringBuffer.append("            sendMessage(vertex.getId(), match);");
                        stringBuffer.append(this.TEXT_138);
                        stringBuffer.append(xx);
                        stringBuffer.append("          }");
                        stringBuffer.append(this.TEXT_140);
                        stringBuffer.append(xx);
                        stringBuffer.append("        }");
                    }
                    if (step.verifyEdgeTo != null) {
                        stringBuffer.append(this.TEXT_142);
                        stringBuffer.append(xx);
                        stringBuffer.append("        break;");
                        stringBuffer.append(this.TEXT_144);
                        stringBuffer.append(xx);
                        stringBuffer.append("      }");
                        stringBuffer.append(this.TEXT_146);
                        stringBuffer.append(xx);
                        stringBuffer.append("    }");
                        xx = xx.substring(0, xx.length() - 4);
                    }
                    if (step.edge != null && step.verifyEdgeTo == null) {
                        String yy = !step.isStart && step.isMatching ? "  " : "";
                        stringBuffer.append(this.TEXT_148);
                        stringBuffer.append(yy);
                        stringBuffer.append("        matchCount++;");
                        stringBuffer.append(this.TEXT_150);
                        stringBuffer.append(yy);
                        stringBuffer.append("        Set<VertexId> targets = new HashSet<VertexId>();");
                        stringBuffer.append(this.TEXT_152);
                        stringBuffer.append(yy);
                        stringBuffer.append("        for (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {");
                        stringBuffer.append(this.TEXT_154);
                        stringBuffer.append(yy);
                        stringBuffer.append("          if (edge.getValue().get() ==");
                        stringBuffer.append(this.TEXT_156);
                        stringBuffer.append(yy);
                        stringBuffer.append("            ");
                        stringBuffer.append(typeConstants.get(step.edge.getType()));
                        stringBuffer.append(" &&");
                        stringBuffer.append(this.TEXT_159);
                        stringBuffer.append(yy);
                        stringBuffer.append("            targets.add(edge.getTargetVertexId())) {");
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_161);
                            stringBuffer.append(yy);
                            stringBuffer.append("            LOG.info(\"Vertex \" + vertex.getId() +");
                            stringBuffer.append(this.TEXT_163);
                            stringBuffer.append(yy);
                            stringBuffer.append("              \" sending (partial) match \" + match +");
                            stringBuffer.append(this.TEXT_165);
                            stringBuffer.append(yy);
                            stringBuffer.append("              \" forward to vertex \" + edge.getTargetVertexId());");
                        }
                        stringBuffer.append(this.TEXT_167);
                        stringBuffer.append(yy);
                        stringBuffer.append("            sendMessage(edge.getTargetVertexId(), match);");
                        stringBuffer.append(this.TEXT_169);
                        stringBuffer.append(yy);
                        stringBuffer.append("          }");
                        stringBuffer.append(this.TEXT_171);
                        stringBuffer.append(yy);
                        stringBuffer.append("        }");
                    }
                    if (!step.isStart) {
                        stringBuffer.append(this.TEXT_173);
                        stringBuffer.append(xx);
                        stringBuffer.append("      }");
                    }
                    if (step.isMatching) {
                        stringBuffer.append(this.TEXT_175);
                    }
                    if (step.keepMatchesOf != null) {
                        stringBuffer.append(this.TEXT_176);
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.keepMatchesOf));
                        stringBuffer.append(this.TEXT_177);
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_178);
                        }
                        stringBuffer.append(this.TEXT_179);
                    }
                }
                stringBuffer.append(this.TEXT_180);
                ++i;
            }
            stringBuffer.append(this.TEXT_181);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_182);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_183);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_184);
            stringBuffer.append(data.matchingSteps.size() - 1);
            stringBuffer.append(this.TEXT_185);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_186);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_187);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_188);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_189);
            ArrayList<Node> matchNodes = new ArrayList<Node>();
            matchNodes.addAll(data.orderedLhsNodes);
            matchNodes.removeAll(data.requiredNodes);
            int j = 0;
            while (j < matchNodes.size()) {
                Node lhsNode = (Node)matchNodes.get(j);
                Node rhsNode = data.rule.getMappings().getImage(lhsNode, data.rule.getRhs());
                boolean needed = changeInfo.getDeletedNodes().contains(lhsNode);
                for (Edge edge : lhsNode.getAllEdges()) {
                    boolean bl = needed = needed || changeInfo.getDeletedEdges().contains(edge);
                }
                if (rhsNode != null) {
                    for (Edge edge : rhsNode.getAllEdges()) {
                        boolean bl = needed = needed || changeInfo.getCreatedEdges().contains(edge);
                    }
                }
                if (needed) {
                    stringBuffer.append(this.TEXT_190);
                    stringBuffer.append(j);
                    stringBuffer.append(" = match.getVertexId(");
                    stringBuffer.append(j);
                    stringBuffer.append(");");
                }
                ++j;
            }
            if (vertexLogging) {
                stringBuffer.append(this.TEXT_193);
                stringBuffer.append(data.rule.getName());
                stringBuffer.append(" with match \" + match);");
            }
            for (Edge edge : changeInfo.getDeletedEdges()) {
                stringBuffer.append(this.TEXT_195);
                stringBuffer.append(matchNodes.indexOf(edge.getSource()));
                stringBuffer.append(", cur");
                stringBuffer.append(matchNodes.indexOf(edge.getTarget()));
                stringBuffer.append(");");
            }
            for (Node node : changeInfo.getDeletedNodes()) {
                stringBuffer.append(this.TEXT_198);
                stringBuffer.append(matchNodes.indexOf(node));
                stringBuffer.append(");");
            }
            int n = 0;
            for (Node node : changeInfo.getCreatedNodes()) {
                stringBuffer.append(this.TEXT_200);
                stringBuffer.append(n);
                stringBuffer.append(" =");
                if (useUUIDs) {
                    stringBuffer.append(this.TEXT_202);
                } else {
                    stringBuffer.append(this.TEXT_203);
                    stringBuffer.append(n);
                    stringBuffer.append(");");
                }
                stringBuffer.append(this.TEXT_205);
                stringBuffer.append(n++);
                stringBuffer.append(this.TEXT_206);
                stringBuffer.append(typeConstants.get(node.getType()));
                stringBuffer.append("));");
            }
            int e = 0;
            for (Edge edge : changeInfo.getCreatedEdges()) {
                if (changeInfo.getCreatedNodes().contains(edge.getSource())) {
                    stringBuffer.append(this.TEXT_208);
                    stringBuffer.append(e);
                    stringBuffer.append(" = new");
                    stringBuffer.append(changeInfo.getCreatedNodes().indexOf(edge.getSource()));
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(this.TEXT_211);
                    stringBuffer.append(e);
                    stringBuffer.append(" = cur");
                    stringBuffer.append(matchNodes.indexOf(data.rule.getMappings().getOrigin(edge.getSource())));
                    stringBuffer.append(";");
                }
                if (changeInfo.getCreatedNodes().contains(edge.getTarget())) {
                    stringBuffer.append(this.TEXT_214);
                    stringBuffer.append(e);
                    stringBuffer.append(" = new");
                    stringBuffer.append(changeInfo.getCreatedNodes().indexOf(edge.getTarget()));
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(this.TEXT_217);
                    stringBuffer.append(e);
                    stringBuffer.append(" = cur");
                    stringBuffer.append(matchNodes.indexOf(data.rule.getMappings().getOrigin(edge.getTarget())));
                    stringBuffer.append(";");
                }
                stringBuffer.append(this.TEXT_220);
                stringBuffer.append(e);
                stringBuffer.append(this.TEXT_221);
                stringBuffer.append(e);
                stringBuffer.append(this.TEXT_222);
                stringBuffer.append(typeConstants.get(edge.getType()));
                stringBuffer.append(this.TEXT_223);
                stringBuffer.append(e);
                stringBuffer.append(", edge");
                stringBuffer.append(e);
                stringBuffer.append(");");
                ++e;
            }
            stringBuffer.append(this.TEXT_226);
        }
        stringBuffer.append(this.TEXT_227);
        if (needsVertexIdFactory && !useUUIDs) {
            stringBuffer.append(this.TEXT_228);
        }
        stringBuffer.append(this.TEXT_229);
        if (masterLogging) {
            stringBuffer.append(this.TEXT_230);
        }
        stringBuffer.append(this.TEXT_231);
        stringBuffer.append(unitConstants.get(mainUnit));
        stringBuffer.append(", 0, 0);");
        if (!(mainUnit instanceof Rule)) {
            stringBuffer.append(this.TEXT_233);
        }
        stringBuffer.append(this.TEXT_234);
        for (Unit unit : allUnits) {
            stringBuffer.append(this.TEXT_235);
            stringBuffer.append(unitConstants.get(unit));
            stringBuffer.append(this.TEXT_236);
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_237);
            stringBuffer.append(unit instanceof Rule ? ", segment" : "");
            stringBuffer.append(", microstep");
            stringBuffer.append(unit instanceof Rule ? ", ruleApps" : "");
            stringBuffer.append(this.TEXT_239);
        }
        stringBuffer.append(this.TEXT_240);
        int i = 0;
        while (i < rules.size()) {
            stringBuffer.append(this.TEXT_241);
            stringBuffer.append(i == 0 ? "if (" : "  ");
            stringBuffer.append("unit == ");
            stringBuffer.append(String.valueOf(unitConstants.get(rules.get(i))) + (i < rules.size() - 1 ? " ||" : ") {"));
            ++i;
        }
        stringBuffer.append(this.TEXT_243);
        for (Unit unit : allUnits) {
            stringBuffer.append(this.TEXT_244);
            stringBuffer.append(unit.eClass().getName());
            stringBuffer.append(" \"");
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_246);
            if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_247);
            }
            stringBuffer.append(this.TEXT_248);
            if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_249);
            }
            stringBuffer.append(this.TEXT_250);
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_251);
            stringBuffer.append(unit instanceof Rule ? ", int segment" : "");
            stringBuffer.append(", int microstep");
            stringBuffer.append(unit instanceof Rule ? ", long ruleApps" : "");
            stringBuffer.append(") {");
            if (unit instanceof IteratedUnit) {
                int iters = Integer.parseInt(((IteratedUnit)unit).getIterations());
                stringBuffer.append(this.TEXT_254);
                stringBuffer.append(iters);
                stringBuffer.append(this.TEXT_255);
                stringBuffer.append(iters);
                stringBuffer.append(this.TEXT_256);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_257);
                stringBuffer.append(unitConstants.get(((IteratedUnit)unit).getSubUnit()));
                stringBuffer.append(this.TEXT_258);
            } else if (unit instanceof SequentialUnit) {
                SequentialUnit seq = (SequentialUnit)unit;
                stringBuffer.append(this.TEXT_259);
                stringBuffer.append(seq.getSubUnits().size());
                stringBuffer.append(this.TEXT_260);
                int i2 = 0;
                while (i2 < seq.getSubUnits().size()) {
                    stringBuffer.append(this.TEXT_261);
                    stringBuffer.append(i2);
                    stringBuffer.append(this.TEXT_262);
                    stringBuffer.append(unitConstants.get(unit));
                    stringBuffer.append(", 0, ");
                    stringBuffer.append(i2 + 1);
                    stringBuffer.append(this.TEXT_264);
                    stringBuffer.append(unitConstants.get(seq.getSubUnits().get(i2)));
                    stringBuffer.append(this.TEXT_265);
                    ++i2;
                }
                stringBuffer.append(this.TEXT_266);
            } else if (unit instanceof IndependentUnit) {
                IndependentUnit indi = (IndependentUnit)unit;
                stringBuffer.append(this.TEXT_267);
                stringBuffer.append(indi.getSubUnits().size());
                stringBuffer.append(this.TEXT_268);
                stringBuffer.append(indi.getSubUnits().size());
                stringBuffer.append(this.TEXT_269);
                int i3 = 0;
                while (i3 < indi.getSubUnits().size()) {
                    stringBuffer.append(this.TEXT_270);
                    stringBuffer.append(i3);
                    stringBuffer.append(this.TEXT_271);
                    stringBuffer.append(unitConstants.get(unit));
                    stringBuffer.append(this.TEXT_272);
                    stringBuffer.append(unitConstants.get(indi.getSubUnits().get(i3)));
                    stringBuffer.append(this.TEXT_273);
                    ++i3;
                }
                stringBuffer.append(this.TEXT_274);
            } else if (unit instanceof LoopUnit) {
                stringBuffer.append(this.TEXT_275);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_276);
                stringBuffer.append(unitConstants.get(((LoopUnit)unit).getSubUnit()));
                stringBuffer.append(this.TEXT_277);
            } else if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_278);
                stringBuffer.append(((GiraphRuleData)ruleData.get((Object)unit)).matchingSteps.size() - 1);
                stringBuffer.append(this.TEXT_279);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_280);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_281);
            }
            stringBuffer.append(this.TEXT_282);
        }
        stringBuffer.append(this.TEXT_283);
        stringBuffer.append(this.TEXT_284);
        return stringBuffer.toString();
    }
}

