/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;

public class NodeComplexRemoveCommand
extends CompoundCommand {
    protected final EditingDomain domain;
    protected final Collection<Node> nodes;
    Graph owningGraph;

    public NodeComplexRemoveCommand(EditingDomain domain, Graph owner, Collection<Node> nodes) {
        this.domain = domain;
        this.nodes = nodes;
        this.owningGraph = owner;
    }

    protected boolean prepare() {
        this.isPrepared = true;
        this.isExecutable = true;
        return true;
    }

    public void execute() {
        this.removeEdges();
        this.removeMappings();
        this.appendAndExecute((Command)new RemoveCommand(this.domain, (EObject)this.owningGraph, (EStructuralFeature)HenshinPackage.Literals.GRAPH__NODES, this.nodes));
    }

    private void removeEdges() {
        HashSet<Edge> edgeSet = new HashSet<Edge>();
        for (Node node : this.nodes) {
            for (Edge edge : node.getAllEdges()) {
                if (edge.getGraph() == null) continue;
                edgeSet.add(edge);
            }
        }
        if (!edgeSet.isEmpty()) {
            this.appendAndExecute((Command)new DeleteCommand(this.domain, edgeSet));
        }
    }

    private void removeMappings() {
        HashSet<Mapping> mappingSet = new HashSet<Mapping>();
        EObject graphContainer = this.owningGraph.eContainer();
        if (graphContainer == null) {
            return;
        }
        if (graphContainer instanceof Rule) {
            Rule rule = (Rule)graphContainer;
            this.filterMappings((List<Mapping>)rule.getMappings(), mappingSet);
            this.filterMappings((List<Mapping>)rule.getMultiMappings(), mappingSet);
            for (Rule mRule : rule.getMultiRules()) {
                this.filterMappings((List<Mapping>)mRule.getMultiMappings(), mappingSet);
            }
        } else if (graphContainer instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)graphContainer;
            this.filterMappings((List<Mapping>)nc.getMappings(), mappingSet);
        } else {
            return;
        }
        if (this.owningGraph.getFormula() != null) {
            ArrayList<NestedCondition> ncList = new ArrayList<NestedCondition>();
            this.findDirectlyContainedNestedConditions(this.owningGraph.getFormula(), ncList);
            for (NestedCondition n : ncList) {
                this.filterMappings((List<Mapping>)n.getMappings(), mappingSet);
            }
        }
        if (!mappingSet.isEmpty()) {
            this.appendAndExecute((Command)new DeleteCommand(this.domain, mappingSet));
        }
    }

    private void findDirectlyContainedNestedConditions(Formula f, List<NestedCondition> list) {
        if (f instanceof UnaryFormula) {
            UnaryFormula uf = (UnaryFormula)f;
            this.findDirectlyContainedNestedConditions(uf.getChild(), list);
        } else if (f instanceof BinaryFormula) {
            BinaryFormula bf = (BinaryFormula)f;
            this.findDirectlyContainedNestedConditions(bf.getLeft(), list);
            this.findDirectlyContainedNestedConditions(bf.getRight(), list);
        } else if (f != null) {
            list.add((NestedCondition)f);
        }
    }

    private void filterMappings(List<Mapping> unfilteredList, Set<Mapping> targetSet) {
        block0: for (Mapping mapping : unfilteredList) {
            if (mapping.eContainer() == null) continue;
            for (Node node : this.nodes) {
                if (mapping.getImage() != node && mapping.getOrigin() != node) continue;
                targetSet.add(mapping);
                continue block0;
            }
        }
    }
}

