/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.Change;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.ChangeImpl;
import org.eclipse.emf.henshin.interpreter.impl.MatchImpl;
import org.eclipse.emf.henshin.interpreter.info.ConditionInfo;
import org.eclipse.emf.henshin.interpreter.info.RuleChangeInfo;
import org.eclipse.emf.henshin.interpreter.info.RuleInfo;
import org.eclipse.emf.henshin.interpreter.info.VariableInfo;
import org.eclipse.emf.henshin.interpreter.matching.conditions.AndFormula;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ApplicationCondition;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ConditionHandler;
import org.eclipse.emf.henshin.interpreter.matching.conditions.IFormula;
import org.eclipse.emf.henshin.interpreter.matching.conditions.NotFormula;
import org.eclipse.emf.henshin.interpreter.matching.conditions.OrFormula;
import org.eclipse.emf.henshin.interpreter.matching.conditions.XorFormula;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Solution;
import org.eclipse.emf.henshin.interpreter.matching.constraints.SolutionFinder;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Xor;

public class EngineImpl
implements Engine {
    protected final Map<String, Object> options;
    protected final ScriptEngine scriptEngine;
    protected final Map<Rule, RuleInfo> ruleInfos = new HashMap<Rule, RuleInfo>();
    protected final Map<Graph, MatchingOptions> graphOptions = new HashMap<Graph, MatchingOptions>();
    protected final EContentAdapter ruleListener;
    protected boolean sortVariables = true;
    private static final EcorePackage ECORE = EcorePackage.eINSTANCE;

    public EngineImpl() {
        this.options = new EngineOptions();
        this.scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        if (this.scriptEngine == null) {
            System.err.println("Warning: cannot find JavaScript engine");
        } else {
            try {
                this.scriptEngine.eval("importPackage(java.lang)");
            }
            catch (Throwable throwable) {
                System.err.println("Warning: error importing java.lang package in JavaScript engine");
            }
        }
        this.ruleListener = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                int eventType = notification.getEventType();
                if (eventType == 9 || eventType == 8) {
                    return;
                }
                if (notification.getNotifier() instanceof EObject) {
                    EObject object = (EObject)notification.getNotifier();
                    while (object != null) {
                        if (object instanceof Rule) {
                            EngineImpl.this.ruleInfos.remove(object);
                            object.eAdapters().remove((Object)EngineImpl.this.ruleListener);
                        }
                        if (object instanceof Graph) {
                            EngineImpl.this.graphOptions.remove(object);
                        }
                        object = object.eContainer();
                    }
                }
            }
        };
    }

    @Override
    public Iterable<Match> findMatches(Rule rule, EGraph graph, Match partialMatch) {
        if (rule == null || graph == null) {
            throw new NullPointerException("Rule and graph must not be null");
        }
        if (partialMatch == null) {
            partialMatch = new MatchImpl(rule);
        }
        return new MatchGenerator(rule, graph, partialMatch);
    }

    protected RuleInfo getRuleInfo(Rule rule) {
        RuleInfo ruleInfo = this.ruleInfos.get(rule);
        if (ruleInfo == null) {
            ruleInfo = new RuleInfo(rule, this);
            this.ruleInfos.put(rule, ruleInfo);
            rule.eAdapters().add((Object)this.ruleListener);
            for (Node node : ruleInfo.getChangeInfo().getCreatedNodes()) {
                if (node.getType() == null) {
                    throw new RuntimeException("Missing type for " + node);
                }
                if (node.getType().getEPackage() != null && node.getType().getEPackage().getEFactoryInstance() != null) continue;
                throw new RuntimeException("Missing factory for '" + node + "'. Register the corresponding package, e.g. using PackageName.eINSTANCE.getName().");
            }
        }
        return ruleInfo;
    }

    public void clearCache() {
        this.ruleInfos.clear();
    }

    @Override
    public Change createChange(Rule rule, EGraph graph, Match completeMatch, Match resultMatch) {
        if (resultMatch == null) {
            resultMatch = new MatchImpl(rule, true);
        }
        ChangeImpl.CompoundChangeImpl complexChange = new ChangeImpl.CompoundChangeImpl(graph);
        this.createChanges(rule, graph, completeMatch, resultMatch, complexChange);
        return complexChange;
    }

    public void createChanges(Rule rule, EGraph graph, Match completeMatch, Match resultMatch, Change.CompoundChange complexChange) {
        RuleChangeInfo ruleChange = this.getRuleInfo(rule).getChangeInfo();
        List<Change> changes = complexChange.getChanges();
        for (Parameter param : rule.getParameters()) {
            Object value = completeMatch.getParameterValue(param);
            resultMatch.setParameterValue(param, value);
            this.scriptEngine.put(param.getName(), value);
        }
        for (Node node : ruleChange.getCreatedNodes()) {
            EClass type = node.getType();
            EObject createdObject = type.getEPackage().getEFactoryInstance().create(type);
            changes.add(new ChangeImpl.ObjectChangeImpl(graph, createdObject, true));
            resultMatch.setNodeTarget(node, createdObject);
        }
        for (Node node : ruleChange.getDeletedNodes()) {
            EObject deletedObject = completeMatch.getNodeTarget(node);
            changes.add(new ChangeImpl.ObjectChangeImpl(graph, deletedObject, false));
            if (rule.isCheckDangling()) continue;
            Collection removedEdges = graph.getCrossReferenceAdapter().getInverseReferences(deletedObject);
            for (EStructuralFeature.Setting edge : removedEdges) {
                changes.add(new ChangeImpl.ReferenceChangeImpl(graph, edge.getEObject(), deletedObject, (EReference)edge.getEStructuralFeature(), false));
            }
        }
        for (Node node : ruleChange.getPreservedNodes()) {
            Node lhsNode = rule.getMappings().getOrigin(node);
            resultMatch.setNodeTarget(node, completeMatch.getNodeTarget(lhsNode));
        }
        for (Edge edge : ruleChange.getDeletedEdges()) {
            changes.add(new ChangeImpl.ReferenceChangeImpl(graph, completeMatch.getNodeTarget(edge.getSource()), completeMatch.getNodeTarget(edge.getTarget()), edge.getType(), false));
        }
        for (Edge edge : ruleChange.getCreatedEdges()) {
            changes.add(new ChangeImpl.ReferenceChangeImpl(graph, resultMatch.getNodeTarget(edge.getSource()), resultMatch.getNodeTarget(edge.getTarget()), edge.getType(), true));
        }
        for (Edge edge : ruleChange.getIndexChanges()) {
            Integer newIndex = edge.getIndexConstant();
            if (newIndex == null) {
                Parameter param = rule.getParameter(edge.getIndex());
                if (param != null) {
                    newIndex = ((Number)resultMatch.getParameterValue(param)).intValue();
                } else {
                    try {
                        newIndex = ((Number)this.scriptEngine.eval(edge.getIndex())).intValue();
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException("Error evaluating edge index expression \"" + edge.getIndex() + "\": " + e.getMessage(), e);
                    }
                }
            }
            changes.add(new ChangeImpl.IndexChangeImpl(graph, resultMatch.getNodeTarget(edge.getSource()), resultMatch.getNodeTarget(edge.getTarget()), edge.getType(), newIndex));
        }
        for (Attribute attribute : ruleChange.getAttributeChanges()) {
            EObject object = resultMatch.getNodeTarget(attribute.getNode());
            Parameter param = rule.getParameter(attribute.getValue());
            Object value = param != null ? EngineImpl.castValueToDataType(resultMatch.getParameterValue(param), attribute.getType().getEAttributeType(), attribute.getType().isMany()) : this.evalAttributeExpression(attribute);
            changes.add(new ChangeImpl.AttributeChangeImpl(graph, object, attribute.getType(), value));
        }
        for (Rule multiRule : rule.getMultiRules()) {
            for (Match multiMatch : completeMatch.getMultiMatches(multiRule)) {
                MatchImpl multiResultMatch = new MatchImpl(multiRule, true);
                for (Mapping mapping : multiRule.getMultiMappings()) {
                    if (!mapping.getImage().getGraph().isRhs()) continue;
                    multiResultMatch.setNodeTarget(mapping.getImage(), resultMatch.getNodeTarget(mapping.getOrigin()));
                }
                this.createChanges(multiRule, graph, multiMatch, multiResultMatch, complexChange);
                resultMatch.getMultiMatches(multiRule).add(multiResultMatch);
            }
        }
    }

    public Object evalAttributeExpression(Attribute attribute) {
        Object constant = attribute.getConstant();
        if (constant != null) {
            return constant;
        }
        if (attribute.isNull()) {
            return null;
        }
        try {
            return EngineImpl.castValueToDataType(this.scriptEngine.eval(attribute.getValue()), attribute.getType().getEAttributeType(), attribute.getType().isMany());
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static Object castValueToDataType(Object value, EDataType type, boolean isMany) {
        if (isMany) {
            BasicEList list = new BasicEList();
            if (value instanceof Collection) {
                for (Object elem : (Collection)value) {
                    list.add(EngineImpl.castValueToDataType(elem, type, false));
                }
            } else if (value != null) {
                list.add(value);
            }
            return list;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (type == ECORE.getEInt() || type == ECORE.getEIntegerObject()) {
                return ((Number)value).intValue();
            }
            if (type == ECORE.getEDouble() || type == ECORE.getEDoubleObject()) {
                return ((Number)value).doubleValue();
            }
            if (type == ECORE.getEByte() || type == ECORE.getEByteObject()) {
                return ((Number)value).byteValue();
            }
            if (type == ECORE.getELong() || type == ECORE.getELongObject()) {
                return ((Number)value).longValue();
            }
            if (type == ECORE.getEFloat() || type == ECORE.getEFloatObject()) {
                return Float.valueOf(((Number)value).floatValue());
            }
        }
        if (type == ECORE.getEString()) {
            if (value != null) {
                value = value.toString();
            }
            return value;
        }
        if (type == ECORE.getEJavaObject() || type == ECORE.getEJavaClass()) {
            return value;
        }
        return EcoreUtil.createFromString((EDataType)type, (String)value.toString());
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    protected MatchingOptions getGraphOptions(Graph graph) {
        MatchingOptions options = this.graphOptions.get(graph);
        if (options == null) {
            options = new MatchingOptions();
            Rule rule = graph.getRule();
            Boolean injective = (Boolean)this.options.get("INJECTIVE_MATCHING");
            Boolean dangling = (Boolean)this.options.get("CHECK_DANGLING");
            Boolean determistic = (Boolean)this.options.get("DETERMINISTIC");
            options.injective = injective != null ? injective.booleanValue() : rule.isInjectiveMatching();
            options.dangling = dangling != null ? dangling.booleanValue() : rule.isCheckDangling();
            boolean bl = options.deterministic = determistic == null || determistic != false;
            if (graph != rule.getLhs()) {
                options.injective = true;
                options.dangling = false;
                options.deterministic = true;
            }
            this.graphOptions.put(graph, options);
        }
        return options;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public UnaryConstraint createUserConstraints(Node node) {
        return null;
    }

    public BinaryConstraint createUserConstraints(Edge edge) {
        return null;
    }

    public UnaryConstraint createUserConstraints(Attribute attribute) {
        return null;
    }

    private class EngineOptions
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        private EngineOptions() {
        }

        @Override
        public Object put(String key, Object value) {
            Object result = super.put(key, value);
            EngineImpl.this.graphOptions.clear();
            this.updateSortVariablsFlag();
            return result;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            super.putAll(map);
            EngineImpl.this.graphOptions.clear();
            this.updateSortVariablsFlag();
        }

        @Override
        public Object remove(Object key) {
            Object result = super.remove(key);
            EngineImpl.this.graphOptions.clear();
            this.updateSortVariablsFlag();
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            EngineImpl.this.graphOptions.clear();
            this.updateSortVariablsFlag();
        }

        private void updateSortVariablsFlag() {
            Boolean sort = (Boolean)this.get("SORT_VARIABLES");
            EngineImpl.this.sortVariables = sort != null ? sort : true;
        }
    }

    private final class MatchFinder
    implements Iterator<Match> {
        private Match nextMatch;
        private boolean computedNextMatch;
        private final EGraph graph;
        private final SolutionFinder solutionFinder;
        private final Rule rule;
        private final RuleInfo ruleInfo;
        private final Set<EObject> usedObjects;

        public MatchFinder(Rule rule, EGraph graph, Match partialMatch, Set<EObject> usedObjects) {
            this.rule = rule;
            this.ruleInfo = EngineImpl.this.getRuleInfo(rule);
            this.graph = graph;
            this.usedObjects = usedObjects;
            this.solutionFinder = this.createSolutionFinder(partialMatch);
        }

        @Override
        public boolean hasNext() {
            if (!this.computedNextMatch) {
                this.computeNextMatch();
                this.computedNextMatch = true;
            }
            return this.nextMatch != null;
        }

        @Override
        public Match next() {
            if (this.hasNext()) {
                this.computedNextMatch = false;
            }
            return this.nextMatch;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void computeNextMatch() {
            if (this.solutionFinder == null) {
                this.nextMatch = null;
                return;
            }
            Solution solution = this.solutionFinder.getNextSolution();
            if (solution == null) {
                this.nextMatch = null;
                return;
            }
            this.nextMatch = new MatchImpl(this.rule);
            Map<Node, Variable> node2var = this.ruleInfo.getVariableInfo().getNode2variable();
            for (Map.Entry<String, Object> entry : solution.parameterValues.entrySet()) {
                Parameter param = this.nextMatch.getUnit().getParameter(entry.getKey());
                if (param == null) continue;
                this.nextMatch.setParameterValue(param, entry.getValue());
            }
            for (Node node : this.rule.getLhs().getNodes()) {
                this.nextMatch.setNodeTarget(node, solution.objectMatches.get(node2var.get(node)));
            }
            for (Rule multiRule : this.rule.getMultiRules()) {
                HashSet<EObject> usedKernelObjects = new HashSet<EObject>(this.usedObjects);
                usedKernelObjects.addAll(this.nextMatch.getNodeTargets());
                MatchImpl partialMultiMatch = new MatchImpl(multiRule);
                for (Parameter param : this.rule.getParameters()) {
                    Parameter multiParam = multiRule.getParameter(param.getName());
                    if (multiParam == null) continue;
                    partialMultiMatch.setParameterValue(multiParam, this.nextMatch.getParameterValue(param));
                }
                for (Mapping mapping : multiRule.getMultiMappings()) {
                    partialMultiMatch.setNodeTarget(mapping.getImage(), this.nextMatch.getNodeTarget(mapping.getOrigin()));
                }
                MatchFinder matchFinder = new MatchFinder(multiRule, this.graph, partialMultiMatch, usedKernelObjects);
                List<Match> nestedMatches = this.nextMatch.getMultiMatches(multiRule);
                while (matchFinder.hasNext()) {
                    nestedMatches.add(matchFinder.next());
                }
            }
        }

        protected SolutionFinder createSolutionFinder(Match partialMatch) {
            Map<Object, Object> graphMap;
            RuleInfo ruleInfo = EngineImpl.this.getRuleInfo(this.rule);
            ConditionInfo conditionInfo = ruleInfo.getConditionInfo();
            VariableInfo varInfo = ruleInfo.getVariableInfo();
            ConditionHandler conditionHandler = new ConditionHandler(conditionInfo.getConditionParameters(), EngineImpl.this.scriptEngine);
            HashMap<Variable, DomainSlot> domainMap = new HashMap<Variable, DomainSlot>();
            for (Variable mainVariable : varInfo.getMainVariables()) {
                Node node = varInfo.getVariableForNode(mainVariable);
                MatchingOptions opt = EngineImpl.this.getGraphOptions(node.getGraph());
                DomainSlot domainSlot = new DomainSlot(conditionHandler, this.usedObjects, opt.injective, opt.dangling, opt.deterministic);
                EObject target = partialMatch.getNodeTarget(node);
                if (target != null) {
                    domainSlot.fixInstantiation(target);
                }
                for (Variable dependendVariable : varInfo.getDependendVariables(mainVariable)) {
                    domainMap.put(dependendVariable, domainSlot);
                }
            }
            for (Parameter param : this.rule.getParameters()) {
                Object value = partialMatch.getParameterValue(param);
                if (value == null || conditionHandler.setParameter(param.getName(), value)) continue;
                return null;
            }
            if (EngineImpl.this.sortVariables) {
                graphMap = new HashMap();
                for (Map.Entry<Graph, List<Variable>> entry : ruleInfo.getVariableInfo().getGraph2variables().entrySet()) {
                    ArrayList sorted = new ArrayList(entry.getValue());
                    Collections.sort(sorted, new VariableComparator(this.graph, varInfo, partialMatch));
                    graphMap.put(entry.getKey(), sorted);
                }
            } else {
                graphMap = ruleInfo.getVariableInfo().getGraph2variables();
            }
            SolutionFinder solutionFinder = new SolutionFinder(this.graph, domainMap, conditionHandler);
            solutionFinder.variables = (List)graphMap.get(this.rule.getLhs());
            solutionFinder.formula = this.initFormula(this.rule.getLhs().getFormula(), this.graph, graphMap, domainMap);
            return solutionFinder;
        }

        private IFormula initFormula(Formula formula, EGraph graph, Map<Graph, List<Variable>> graphMap, Map<Variable, DomainSlot> domainMap) {
            if (formula instanceof And) {
                And and = (And)formula;
                IFormula left = this.initFormula(and.getLeft(), graph, graphMap, domainMap);
                IFormula right = this.initFormula(and.getRight(), graph, graphMap, domainMap);
                return new AndFormula(left, right);
            }
            if (formula instanceof Or) {
                Or or = (Or)formula;
                IFormula left = this.initFormula(or.getLeft(), graph, graphMap, domainMap);
                IFormula right = this.initFormula(or.getRight(), graph, graphMap, domainMap);
                return new OrFormula(left, right);
            }
            if (formula instanceof Xor) {
                Xor xor = (Xor)formula;
                IFormula left = this.initFormula(xor.getLeft(), graph, graphMap, domainMap);
                IFormula right = this.initFormula(xor.getRight(), graph, graphMap, domainMap);
                return new XorFormula(left, right);
            }
            if (formula instanceof Not) {
                Not not = (Not)formula;
                IFormula child = this.initFormula(not.getChild(), graph, graphMap, domainMap);
                return new NotFormula(child);
            }
            if (formula instanceof NestedCondition) {
                NestedCondition nc = (NestedCondition)formula;
                return this.initApplicationCondition(nc, graph, graphMap, domainMap);
            }
            return IFormula.TRUE;
        }

        private ApplicationCondition initApplicationCondition(NestedCondition nc, EGraph graph, Map<Graph, List<Variable>> graphMap, Map<Variable, DomainSlot> domainMap) {
            ApplicationCondition ac = new ApplicationCondition(graph, domainMap);
            ac.variables = graphMap.get(nc.getConclusion());
            ac.formula = this.initFormula(nc.getConclusion().getFormula(), graph, graphMap, domainMap);
            return ac;
        }
    }

    private final class MatchGenerator
    implements Iterable<Match> {
        private final Rule rule;
        private final EGraph graph;
        private final Match partialMatch;

        public MatchGenerator(Rule rule, EGraph graph, Match partialMatch) {
            this.rule = rule;
            this.graph = graph;
            this.partialMatch = partialMatch;
        }

        @Override
        public Iterator<Match> iterator() {
            return new MatchFinder(this.rule, this.graph, this.partialMatch, new HashSet<EObject>());
        }
    }

    private static class MatchingOptions {
        boolean injective;
        boolean dangling;
        boolean deterministic;

        private MatchingOptions() {
        }
    }

    private class VariableComparator
    implements Comparator<Variable> {
        private final EGraph graph;
        private final VariableInfo varInfo;
        private final Match partialMatch;

        public VariableComparator(EGraph graph, VariableInfo varInfo, Match partialMatch) {
            this.graph = graph;
            this.varInfo = varInfo;
            this.partialMatch = partialMatch;
        }

        @Override
        public int compare(Variable v1, Variable v2) {
            int s;
            Node n1 = this.varInfo.getVariableForNode(v1);
            if (n1 == null) {
                return 1;
            }
            Node n2 = this.varInfo.getVariableForNode(v2);
            if (n2 == null) {
                return -1;
            }
            if (this.partialMatch != null) {
                if (this.isNodeObjectMatched(n1)) {
                    return -1;
                }
                if (this.isNodeObjectMatched(n2)) {
                    return 1;
                }
                if (this.isNodeAttributeMatched(n1)) {
                    return -1;
                }
                if (this.isNodeAttributeMatched(n2)) {
                    return 1;
                }
            }
            if ((s = this.graph.getDomainSize(v1.typeConstraint.type, v1.typeConstraint.strictTyping) - this.graph.getDomainSize(v2.typeConstraint.type, v2.typeConstraint.strictTyping)) != 0) {
                return s;
            }
            int a = n2.getAttributes().size() - n1.getAttributes().size();
            if (a != 0) {
                return a;
            }
            return n2.getOutgoing().size() - n1.getOutgoing().size();
        }

        private boolean isNodeObjectMatched(Node node) {
            return this.partialMatch.getNodeTarget(node) != null;
        }

        private boolean isNodeAttributeMatched(Node node) {
            for (Attribute attribute : node.getAttributes()) {
                Parameter param;
                String value = attribute.getValue();
                if (value == null || (param = node.getGraph().getRule().getParameter(value)) == null || this.partialMatch.getParameterValue(param) == null) continue;
                return true;
            }
            return false;
        }
    }
}

