/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.menuContributors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.editor.commands.CreateEdgeCommand;
import org.eclipse.emf.henshin.editor.commands.MenuContributor;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class CreateEdgeCommandMenuContributor
extends MenuContributor {
    public static MenuContributor INSTANCE = new CreateEdgeCommandMenuContributor();
    private static final String COMMAND_LABEL = "CreateEdge";
    private static final String COMMAND_LABEL_UR = "CreateEdge_UnnamedReference";
    private static final String COMMAND_LABEL_EM = "CreateEdge_ExceededMultiplicity";
    private static final String COMMAND_LABEL_AE = "CreateEdge_AlreadyExists";
    private static final String COMMAND_LABEL_DU = "CreateEdge_DerivedUnmapped";
    private static final String COMMAND_LABEL_DERIVED = "CreateEdge_DerivedReference";

    @Override
    public void contributeActions(IMenuManager menuManager, List<?> selection) {
        String label;
        MenuManager mm;
        if (selection.size() != 2) {
            return;
        }
        if (!QuantUtil.allInstancesOf(Node.class, selection.toArray())) {
            return;
        }
        Node sourceNode = (Node)selection.get(0);
        Node targetNode = (Node)selection.get(1);
        if (!QuantUtil.allIdenticalAndNotNull(sourceNode.getGraph(), targetNode.getGraph())) {
            return;
        }
        boolean includeDerived = false;
        includeDerived = true;
        if (QuantUtil.anyNull(sourceNode.getType(), targetNode.getType())) {
            return;
        }
        ArrayList<EReference> references = new ArrayList<EReference>();
        ArrayList<EReference> referencesWithExceededMultiplicity = new ArrayList<EReference>();
        ArrayList<EReference> existingReferences = new ArrayList<EReference>();
        ArrayList<EReference> derivedUnmappedReferences = new ArrayList<EReference>();
        block0: for (EReference reference : sourceNode.getType().getEAllReferences()) {
            EClass refType;
            if (!(reference.getEType() instanceof EClass) || !(refType = (EClass)reference.getEType()).isSuperTypeOf(targetNode.getType()) && refType.getName() != "EObject") continue;
            if (reference.isDerived() && !includeDerived) {
                derivedUnmappedReferences.add(reference);
                continue;
            }
            int multiplicityCounter = 0;
            for (Edge edge : sourceNode.getOutgoing()) {
                if (reference.equals(edge.getType())) {
                    ++multiplicityCounter;
                }
                if (edge.getTarget() != targetNode || !reference.equals(edge.getType())) continue;
                existingReferences.add(edge.getType());
                continue block0;
            }
            if (reference.getUpperBound() == -1 || multiplicityCounter < reference.getUpperBound()) {
                references.add(reference);
                continue;
            }
            referencesWithExceededMultiplicity.add(reference);
        }
        ArrayList<EReference> inverseReferences = new ArrayList<EReference>();
        ArrayList<EReference> inverseReferencesWithExceededMultiplicity = new ArrayList<EReference>();
        ArrayList<EReference> inverseExistingReferences = new ArrayList<EReference>();
        ArrayList<EReference> inverseDerivedUnmappedReferences = new ArrayList<EReference>();
        block2: for (EReference reference : targetNode.getType().getEAllReferences()) {
            EClass refType;
            if (!(reference.getEType() instanceof EClass) || !(refType = (EClass)reference.getEType()).isSuperTypeOf(sourceNode.getType()) && refType.getName() != "EObject") continue;
            if (reference.isDerived() && !includeDerived) {
                inverseDerivedUnmappedReferences.add(reference);
                continue;
            }
            int multiplicityCounter = 0;
            for (Edge edge : targetNode.getOutgoing()) {
                if (reference.equals(edge.getType())) {
                    ++multiplicityCounter;
                }
                if (edge.getTarget() != sourceNode || !reference.equals(edge.getType())) continue;
                inverseExistingReferences.add(edge.getType());
                continue block2;
            }
            if (reference.getUpperBound() == -1 || multiplicityCounter < reference.getUpperBound()) {
                inverseReferences.add(reference);
                continue;
            }
            inverseReferencesWithExceededMultiplicity.add(reference);
        }
        if (references.size() + referencesWithExceededMultiplicity.size() + existingReferences.size() + derivedUnmappedReferences.size() > 0) {
            mm = new MenuManager(String.valueOf(this.getLabel(COMMAND_LABEL)) + " " + sourceNode.getName() + " -> " + targetNode.getName());
            for (EReference ref : references) {
                CreateEdgeCommand cmd = new CreateEdgeCommand(this.domain, sourceNode.getGraph(), sourceNode, targetNode, ref);
                label = ref.getName();
                if (ref.isDerived()) {
                    label = String.valueOf(label) + this.getLabel(COMMAND_LABEL_DERIVED);
                }
                label = label.length() > 0 ? label : this.getLabel(COMMAND_LABEL_UR);
                mm.add(this.createAction(label, (Command)cmd));
            }
            for (EReference ref : referencesWithExceededMultiplicity) {
                mm.add(this.createUnrunnableItem(String.valueOf(ref.getName()) + " * " + this.getLabel(COMMAND_LABEL_EM) + " *"));
            }
            for (EReference ref : existingReferences) {
                mm.add(this.createUnrunnableItem(String.valueOf(ref.getName()) + " * " + this.getLabel(COMMAND_LABEL_AE) + " *"));
            }
            for (EReference ref : derivedUnmappedReferences) {
                mm.add(this.createUnrunnableItem(String.valueOf(ref.getName()) + " * " + this.getLabel(COMMAND_LABEL_DU) + " *"));
            }
            menuManager.add((IContributionItem)mm);
        }
        if (inverseReferences.size() + inverseReferencesWithExceededMultiplicity.size() + inverseExistingReferences.size() > 0) {
            mm = new MenuManager(String.valueOf(this.getLabel(COMMAND_LABEL)) + " " + targetNode.getName() + " -> " + sourceNode.getName());
            for (EReference ref : inverseReferences) {
                CreateEdgeCommand cmd = new CreateEdgeCommand(this.domain, targetNode.getGraph(), targetNode, sourceNode, ref);
                label = ref.getName();
                if (ref.isDerived()) {
                    label = String.valueOf(label) + this.getLabel(COMMAND_LABEL_DERIVED);
                }
                mm.add(this.createAction(label, (Command)cmd));
            }
            for (EReference ref : inverseReferencesWithExceededMultiplicity) {
                mm.add(this.createUnrunnableItem(String.valueOf(ref.getName()) + " * " + this.getLabel(COMMAND_LABEL_EM) + " *"));
            }
            for (EReference ref : inverseExistingReferences) {
                mm.add(this.createUnrunnableItem(String.valueOf(ref.getName()) + " * " + this.getLabel(COMMAND_LABEL_AE) + " *"));
            }
            for (EReference ref : inverseDerivedUnmappedReferences) {
                mm.add(this.createUnrunnableItem(String.valueOf(ref.getName()) + " * " + this.getLabel(COMMAND_LABEL_DU) + " *"));
            }
            menuManager.add((IContributionItem)mm);
        }
    }
}

