/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.editor.filter.IFilterChangeListener;
import org.eclipse.emf.henshin.presentation.HenshinEditorPlugin;
import org.eclipse.emf.henshin.provider.filter.IFilterProvider;
import org.eclipse.jface.preference.IPreferenceStore;

public class FilterController
implements IFilterProvider {
    private Collection<IFilterChangeListener> listeners = new ArrayList<IFilterChangeListener>();
    private String prefPrefix = "filterEClassifier_";
    private IPreferenceStore store;
    private Map<EClass, Boolean> filterMap = new HashMap<EClass, Boolean>();

    public FilterController() {
        this.store = HenshinEditorPlugin.getPlugin().getPreferenceStore();
    }

    public void addFilterListener(IFilterChangeListener iFilterListener) {
        this.listeners.add(iFilterListener);
    }

    public boolean isFiltered(EStructuralFeature feature) {
        if (feature instanceof EReference) {
            return this.isFiltered(((EReference)feature).getEReferenceType());
        }
        return false;
    }

    public boolean isFiltered(EClass eClass) {
        if (!this.filterMap.containsKey(eClass)) {
            this.filterMap.put(eClass, this.load(eClass));
        }
        return this.filterMap.get(eClass);
    }

    protected void setFiltered(boolean isFiltered, EClass eClass) {
        this.filterMap.put(eClass, isFiltered);
        this.save(eClass, isFiltered);
        for (IFilterChangeListener listener : this.listeners) {
            listener.filterChanged();
        }
    }

    public boolean load(EClass eClass) {
        return this.store.getBoolean(this.getKey((EClassifier)eClass));
    }

    public void save(EClass classifier, boolean filtered) {
        this.store.setValue(this.getKey((EClassifier)classifier), filtered);
    }

    private String getKey(EClassifier cl) {
        return String.valueOf(this.prefPrefix) + cl.getName();
    }
}

