/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.EEFPropertiesUiLegacyPlugin;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemDescriptor;
import org.eclipse.eef.properties.ui.legacy.internal.extension.IItemRegistry;

public class LegacyPropertyTabRegistry
implements IItemRegistry {
    private static final String TOP = "top";
    private Map<String, IItemDescriptor> id2descriptors = new HashMap<String, IItemDescriptor>();

    public List<IEEFTabDescriptor> getPropertyTabs() {
        List<IEEFTabDescriptor> tabs = this.readTabDescriptors();
        List<String> propertyCategories = this.readPropertyCategories();
        List<IEEFTabDescriptor> sortedTabs = this.sortTabDescriptorsByCategory(tabs, propertyCategories);
        sortedTabs = this.sortTabDescriptorsByAfterTab(sortedTabs, propertyCategories);
        return sortedTabs;
    }

    private List<IEEFTabDescriptor> sortTabDescriptorsByCategory(List<IEEFTabDescriptor> tabs, final List<String> propertyCategories) {
        ArrayList<IEEFTabDescriptor> sortedTabs = new ArrayList<IEEFTabDescriptor>(tabs);
        if (propertyCategories != null) {
            Collections.sort(sortedTabs, new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    IEEFTabDescriptor one = (IEEFTabDescriptor)arg0;
                    IEEFTabDescriptor two = (IEEFTabDescriptor)arg1;
                    String categoryOne = one.getCategory();
                    String categoryTwo = two.getCategory();
                    if (categoryOne != null && categoryTwo != null) {
                        int categoryOnePosition = LegacyPropertyTabRegistry.this.getIndex(propertyCategories.toArray(), categoryOne);
                        int categoryTwoPosition = LegacyPropertyTabRegistry.this.getIndex(propertyCategories.toArray(), categoryTwo);
                        return categoryOnePosition - categoryTwoPosition;
                    }
                    return 0;
                }
            });
        }
        return sortedTabs;
    }

    private List<IEEFTabDescriptor> sortTabDescriptorsByAfterTab(List<IEEFTabDescriptor> tabs, List<String> propertyCategories) {
        if (tabs.size() == 0 || propertyCategories == null) {
            return tabs;
        }
        ArrayList<IEEFTabDescriptor> sorted = new ArrayList<IEEFTabDescriptor>();
        int categoryIndex = 0;
        int i = 0;
        while (i < propertyCategories.size()) {
            ArrayList<IEEFTabDescriptor> categoryList = new ArrayList<IEEFTabDescriptor>();
            String category = propertyCategories.get(i);
            int topOfCategory = categoryIndex;
            int endOfCategory = categoryIndex;
            while (endOfCategory < tabs.size() && tabs.get(endOfCategory).getCategory().equals(category)) {
                ++endOfCategory;
            }
            int j = topOfCategory;
            while (j < endOfCategory) {
                IEEFTabDescriptor tab = tabs.get(j);
                if (tab.getAfterTab().equals(TOP)) {
                    categoryList.add(0, tabs.get(j));
                } else {
                    categoryList.add(tabs.get(j));
                }
                ++j;
            }
            Collections.sort(categoryList, new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    IEEFTabDescriptor one = (IEEFTabDescriptor)arg0;
                    IEEFTabDescriptor two = (IEEFTabDescriptor)arg1;
                    int result = 0;
                    if (two.getAfterTab().equals(one.getId())) {
                        result = -1;
                    } else if (one.getAfterTab().equals(two.getId())) {
                        result = 1;
                    }
                    return result;
                }
            });
            j = 0;
            while (j < categoryList.size()) {
                sorted.add((IEEFTabDescriptor)categoryList.get(j));
                ++j;
            }
            categoryIndex = endOfCategory;
            ++i;
        }
        return sorted;
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (target != null && array[i] != null && array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<String> readPropertyCategories() {
        return EEFPropertiesUiLegacyPlugin.getImplementation().getTabbedPropertyContributorRegistry().getPropertyCategories();
    }

    private List<IEEFTabDescriptor> readTabDescriptors() {
        HashMap<String, IEEFTabDescriptor> eefTabDescriptors = new HashMap<String, IEEFTabDescriptor>();
        Collection<IItemDescriptor> values = this.id2descriptors.values();
        for (IItemDescriptor itemDescriptor : values) {
            if (!(itemDescriptor instanceof IEEFTabDescriptor) || eefTabDescriptors.containsKey(itemDescriptor.getId())) continue;
            eefTabDescriptors.put(itemDescriptor.getId(), (IEEFTabDescriptor)itemDescriptor);
        }
        return new ArrayList<IEEFTabDescriptor>(eefTabDescriptors.values());
    }

    @Override
    public IItemDescriptor add(IItemDescriptor descriptor) {
        return this.id2descriptors.put(descriptor.getId(), descriptor);
    }

    @Override
    public IItemDescriptor remove(String id) {
        return this.id2descriptors.remove(id);
    }

    @Override
    public void clear() {
        this.id2descriptors.clear();
    }
}

