/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.core.util;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class EMFHelper {
    public static EObject load(URI modelURI, ResourceSet resourceSet) throws IOException {
        HashMap<String, String> options;
        EObject result = null;
        Resource modelResource = null;
        if ((modelResource = EMFHelper.resourceAlreadyLoaded(modelURI, resourceSet, modelResource)) == null) {
            modelResource = EMFHelper.createResource(modelURI, resourceSet);
            options = new HashMap<String, String>();
            options.put("ENCODING", System.getProperty("file.encoding"));
            modelResource.load(options);
        }
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        } else {
            modelResource.unload();
            options = new HashMap();
            options.put("ENCODING", System.getProperty("file.encoding"));
            modelResource.load(options);
            if (modelResource.getContents().size() > 0) {
                result = (EObject)modelResource.getContents().get(0);
            }
        }
        return result;
    }

    protected static Resource resourceAlreadyLoaded(URI modelURI, ResourceSet resourceSet, Resource modelResource) {
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.getURI().equals((Object)modelURI)) continue;
            modelResource = resource;
        }
        return modelResource;
    }

    public static Resource createResource(URI modelURI, ResourceSet resourceSet) {
        Resource.Factory.Registry registry;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (registry = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        return resourceSet.createResource(modelURI);
    }

    public static IFile associatedFile(EObject eObject) {
        if (eObject.eResource().getURI().isPlatformResource()) {
            URI uri = eObject.eResource().getURI();
            String path = uri.toString().substring("platform:/resource".length());
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        return null;
    }
}

