/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ecore.services.wrappers;

import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.impl.Literals;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelWrapper {
    public boolean isJDK50(GenModel genModel) {
        if (genModel != null && genModel.getComplianceLevel() != null) {
            return genModel.getComplianceLevel().getValue() >= 1;
        }
        return false;
    }

    public boolean isEMF26(GenModel genModel) {
        if (genModel != null && genModel.getRuntimeVersion() != null) {
            return genModel.getRuntimeVersion().getValue() >= 4;
        }
        return false;
    }

    public boolean isEMF25(GenModel genModel) {
        if (genModel != null && genModel.getRuntimeVersion() != null) {
            return genModel.getRuntimeVersion().getValue() >= 3;
        }
        return false;
    }

    public boolean isEMF24(GenModel genModel) {
        if (genModel != null && genModel.getRuntimeVersion() != null) {
            return genModel.getRuntimeVersion().getValue() >= 2;
        }
        return false;
    }

    public String getIndentation(GenModel genModel) {
        return genModel.getIndentation(new StringBuffer());
    }

    public String genSortedImports(GenModel genModel) {
        return genModel.getImportManager().computeSortedImports();
    }

    public String genSortedImports(GenClass genClass) {
        return genClass.getGenModel().getImportManager().computeSortedImports();
    }

    public void initializeImportManager(GenModel genModel, String packageName, String className) {
        this.createImportManagerAndSetItTo(genModel, packageName, className);
    }

    private ImportManager createImportManagerAndSetItTo(GenModel genModel, String packageName, String className) {
        ImportManager importManager = new ImportManager(packageName, className);
        genModel.setImportManager(importManager);
        return importManager;
    }

    public void initializeImportManager(GenModel genModel, GenPackage genPackage, String packageName, String className) {
        ImportManager importManager = this.createImportManagerAndSetItTo(genModel, packageName, className);
        importManager.addJavaLangImports(genPackage.getJavaLangConflicts());
    }

    public void addImport(GenModel genModel, String qualifiedName) {
        genModel.addImport(qualifiedName);
    }

    public void addPseudoImport(GenModel genModel, String qualifiedName) {
        genModel.addPseudoImport(qualifiedName);
    }

    public String toStringLiteral(GenModel genModel, String literal) {
        return Literals.toStringLiteral((String)literal, (GenModel)genModel);
    }

    public List<EStructuralFeature> getAllExtendedMetaDataAttributes(GenModel genModel, EClass eClass) {
        return genModel.getExtendedMetaData().getAllAttributes(eClass);
    }

    public List<EStructuralFeature> getAllExtendedMetaDataElements(GenModel genModel, EClass eClass) {
        return genModel.getExtendedMetaData().getAllElements(eClass);
    }

    public String getExtendedMetaDataName(GenModel genModel, EStructuralFeature eFeature) {
        return genModel.getExtendedMetaData().getName(eFeature);
    }

    public String getExtendedMetaDataNamespace(GenModel genModel, EStructuralFeature eFeature) {
        return genModel.getExtendedMetaData().getNamespace(eFeature);
    }

    public String getExtendedMetaDataNamespaceAsLiteral(GenModel genModel, EStructuralFeature eFeature) {
        String result = Literals.toStringLiteral((String)genModel.getExtendedMetaData().getNamespace(eFeature), (GenModel)genModel);
        if ("null".equals(result)) {
            result = "\"\"";
        }
        return result;
    }

    public boolean supportsComposition(GenModel genModel) {
        return genModel.getRuntimeVersion().getValue() >= 5;
    }

    public String formatConstraint(GenModel genModel, String constraint) {
        if (constraint != null) {
            return CodeGenUtil.format((String)constraint, (char)'_', null, (boolean)false, (boolean)false).toUpperCase(genModel.getLocale());
        }
        return "";
    }

    public String upperNameConstraint(String constraint) {
        return CodeGenUtil.upperName((String)constraint);
    }
}

