/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.ClientContextManager;
import org.eclipse.emf.validation.internal.service.IClientContext;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;

public class ClientContextTest
extends TestCase {
    private IModelConstraint constraint1_1;
    private IModelConstraint constraint1_2;
    private IModelConstraint constraint2_1;
    private IModelConstraint constraint2_2;
    private IModelConstraint constraint2a_1;
    private IModelConstraint constraint2a_2;
    private IModelConstraint constraint3_1;
    private IModelConstraint constraint3_2;
    private IModelConstraint constraint3a_1;
    private IModelConstraint constraint3a_2;
    private IClientContext fixture;

    public ClientContextTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ClientContextTest.class, "Client context tests");
    }

    public void test_includedChildOfExcludedCategory() {
        ClientContextTest.assertTrue((String)"Constraint is excluded", (boolean)this.fixture.includes(this.constraint3_1));
        ClientContextTest.assertTrue((String)"Constraint is excluded", (boolean)this.fixture.includes(this.constraint3_2));
    }

    public void test_constraintExcludedFromIncludedCategory() {
        ClientContextTest.assertFalse((String)"Constraint is included", (boolean)this.fixture.includes(this.constraint1_1));
        ClientContextTest.assertTrue((String)"Constraint is excluded", (boolean)this.fixture.includes(this.constraint1_2));
    }

    public void test_constraintIncludedInExcludedCategory() {
        ClientContextTest.assertFalse((String)"Constraint is included", (boolean)this.fixture.includes(this.constraint2_1));
        ClientContextTest.assertTrue((String)"Constraint is excluded", (boolean)this.fixture.includes(this.constraint2_2));
    }

    public void test_constraintExcludedFromIncludedCategory_nested() {
        ClientContextTest.assertFalse((String)"Constraint is included", (boolean)this.fixture.includes(this.constraint2a_1));
        ClientContextTest.assertTrue((String)"Constraint is excluded", (boolean)this.fixture.includes(this.constraint2a_2));
    }

    public void test_constraintIncludedInExcludedCategory_nested() {
        ClientContextTest.assertFalse((String)"Constraint is included", (boolean)this.fixture.includes(this.constraint3a_1));
        ClientContextTest.assertTrue((String)"Constraint is excluded", (boolean)this.fixture.includes(this.constraint3a_2));
    }

    public void test_multipleMatchingContextsWithExclusions() {
        Collection contexts;
        System.setProperty("BOGUS_SYSTEM_PROPERTY", "1");
        try {
            contexts = ClientContextManager.getInstance().getClientContextsFor((EObject)EcoreFactory.eINSTANCE.createEAnnotation());
        }
        finally {
            System.clearProperty("BOGUS_SYSTEM_PROPERTY");
        }
        boolean extenderFound = false;
        boolean extendedFound = false;
        for (IClientContext next : contexts) {
            extenderFound |= "org.eclipse.emf.validation.tests.testcontext".equals(next.getId());
            extendedFound |= "org.eclipse.emf.validation.tests.testContextToExtend".equals(next.getId());
        }
        ClientContextTest.assertTrue((String)"Extending context not matched", (boolean)extenderFound);
        ClientContextTest.assertFalse((String)"Extended context was matched", (boolean)extendedFound);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture = ClientContextManager.getInstance().getClientContext("org.eclipse.emf.validation.tests.testcontext");
        String prefix = "org.eclipse.emf.validation.tests.clientContext.";
        ConstraintRegistry reg = ConstraintRegistry.getInstance();
        ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH).validate((Object)EcoreFactory.eINSTANCE.createEAnnotation());
        this.constraint1_1 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.1.1"));
        this.constraint1_2 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.1.2"));
        this.constraint2_1 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.2.1"));
        this.constraint2_2 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.2.2"));
        this.constraint2a_1 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.2a.1"));
        this.constraint2a_2 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.2a.2"));
        this.constraint3_1 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.3.1"));
        this.constraint3_2 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.3.2"));
        this.constraint3a_1 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.3a.1"));
        this.constraint3a_2 = new TestConstraint(reg.getDescriptor("org.eclipse.emf.validation.tests.clientContext.3a.2"));
    }

    private static final class TestConstraint
    implements IModelConstraint {
        private IConstraintDescriptor desc;

        TestConstraint(IConstraintDescriptor desc) {
            this.desc = desc;
        }

        public IStatus validate(IValidationContext c) {
            return Status.OK_STATUS;
        }

        public IConstraintDescriptor getDescriptor() {
            return this.desc;
        }
    }
}

