/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import ordersystem.OrderSystemFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.tests.TestNotification;

public class ConstraintDescriptorTest
extends TestCase {
    private static final String TEST_NAME = "Testing";
    private static final String TEST_PLUGIN = "org.eclipse.emf.validation.tests";
    private static final String TEST_ID = "org.eclipse.emf.validation.tests.test.id";
    private static final String TEST_DESCRIPTION = "Test description";
    private static final String TEST_MESSAGE = "Error in {0}";
    private static final String TEST_LANG = "OCL";
    private static final String TEST_BODY = "self.name = 'Ottawa'";
    private static final int TEST_CODE = 1000;
    private static final ConstraintSeverity TEST_SEVERITY = ConstraintSeverity.WARNING;
    private static final EvaluationMode<Notification> TEST_MODE = EvaluationMode.LIVE;
    private static final String TEST_NAMESPACE_URI = "http:///ordersystem.ecore";
    private static final String TEST_CLASS = "Warehouse";
    private static final String TEST_EVENT = "Set";
    private static final Category TEST_CATEGORY = CategoryManager.getInstance().getCategory("test/descriptor");
    private static XmlConstraintDescriptor fixture;
    private static FixtureElement fixtureConfig;

    public static XmlConstraintDescriptor getFixture() {
        if (fixture == null) {
            try {
                fixture = new XmlConstraintDescriptor(ConstraintDescriptorTest.getFixtureConfig());
            }
            catch (ConstraintExistsException e) {
                ConstraintDescriptorTest.fail((String)("Constraint already exists: " + e.getLocalizedMessage()));
            }
        }
        return fixture;
    }

    public static FixtureElement newFixtureConfig() {
        FixtureElement result = new FixtureElement("constraint");
        result.putAttribute("id", TEST_ID);
        result.putAttribute("name", TEST_NAME);
        result.putAttribute("lang", TEST_LANG);
        result.putAttribute("severity", TEST_SEVERITY.getName());
        result.putAttribute("statusCode", String.valueOf(1000));
        result.putAttribute("mode", TEST_MODE.getName());
        result.setValue(TEST_BODY);
        FixtureElement description = new FixtureElement("description");
        description.setValue(TEST_DESCRIPTION);
        FixtureElement message = new FixtureElement("message");
        message.setValue(TEST_MESSAGE);
        FixtureElement target = new FixtureElement("target");
        target.putAttribute("class", TEST_CLASS);
        FixtureElement event = new FixtureElement("event");
        event.putAttribute("name", TEST_EVENT);
        target.addChild(event);
        result.addChild(description);
        result.addChild(message);
        result.addChild(target);
        return result;
    }

    static IConfigurationElement getFixtureConfig() {
        if (fixtureConfig == null) {
            fixtureConfig = ConstraintDescriptorTest.newFixtureConfig();
        }
        return fixtureConfig;
    }

    public void test_hashCode() {
        ConstraintDescriptorTest.assertEquals((int)TEST_ID.hashCode(), (int)ConstraintDescriptorTest.getFixture().hashCode());
    }

    public void test_registry() {
        ConstraintDescriptorTest.assertSame((Object)ConstraintDescriptorTest.getFixture(), (Object)ConstraintRegistry.getInstance().getDescriptor(TEST_PLUGIN, TEST_ID));
    }

    public void test_getConfig() {
        ConstraintDescriptorTest.assertSame((Object)ConstraintDescriptorTest.getFixtureConfig(), (Object)ConstraintDescriptorTest.getFixture().getConfig());
    }

    public void test_getDescriptor() {
        ConstraintDescriptorTest.assertSame((Object)ConstraintDescriptorTest.getFixture(), (Object)ConstraintDescriptorTest.getFixture().getDescriptor());
    }

    public void test_getName() {
        ConstraintDescriptorTest.assertEquals((String)TEST_NAME, (String)ConstraintDescriptorTest.getFixture().getName());
    }

    public void test_getId() {
        ConstraintDescriptorTest.assertEquals((String)TEST_ID, (String)ConstraintDescriptorTest.getFixture().getId());
    }

    public void test_getPluginId() {
        ConstraintDescriptorTest.assertEquals((String)TEST_PLUGIN, (String)ConstraintDescriptorTest.getFixture().getPluginId());
    }

    public void test_getDescription() {
        ConstraintDescriptorTest.assertEquals((String)TEST_DESCRIPTION, (String)ConstraintDescriptorTest.getFixture().getDescription());
    }

    public void test_getSeverity() {
        ConstraintDescriptorTest.assertSame((Object)TEST_SEVERITY, (Object)ConstraintDescriptorTest.getFixture().getSeverity());
    }

    public void test_getStatusCode() {
        ConstraintDescriptorTest.assertEquals((int)1000, (int)ConstraintDescriptorTest.getFixture().getStatusCode());
    }

    public void test_getEvaluationMode() {
        ConstraintDescriptorTest.assertSame(TEST_MODE, (Object)ConstraintDescriptorTest.getFixture().getEvaluationMode());
    }

    public void test_isBatch() {
        ConstraintDescriptorTest.assertFalse((boolean)ConstraintDescriptorTest.getFixture().getEvaluationMode().isBatchOnly());
    }

    public void test_isLive() {
        ConstraintDescriptorTest.assertTrue((boolean)ConstraintDescriptorTest.getFixture().getEvaluationMode().isLive());
    }

    public void test_isEnabled_isError_getException() {
        ConstraintDescriptorTest.assertTrue((boolean)ConstraintDescriptorTest.getFixture().isEnabled());
        ConstraintDescriptorTest.assertFalse((boolean)ConstraintDescriptorTest.getFixture().isError());
        ConstraintDescriptorTest.assertNull((Object)ConstraintDescriptorTest.getFixture().getException());
        Exception e = new Exception();
        ConstraintDescriptorTest.getFixture().setError((Throwable)e);
        ConstraintDescriptorTest.assertFalse((boolean)ConstraintDescriptorTest.getFixture().isEnabled());
        ConstraintDescriptorTest.assertTrue((boolean)ConstraintDescriptorTest.getFixture().isError());
        ConstraintDescriptorTest.assertSame((Object)e, (Object)ConstraintDescriptorTest.getFixture().getException());
    }

    public void test_getCategories() {
        Set<Category> categories = Collections.singleton(CategoryManager.getInstance().getDefaultCategory());
        ConstraintDescriptorTest.assertEquals(categories, (Object)ConstraintDescriptorTest.getFixture().getCategories());
    }

    public void test_addCategory_removeCategory() {
        ConstraintDescriptorTest.getFixture().addCategory(TEST_CATEGORY);
        ConstraintDescriptorTest.assertEquals(Collections.singleton(TEST_CATEGORY), (Object)ConstraintDescriptorTest.getFixture().getCategories());
        ConstraintDescriptorTest.getFixture().removeCategory(TEST_CATEGORY);
        ConstraintDescriptorTest.assertEquals(Collections.singleton(CategoryManager.getInstance().getDefaultCategory()), (Object)ConstraintDescriptorTest.getFixture().getCategories());
    }

    public void test_resolveTargetTypes() {
        ConstraintDescriptorTest.getFixture().resolveTargetTypes(new String[]{TEST_NAMESPACE_URI});
        ConstraintDescriptorTest.assertTrue((boolean)ConstraintDescriptorTest.getFixture().targetsTypeOf((EObject)OrderSystemFactory.eINSTANCE.createWarehouse()));
    }

    public void test_targetsTypeOf() {
        ConstraintDescriptorTest.getFixture().resolveTargetTypes(new String[]{TEST_NAMESPACE_URI});
        ConstraintDescriptorTest.assertTrue((boolean)ConstraintDescriptorTest.getFixture().targetsTypeOf((EObject)OrderSystemFactory.eINSTANCE.createWarehouse()));
    }

    public void test_targetsEvent() {
        ConstraintDescriptorTest.getFixture().resolveTargetTypes(new String[]{TEST_NAMESPACE_URI});
        ConstraintDescriptorTest.assertTrue((boolean)ConstraintDescriptorTest.getFixture().targetsEvent((Notification)new TestNotification(OrderSystemFactory.eINSTANCE.createWarehouse(), EMFEventType.getInstance((String)TEST_EVENT).toNotificationType())));
    }

    public void test_getMessagePattern() {
        ConstraintDescriptorTest.assertEquals((String)TEST_MESSAGE, (String)ConstraintDescriptorTest.getFixture().getMessagePattern());
    }

    public void test_getBody() {
        ConstraintDescriptorTest.assertEquals((String)TEST_BODY, (String)ConstraintDescriptorTest.getFixture().getBody());
    }

    public void test_equalsObject() {
        ConstraintDescriptorTest.assertEquals((Object)ConstraintDescriptorTest.getFixture(), (Object)ConstraintDescriptorTest.getFixture());
    }

    public static class FixtureElement
    implements IConfigurationElement {
        private final Map<String, String> attributes = new HashMap<String, String>();
        private final List<IConfigurationElement> children = new ArrayList<IConfigurationElement>();
        private Object parent;
        private final String myName;
        private String value = "";

        public FixtureElement(String name) {
            this.myName = name;
        }

        public static FixtureElement build(String name, String[][] attributes) {
            return FixtureElement.build(name, null, attributes);
        }

        public static FixtureElement build(String name, String value) {
            return FixtureElement.build(name, value, null);
        }

        public static FixtureElement build(String name, String value, String[][] attributes) {
            FixtureElement result = new FixtureElement(name);
            if (attributes != null) {
                String[][] stringArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] element = stringArray[n2];
                    result.putAttribute(element[0], element[1]);
                    ++n2;
                }
            }
            result.setValue(value);
            return result;
        }

        public String getAttribute(String name) {
            return this.attributes.get(name);
        }

        public FixtureElement putAttribute(String name, String newValue) {
            this.attributes.put(name, newValue);
            return this;
        }

        public String getAttributeAsIs(String name) {
            return this.getAttribute(name);
        }

        public String[] getAttributeNames() {
            return this.attributes.keySet().toArray(new String[this.attributes.size()]);
        }

        public IConfigurationElement[] getChildren() {
            return this.children.toArray(new IConfigurationElement[this.children.size()]);
        }

        public IConfigurationElement[] getChildren(String name) {
            ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
            for (IConfigurationElement next : this.children) {
                if (!next.getName().equals(name)) continue;
                result.add(next);
            }
            return result.toArray(new IConfigurationElement[result.size()]);
        }

        public FixtureElement addChild(IConfigurationElement child) {
            this.children.add(child);
            if (child instanceof FixtureElement) {
                ((FixtureElement)child).setParent(this);
            }
            return this;
        }

        public String getName() {
            return this.myName;
        }

        public String getValue() {
            return this.value;
        }

        public String getValueAsIs() {
            return this.getValue();
        }

        public FixtureElement setValue(String value) {
            this.value = value;
            return this;
        }

        @Deprecated
        public IExtension getDeclaringExtension() {
            return new IExtension(){

                public String getNamespace() {
                    return ConstraintDescriptorTest.TEST_PLUGIN;
                }

                public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
                    return ConstraintDescriptorTest.TEST_PLUGIN;
                }

                public IConfigurationElement[] getConfigurationElements() throws InvalidRegistryObjectException {
                    return null;
                }

                public String getExtensionPointUniqueIdentifier() throws InvalidRegistryObjectException {
                    return null;
                }

                public String getLabel() throws InvalidRegistryObjectException {
                    return ConstraintDescriptorTest.TEST_PLUGIN;
                }

                public String getSimpleIdentifier() throws InvalidRegistryObjectException {
                    return null;
                }

                public String getUniqueIdentifier() throws InvalidRegistryObjectException {
                    return null;
                }

                public boolean isValid() {
                    return false;
                }

                public IContributor getContributor() throws InvalidRegistryObjectException {
                    return null;
                }

                public IPluginDescriptor getDeclaringPluginDescriptor() throws InvalidRegistryObjectException {
                    return null;
                }

                public String getLabel(String locale) throws InvalidRegistryObjectException {
                    return ConstraintDescriptorTest.TEST_PLUGIN;
                }
            };
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            try {
                Object result = Class.forName(this.getAttribute(propertyName)).newInstance();
                if (result instanceof IExecutableExtension) {
                    ((IExecutableExtension)result).setInitializationData((IConfigurationElement)this, propertyName, null);
                }
                return result;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, ConstraintDescriptorTest.TEST_PLUGIN, 1, "Failed to create executable extension", (Throwable)e));
            }
        }

        public Object getParent() {
            return this.parent;
        }

        void setParent(Object parent) {
            this.parent = parent;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return false;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue(String locale) throws InvalidRegistryObjectException {
            return null;
        }
    }
}

