/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.internal.util.DisabledConstraint;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.xml.IXmlConstraintDescriptor;

public class ConstraintFactoryTest
extends TestCase {
    private final ConstraintFactory factory = ConstraintFactory.getInstance();

    public void test_getInstance() {
        ConstraintFactoryTest.assertSame((Object)this.factory, (Object)ConstraintFactory.getInstance());
    }

    public void test_newConstraint() {
        IModelConstraint constraint = this.factory.newConstraint((IXmlConstraintDescriptor)ConstraintDescriptorTest.getFixture());
        ConstraintFactoryTest.assertNotNull((Object)constraint);
        ConstraintFactoryTest.assertSame((Object)ConstraintDescriptorTest.getFixture(), (Object)constraint.getDescriptor());
    }

    public void test_newConstraint_disabledConstraint() {
        ConstraintDescriptorTest.FixtureElement element = new ConstraintDescriptorTest.FixtureElement("constraint");
        element.putAttribute("id", "junit.validation.util.foo");
        element.putAttribute("name", "foo");
        element.putAttribute("lang", "Java");
        ConstraintDescriptorTest.FixtureElement message = new ConstraintDescriptorTest.FixtureElement("message");
        message.setValue("Nothing.");
        try {
            XmlConstraintDescriptor desc = new XmlConstraintDescriptor((IConfigurationElement)element);
            IModelConstraint constraint = this.factory.newConstraint((IXmlConstraintDescriptor)desc);
            ConstraintFactoryTest.assertFalse((boolean)desc.isEnabled());
            ConstraintFactoryTest.assertTrue((boolean)desc.isError());
            ConstraintFactoryTest.assertTrue((boolean)(constraint instanceof DisabledConstraint));
        }
        catch (ConstraintExistsException e) {
            ConstraintFactoryTest.fail((String)("Constraint already exists: " + e.getLocalizedMessage()));
        }
    }
}

