/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.internal.util.JavaConstraintParser;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IParameterizedConstraintDescriptor;
import org.eclipse.emf.validation.service.IParameterizedConstraintParser;
import org.eclipse.emf.validation.xml.ConstraintParserException;

public class JavaConstraintParserTest
extends TestCase {
    IParameterizedConstraintParser parser = new JavaConstraintParser();

    public void test_parseConstraint() {
        try {
            this.parser.parseConstraint((IParameterizedConstraintDescriptor)ConstraintRegistry.getInstance().getDescriptor("org.eclipse.emf.validation.tests", "bad.constraint.disabled.runtime"));
        }
        catch (ConstraintParserException e) {
            JavaConstraintParserTest.fail((String)("Got exception: " + e.getLocalizedMessage()));
        }
    }

    public void test_parseConstraint_throws() {
        ConstraintDescriptorTest.FixtureElement element = new ConstraintDescriptorTest.FixtureElement("constraint");
        element.putAttribute("id", "junit.validation.util.foo");
        element.putAttribute("name", "foo");
        element.putAttribute("lang", "Java");
        ConstraintDescriptorTest.FixtureElement message = new ConstraintDescriptorTest.FixtureElement("message");
        message.setValue("Nothing.");
        try {
            XmlConstraintDescriptor desc = new XmlConstraintDescriptor((IConfigurationElement)element);
            try {
                this.parser.parseConstraint((IParameterizedConstraintDescriptor)desc);
                JavaConstraintParserTest.fail((String)"Did not get an exception.");
            }
            catch (ConstraintParserException constraintParserException) {}
        }
        catch (ConstraintExistsException e) {
            JavaConstraintParserTest.fail((String)("Constraint already exists: " + e.getLocalizedMessage()));
        }
    }

    public void test_getInstance() {
        ConstraintDescriptorTest.FixtureElement config = ConstraintDescriptorTest.FixtureElement.build("constraint", new String[][]{{"id", "constraint.parser.test.constraint1"}, {"name", "Constraint Parser Test Constraint"}, {"lang", "OCL"}, {"statusCode", "1"}, {"class", ConstraintUniquenessTest.class.getName()}});
        config.addChild(ConstraintDescriptorTest.FixtureElement.build("message", "No message."));
        try {
            JavaConstraintParserTest.assertEquals((int)0, (int)ConstraintUniquenessTest.instanceCount);
            IModelConstraint constraint1 = this.parser.parseConstraint((IParameterizedConstraintDescriptor)new XmlConstraintDescriptor((IConfigurationElement)config));
            JavaConstraintParserTest.assertEquals((int)1, (int)ConstraintUniquenessTest.instanceCount);
            config.putAttribute("id", "constraint.parser.test.constraint2");
            IModelConstraint constraint2 = this.parser.parseConstraint((IParameterizedConstraintDescriptor)new XmlConstraintDescriptor((IConfigurationElement)config));
            JavaConstraintParserTest.assertEquals((int)1, (int)ConstraintUniquenessTest.instanceCount);
            JavaConstraintParserTest.assertNotSame((Object)constraint1, (Object)constraint2);
        }
        catch (ConstraintExistsException e) {
            JavaConstraintParserTest.fail((String)("Got exception: " + e.getLocalizedMessage()));
        }
        catch (ConstraintParserException e) {
            JavaConstraintParserTest.fail((String)("Got exception: " + e.getLocalizedMessage()));
        }
    }

    public static class ConstraintUniquenessTest
    extends AbstractModelConstraint {
        static int instanceCount = 0;

        public ConstraintUniquenessTest() {
            ++instanceCount;
        }

        public IStatus validate(IValidationContext ctx) {
            return Status.OK_STATUS;
        }
    }
}

