/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.export;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.ui.AbstractCompareAction;
import org.eclipse.emf.compare.ui.export.ExportActionDescriptor;
import org.eclipse.emf.compare.ui.export.IExportAction;
import org.eclipse.emf.compare.ui.internal.wizard.SaveDeltaWizard;
import org.eclipse.emf.compare.ui.viewer.structure.ModelStructureMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMenu
extends AbstractCompareAction
implements IMenuCreator {
    private static final String ALL_EXTENSIONS = "*";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.eclipse.emf.compare.ui.viewer.content.ModelMergeViewerResources");
    private static final Set<ExportActionDescriptor> CACHED_ACTIONS = new HashSet<ExportActionDescriptor>();
    private static final String EXPORT_ACTIONS_EXTENSION_POINT = "org.eclipse.emf.compare.ui.export";
    protected final Control parentControl;
    protected final ModelStructureMergeViewer parentViewer;
    private final MenuManager menuManager = new MenuManager();
    private final Action saveAction;

    static {
        ExportMenu.parseExtensionMetaData();
    }

    public ExportMenu(Control parent, ModelStructureMergeViewer owner) {
        super(BUNDLE, "action.export.menu.");
        this.setMenuCreator(this);
        this.parentControl = parent;
        this.parentViewer = owner;
        final ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.emf.compare.ui.viewer.content.ModelMergeViewerResources");
        this.saveAction = new AbstractCompareAction(bundle, "action.export.emfdiff."){

            public void run() {
                SaveDeltaWizard wizard = new SaveDeltaWizard(bundle.getString("UI_SaveDeltaWizard_FileExtension"));
                wizard.init(PlatformUI.getWorkbench(), (ComparisonSnapshot)ExportMenu.this.parentViewer.getInput());
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.open();
            }
        };
    }

    private static void parseExtensionMetaData() {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(EXPORT_ACTIONS_EXTENSION_POINT).getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                ExportActionDescriptor descriptor = new ExportActionDescriptor(configElement);
                CACHED_ACTIONS.add(descriptor);
                ++n4;
            }
            ++n2;
        }
    }

    public void addActionToMenu(Action action) {
        ActionContributionItem contribution = new ActionContributionItem((IAction)action);
        this.menuManager.add((IContributionItem)contribution);
    }

    public void dispose() {
        if (this.menuManager.getMenu() != null) {
            this.menuManager.getMenu().dispose();
        }
        this.menuManager.dispose();
    }

    public void enableSave(boolean enabled) {
        this.saveAction.setEnabled(enabled);
    }

    public Set<ExportActionDescriptor> getActions(String fileExtension) {
        HashSet<ExportActionDescriptor> result = new HashSet<ExportActionDescriptor>(CACHED_ACTIONS.size());
        for (ExportActionDescriptor actionDescriptor : CACHED_ACTIONS) {
            String extension = actionDescriptor.getFileExtension() != null ? actionDescriptor.getFileExtension() : ALL_EXTENSIONS;
            if (!extension.equals(ALL_EXTENSIONS) && !extension.equals(fileExtension)) continue;
            result.add(actionDescriptor);
        }
        return result;
    }

    public String getComparedModelsExtension() {
        String extension = ALL_EXTENSIONS;
        if (this.parentViewer.getInput() instanceof ComparisonResourceSnapshot) {
            DiffModel diffModel = ((ComparisonResourceSnapshot)this.parentViewer.getInput()).getDiff();
            String leftExtension = ALL_EXTENSIONS;
            String rightExtension = ALL_EXTENSIONS;
            String ancestorExtension = null;
            if (((EObject)diffModel.getLeftRoots().get(0)).eResource() != null) {
                leftExtension = ((EObject)diffModel.getLeftRoots().get(0)).eResource().getURI().fileExtension();
            }
            if (((EObject)diffModel.getRightRoots().get(0)).eResource() != null) {
                rightExtension = ((EObject)diffModel.getRightRoots().get(0)).eResource().getURI().fileExtension();
            }
            if (!diffModel.getAncestorRoots().isEmpty() && ((EObject)diffModel.getAncestorRoots().get(0)).eResource() != null) {
                ancestorExtension = ((EObject)diffModel.getAncestorRoots().get(0)).eResource().getURI().fileExtension();
            }
            if (leftExtension.equals(rightExtension) && (ancestorExtension == null || leftExtension.equals(ancestorExtension))) {
                extension = leftExtension;
            }
        } else {
            String lastExtension = null;
            for (DiffModel diff : ((ComparisonResourceSetSnapshot)this.parentViewer.getInput()).getDiffResourceSet().getDiffModels()) {
                String leftExtension = ALL_EXTENSIONS;
                String rightExtension = ALL_EXTENSIONS;
                String ancestorExtension = null;
                if (((EObject)diff.getLeftRoots().get(0)).eResource() != null) {
                    leftExtension = ((EObject)diff.getLeftRoots().get(0)).eResource().getURI().fileExtension();
                }
                if (((EObject)diff.getRightRoots().get(0)).eResource() != null) {
                    rightExtension = ((EObject)diff.getRightRoots().get(0)).eResource().getURI().fileExtension();
                }
                if (!diff.getAncestorRoots().isEmpty() && ((EObject)diff.getAncestorRoots().get(0)).eResource() != null) {
                    ancestorExtension = ((EObject)diff.getAncestorRoots().get(0)).eResource().getURI().fileExtension();
                }
                if (!leftExtension.equals(rightExtension) || ancestorExtension != null && !leftExtension.equals(ancestorExtension)) continue;
                if (lastExtension != null && !leftExtension.equals(lastExtension)) {
                    lastExtension = ALL_EXTENSIONS;
                    break;
                }
                if (lastExtension != null) continue;
                lastExtension = leftExtension;
            }
            extension = lastExtension;
        }
        return extension;
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager.getMenu() == null) {
            this.menuManager.createContextMenu(parent);
        } else {
            this.menuManager.removeAll();
        }
        this.menuManager.add((IAction)this.saveAction);
        for (ExportActionDescriptor descriptor : this.getActions(this.getComparedModelsExtension())) {
            final IExportAction actionDescriptor = descriptor.getActionDescriptorInstance();
            AbstractCompareAction action = new AbstractCompareAction(actionDescriptor){

                public void run() {
                    actionDescriptor.exportSnapshot((ComparisonSnapshot)ExportMenu.this.parentViewer.getInput());
                }
            };
            this.addActionToMenu(action);
        }
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        if (this.menuManager.getMenu() != null) {
            return this.menuManager.getMenu();
        }
        return null;
    }

    @Override
    public void run() {
        if (this.saveAction.isEnabled()) {
            this.saveAction.run();
        }
    }
}

