/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.presentation;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.presentation.CodeGenUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class JETPropertyPage
extends PropertyPage
implements Listener {
    protected IProject project;
    protected Text templateContainerField;
    protected Text javaSourceField;
    protected List oldTemplateContainers;
    protected List oldTemplateSourceContainers;
    protected List newTemplateContainers;
    protected List newTemplateSourceContainers;
    protected IContainer oldJavaSoureContainer;
    protected IContainer newJavaSourceContainer;

    protected Control createContents(Composite parent) {
        Label control = null;
        this.project = this.getJETProject();
        if (this.project != null) {
            JETNature jetNature = JETNature.getRuntime((IProject)this.project);
            if (jetNature != null) {
                Composite containerGroup = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                containerGroup.setLayout((Layout)layout);
                containerGroup.setLayoutData((Object)new GridData(768));
                Label templateContainerLabel = new Label(containerGroup, 32);
                templateContainerLabel.setText(CodeGenUIPlugin.getPlugin().getString("_UI_TemplateContainer_label"));
                this.templateContainerField = new Text(containerGroup, 2048);
                GridData data = new GridData(768);
                this.templateContainerField.setLayoutData((Object)data);
                this.oldTemplateContainers = jetNature.getTemplateContainers();
                this.oldTemplateSourceContainers = jetNature.getTemplateSourceContainers();
                this.templateContainerField.setText(JETNature.getContainers((IProject)this.project, (List)this.oldTemplateContainers, (List)this.oldTemplateSourceContainers));
                this.templateContainerField.addListener(24, (Listener)this);
                Label sourceContainerLabel = new Label(containerGroup, 32);
                sourceContainerLabel.setText(CodeGenUIPlugin.getPlugin().getString("_UI_SourceContainer_label"));
                this.javaSourceField = new Text(containerGroup, 2048);
                data = new GridData(768);
                this.javaSourceField.setLayoutData((Object)data);
                this.oldJavaSoureContainer = jetNature.getJavaSourceContainer();
                this.javaSourceField.setText(this.oldJavaSoureContainer.getProjectRelativePath().toString());
                this.javaSourceField.addListener(24, (Listener)this);
                control = containerGroup;
            } else {
                Label closedProjectLabel = new Label(parent, 0);
                closedProjectLabel.setText(CodeGenUIPlugin.getPlugin().getString("_UI_WebSettingsNotAvaiable_message"));
                control = closedProjectLabel;
            }
        }
        return control;
    }

    protected IProject getJETProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return JETPropertyPage.isJETProject((IProject)element) ? (IProject)element : null;
        }
        if (element instanceof IJavaProject) {
            return JETPropertyPage.isJETProject(((IJavaProject)element).getProject()) ? ((IJavaProject)element).getProject() : null;
        }
        return null;
    }

    protected static boolean isJETProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.emf.codegen.jet.IJETNature");
        }
        catch (CoreException e) {
            CodeGenUIPlugin.write((Exception)((Object)e));
            return false;
        }
    }

    public void handleEvent(Event event) {
        JETNature jetNature;
        if (event.widget == this.templateContainerField && (jetNature = JETNature.getRuntime((IProject)this.project)) != null) {
            try {
                this.newTemplateContainers = JETNature.getContainers((IProject)this.getJETProject(), (String)this.templateContainerField.getText());
                this.newTemplateSourceContainers = JETNature.getContainers((IProject)this.getJETProject(), (String)this.templateContainerField.getText(), (boolean)true);
                this.setErrorMessage(null);
            }
            catch (Exception exception) {
                this.setErrorMessage(CodeGenUIPlugin.getPlugin().getString("_UI_CannotSetTemplateContainer_message", new String[]{exception.getLocalizedMessage()}));
            }
        }
        if (event.widget == this.javaSourceField && (jetNature = JETNature.getRuntime((IProject)this.project)) != null) {
            this.newJavaSourceContainer = JETNature.getContainer((IProject)this.getJETProject(), (String)this.javaSourceField.getText());
            if (this.newJavaSourceContainer.exists()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(CodeGenUIPlugin.getPlugin().getString("_UI_ContainerDoesNotExist_message", new String[]{this.newJavaSourceContainer.toString()}));
            }
        }
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performApply() {
        JETNature jetNature = JETNature.getRuntime((IProject)this.project);
        if (jetNature != null) {
            if (this.newTemplateContainers != null) {
                jetNature.setTemplateContainers(this.newTemplateContainers, this.newTemplateSourceContainers == null ? this.newTemplateContainers : this.newTemplateSourceContainers);
            }
            if (this.newJavaSourceContainer != null) {
                jetNature.setJavaSourceContainer(this.newJavaSourceContainer);
            }
        }
    }

    protected void performDefaults() {
        JETNature jetNature = JETNature.getRuntime((IProject)this.project);
        if (jetNature != null) {
            try {
                jetNature.setDefaults((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                CodeGenUIPlugin.write((Exception)((Object)e));
            }
        }
    }
}

