/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMeta;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.session.CDORevisionManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.DanglingReferenceException;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewEvent;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDODeltaNotificationImpl;
import org.eclipse.emf.internal.cdo.CDOInvalidationNotificationImpl;
import org.eclipse.emf.internal.cdo.CDOLegacyAdapter;
import org.eclipse.emf.internal.cdo.CDOMetaWrapper;
import org.eclipse.emf.internal.cdo.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOStore;
import org.eclipse.emf.internal.cdo.CDOURIHandler;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.query.CDOQueryImpl;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.ref.ReferenceType;
import org.eclipse.net4j.util.ref.ReferenceValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOViewImpl
extends Lifecycle
implements InternalCDOView {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, CDOViewImpl.class);
    private int viewID;
    private InternalCDOSession session;
    private InternalCDOViewSet viewSet;
    private CDOURIHandler uriHandler = new CDOURIHandler(this);
    private CDOFeatureAnalyzer featureAnalyzer = CDOFeatureAnalyzer.NOOP;
    private ConcurrentMap<CDOID, InternalCDOObject> objects;
    private CDOStore store = new CDOStore(this);
    private ReentrantLock lock = new ReentrantLock(true);
    private ReentrantLock stateLock = new ReentrantLock(true);
    private CDOResourceImpl rootResource;
    private ChangeSubscriptionManager changeSubscriptionManager = this.createChangeSubscriptionManager();
    private AdapterManager adapterPolicyManager = this.createAdapterManager();
    private OptionsImpl options = this.createOptions();
    @ReflectUtil.ExcludeFromDump
    private transient CDOID lastLookupID;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOObject lastLookupObject;

    @Override
    public OptionsImpl options() {
        return this.options;
    }

    public int getViewID() {
        return this.viewID;
    }

    @Override
    public void setViewID(int viewId) {
        this.viewID = viewId;
    }

    public CDOCommonView.Type getViewType() {
        return CDOCommonView.Type.READONLY;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.viewSet.getResourceSet();
    }

    @Override
    public InternalCDOViewSet getViewSet() {
        return this.viewSet;
    }

    @Override
    public void setViewSet(InternalCDOViewSet viewSet) {
        this.viewSet = viewSet;
        if (viewSet != null) {
            viewSet.getResourceSet().getURIConverter().getURIHandlers().add(0, (Object)this.getURIHandler());
        }
    }

    @Override
    public InternalCDOSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(InternalCDOSession session) {
        this.session = session;
    }

    @Override
    public CDOStore getStore() {
        this.checkActive();
        return this.store;
    }

    @Override
    public synchronized CDOResourceImpl getRootResource() {
        this.checkActive();
        if (this.rootResource == null) {
            this.rootResource = this.createRootResource();
        }
        return this.rootResource;
    }

    protected CDOResourceImpl createRootResource() {
        return (CDOResourceImpl)this.getResource("/");
    }

    @Override
    public CDOURIHandler getURIHandler() {
        return this.uriHandler;
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public ReentrantLock getStateLock() {
        return this.stateLock;
    }

    @Override
    public void lockObjects(Collection<? extends CDOObject> objects, RWLockManager.LockType lockType, long timeout) throws InterruptedException {
        this.checkActive();
        HashMap<CDOID, CDOIDAndVersion> uniqueObjects = new HashMap<CDOID, CDOIDAndVersion>();
        this.getCDOIDAndVersion(uniqueObjects, objects);
        for (CDOObject cDOObject : objects) {
            CDOIDAndVersion idAndVersion = (CDOIDAndVersion)uniqueObjects.get(cDOObject.cdoID());
            if (idAndVersion != null) continue;
            uniqueObjects.put(cDOObject.cdoID(), CDOIDUtil.createIDAndVersion((CDOID)cDOObject.cdoID(), (int)0));
        }
        this.session.getSessionProtocol().lockObjects(this, uniqueObjects, timeout, lockType);
    }

    @Override
    public void unlockObjects(Collection<? extends CDOObject> objects, RWLockManager.LockType lockType) {
        this.checkActive();
        this.session.getSessionProtocol().unlockObjects(this, objects, lockType);
    }

    @Override
    public void unlockObjects() {
        this.unlockObjects(null, null);
    }

    @Override
    public boolean isObjectLocked(CDOObject object, RWLockManager.LockType lockType, boolean byOthers) {
        this.checkActive();
        return this.session.getSessionProtocol().isObjectLocked(this, object, lockType, byOthers);
    }

    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean hasConflict() {
        return false;
    }

    @Override
    public CDOFeatureAnalyzer getFeatureAnalyzer() {
        return this.featureAnalyzer;
    }

    @Override
    public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
        this.featureAnalyzer = featureAnalyzer == null ? CDOFeatureAnalyzer.NOOP : featureAnalyzer;
    }

    @Override
    public InternalCDOTransaction toTransaction() {
        this.checkActive();
        if (this instanceof InternalCDOTransaction) {
            return (InternalCDOTransaction)((Object)this);
        }
        throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.0"), this));
    }

    @Override
    public boolean hasResource(String path) {
        this.checkActive();
        try {
            this.getResourceNodeID(path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public CDOQuery createQuery(String language, String queryString) {
        this.checkActive();
        return new CDOQueryImpl(this, language, queryString);
    }

    @Override
    public CDOResourceNode getResourceNode(String path) {
        CDOID id = this.getResourceNodeID(path);
        if (id == null) {
            return null;
        }
        InternalCDOObject object = this.getObject(id);
        if (object instanceof CDOResourceNode) {
            return (CDOResourceNode)((Object)object);
        }
        return null;
    }

    @Override
    public CDOID getResourceNodeID(String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IllegalArgumentException(Messages.getString("CDOViewImpl.1"));
        }
        CDOID folderID = null;
        if (CDOURIUtil.SEGMENT_SEPARATOR.equals(path)) {
            folderID = this.getResourceNodeIDChecked(null, null);
        } else {
            List<String> names = CDOURIUtil.analyzePath(path);
            for (String name : names) {
                folderID = this.getResourceNodeIDChecked(folderID, name);
            }
        }
        return folderID;
    }

    private CDOID getResourceNodeIDChecked(CDOID folderID, String name) {
        if ((folderID = this.getResourceNodeID(folderID, name)) == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.2"), name));
        }
        return folderID;
    }

    protected CDOResourceNode getResourceNode(CDOID folderID, String name) {
        try {
            CDOID id = this.getResourceNodeID(folderID, name);
            return (CDOResourceNode)((Object)this.getObject(id));
        }
        catch (CDOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CDOException((Throwable)ex);
        }
    }

    protected CDOID getResourceNodeID(CDOID folderID, String name) {
        if (folderID == null) {
            return this.getRootOrTopLevelResourceNodeID(name);
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString("CDOViewImpl.3"));
        }
        InternalCDORevision folderRevision = this.getLocalRevision(folderID);
        EClass resourceFolderClass = EresourcePackage.eINSTANCE.getCDOResourceFolder();
        if (folderRevision.getEClass() != resourceFolderClass) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.4"), folderID));
        }
        EReference nodesFeature = EresourcePackage.eINSTANCE.getCDOResourceFolder_Nodes();
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        int size = folderRevision.data().size((EStructuralFeature)nodesFeature);
        int i = 0;
        while (i < size) {
            Object value = folderRevision.data().get((EStructuralFeature)nodesFeature, i);
            value = this.getStore().resolveProxy(folderRevision, (EStructuralFeature)nodesFeature, i, value);
            InternalCDORevision childRevision = this.getLocalRevision((CDOID)this.convertObjectToID(value, false));
            if (name.equals(childRevision.data().get((EStructuralFeature)nameFeature, 0))) {
                return childRevision.getID();
            }
            ++i;
        }
        throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.5"), name));
    }

    protected CDOID getRootOrTopLevelResourceNodeID(String name) {
        CDOQuery resourceQuery = this.createResourcesQuery(null, name, true);
        resourceQuery.setMaxResults(1);
        List<CDOID> ids = resourceQuery.getResult(CDOID.class);
        if (ids.isEmpty()) {
            if (name == null) {
                throw new CDOException(Messages.getString("CDOViewImpl.6"));
            }
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.7"), name));
        }
        if (ids.size() > 1) {
            throw new ImplementationError(Messages.getString("CDOViewImpl.8"));
        }
        return ids.get(0);
    }

    protected InternalCDORevision getLocalRevision(CDOID id) {
        InternalCDORevision revision = null;
        InternalCDOObject object = this.getObject(id, false);
        if (object != null && object.cdoState() != CDOState.PROXY) {
            revision = object.cdoRevision();
        }
        if (revision == null) {
            revision = this.getRevision(id, true);
        }
        if (revision == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.9"), id));
        }
        return revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOObject[] getObjectsArray() {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            return this.objects.values().toArray(new InternalCDOObject[this.objects.size()]);
        }
    }

    @Deprecated
    public CDOResourceFolder getResourceFolder(String path) {
        if (path == null) {
            return null;
        }
        CDOResourceFolder folder = null;
        StringTokenizer tokenizer = new StringTokenizer(path, CDOURIUtil.SEGMENT_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String segment = tokenizer.nextToken();
            if (segment == null) continue;
        }
        return folder;
    }

    @Override
    public CDOResource getResource(String path) {
        return this.getResource(path, true);
    }

    @Override
    public CDOResource getResource(String path, boolean loadInDemand) {
        this.checkActive();
        URI uri = CDOURIUtil.createResourceURI(this, path);
        return (CDOResource)this.getResourceSet().getResource(uri, loadInDemand);
    }

    @Override
    public List<CDOResourceNode> queryResources(CDOResourceFolder folder, String name, boolean exactMatch) {
        this.checkActive();
        CDOQuery resourceQuery = this.createResourcesQuery(folder, name, exactMatch);
        return resourceQuery.getResult(CDOResourceNode.class);
    }

    @Override
    public CloseableIterator<CDOResourceNode> queryResourcesAsync(CDOResourceFolder folder, String name, boolean exactMatch) {
        this.checkActive();
        CDOQuery resourceQuery = this.createResourcesQuery(folder, name, exactMatch);
        return resourceQuery.getResultAsync(CDOResourceNode.class);
    }

    private CDOQuery createResourcesQuery(CDOResourceFolder folder, String name, boolean exactMatch) {
        CDOQuery query = this.createQuery("resources", name);
        query.setParameter("folder", folder == null ? null : folder.cdoID());
        query.setParameter("exactMatch", exactMatch);
        return query;
    }

    public CDOResourceImpl getResource(CDOID resourceID) {
        if (CDOIDUtil.isNull((CDOID)resourceID)) {
            throw new IllegalArgumentException("resourceID: " + resourceID);
        }
        return (CDOResourceImpl)this.getObject(resourceID);
    }

    public InternalCDOObject newInstance(EClass eClass) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        return FSMUtil.adapt(eObject, this);
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        CDORevisionManager revisionManager = this.session.getRevisionManager();
        int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
        return (InternalCDORevision)revisionManager.getRevision(id, initialChunkSize, loadOnDemand);
    }

    @Override
    public InternalCDOObject getObject(CDOID id) {
        return this.getObject(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            if (id.equals(this.lastLookupID)) {
                return this.lastLookupObject;
            }
            InternalCDOObject localLookupObject = (InternalCDOObject)this.objects.get(id);
            if (localLookupObject == null) {
                if (id.isMeta()) {
                    localLookupObject = this.createMetaObject((CDOIDMeta)id);
                } else {
                    if (!loadOnDemand) {
                        return null;
                    }
                    localLookupObject = this.createObject(id);
                }
                if (!CDOModelUtil.isResource((EClass)localLookupObject.eClass())) {
                    this.registerObject(localLookupObject);
                }
            }
            this.lastLookupID = id;
            this.lastLookupObject = localLookupObject;
            return this.lastLookupObject;
        }
    }

    @Override
    public <T extends EObject> T getObject(T objectFromDifferentView) {
        CDOObject object;
        CDOView view;
        this.checkActive();
        if (objectFromDifferentView instanceof CDOObject && (view = (object = (CDOObject)objectFromDifferentView).cdoView()) != this) {
            if (view.getSession() != this.session) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewImpl.11"), objectFromDifferentView));
            }
            CDOID id = object.cdoID();
            objectFromDifferentView = this.getObject(id, true);
        }
        return objectFromDifferentView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObjectRegistered(CDOID id) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return false;
        }
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            return this.objects.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDOObject removeObject(CDOID id) {
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            if (id.equals(this.lastLookupID)) {
                this.lastLookupID = null;
                this.lastLookupObject = null;
            }
            return (InternalCDOObject)this.objects.remove(id);
        }
    }

    private InternalCDOObject createMetaObject(CDOIDMeta id) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating meta object for " + id);
        }
        InternalCDOPackageRegistry packageRegistry = this.session.getPackageRegistry();
        InternalEObject metaInstance = packageRegistry.getMetaInstanceMapper().lookupMetaInstance((CDOID)id);
        return new CDOMetaWrapper(this, metaInstance, (CDOID)id);
    }

    private InternalCDOObject createObject(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating object for " + id);
        }
        InternalCDORevision revision = this.getRevision(id, true);
        FSMUtil.validate(id, (CDORevision)revision);
        EClass eClass = revision.getEClass();
        InternalCDOObject object = CDOModelUtil.isResource((EClass)eClass) ? (InternalCDOObject)((Object)this.newResourceInstance(revision)) : this.newInstance(eClass);
        this.cleanObject(object, revision);
        return object;
    }

    private CDOResource newResourceInstance(InternalCDORevision revision) {
        String path = this.getResourcePath(revision);
        return this.getResource(path, true);
    }

    private String getResourcePath(InternalCDORevision revision) {
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        CDOID folderID = (CDOID)revision.data().getContainerID();
        String name = (String)revision.data().get((EStructuralFeature)nameFeature, 0);
        if (CDOIDUtil.isNull((CDOID)folderID)) {
            if (name == null) {
                return CDOURIUtil.SEGMENT_SEPARATOR;
            }
            return name;
        }
        InternalCDOObject object = this.getObject(folderID, true);
        if (object instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)((Object)object);
            String path = folder.getPath();
            return String.valueOf(path) + CDOURIUtil.SEGMENT_SEPARATOR + name;
        }
        throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.14"), object));
    }

    protected void cleanObject(InternalCDOObject object, InternalCDORevision revision) {
        object.cdoInternalCleanup();
        object.cdoInternalSetView(this);
        object.cdoInternalSetRevision((CDORevision)revision);
        object.cdoInternalSetID(revision.getID());
        object.cdoInternalSetState(CDOState.CLEAN);
        object.cdoInternalPostLoad();
    }

    public CDOID provideCDOID(Object idOrObject) {
        Object shouldBeCDOID = this.convertObjectToID(idOrObject);
        if (shouldBeCDOID instanceof CDOID) {
            CDOID id = (CDOID)shouldBeCDOID;
            if (TRACER.isEnabled() && id != idOrObject) {
                TRACER.format("Converted object to CDOID: {0} --> {1}", new Object[]{idOrObject, id});
            }
            return id;
        }
        if (idOrObject instanceof InternalEObject) {
            InternalCDOObject object;
            InternalEObject eObject = (InternalEObject)idOrObject;
            String uri = EcoreUtil.getURI((EObject)eObject).toString();
            if (eObject instanceof InternalCDOObject && (object = (InternalCDOObject)idOrObject).cdoView() != null && FSMUtil.isNew(object)) {
                return CDOIDUtil.createExternalTemp((String)uri);
            }
            if (eObject.eResource() != null) {
                return CDOIDUtil.createExternal((String)uri);
            }
            throw new DanglingReferenceException((EObject)eObject);
        }
        throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.16"), idOrObject.getClass().getName()));
    }

    @Override
    public Object convertObjectToID(Object potentialObject) {
        return this.convertObjectToID(potentialObject, false);
    }

    @Override
    public Object convertObjectToID(Object potentialObject, boolean onlyPersistedID) {
        if (potentialObject instanceof CDOID) {
            return potentialObject;
        }
        if (potentialObject instanceof InternalEObject) {
            if (potentialObject instanceof InternalCDOObject) {
                InternalCDOObject object = (InternalCDOObject)potentialObject;
                CDOID id = this.getID(object, onlyPersistedID);
                if (id != null) {
                    return id;
                }
            } else {
                try {
                    CDOLegacyAdapter object = FSMUtil.getLegacyAdapter((EList<Adapter>)((InternalEObject)potentialObject).eAdapters());
                    if (object != null) {
                        CDOID id = this.getID(object, onlyPersistedID);
                        if (id != null) {
                            return id;
                        }
                        potentialObject = object;
                    }
                }
                catch (Throwable ex) {
                    OM.LOG.warn(ex);
                }
            }
        }
        return potentialObject;
    }

    private CDOID getID(InternalCDOObject object, boolean onlyPersistedID) {
        boolean newOrTransient;
        boolean bl = newOrTransient = FSMUtil.isTransient(object) || FSMUtil.isNew(object);
        if (!onlyPersistedID || !newOrTransient) {
            InternalCDOView view = object.cdoView();
            if (view == this) {
                return object.cdoID();
            }
            if (view != null && view.getSession() == this.getSession()) {
                return object.cdoID();
            }
        }
        return null;
    }

    @Override
    public Object convertIDToObject(Object potentialID) {
        if (potentialID instanceof CDOID) {
            if (potentialID == CDOID.NULL) {
                return null;
            }
            CDOID id = (CDOID)potentialID;
            if (id.isExternal()) {
                return this.getResourceSet().getEObject(URI.createURI((String)id.toURIFragment()), true);
            }
            InternalCDOObject result = this.getObject(id, true);
            if (result == null) {
                throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.17"), id));
            }
            return result.cdoInternalInstance();
        }
        return potentialID;
    }

    @Override
    public void attachResource(CDOResourceImpl resource) {
        if (!resource.isExisting()) {
            throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.18"), this));
        }
        resource.cdoInternalSetView(this);
        resource.cdoInternalSetState(CDOState.PROXY);
    }

    @Override
    public void registerProxyResource(CDOResourceImpl resource) {
        URI uri = resource.getURI();
        String path = CDOURIUtil.extractResourcePath(uri);
        try {
            CDOID id = this.getResourceNodeID(path);
            resource.cdoInternalSetID(id);
            this.registerObject(resource);
        }
        catch (Exception ex) {
            throw new InvalidURIException(uri, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(InternalCDOObject object) {
        InternalCDOObject old;
        if (TRACER.isEnabled()) {
            TRACER.format("Registering {0}", new Object[]{object});
        }
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            old = this.objects.put(object.cdoID(), object);
        }
        if (old != null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.20"), object));
        }
    }

    @Override
    public void deregisterObject(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering {0}", new Object[]{object});
        }
        this.removeObject(object.cdoID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapObject(CDOID oldID) {
        CDOID newID;
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            InternalCDOObject object = (InternalCDOObject)this.objects.remove(oldID);
            newID = object.cdoID();
            this.objects.put(newID, object);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Remapping {0} --> {1}", new Object[]{oldID, newID});
        }
    }

    @Override
    public Set<CDOObject> handleInvalidation(long timeStamp, Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedOIDs) {
        Set<CDOObject> conflicts = null;
        HashSet<InternalCDOObject> dirtyObjects = new HashSet<InternalCDOObject>();
        HashSet<InternalCDOObject> detachedObjects = new HashSet<InternalCDOObject>();
        this.lock.lock();
        try {
            conflicts = this.handleInvalidationWithoutNotification(dirtyOIDs, detachedOIDs, dirtyObjects, detachedObjects);
        }
        finally {
            this.lock.unlock();
        }
        if (this.options().isInvalidationNotificationEnabled()) {
            CDOInvalidationNotificationImpl notification;
            for (InternalCDOObject dirtyObject : dirtyObjects) {
                if (!dirtyObject.eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(dirtyObject);
                dirtyObject.eNotify(notification);
            }
            for (InternalCDOObject detachedObject : detachedObjects) {
                if (!detachedObject.eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(detachedObject);
                detachedObject.eNotify(notification);
            }
        }
        this.fireInvalidationEvent(timeStamp, Collections.unmodifiableSet(dirtyObjects), Collections.unmodifiableSet(detachedObjects));
        return conflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<CDOObject> handleInvalidationWithoutNotification(Set<CDOIDAndVersion> dirtyOIDs, Collection<CDOID> detachedOIDs, Set<InternalCDOObject> dirtyObjects, Set<InternalCDOObject> detachedObjects) {
        HashSet<InternalCDOObject> conflicts = null;
        for (CDOIDAndVersion dirtyOID : dirtyOIDs) {
            InternalCDOObject dirtyObject = null;
            ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
            synchronized (concurrentMap) {
                dirtyObject = (InternalCDOObject)this.objects.get(dirtyOID.getID());
            }
            if (dirtyObject == null) continue;
            CDOStateMachine.INSTANCE.invalidate(dirtyObject, dirtyOID.getVersion());
            dirtyObjects.add(dirtyObject);
            if (!dirtyObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashSet();
            }
            conflicts.add(dirtyObject);
        }
        for (CDOID id : detachedOIDs) {
            InternalCDOObject detachedObject = this.removeObject(id);
            if (detachedObject == null) continue;
            CDOStateMachine.INSTANCE.detachRemote(detachedObject);
            detachedObjects.add(detachedObject);
            if (!detachedObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashSet<InternalCDOObject>();
            }
            conflicts.add(detachedObject);
        }
        return conflicts;
    }

    public void fireInvalidationEvent(long timeStamp, Set<? extends CDOObject> dirtyObjects, Set<? extends CDOObject> detachedObjects) {
        if (!dirtyObjects.isEmpty() || !detachedObjects.isEmpty()) {
            this.fireEvent(new InvalidationEvent(timeStamp, dirtyObjects, detachedObjects));
        }
    }

    @Override
    public void handleChangeSubscription(Collection<CDORevisionDelta> deltas, Collection<CDOID> detachedObjects) {
        boolean policiesPresent = this.options().hasChangeSubscriptionPolicies();
        if (!policiesPresent) {
            return;
        }
        if (deltas != null) {
            CDONotificationBuilder builder = new CDONotificationBuilder();
            for (CDORevisionDelta delta : deltas) {
                NotificationImpl notification;
                InternalCDOObject object = this.changeSubscriptionManager.getSubcribeObject(delta.getID());
                if (object == null || !object.eNotificationRequired() || (notification = builder.buildNotification(object, delta)) == null) continue;
                notification.dispatch();
            }
        }
        if (detachedObjects != null) {
            for (CDOID id : detachedObjects) {
                InternalCDOObject object = this.changeSubscriptionManager.getSubcribeObject(id);
                if (object == null || !object.eNotificationRequired()) continue;
                CDODeltaNotificationImpl notification = new CDODeltaNotificationImpl((InternalEObject)object, 111, -1, null, null);
                notification.dispatch();
            }
            this.getChangeSubscriptionManager().handleDetachedObjects(detachedObjects);
        }
    }

    protected ChangeSubscriptionManager createChangeSubscriptionManager() {
        return new ChangeSubscriptionManager();
    }

    public AdapterManager getAdapterManager() {
        return this.adapterPolicyManager;
    }

    protected AdapterManager createAdapterManager() {
        return new AdapterManager();
    }

    @Override
    public void handleAddAdapter(InternalCDOObject eObject, Adapter adapter) {
        if (!FSMUtil.isNew(eObject)) {
            this.subscribe(eObject, adapter);
        }
        this.adapterPolicyManager.attachAdapter(eObject, adapter);
    }

    @Override
    public void handleRemoveAdapter(InternalCDOObject eObject, Adapter adapter) {
        if (!FSMUtil.isNew(eObject)) {
            this.unsubscribe(eObject, adapter);
        }
        this.adapterPolicyManager.detachAdapter(eObject, adapter);
    }

    @Override
    public void subscribe(EObject eObject, Adapter adapter) {
        this.changeSubscriptionManager.subscribe(eObject, adapter);
    }

    @Override
    public void unsubscribe(EObject eObject, Adapter adapter) {
        this.changeSubscriptionManager.unsubscribe(eObject, adapter);
    }

    @Override
    public boolean hasSubscription(CDOID id) {
        return this.changeSubscriptionManager.getSubcribeObject(id) != null;
    }

    protected ChangeSubscriptionManager getChangeSubscriptionManager() {
        return this.changeSubscriptionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<InternalCDOObject> getInvalidObjects(long timeStamp) {
        ArrayList<InternalCDOObject> result = new ArrayList<InternalCDOObject>();
        ConcurrentMap<CDOID, InternalCDOObject> concurrentMap = this.objects;
        synchronized (concurrentMap) {
            for (InternalCDOObject object : this.objects.values()) {
                InternalCDORevision revision = object.cdoRevision();
                if (revision == null) {
                    revision = this.getRevision(object.cdoID(), false);
                }
                if (revision != null && revision.isValid(timeStamp)) continue;
                result.add(object);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reload(CDOObject ... objects) {
        Object object;
        ArrayList<Object> internalObjects;
        if (objects != null && objects.length != 0) {
            internalObjects = new ArrayList(objects.length);
            CDOObject[] cDOObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                object = cDOObjectArray[n2];
                if (object instanceof InternalCDOObject) {
                    internalObjects.add((InternalCDOObject)object);
                }
                ++n2;
            }
        } else {
            object = this.objects;
            synchronized (object) {
                internalObjects = new ArrayList(this.objects.values());
            }
        }
        int result = internalObjects.size();
        if (result != 0) {
            CDOStateMachine.INSTANCE.reload(internalObjects.toArray(new InternalCDOObject[result]));
        }
        return result;
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public String toString() {
        return MessageFormat.format("CDOView({0})", this.viewID);
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    public Notifier getTarget() {
        return this.getResourceSet();
    }

    @Override
    public void getCDOIDAndVersion(Map<CDOID, CDOIDAndVersion> uniqueObjects, Collection<? extends CDOObject> cdoObjects) {
        for (CDOObject cDOObject : cdoObjects) {
            InternalCDORevision cdoRevision = CDOStateMachine.INSTANCE.readNoLoad((InternalCDOObject)cDOObject);
            CDOID cdoId = cDOObject.cdoID();
            if (cdoRevision == null || uniqueObjects.containsKey(cdoId)) continue;
            int version = cdoRevision.getVersion();
            uniqueObjects.put(cdoId, CDOIDUtil.createIDAndVersion((CDOID)cdoId, (int)version));
        }
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.session, "session");
        this.checkState(this.viewID > 0, "viewID");
    }

    protected void doActivate() throws Exception {
        this.session.getSessionProtocol().openView(this.getViewID(), this.getProtocolViewType(), this.getTimeStamp());
    }

    protected void doDeactivate() throws Exception {
        this.session.getSessionProtocol().closeView(this.getViewID());
        this.session.viewDetached(this);
        this.session = null;
        this.objects = null;
        this.store = null;
        this.viewSet = null;
        this.changeSubscriptionManager = null;
        this.featureAnalyzer = null;
        this.lastLookupID = null;
        this.lastLookupObject = null;
        this.options = null;
    }

    private byte getProtocolViewType() {
        CDOCommonView.Type viewType = this.getViewType();
        switch (viewType) {
            case READONLY: {
                return 3;
            }
            case TRANSACTION: {
                return 1;
            }
            case AUDIT: {
                return 2;
            }
        }
        throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.26"), viewType));
    }

    protected class AdapterManager {
        private Set<CDOObject> objects = new HashBag();

        protected AdapterManager() {
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (CDOObject cDOObject : commitContext.getNewObjects().values()) {
                    this.attachObject(cDOObject);
                }
                for (CDOObject cDOObject : commitContext.getNewResources().values()) {
                    this.attachObject(cDOObject);
                }
                for (CDOObject cDOObject : commitContext.getDetachedObjects().values()) {
                    this.detachObject(cDOObject);
                }
            }
        }

        protected synchronized void attachObject(CDOObject object) {
            if (((InternalEObject)object).eNotificationRequired()) {
                CDOAdapterPolicy strongReferencePolicy = CDOViewImpl.this.options().getStrongReferencePolicy();
                int count = 0;
                for (Adapter adapter : object.eAdapters()) {
                    if (!strongReferencePolicy.isValid(object, adapter)) continue;
                    ++count;
                }
                int i = 0;
                while (i < count) {
                    this.objects.add(object);
                    ++i;
                }
            }
        }

        protected synchronized void detachObject(CDOObject object) {
            while (this.objects.remove(object)) {
            }
        }

        protected synchronized void attachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.add(object);
            }
        }

        protected synchronized void detachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.add(object);
            }
        }

        public synchronized void reset() {
            Set<CDOObject> oldObject = this.objects;
            this.objects = new HashBag();
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                InternalCDOObject[] objects = CDOViewImpl.this.getObjectsArray();
                int i = 0;
                while (i < objects.length) {
                    InternalCDOObject object = objects[i];
                    this.attachObject(object);
                    ++i;
                }
            }
            oldObject.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangeSubscriptionManager {
        private Map<CDOID, SubscribeEntry> subscriptions = new HashMap<CDOID, SubscribeEntry>(){
            private static final long serialVersionUID = 1L;
        };

        protected ChangeSubscriptionManager() {
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.handleNewObjects(commitContext.getNewResources().values());
            this.handleNewObjects(commitContext.getNewObjects().values());
            this.handleDetachedObjects(commitContext.getDetachedObjects().keySet());
        }

        public void subscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, 1);
        }

        public void unsubscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyChangeSubcriptionPolicy() {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                this.subscriptions.clear();
                ArrayList<CDOID> cdoIDs = new ArrayList<CDOID>();
                if (policiesPresent) {
                    InternalCDOObject[] internalCDOObjectArray = CDOViewImpl.this.getObjectsArray();
                    int n = internalCDOObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalCDOObject cdoObject = internalCDOObjectArray[n2];
                        int count = this.getNumberOfValidAdapter(cdoObject);
                        if (count > 0) {
                            cdoIDs.add(cdoObject.cdoID());
                            this.addEntry(cdoObject.cdoID(), cdoObject, count);
                        }
                        ++n2;
                    }
                }
                this.request(cdoIDs, true, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleDetachedObjects(Collection<CDOID> detachedObjects) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                for (CDOID id : detachedObjects) {
                    SubscribeEntry entry = this.subscriptions.get(id);
                    if (entry == null) continue;
                    this.detachObject(id);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleNewObjects(Collection<? extends CDOObject> newObjects) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                for (CDOObject cDOObject : newObjects) {
                    int count;
                    InternalCDOObject cdoDetachedObject = (InternalCDOObject)cDOObject;
                    if (cdoDetachedObject == null || (count = this.getNumberOfValidAdapter(cdoDetachedObject)) <= 0) continue;
                    this.subscribe(cdoDetachedObject.cdoID(), cdoDetachedObject, count);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InternalCDOObject getSubcribeObject(CDOID id) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                SubscribeEntry entry = this.subscriptions.get(id);
                if (entry != null) {
                    return entry.getObject();
                }
            }
            return null;
        }

        protected void request(List<CDOID> cdoIDs, boolean clear, boolean subscribeMode) {
            CDOViewImpl.this.session.getSessionProtocol().changeSubscription(CDOViewImpl.this.getViewID(), cdoIDs, subscribeMode, clear);
        }

        protected int getNumberOfValidAdapter(InternalCDOObject object) {
            int count = 0;
            if (!FSMUtil.isTransient(object) && !FSMUtil.isNew(object) && object.eNotificationRequired()) {
                for (Adapter adapter : object.eAdapters()) {
                    if (!this.shouldSubscribe(object, adapter)) continue;
                    ++count;
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribe(EObject eObject, Adapter adapter, int adjust) {
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                if (this.shouldSubscribe(eObject, adapter)) {
                    InternalCDOObject internalCDOObject = FSMUtil.adapt(eObject, CDOViewImpl.this);
                    if (internalCDOObject.cdoView() != CDOViewImpl.this) {
                        throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.27"), internalCDOObject));
                    }
                    this.subscribe(internalCDOObject.cdoID(), internalCDOObject, adjust);
                }
            }
        }

        private boolean shouldSubscribe(EObject eObject, Adapter adapter) {
            CDOAdapterPolicy[] cDOAdapterPolicyArray = CDOViewImpl.this.options().getChangeSubscriptionPolicies();
            int n = cDOAdapterPolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOAdapterPolicy policy = cDOAdapterPolicyArray[n2];
                if (policy.isValid(eObject, adapter)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribe(CDOID id, InternalCDOObject cdoObject, int adjust) {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            Map<CDOID, SubscribeEntry> map = this.subscriptions;
            synchronized (map) {
                int count = 0;
                SubscribeEntry entry = this.subscriptions.get(id);
                if (entry == null) {
                    if (adjust < 0) {
                        return;
                    }
                    if (policiesPresent) {
                        this.request(Collections.singletonList(id), false, true);
                    }
                } else {
                    count = entry.getCount();
                }
                if ((count += adjust) <= 0) {
                    this.subscriptions.remove(id);
                    if (policiesPresent) {
                        this.request(Collections.singletonList(id), false, false);
                    }
                } else if (entry == null) {
                    this.addEntry(id, cdoObject, count);
                } else {
                    entry.setCount(count);
                }
            }
        }

        private void detachObject(CDOID id) {
            this.subscribe(id, null, Integer.MIN_VALUE);
        }

        private void addEntry(CDOID key, InternalCDOObject object, int count) {
            this.subscriptions.put(key, new SubscribeEntry(key, object, count));
        }

        class SubscribeEntry {
            private CDOID id;
            private int count = 0;
            private InternalCDOObject object;

            public SubscribeEntry(CDOID id, InternalCDOObject object, int count) {
                this.id = id;
                this.count = count;
                this.object = object;
            }

            public int getCount() {
                return this.count;
            }

            public void setCount(int count) {
                this.count = count;
            }

            public CDOID getId() {
                return this.id;
            }

            public InternalCDOObject getObject() {
                return this.object;
            }
        }
    }

    protected abstract class Event
    extends org.eclipse.net4j.util.event.Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;

        public Event() {
            super((INotifier)CDOViewImpl.this);
        }

        public CDOViewImpl getView() {
            return CDOViewImpl.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends Event
    implements CDOViewInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;
        private Set<? extends CDOObject> dirtyObjects;
        private Set<? extends CDOObject> detachedObjects;

        public InvalidationEvent(long timeStamp, Set<? extends CDOObject> dirtyOIDs, Set<? extends CDOObject> detachedObjects) {
            this.timeStamp = timeStamp;
            this.dirtyObjects = dirtyOIDs;
            this.detachedObjects = detachedObjects;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public Set<? extends CDOObject> getDirtyObjects() {
            return this.dirtyObjects;
        }

        @Override
        public Set<? extends CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        public String toString() {
            return "CDOViewInvalidationEvent: " + this.dirtyObjects;
        }
    }

    protected class OptionsImpl
    extends org.eclipse.net4j.util.event.Notifier
    implements CDOView.Options {
        private boolean invalidationNotificationEnabled;
        private CDORevisionPrefetchingPolicy revisionPrefetchingPolicy;
        private HashBag<CDOAdapterPolicy> changeSubscriptionPolicies = new HashBag();
        private CDOAdapterPolicy adapterReferencePolicy = CDOAdapterPolicy.ALL;

        public OptionsImpl() {
            this.setCacheReferenceType(null);
            this.invalidationNotificationEnabled = (Boolean)OM.PREF_ENABLE_INVALIDATION_NOTIFICATION.getValue();
            this.revisionPrefetchingPolicy = CDOUtil.createRevisionPrefetchingPolicy((Integer)OM.PREF_REVISION_LOADING_CHUNK_SIZE.getValue());
        }

        public CDOViewImpl getContainer() {
            return CDOViewImpl.this;
        }

        public boolean isInvalidationNotificationEnabled() {
            return this.invalidationNotificationEnabled;
        }

        public void setInvalidationNotificationEnabled(boolean enabled) {
            if (this.invalidationNotificationEnabled != enabled) {
                this.invalidationNotificationEnabled = enabled;
                this.fireEvent(new InvalidationNotificationEventImpl());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasChangeSubscriptionPolicies() {
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                return !this.changeSubscriptionPolicies.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOAdapterPolicy[] getChangeSubscriptionPolicies() {
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                return (CDOAdapterPolicy[])this.changeSubscriptionPolicies.toArray((Object[])new CDOAdapterPolicy[this.changeSubscriptionPolicies.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            boolean changed = false;
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                if (this.changeSubscriptionPolicies.add((Object)policy)) {
                    CDOViewImpl.this.changeSubscriptionManager.notifyChangeSubcriptionPolicy();
                    changed = true;
                }
            }
            if (changed) {
                this.fireEvent(new ChangeSubscriptionPoliciesEventImpl());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            boolean changed = false;
            HashBag<CDOAdapterPolicy> hashBag = this.changeSubscriptionPolicies;
            synchronized (hashBag) {
                if (this.changeSubscriptionPolicies.remove((Object)policy) && !this.changeSubscriptionPolicies.contains((Object)policy)) {
                    CDOViewImpl.this.changeSubscriptionManager.notifyChangeSubcriptionPolicy();
                    changed = true;
                }
            }
            if (changed) {
                this.fireEvent(new ChangeSubscriptionPoliciesEventImpl());
            }
        }

        public CDOAdapterPolicy getStrongReferencePolicy() {
            return this.adapterReferencePolicy;
        }

        public void setStrongReferencePolicy(CDOAdapterPolicy adapterPolicy) {
            if (adapterPolicy == null) {
                adapterPolicy = CDOAdapterPolicy.ALL;
            }
            if (this.adapterReferencePolicy != adapterPolicy) {
                this.adapterReferencePolicy = adapterPolicy;
                CDOViewImpl.this.adapterPolicyManager.reset();
                this.fireEvent(new ReferencePolicyEventImpl());
            }
        }

        public CDORevisionPrefetchingPolicy getRevisionPrefetchingPolicy() {
            return this.revisionPrefetchingPolicy;
        }

        public void setRevisionPrefetchingPolicy(CDORevisionPrefetchingPolicy prefetchingPolicy) {
            if (prefetchingPolicy == null) {
                prefetchingPolicy = CDORevisionPrefetchingPolicy.NO_PREFETCHING;
            }
            if (this.revisionPrefetchingPolicy != prefetchingPolicy) {
                this.revisionPrefetchingPolicy = prefetchingPolicy;
                this.fireEvent(new RevisionPrefetchingPolicyEventImpl());
            }
        }

        public ReferenceType getCacheReferenceType() {
            if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Strong) {
                return ReferenceType.STRONG;
            }
            if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Soft) {
                return ReferenceType.SOFT;
            }
            if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Weak) {
                return ReferenceType.WEAK;
            }
            throw new IllegalStateException(Messages.getString("CDOViewImpl.29"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setCacheReferenceType(ReferenceType referenceType) {
            ReferenceValueMap.Strong newObjects;
            if (referenceType == null) {
                referenceType = ReferenceType.SOFT;
            }
            switch (referenceType) {
                case STRONG: {
                    if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Strong) {
                        return false;
                    }
                    newObjects = new ReferenceValueMap.Strong();
                    break;
                }
                case SOFT: {
                    if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Soft) {
                        return false;
                    }
                    newObjects = new ReferenceValueMap.Soft();
                    break;
                }
                case WEAK: {
                    if (CDOViewImpl.this.objects instanceof ReferenceValueMap.Weak) {
                        return false;
                    }
                    newObjects = new ReferenceValueMap.Weak();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Messages.getString("CDOViewImpl.29"));
                }
            }
            if (CDOViewImpl.this.objects == null) {
                CDOViewImpl.this.objects = (ConcurrentMap)newObjects;
                this.fireEvent(new CacheReferenceTypeEventImpl());
                return true;
            }
            for (Map.Entry entry : CDOViewImpl.this.objects.entrySet()) {
                InternalCDOObject object = (InternalCDOObject)entry.getValue();
                if (object == null) continue;
                newObjects.put((Object)((CDOID)entry.getKey()), (Object)object);
            }
            ConcurrentMap oldObjects = CDOViewImpl.this.objects;
            ConcurrentMap concurrentMap = CDOViewImpl.this.objects;
            synchronized (concurrentMap) {
                CDOViewImpl.this.objects = (ConcurrentMap)newObjects;
            }
            oldObjects.clear();
            this.fireEvent(new CacheReferenceTypeEventImpl());
            return true;
        }

        private final class CacheReferenceTypeEventImpl
        extends OptionsEvent
        implements CDOView.Options.CacheReferenceTypeEvent {
            private static final long serialVersionUID = 1L;

            public CacheReferenceTypeEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ChangeSubscriptionPoliciesEventImpl
        extends OptionsEvent
        implements CDOView.Options.ChangeSubscriptionPoliciesEvent {
            private static final long serialVersionUID = 1L;

            public ChangeSubscriptionPoliciesEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationNotificationEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.ReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public ReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class RevisionPrefetchingPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.RevisionPrefetchingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public RevisionPrefetchingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }
}

