/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientIndication;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitNotificationIndication
extends CDOClientIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitNotificationIndication.class);

    public CommitNotificationIndication(CDOClientProtocol protocol) {
        super(protocol, (short)17);
    }

    protected void indicating(CDODataInput in) throws IOException {
        long timeStamp = in.readLong();
        if (TRACER.isEnabled()) {
            TRACER.format("Read timeStamp: {0,date} {0,time}", new Object[]{timeStamp});
        }
        CDOPackageUnit[] packageUnits = in.readCDOPackageUnits(null);
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        int i = 0;
        while (i < packageUnits.length) {
            packageRegistry.putPackageUnit((InternalCDOPackageUnit)packageUnits[i]);
            ++i;
        }
        int size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} dirty IDs", new Object[]{size});
        }
        InternalCDOSession session = this.getSession();
        HashSet<CDOIDAndVersion> dirtyOIDs = new HashSet<CDOIDAndVersion>();
        int i2 = 0;
        while (i2 < size) {
            CDOIDAndVersion dirtyOID = in.readCDOIDAndVersion();
            if (TRACER.isEnabled()) {
                TRACER.format("Read dirty ID: {0}", new Object[]{dirtyOID});
            }
            dirtyOIDs.add(dirtyOID);
            ++i2;
        }
        size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} Deltas", new Object[]{size});
        }
        ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>();
        int i3 = 0;
        while (i3 < size) {
            CDORevisionDelta revisionDelta = in.readCDORevisionDelta();
            deltas.add(revisionDelta);
            ++i3;
        }
        size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} Detach Objects", new Object[]{size});
        }
        ArrayList<CDOID> detachedObjects = new ArrayList<CDOID>();
        int i4 = 0;
        while (i4 < size) {
            detachedObjects.add(in.readCDOID());
            ++i4;
        }
        session.handleCommitNotification(timeStamp, Arrays.asList(packageUnits), dirtyOIDs, detachedObjects, deltas, null);
    }
}

