/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.Iterator;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOXATransaction;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.session.CDOCollectionLoadingPolicyImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOXATransactionImpl;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.internal.cdo.view.CDORevisionPrefetchingPolicyImpl;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOUtil {
    private CDOUtil() {
    }

    public static boolean prepareDynamicEPackage(EPackage startPackage) {
        if (CDOFactoryImpl.prepareDynamicEPackage(startPackage)) {
            for (EPackage subPackage : startPackage.getESubpackages()) {
                CDOUtil.prepareDynamicEPackage(subPackage);
            }
            return true;
        }
        return false;
    }

    public static CDORevisionPrefetchingPolicy createRevisionPrefetchingPolicy(int chunkSize) {
        if (chunkSize <= 0) {
            return CDORevisionPrefetchingPolicy.NO_PREFETCHING;
        }
        return new CDORevisionPrefetchingPolicyImpl(chunkSize);
    }

    public static CDOCollectionLoadingPolicy createCollectionLoadingPolicy(int initialChunkSize, int resolveChunkSize) {
        if (initialChunkSize == -1 && resolveChunkSize == -1) {
            return CDOCollectionLoadingPolicy.DEFAULT;
        }
        return new CDOCollectionLoadingPolicyImpl(initialChunkSize, resolveChunkSize);
    }

    public static CDOXATransaction createXATransaction(CDOViewSet viewSet) {
        CDOXATransactionImpl xaTransaction = new CDOXATransactionImpl();
        if (viewSet != null) {
            xaTransaction.add(viewSet);
        }
        return xaTransaction;
    }

    public static CDOXATransaction createXATransaction() {
        return CDOUtil.createXATransaction(null);
    }

    public static CDOXATransaction getXATransaction(CDOViewSet viewSet) {
        EList adapters = viewSet.eAdapters();
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof CDOXATransactionImpl.CDOXAInternalAdapter)) continue;
            return ((CDOXATransactionImpl.CDOXAInternalAdapter)adapter).getCDOXA();
        }
        return null;
    }

    public static CDOViewSet getViewSet(ResourceSet resourceSet) {
        EList adapters = resourceSet.eAdapters();
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof CDOViewSet)) continue;
            return (CDOViewSet)adapter;
        }
        return null;
    }

    public static void load(EObject eObject, CDOView view) {
        InternalCDOObject cdoObject = FSMUtil.adapt(eObject, view);
        CDOStateMachine.INSTANCE.read(cdoObject);
        Iterator<InternalCDOObject> it = FSMUtil.iterator(cdoObject.eContents(), (InternalCDOView)view);
        while (it.hasNext()) {
            InternalCDOObject content = it.next();
            CDOUtil.load(content, view);
        }
    }

    public static EObject getEObject(EObject object) {
        if (object instanceof InternalCDOObject) {
            return ((InternalCDOObject)object).cdoInternalInstance();
        }
        return object;
    }

    public static CDOObject getCDOObject(EObject object) {
        if (object instanceof CDOObject) {
            return (CDOObject)object;
        }
        return FSMUtil.adaptLegacy((InternalEObject)object);
    }

    public static CDOObject getCDOObject(EModelElement object, CDOView view) {
        return FSMUtil.adaptMeta((InternalEObject)object, view);
    }

    public static CDOObject getCDOObject(EGenericType object, CDOView view) {
        return FSMUtil.adaptMeta((InternalEObject)object, view);
    }

    public static CDOObject getCDOObject(EStringToStringMapEntryImpl object, CDOView view) {
        return FSMUtil.adaptMeta((InternalEObject)object, view);
    }

    public static CDORevision getRevisionByVersion(CDOObject object, int version) {
        if (FSMUtil.isTransient(object)) {
            return null;
        }
        InternalCDORevision revision = CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
        if (revision.getVersion() != version) {
            CDOSession session = object.cdoView().getSession();
            if (session.repository().isSupportingAudits()) {
                throw new IllegalStateException(Messages.getString("CDOUtil.0"));
            }
            return session.getRevisionManager().getRevisionByVersion(object.cdoID(), 0, version);
        }
        return revision;
    }

    public static EList<Resource> getResources(ResourceSet resourceSet) {
        BasicEList result = new BasicEList();
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            CDOResource cdoResource;
            if (resource instanceof CDOResource && (cdoResource = (CDOResource)resource).isRoot()) continue;
            result.add((Object)resource);
        }
        return result;
    }

    public static boolean isSessionDirty(CDOSession session) {
        CDOView[] cDOViewArray = (CDOView[])session.getElements();
        int n = cDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view = cDOViewArray[n2];
            if (view.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

