/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContextImpl;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class Transaction
extends View
implements ITransaction {
    public Transaction(Session session, int viewID) {
        super(session, viewID);
    }

    public CDOCommonView.Type getViewType() {
        return CDOCommonView.Type.TRANSACTION;
    }

    public int getTransactionID() {
        return this.getViewID();
    }

    public String toString() {
        return MessageFormat.format("Transaction[{0}]", this.getTransactionID());
    }

    public InternalCommitContext createCommitContext() {
        this.checkOpen();
        return new TransactionCommitContextImpl(this);
    }

    public InternalCommitContext testCreateCommitContext(final long timeStamp) {
        this.checkOpen();
        return new TransactionCommitContextImpl(this){

            protected long createTimeStamp() {
                return timeStamp;
            }
        };
    }

    private void checkOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("View closed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface InternalCommitContext
    extends IStoreAccessor.CommitContext {
        public Transaction getTransaction();

        public void preCommit();

        public void write(OMMonitor var1);

        public void commit(OMMonitor var1);

        public void rollback(String var1);

        public void postCommit(boolean var1);

        public String getRollbackMessage();

        public List<CDOIDMetaRange> getMetaIDRanges();

        public void setNewPackageUnits(InternalCDOPackageUnit[] var1);

        public void setNewObjects(InternalCDORevision[] var1);

        public void setDirtyObjectDeltas(InternalCDORevisionDelta[] var1);

        public void setDetachedObjects(CDOID[] var1);

        public boolean setAutoReleaseLocksEnabled(boolean var1);

        public boolean isAutoReleaseLocksEnabled();
    }
}

