/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryObjectTypesIndication
extends CDOReadIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, QueryObjectTypesIndication.class);
    private CDOID[] ids;

    protected short getSignalID() {
        return 12;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} IDs", new Object[]{size});
        }
        CDOIDObjectFactory factory = this.getStore().getCDOIDObjectFactory();
        this.ids = new CDOID[size];
        int i = 0;
        while (i < this.ids.length) {
            this.ids[i] = CDOIDUtil.read((ExtendedDataInput)in, (CDOIDObjectFactory)factory);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read ID: {0}", new Object[]{this.ids[i]});
            }
            ++i;
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        CDOID[] cDOIDArray = this.ids;
        int n = this.ids.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id = cDOIDArray[n2];
            CDOClassRef classRef = this.getSession().getClassRef(id);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Wrinting type: {0}", new Object[]{classRef});
            }
            CDOModelUtil.writeClassRef((ExtendedDataOutput)out, (CDOClassRef)classRef);
            ++n2;
        }
    }
}

