/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.internal.id;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateImpl;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateLongImpl;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateStringImpl;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInput;

public class CDOIDHibernateFactoryImpl
implements CDOIDObjectFactory {
    private static CDOIDHibernateFactoryImpl instance = new CDOIDHibernateFactoryImpl();

    public static CDOIDHibernateFactoryImpl getInstance() {
        return instance;
    }

    public static void setInstance(CDOIDHibernateFactoryImpl instance) {
        CDOIDHibernateFactoryImpl.instance = instance;
    }

    public CDOIDObject createCDOIDObject(ExtendedDataInput in) {
        try {
            int idType = in.readInt();
            switch (idType) {
                case 0: {
                    return new CDOIDHibernateImpl();
                }
                case 1: {
                    return new CDOIDHibernateLongImpl();
                }
                case 2: {
                    return new CDOIDHibernateStringImpl();
                }
            }
            throw new IllegalArgumentException("IDTYPE " + idType + " not supported");
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public CDOIDHibernate createCDOID(Serializable id, String entityName) {
        CDOIDHibernateImpl cdoID = id instanceof Long ? new CDOIDHibernateLongImpl() : (id instanceof Long ? new CDOIDHibernateStringImpl() : new CDOIDHibernateImpl());
        cdoID.setId(id);
        cdoID.setEntityName(entityName);
        return cdoID;
    }
}

