/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalClassMapping
implements IClassMapping {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalClassMapping.class);
    private EClass eClass;
    private IDBTable table;
    private AbstractHorizontalMappingStrategy mappingStrategy;
    private List<ITypeMapping> valueMappings;
    private List<IListMapping> listMappings;

    public AbstractHorizontalClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        this.mappingStrategy = mappingStrategy;
        this.eClass = eClass;
        this.initTable();
        this.initFeatures();
    }

    private void initTable() {
        String name = this.getMappingStrategy().getTableName((ENamedElement)this.eClass);
        this.table = this.getMappingStrategy().getStore().getDBSchema().addTable(name);
        IDBField idField = this.table.addField("cdo_id", DBType.BIGINT, true);
        this.table.addField("cdo_version", DBType.INTEGER, true);
        this.table.addField("cdo_class", DBType.BIGINT, true);
        this.table.addField("cdo_created", DBType.BIGINT, true);
        IDBField revisedField = this.table.addField("cdo_revised", DBType.BIGINT, true);
        this.table.addField("cdo_resource", DBType.BIGINT, true);
        this.table.addField("cdo_container", DBType.BIGINT, true);
        this.table.addField("cdo_feature", DBType.INTEGER, true);
        this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{idField, revisedField});
    }

    private void initFeatures() {
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)this.eClass);
        if (features == null) {
            this.valueMappings = Collections.emptyList();
            this.listMappings = Collections.emptyList();
        } else {
            this.valueMappings = this.createValueMappings(features);
            this.listMappings = this.createListMappings(features);
        }
    }

    private List<ITypeMapping> createValueMappings(EStructuralFeature[] features) {
        ArrayList<ITypeMapping> mappings = new ArrayList<ITypeMapping>();
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (!feature.isMany()) {
                ITypeMapping mapping = this.mappingStrategy.createValueMapping(feature);
                mapping.createDBField(this.getTable());
                mappings.add(mapping);
            }
            ++n2;
        }
        return mappings;
    }

    private List<IListMapping> createListMappings(EStructuralFeature[] features) {
        ArrayList<IListMapping> listMappings = new ArrayList<IListMapping>();
        EStructuralFeature[] eStructuralFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                listMappings.add(this.mappingStrategy.createListMapping(this.eClass, feature));
            }
            ++n2;
        }
        return listMappings;
    }

    protected final boolean readValuesFromStatement(PreparedStatement pstmt, InternalCDORevision revision) {
        ResultSet resultSet;
        block7: {
            block8: {
                resultSet = null;
                if (TRACER.isEnabled()) {
                    TRACER.format("Executing Query: {0}", new Object[]{pstmt.toString()});
                }
                pstmt.setMaxRows(1);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) break block7;
                if (!TRACER.isEnabled()) break block8;
                TRACER.format("Resultset was empty.", new Object[0]);
            }
            DBUtil.close((ResultSet)resultSet);
            return false;
        }
        try {
            int i = 1;
            revision.setVersion(resultSet.getInt(i++));
            revision.setCreated(resultSet.getLong(i++));
            revision.setRevised(resultSet.getLong(i++));
            revision.setResourceID(CDOIDUtil.createLong((long)resultSet.getLong(i++)));
            revision.setContainerID((Object)CDOIDUtil.createLong((long)resultSet.getLong(i++)));
            revision.setContainingFeatureID(resultSet.getInt(i++));
            for (ITypeMapping mapping : this.valueMappings) {
                mapping.readValueToRevision(resultSet, i++, revision);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        return true;
    }

    protected final void readLists(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.readValues(accessor, revision, listChunk);
        }
    }

    @Override
    public final void detachObject(IDBStoreAccessor accessor, CDOID id, long revised, OMMonitor monitor) {
        OMMonitor.Async async = null;
        try {
            monitor.begin((double)(this.getListMappings().size() + 1));
            async = monitor.forkAsync();
            this.reviseObject(accessor, id, revised);
            async.stop();
            async = monitor.forkAsync((double)this.getListMappings().size());
            for (IListMapping mapping : this.getListMappings()) {
                mapping.objectRevised(accessor, id, revised);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    protected final IMetaDataManager getMetaDataManager() {
        return this.getMappingStrategy().getStore().getMetaDataManager();
    }

    protected final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    protected final EClass getEClass() {
        return this.eClass;
    }

    public final List<ITypeMapping> getValueMappings() {
        return this.valueMappings;
    }

    public final ITypeMapping getValueMapping(EStructuralFeature feature) {
        for (ITypeMapping mapping : this.valueMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        return null;
    }

    public final List<IListMapping> getListMappings() {
        return this.listMappings;
    }

    @Override
    public final IListMapping getListMapping(EStructuralFeature feature) {
        for (IListMapping mapping : this.listMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        throw new IllegalArgumentException("List mapping for feature " + feature + " does not exist.");
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    @Override
    public Collection<IDBTable> getDBTables() {
        ArrayList<IDBTable> tables = new ArrayList<IDBTable>();
        tables.add(this.table);
        for (IListMapping listMapping : this.listMappings) {
            tables.addAll(listMapping.getDBTables());
        }
        return tables;
    }

    private void checkDuplicateResources(IDBStoreAccessor accessor, CDORevision revision) throws IllegalStateException {
        String name;
        CDOID folderID = (CDOID)revision.data().getContainerID();
        CDOID existingID = accessor.readResourceID(folderID, name = (String)revision.data().get((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name(), 0), 0L);
        if (existingID != null && !existingID.equals(revision.getID())) {
            throw new IllegalStateException("Duplicate resource or folder: " + name + " in folder " + folderID);
        }
    }

    protected void writeLists(IDBStoreAccessor accessor, InternalCDORevision revision) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.writeValues(accessor, revision);
        }
    }

    @Override
    public void writeRevision(IDBStoreAccessor accessor, InternalCDORevision revision, OMMonitor monitor) {
        OMMonitor.Async async = null;
        try {
            monitor.begin(10.0);
            async = monitor.forkAsync();
            CDOID id = revision.getID();
            if (revision.getVersion() == 1) {
                this.mappingStrategy.putObjectType(accessor, id, this.eClass);
            } else {
                long revised = revision.getCreated() - 1L;
                this.reviseObject(accessor, id, revised);
                for (IListMapping mapping : this.getListMappings()) {
                    mapping.objectRevised(accessor, id, revised);
                }
            }
            async.stop();
            async = monitor.forkAsync();
            if (revision.isResourceFolder() || revision.isResource()) {
                this.checkDuplicateResources(accessor, (CDORevision)revision);
            }
            async.stop();
            async = monitor.forkAsync();
            this.writeValues(accessor, revision);
            async.stop();
            async = monitor.forkAsync(7.0);
            if (this.listMappings != null) {
                this.writeLists(accessor, revision);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    protected abstract void writeValues(IDBStoreAccessor var1, InternalCDORevision var2);

    protected abstract void reviseObject(IDBStoreAccessor var1, CDOID var2, long var3);
}

