/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.server.db.IDBStoreReader;
import org.eclipse.emf.cdo.server.internal.db.MappingStrategy;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectIDIterator
implements CloseableIterator<CDOID> {
    private MappingStrategy mappingStrategy;
    private IDBStoreReader storeReader;
    private boolean withTypes;
    private ResultSet currentResultSet;
    private CDOID nextID;

    public ObjectIDIterator(MappingStrategy mappingStrategy, IDBStoreReader storeReader, boolean withTypes) {
        this.mappingStrategy = mappingStrategy;
        this.storeReader = storeReader;
        this.withTypes = withTypes;
    }

    public void close() {
        DBUtil.close((ResultSet)this.currentResultSet);
    }

    public MappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public IDBStoreReader getStoreReader() {
        return this.storeReader;
    }

    public boolean isWithTypes() {
        return this.withTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNext() {
        this.nextID = null;
        while (true) {
            if (this.currentResultSet == null) {
                this.currentResultSet = this.getNextResultSet();
                if (this.currentResultSet == null) {
                    return false;
                }
            }
            try {
                if (this.currentResultSet.next()) {
                    long id = this.currentResultSet.getLong(1);
                    this.nextID = CDOIDUtil.createLong((long)id);
                    if (this.withTypes && this.nextID instanceof CDOIDObject) {
                        int classID = this.currentResultSet.getInt(2);
                        CDOClassRef classRef = this.mappingStrategy.getClassRef(this.storeReader, classID);
                        this.nextID = ((CDOIDObject)this.nextID).asLegacy(classRef);
                    }
                    return true;
                }
                DBUtil.close((ResultSet)this.currentResultSet);
                this.currentResultSet = null;
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
    }

    public CDOID next() {
        return this.nextID;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract ResultSet getNextResultSet();
}

