/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempMetaImpl;

public final class CDOIDMetaRangeImpl
implements CDOIDMetaRange {
    private static final long serialVersionUID = 1L;
    private CDOID lowerBound;
    private int size;

    public CDOIDMetaRangeImpl(CDOID lowerBound, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.lowerBound = lowerBound;
        this.size = size;
    }

    public CDOID getLowerBound() {
        return this.lowerBound;
    }

    public CDOID getUpperBound() {
        return this.size > 0 ? this.get(this.size - 1) : null;
    }

    public CDOID get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("ids < 0 || ids >= size");
        }
        if (this.isTemporary()) {
            return new CDOIDTempMetaImpl(((CDOIDTempMetaImpl)this.lowerBound).getIntValue() + index);
        }
        return new CDOIDMetaImpl(((CDOIDMetaImpl)this.lowerBound).getLongValue() + (long)index);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(CDOID id) {
        if (this.isTemporary()) {
            if (id.getType() != CDOID.Type.TEMP_META) {
                throw new IllegalArgumentException("id.getType() != Type.TEMP_META");
            }
            int index = ((CDOIDTempMetaImpl)id).getIntValue() - ((CDOIDTempMetaImpl)this.lowerBound).getIntValue();
            return index >= 0 && index < this.size;
        }
        if (id.getType() != CDOID.Type.META) {
            throw new IllegalArgumentException("id.getType() != Type.META");
        }
        long index = ((CDOIDMetaImpl)id).getLongValue() - ((CDOIDMetaImpl)this.lowerBound).getLongValue();
        return 0L <= index && index < (long)this.size;
    }

    public CDOIDMetaRange increase() {
        return new CDOIDMetaRangeImpl(this.lowerBound, this.size + 1);
    }

    public CDOID.Type getType() {
        return this.lowerBound.getType();
    }

    public boolean isTemporary() {
        return this.lowerBound.isTemporary();
    }

    public String toString() {
        return MessageFormat.format("[{0}:{1}]", this.lowerBound, this.getUpperBound());
    }
}

