/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.ui.provider;

import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.internal.EMFTransactionUIPlugin;
import org.eclipse.emf.transaction.ui.internal.Tracing;
import org.eclipse.emf.transaction.ui.internal.l10n.Messages;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalPropertySource
implements IPropertySource2 {
    private final TransactionalEditingDomain domain;
    private final IPropertySource propertySource;
    private final IPropertySource2 propertySource2;

    public TransactionalPropertySource(TransactionalEditingDomain domain, IPropertySource propertySource) {
        this.domain = domain;
        this.propertySource = propertySource;
        this.propertySource2 = propertySource instanceof IPropertySource2 ? (IPropertySource2)propertySource : null;
    }

    protected <T> T run(RunnableWithResult<? extends T> run) {
        try {
            return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)this.domain, run);
        }
        catch (InterruptedException e) {
            Tracing.catching(TransactionalPropertySource.class, "run", e);
            Thread.currentThread().interrupt();
            EMFTransactionUIPlugin.INSTANCE.log(new Status(4, EMFTransactionUIPlugin.getPluginId(), 22, Messages.propertyInterrupt, (Throwable)e));
            return null;
        }
    }

    public boolean isPropertyResettable(Object id) {
        return this.propertySource2 == null ? false : this.propertySource2.isPropertyResettable(id);
    }

    public boolean isPropertySet(final Object id) {
        return (Boolean)this.run((RunnableWithResult)new RunnableWithResult.Impl<Boolean>(){

            public void run() {
                this.setResult(TransactionalPropertySource.this.propertySource.isPropertySet(id));
            }
        });
    }

    public Object getEditableValue() {
        return this.run((RunnableWithResult)new RunnableWithResult.Impl<Object>(){

            public void run() {
                this.setResult(TransactionalPropertySource.this.propertySource.getEditableValue());
            }
        });
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertySource.getPropertyDescriptors();
    }

    public Object getPropertyValue(final Object id) {
        return this.run((RunnableWithResult)new RunnableWithResult.Impl<Object>(){

            public void run() {
                this.setResult(TransactionalPropertySource.this.propertySource.getPropertyValue(id));
            }
        });
    }

    public void resetPropertyValue(Object id) {
        InternalTransaction tx;
        if (!(this.propertySource2 == null || (tx = ((InternalTransactionalEditingDomain)this.domain).getActiveTransaction()) != null && tx.isReadOnly())) {
            this.propertySource2.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        InternalTransaction tx = ((InternalTransactionalEditingDomain)this.domain).getActiveTransaction();
        if (tx == null || !tx.isReadOnly()) {
            this.propertySource.setPropertyValue(id, value);
        }
    }
}

